<?php
namespace Skb_Cife;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

/*--------------------------
*   Class Icomoon Icon Manager
* -------------------------*/
class Skb_Cife_Icomoon_Icon_Manager{

    private static $instance = null;

    public static function instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    function __construct(){
        $this->init();
    }

    public function init() {

        // Custom icon filter
        add_filter( 'elementor/icons_manager/additional_tabs', [ $this,'skb_cife_icomoon_icon'] );  

    }

	public function skb_cife_icomoon_icon( $icomoon_icons_args = array() ) {

	    // Append new icons
	    $icomoon_icons = array(
		
			'bookmark', 
    
  
			'home-2', 
			  
			
			'search-2', 
			  
			
			'heart-fill', 
			
			'cart-4', 
			  
			
			'user-fill', 
			  
			
			'cart-3', 
			  
			
			'chart', 
			  
			
			'angle-down-fill', 
			  
			
			'angle-up-fill', 
			  
			
			'arrow-zoom', 
			
			'car', 
			  
			
			'facebook', 
			  
			
			'telegram', 
			
			'money', 
			  
			
			'security', 
			  
			
			'seven-plus', 
			  
			
			'suport', 
			  
			
			'dislike', 
			  
			
			'like', 
			  
			
			'offer', 
			  
			
			'qoute-up', 
			  
			
			'box', 
			  
			
			'cart-2', 
			  
			
			'filter', 
			  
			
			'exclamation-circle', 
			  
			
			'bell', 
			  
			
			'check-circle', 
			  
			
			'location', 
			  
			
			'share', 
			  
			
			'star', 
			  
			
			'user', 
			  
			
			'instagram', 
			  
			
			'linkedin', 
			
			'phone', 
			  
			
			'search', 
			  
			
			'time', 
			  
			
			'time-2', 
			  
			
			'twitter', 
			  
			
			'user-circle', 
			  
			
			'weight', 
			  
			
			'whatsapp', 
			  
			
			'angle-down', 
			  
			
			'angle-right', 
			  
			
			'angle-left', 
			  
			
			'angle-up', 
			  
			
			'arrow-left', 
			  
			
			'ball', 
			  
			
			'cart', 
			  
			
			'email', 
			  
			
			'footbal', 
			  
			
			'heart',
			
			'home',
			
			'close',
	    );
	    
	    $icomoon_icons_args['skb_cife-icomoon-icon'] = array(
	        'name'          => 'skb_cife-icomoon-icon',
	        'label'         => esc_html__( 'کتابخانه icomoon', 'skb_cife' ),
	        'labelIcon'     => 'icon-angle-down-fill',
	        'prefix'        => 'icon-',
	        'displayPrefix' => '',
	        'url'           => get_template_directory_uri().'/assets/css/icomoon.css',
	        'icons'         => $icomoon_icons,
	        'ver'           => 1.0,
	    );

	    return $icomoon_icons_args;
	}



}
Skb_Cife_Icomoon_Icon_Manager::instance();