<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Slidersecondkaveh extends Widget_Base{

  public function get_name(){
    return 'slidersecondkaveh';
  }

  public function get_title(){
    return esc_html__( 'اسلایدر سبک دو', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }
 
  protected function register_controls(){
    
    $this->start_controls_section(
        'contentslidersecondkaveh',
        [
          'label' => esc_html__( 'Content', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'styleslidersecondkaveh',
        [
          'label' => esc_html__( 'طرح بندی اسلایدر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'one',
          'options' => [
            'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
            'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),    
          ],
        ]
        ); 
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'titlelidersecondkaveh',
        [
            'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'به روز ترین', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'tagheading1slidersecondkaveh',
      [
        'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H5',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'title2lidersecondkaveh',
      [
          'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'محصولات ما', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'tagheading2slidersecondkaveh',
    [
      'label' => esc_html__( 'تگ عنوان اصلی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'H2',
      'options' => [
        'H1'  => esc_html__( 'H1', 'kaveh-core' ),
        'H2' => esc_html__( 'H2', 'kaveh-core' ),
        'H3' => esc_html__( 'H3', 'kaveh-core' ),
        'H4' => esc_html__( 'H4', 'kaveh-core' ),
        'H5' => esc_html__( 'H5', 'kaveh-core' ),
        'H6' => esc_html__( 'H6', 'kaveh-core' ),
        'p' => esc_html__( 'p', 'kaveh-core' ),
        'div' => esc_html__( 'div', 'kaveh-core' ),
        'span' => esc_html__( 'span', 'kaveh-core' ),
      ],
    ]
  );
      $repeater->add_control(
        'buttonslidersecondkaveh',
        [
            'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'بیشتر', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'linkbuttonslidersecondkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'backslidersecondkaveh',
    [
      'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::MEDIA,
      'default' => [
        'url' => \Elementor\Utils::get_placeholder_image_src(),
      ],
    ]
  );
  $repeater->add_control(
    'backjslidersecondkaveh',
    [
      'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::MEDIA,            
      'condition' => [
        'styleslidersecondkaveh' => 'three',
      ],
      'default' => [
        'url' => \Elementor\Utils::get_placeholder_image_src(),
      ],
    ]
  );
      $this->add_control(
        'slidesslidersecondkaveh',
        [
          'label' => esc_html__( 'اسلاید ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::REPEATER,
          'condition' => [
            'styleslidersecondkaveh' => 'one',
          ],
          'default' => [
            [
              'titlelidersecondkaveh' => esc_html__( 'به روز ترین', 'kaveh-core' ),
              'title2lidersecondkaveh' => esc_html__( 'محصولات ما', 'kaveh-core' ),
              'buttonslidersecondkaveh' => esc_html__( 'بیشتر', 'kaveh-core' ),
              'linkbuttonslidersecondkaveh' => esc_html__( '#', 'kaveh-core' ),
            ],
          ],
          'fields' => $repeater->get_controls()
          ],
      );
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'titlelidersecondkaveh',
        [
            'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'به روز ترین', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'tagheading1slidersecondkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H5',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'title2lidersecondkaveh',
      [
          'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'محصولات ما', 'kaveh-core' ),
  
      ]
  );
      $repeater->add_control(
        'buttonslidersecondkaveh',
        [
            'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'بیشتر', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'linkbuttonslidersecondkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'backslidersecondkaveh',
    [
      'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::MEDIA,
      'default' => [
        'url' => \Elementor\Utils::get_placeholder_image_src(),
      ],
    ]
  );
  $repeater->add_control(
    'backjslidersecondkaveh',
    [
      'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::MEDIA,            
      'condition' => [
        'styleslidersecondkaveh' => 'three',
      ],
      'default' => [
        'url' => \Elementor\Utils::get_placeholder_image_src(),
      ],
    ]
  );
      $this->add_control(
        'slides2slidersecondkaveh',
        [
          'label' => esc_html__( 'اسلاید ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::REPEATER,
          'condition' => [
            'styleslidersecondkaveh' => 'two',
          ],
          'default' => [
            [
              'titlelidersecondkaveh' => esc_html__( 'به روز ترین', 'kaveh-core' ),
              'title2lidersecondkaveh' => esc_html__( 'محصولات ما', 'kaveh-core' ),
              'buttonslidersecondkaveh' => esc_html__( 'بیشتر', 'kaveh-core' ),
              'linkbuttonslidersecondkaveh' => esc_html__( '#', 'kaveh-core' ),
            ],
          ],
          'fields' => $repeater->get_controls()
          ],
      );
       $this->end_controls_section();
       $this->start_controls_section(
        'style1_slidersecondkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'titlestslidersecondkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleslidersecondkaveh' => 'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .landing-item .detail .sslo' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_slidersecondkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'condition' => [
            'styleslidersecondkaveh' => 'one',
          ],
          'selector' => '{{WRAPPER}} .landing-item .detail .sslo',
        ]
      );
      $this->add_control(
        'titlepstslidersecondkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleslidersecondkaveh' => 'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .landing-item .detail .sub-s2 .sslotwo' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'p_slidersecondkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'condition' => [
            'styleslidersecondkaveh' => 'one',
          ],
          'selector' => '{{WRAPPER}} .landing-item .detail .sub-s2 .sslotwo',
        ]
      );
      $this->add_control(
        'title2stslidersecondkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleslidersecondkaveh' => 'two',
          ],
          'selectors' => [
            '{{WRAPPER}} .landing-tow .title .sltsth' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2_slidersecondkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'condition' => [
            'styleslidersecondkaveh' => 'two',
          ],
          'selector' => '{{WRAPPER}} .landing-tow .title .sltsth',
        ]
      );

      $this->end_controls_section();
      $this->start_controls_section(
        'style2_slidersecondkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'styleslidersecondkaveh' => 'one',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_slidersecondkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-item .detail .btn ',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowslidersecondkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-item .detail .btn ',
        ]
      );
      $this->start_controls_tabs(
        'style_tabsslidersecondkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabslidersecondkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorslidersecondkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-item .detail .btn ' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorslidersecondkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-item .detail .btn ' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusslidersecondkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .landing-item .detail .btn ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderslidersecondkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-item .detail .btn ',
        ]
      );
      $this->add_control(
        'buttonbordersslidersecondkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderslidersecondkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .landing-item .detail .btn ' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabslidersecondkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoverslidersecondkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-item .detail .btn :hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoverslidersecondkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-item .detail .btn :hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoverslidersecondkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .landing-item .detail .btn :hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoverslidersecondkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-item .detail .btn :hover',
        ]
      );
      $this->add_control(
        'buttonbordershoverslidersecondkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoverslidersecondkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .landing-item .detail .btn :hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowslidersecondkavehh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-item .detail .btn ',
        ]
      );
      $this->add_control(
        'hr1slidersecondkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingslidersecondkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .landing-item .detail .btn ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_2slidersecondkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'styleslidersecondkaveh' => 'two',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_2slidersecondkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-tow .link a  ',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadow2slidersecondkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-tow .link a  ',
        ]
      );
      $this->start_controls_tabs(
        'style_tabs2slidersecondkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tab2slidersecondkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolor2slidersecondkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-tow .link a  ' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolor2slidersecondkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-tow .link a  ' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradius2slidersecondkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .landing-tow .link a  ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border2slidersecondkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-tow .link a  ',
        ]
      );
      $this->add_control(
        'buttonborders2slidersecondkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border2slidersecondkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .landing-tow .link a  ' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tab2slidersecondkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhover2slidersecondkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-tow .link a  :hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhover2slidersecondkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-tow .link a  :hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushover2slidersecondkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .landing-tow .link a  :hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhover2slidersecondkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-tow .link a  :hover',
        ]
      );
      $this->add_control(
        'buttonbordershover2slidersecondkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhover2slidersecondkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .landing-tow .link a  :hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow2slidersecondkavehh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-tow .link a  ',
        ]
      );
      $this->add_control(
        'hr12slidersecondkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpadding2slidersecondkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .landing-tow .link a  ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      
      $this->end_controls_section();

      $this->start_controls_section(
        'style3_slidersecondkaveh',
        [
          'label' => esc_html__( 'استایل عکس', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );

      $this->add_control(
        'widthbg7slidersecondkaveh',
        [
          'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .landing-item img,.landing-tow img' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'heigthbg7slidersecondkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .landing-item img,.landing-tow img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style4_slidersecondkaveh',
        [
          'label' => esc_html__( 'استایل اسلایدر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'bgboxcolor1slidersecondkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه اسلایدر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing::after' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->end_controls_section();

          
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
  <?php if('one'===$settings['styleslidersecondkaveh']){ ?>
  <section class="landing position-relative">
    <div class="container">
      <div class="swiper swiper-landing position-relative">
        <div class="swiper-wrapper">
            <?php
            if ( $settings['slidesslidersecondkaveh'] ) {
            foreach (  $settings['slidesslidersecondkaveh'] as $item ) {
            ?>
          <div class="swiper-slide">
            <div
              class="landing-item mx-auto d-flex align-items-lg-center justify-content-lg-between flex-column flex-lg-row">
              <img src="<?php echo esc_url($item['backslidersecondkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['backslidersecondkaveh'] )); ?>" />
              <div class="detail">
                <<?php echo  esc_html($item['tagheading1slidersecondkaveh']); ?> class="sslo">
                  <span> <?php echo  esc_html($item['titlelidersecondkaveh']); ?> </span>
                </<?php echo  esc_html($item['tagheading1slidersecondkaveh']); ?>>
                <<?php echo  esc_html($item['tagheading2slidersecondkaveh']); ?> class="sub-s2">
                  <span class="sslotwo"> <?php echo  esc_html($item['title2lidersecondkaveh']); ?> </span>
                </<?php echo  esc_html($item['tagheading2slidersecondkaveh']); ?>>
                <a href="<?php echo  esc_url($item['linkbuttonslidersecondkaveh']); ?>" class="btn btn-primary">
                    <?php echo  esc_html($item['buttonslidersecondkaveh']); ?>
                  <i class="icon-arrow-left"></i>
                </a>
              </div>
            </div>
          </div>
          <?php
          }
        }
          ?>
        </div>
        <div class="swiper-pagination"></div>
        <div class="swiper-button-next"></div>
        <div class="swiper-button-prev"></div>
      </div>
    </div>
  </section>
  <?php }elseif('two'===$settings['styleslidersecondkaveh']){ ?>
    <div class="landing-tow position-relative">
      <div class="container position-relative">
        <div class="swiper swiper-landing-tow overflow-hidden">
          <div class="swiper-wrapper">
          <?php
            if ( $settings['slides2slidersecondkaveh'] ) {
            foreach (  $settings['slides2slidersecondkaveh'] as $item ) {
            ?>
            <div class="swiper-slide">
              <div class="row align-items-center">
                <div class="col-lg-8">
                  <img src="<?php echo esc_url($item['backslidersecondkaveh']['url']); ?>" alt="cate" class="d-block" />
                </div>
                <div class="col-lg-4 mt-4 mt-lg-0">
                  <div class="title overflow-hidden">
                    <<?php echo  esc_html($item['tagheading1slidersecondkaveh']); ?> class="sltsth">
                    <?php echo  esc_html($item['titlelidersecondkaveh']); ?>
                      <span class="d-block"> <?php echo  esc_html($item['title2lidersecondkaveh']); ?> </span>
                    </<?php echo  esc_html($item['tagheading1slidersecondkaveh']); ?>>
                  </div>
                  <div class="link overflow-hidden">
                    <a href="<?php echo  esc_url($item['linkbuttonslidersecondkaveh']); ?>" class="btn btn-primary">
                    <?php echo  esc_html($item['buttonslidersecondkaveh']); ?>
                      <i class="icon-arrow-left"></i>
                    </a>
                  </div>
                </div>
              </div>
            </div>
            <?php
          }
        }
          ?>
          </div>
          <div class="swiper-button-next"></div>
          <div class="swiper-button-prev"></div>
        </div>
      </div>
    </div>
  <?php } ?>

  <script>
          function init<?php echo $clsid; ?>() {
      // Swiper Landing
  new Swiper(".swiper-landing", {
    slidesPerView: 1,
    spaceBetween: 0,
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    pagination: {
      el: ".swiper-pagination",
      type: "bullets",
      clickable: true,
    },
    autoplay: {
      delay: 5000,
      disableOnInteraction: false,
      pauseOnMouseEnter: true,
    },
    effect: "fade",
    fadeEffect: {
      crossFade: true,
    },
    loop: true,
  });

    // Swiper Landing Tow
    new Swiper(".swiper-landing-tow", {
    slidesPerView: 1,
    spaceBetween: 0,
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    autoplay: {
      delay: 5000,
    },
    effect: "fade",
    fadeEffect: {
      crossFade: true,
    },
    loop: true,
  });
}
      if (window.Swiper) {
    // Swiper library already loaded, initialize Swiper instance
    init<?php echo $clsid; ?>();
  } else {
    // Swiper library not yet loaded, wait for it to load
    window.addEventListener("load", function() {
      init<?php echo $clsid; ?>();
    });
  }
  </script>

    <?php
  }


}
