<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Searchkaveh extends Widget_Base{

  public function get_name(){
    return 'searchkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان سرچ', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['headerfooterkavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentsearchkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'styleboxsearchkaveh',
        [
          'label' => esc_html__( 'طرح بندی المان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'one',
          'options' => [
            'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
            'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
            'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
            'four'  => esc_html__( 'طرح بندی چهار', 'kaveh-core' ),
            'five'  => esc_html__( 'طرح بندی پنج', 'kaveh-core' ),
            'six'  => esc_html__( 'طرح بندی شش', 'kaveh-core' ),
          ],
        ]
        );
      $this->add_control(
          'titlesearchkaveh',
          [
              'label' => esc_html__( 'متن نگهدارنده فرم', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'جستجوی محصول', 'kaveh-core' ),

      
          ]
      );
      $this->add_control(
        'iconsearchkaveh',
        [
          'label' => esc_html__( 'آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::ICONS,
          'skin' => 'inline',
          'exclude_inline_options' => [ 'svg' ],
          'default' => [
            'value' => 'isax isax-search-normal-1',
          ],
        ]
      );
       $this->end_controls_section();

       $this->start_controls_section(
        'styleupsearchkaveh',
        [
          'label' => esc_html__( 'استایل دکمه سرچ', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'iconsizesearchkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxsearchkaveh!' =>['five','six'],
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 18,
          ],
          'selectors' => [
            '{{WRAPPER}} .btsearch' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconsize2searchkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxsearchkaveh' =>'five',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 18,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-four-btn-search' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconsize3searchkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxsearchkaveh' =>'six',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 18,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eleven-search button' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'ticon1colorupsearchkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh!' => ['five','six'],
          ],
          'selectors' => [
            '{{WRAPPER}} .btsearch' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'ticon2colorupsearchkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' => 'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-four-btn-search' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'ticon4colorupsearchkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' => 'six',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eleven-search button' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        't2colorupsearchkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>['one','two','four'],
          ],
          'selectors' => [
            '{{WRAPPER}} .btsearch' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        't3colorupsearchkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-three-search, .btse3' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        't5colorupsearchkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>'four',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-four-btn-search' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        't4colorupsearchkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-four-btn-search' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'button1iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>'one',
          ],
          'size_units' => [ 'px' ],
          'default' => [
            'unit' => 'px',
            'size' => 15,
          ],
          'selectors' => [
            '{{WRAPPER}} .btsearch' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'button2iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>'two',
          ],
          'size_units' => [ 'px' ],
          'default' => [
            'unit' => 'px',
            'size' => 15,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-two-search .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'button3iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>'three',
          ],
          'size_units' => [ 'px' ],
          'default' => [
            'unit' => 'px',
            'size' => 15,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-three-search' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'button4iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>'four',
          ],
          'size_units' => [ 'px' ],
          'default' => [
            'unit' => 'px',
            'size' => 15,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-four-btn-search' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'button5iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>'five',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            '{{WRAPPER}} .top-header-fourteen .top-header-four-btn-search' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      ); 
      $this->add_control(
        'width4iconsearchkaveh',
        [
          'label' => esc_html__( 'عرض', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'condition' => [
            'styleboxsearchkaveh' =>'four',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 50,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-four-btn-search' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'height4iconsearchkaveh',
        [
          'label' => esc_html__( 'ارتفاع', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'condition' => [
            'styleboxsearchkaveh' =>'four',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 50,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-four-btn-search' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'width5iconsearchkaveh',
        [
          'label' => esc_html__( 'عرض', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'condition' => [
            'styleboxsearchkaveh' =>'five',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 50,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a' => 'width: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .top-header-fourteen .top-header-four-btn-search' => 'width: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'height5iconsearchkaveh',
        [
          'label' => esc_html__( 'ارتفاع', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'condition' => [
            'styleboxsearchkaveh' =>'five',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 68,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .nav-header-cart > a,' => 'height: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .top-header-fourteen .top-header-four-btn-search' => 'height: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2upsearchkaveh',
        [
          'label' => esc_html__( 'استایل نگهدارنده متن', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'backcolor1iconsearchkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-search .form-control' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'backcolor21iconsearchkaveh',
        [
          'label' => esc_html__( 'رنگ اول پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>'two',
          ],
        ]
      );
      $this->add_control(
        'backcolor22iconsearchkaveh',
        [
          'label' => esc_html__( 'رنگ دوم پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>'two',
          ],
        ]
      );
      $this->add_control(
        'backcolor3iconsearchkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-three-search .form-control' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'backcolor45iconsearchkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>['four','five'],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-four-search form .form-control' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'backcolor6colorupsearchkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>'six',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eleven-search' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'backcolor62colorupsearchkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه فیلد ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxsearchkaveh' =>'six',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eleven-search .form-control' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'buttonradiu1iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده فیلد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>'one',
          ],
          'size_units' => [ 'px' ],
          'default' => [
            'unit' => 'px',
            'size' => 15,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-search .form-control' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'buttonradiu2iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده فیلد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>'two',
          ],
          'size_units' => [ 'px' ],
          'default' => [
            'unit' => 'px',
            'size' => 15,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-two-search .form-control' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'buttonradiu3iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده فیلد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>'three',
          ],
          'size_units' => [ 'px' ],
          'default' => [
            'unit' => 'px',
            'size' => 15,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-three-search .form-control' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'buttonradiu4iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده فیلد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>['four','five'],
          ],
          'size_units' => [ 'px' ],
          'default' => [
            'unit' => 'px',
            'size' => 15,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-four-search form .form-control' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'buttonradiu6iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>'six',
          ],
          'size_units' => [ 'px' ],
          'default' => [
            'unit' => 'px',
            'size' => 25,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eleven-search' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiu61iconsearchkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده فیلد ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxsearchkaveh' =>'six',
          ],
          'size_units' => [ 'px' ],
          'default' => [
            'unit' => 'px',
            'size' => 25,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eleven-search .form-control' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->add_control(
        'formwidth1iconsearchkaveh',
        [
          'label' => esc_html__( 'عرض فرم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'condition' => [
            'styleboxsearchkaveh' =>'one',
          ],
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 405,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-search' => 'max-width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'formwidth2iconsearchkaveh',
        [
          'label' => esc_html__( 'عرض فرم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'condition' => [
            'styleboxsearchkaveh' =>'two',
          ],
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 420,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-two-search' => 'max-width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'formwidth3iconsearchkaveh',
        [
          'label' => esc_html__( 'عرض فرم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'condition' => [
            'styleboxsearchkaveh' =>'three',
          ],
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 350,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-three-search' => 'max-width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'formwidth6iconsearchkaveh',
        [
          'label' => esc_html__( 'عرض فرم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'condition' => [
            'styleboxsearchkaveh' =>'six',
          ],
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 487,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eleven-search' => 'max-width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <?php if('one'===$settings['styleboxsearchkaveh']){ ?>
      <form action="/" method="get" autocomplete="off" class="top-header-search position-relative d-lg-block">
          <div class="input-group">
            <input id="maninpu<?php echo $clsid; ?>" oninput="fetchData()" type="text" name="q" class="form-control" placeholder="<?php echo  esc_attr($settings['titlesearchkaveh']); ?>" />
            <button id="butno" type="submit" class="btn btn-primary btsearch">
              <i class="<?php echo  esc_attr($settings['iconsearchkaveh']['value']); ?>"></i>
            </button>
          </div>
        </form>
    <?php }elseif('two'===$settings['styleboxsearchkaveh']){ ?>
      <form action="/" method="get" autocomplete="off"
          class="top-header-two-search ms-auto d-lg-flex align-items-center position-relative">
          <input id="maninpu<?php echo $clsid; ?>" oninput="fetchData()" type="text" name="search" class="form-control" placeholder="<?php echo  esc_attr($settings['titlesearchkaveh']); ?>" />
          <button id="butno" type="submit" class="btn btn-primary btsearch">
            <i class="<?php echo  esc_attr($settings['iconsearchkaveh']['value']); ?>"></i>
          </button>
     </form>
     <style>
      <?php echo '.elementor-element-' . $clsid . ''; ?> .top-header-two-search .form-control {
      background-image: -webkit-linear-gradient(right, <?php echo  esc_attr($settings['backcolor21iconsearchkaveh']); ?>, <?php echo  esc_attr($settings['backcolor22iconsearchkaveh']); ?>);
      background-image: -moz-linear-gradient(right, <?php echo  esc_attr($settings['backcolor21iconsearchkaveh']); ?>, <?php echo  esc_attr($settings['backcolor22iconsearchkaveh']); ?>);
      background-image: -o-linear-gradient(right, <?php echo  esc_attr($settings['backcolor21iconsearchkaveh']); ?>, <?php echo  esc_attr($settings['backcolor22iconsearchkaveh']); ?>);
      background-image: linear-gradient(to left, <?php echo  esc_attr($settings['backcolor21iconsearchkaveh']); ?>, <?php echo  esc_attr($settings['backcolor22iconsearchkaveh']); ?>);
      }
     </style>
    <?php }elseif('three'===$settings['styleboxsearchkaveh']){ ?>
      <form action="/" method="get" autocomplete="off"
          class="top-header-three-search d-lg-flex align-items-lg-center d-flex">
          <input id="maninpu<?php echo $clsid; ?>" oninput="fetchData()" type="text" name="search" class="form-control" placeholder="<?php echo  esc_attr($settings['titlesearchkaveh']); ?>" />
          <button id="butno" type="submit" class="btn btn-primary p-0 btsearch btse3">
            <i class="<?php echo  esc_attr($settings['iconsearchkaveh']['value']); ?>"></i>
          </button>
        </form>
        <style>
          <?php echo '.elementor-element-' . $clsid . ''; ?> .top-header-three-search, .btse3{
            background-color: <?php echo  esc_attr($settings['t3colorupsearchkaveh']); ?>;
          }
        </style>
    <?php }elseif('four'===$settings['styleboxsearchkaveh']){ ?>
      <button type="button" class="top-header-four-btn-search d-lg-block btsearch">
          <i class="<?php echo  esc_attr($settings['iconsearchkaveh']['value']); ?>"></i>
        </button>
        <div class="top-header-four-search">
          <div class="backdrop"></div>
          <form action="/" method="get" autocomplete="off" class="position-relative">
            <input id="maninpu<?php echo $clsid; ?>" oninput="fetchData()" type="text" name="search" class="form-control" placeholder="<?php echo  esc_attr($settings['titlesearchkaveh']); ?>" />
            <button id="butno" type="submit">
              <i class="<?php echo  esc_attr($settings['iconsearchkaveh']['value']); ?>"></i>
            </button>
          </form>
        </div>
    <?php }elseif('five'===$settings['styleboxsearchkaveh']){ ?>
      <div class="top-header-fourteen">
      <button type="button" class="top-header-four-btn-search  btsearchs">
          <i class="<?php echo  esc_attr($settings['iconsearchkaveh']['value']); ?>"></i>
      </button>
        <div class="top-header-four-search">
          <div class="backdrop"></div>
          <form action="/" method="get" autocomplete="off" class="position-relative">
            <input id="maninpu<?php echo $clsid; ?>" oninput="fetchData()" oninput="fetchData()" type="text" name="search" class="form-control" placeholder="<?php echo  esc_attr($settings['titlesearchkaveh']); ?>">
            <button id="butno" type="submit">
              <i class="<?php echo  esc_attr($settings['iconsearchkaveh']['value']); ?>"></i>
            </button>
          </form>
        </div>
        </div>
    <?php }elseif('six'===$settings['styleboxsearchkaveh']){ ?>
      <form action="<?php echo site_url().'/?post_type=product$?s='; ?>" method="get" autocomplete="off"
          class="top-header-eleven-search d-flex align-items-center position-relative ms-lg-auto w-100 order-5 order-lg-3">
          <select name="category" class="form-control border-none">
            <?php $categories = get_categories( array(
                'taxonomy' => 'product_cat',
            ) ); ?>
            <?php foreach($categories as $category) : ?>
            <option value=""> <?php echo $category->name; ?> </option>
            <?php endforeach; ?> 
          </select>
          <input  type="text" name="search" class="form-control border-none"
          placeholder="<?php echo  esc_attr($settings['titlesearchkaveh']); ?>" />
          <button type="submit" class="position-absolute top-50 translate-middle-y">
            <i class="<?php echo  esc_attr($settings['iconsearchkaveh']['value']); ?>"></i>
          </button>
      </form>
    <?php } ?>
      <!--start search popup -->
      <div id="seeebox<?php echo $clsid; ?>" class="seeebox d-none">
          <div onclick="hidePopup<?php echo $clsid; ?>()" class="backdrop"></div>
          <div class="container position-fixed top-50 start-50 translate-middle">
           
            <span class="position-absolute top-0 end-0 bg-porp me-3 mt-3">
                 <svg  onclick="hidePopup<?php echo $clsid; ?>()" width="24px"  height="24px"  viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                <title>Iconly/Bulk/Close Square</title>
                <g id="Iconly/Bulk/Close-Square" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <g id="Group" transform="translate(1.999900, 1.999800)" fill="#060606"  fill-rule="nonzero">
                        <path d="M14.34,0 L5.67,0 C2.28,0 0,2.38 0,5.92 L0,14.09 C0,17.62 2.28,20 5.67,20 L14.34,20 C17.73,20 20,17.62 20,14.09 L20,5.92 C20,2.38 17.73,0 14.34,0" id="Fill-1" opacity="0.400000006"></path>
                        <path d="M13.0157,11.7705 L11.2367,9.9925 L13.0147,8.2145 C13.3567,7.8735 13.3567,7.3185 13.0147,6.9775 C12.6727,6.6335 12.1197,6.6345 11.7777,6.9765 L9.9987,8.7545 L8.2197,6.9745 C7.8777,6.6325 7.3237,6.6345 6.9817,6.9745 C6.6407,7.3165 6.6407,7.8715 6.9817,8.2125 L8.7617,9.9925 L6.9857,11.7675 C6.6437,12.1095 6.6437,12.6645 6.9857,13.0045 C7.1567,13.1765 7.3797,13.2615 7.6037,13.2615 C7.8287,13.2615 8.0517,13.1765 8.2227,13.0055 L9.9987,11.2295 L11.7787,13.0085 C11.9497,13.1795 12.1727,13.2645 12.3967,13.2645 C12.6207,13.2645 12.8447,13.1785 13.0157,13.0085 C13.3577,12.6665 13.3577,12.1125 13.0157,11.7705" id="Fill-4"></path>
                    </g>
                </g>
            </svg>
            بستن
            </span>
         

            <i class="icon-search position-absolute top-0 start-0 bg-purp"></i>
            <form id="manod<?php echo $clsid; ?>" action="/" method="get" autocomplete="off">
            <input id="keyword<?php echo $clsid; ?>" oninput="fetchData(this)" class="form-control position-absolute fetchinpu" type="text" placeholder="برای یافتن محصول مورد نیاز جستجو کنید"
              aria-label="default input example"></form>
            <div class="row seabox shadow-lg bg-white rounded-4 pt-5">
              <div class="col-lg-7 p-3 position-relative">
                <div class="swiper-sea-next position-absolute top-0 end-0 bg-white rounded">
                  <svg xmlns="http://www.w3.org/2000/svg" width="6.667" height="8" viewBox="0 0 6.667 8">
                    <path id="Arrow_-_Left_2" data-name="Arrow - Left 2" d="M7.246,9.246c.038-.039.18-.2.312-.34a14.46,14.46,0,0,1,3.864-2.683A3.078,3.078,0,0,1,12.208,6a1.289,1.289,0,0,1,.6.145,1.249,1.249,0,0,1,.53.6,6.566,6.566,0,0,1,.171.709,15.983,15.983,0,0,1,.161,2.537,18.486,18.486,0,0,1-.142,2.459,5.669,5.669,0,0,1-.227.885A1.19,1.19,0,0,1,12.246,14h-.038a3.253,3.253,0,0,1-.881-.273,14.46,14.46,0,0,1-3.779-2.644,3.773,3.773,0,0,1-.321-.369A1.189,1.189,0,0,1,7,10,1.25,1.25,0,0,1,7.246,9.246Z" transform="translate(-7 -6)" fill="#200e32"/>
                  </svg>
                </div>
                <div class="swiper-sea-prev position-absolute top-0 start-0 bg-white rounded">
                  <svg xmlns="http://www.w3.org/2000/svg" width="6.667" height="8" viewBox="0 0 6.667 8">
                    <path id="Arrow_-_Left_2" data-name="Arrow - Left 2" d="M7.246,9.246c.038-.039.18-.2.312-.34a14.46,14.46,0,0,1,3.864-2.683A3.078,3.078,0,0,1,12.208,6a1.289,1.289,0,0,1,.6.145,1.249,1.249,0,0,1,.53.6,6.566,6.566,0,0,1,.171.709,15.983,15.983,0,0,1,.161,2.537,18.486,18.486,0,0,1-.142,2.459,5.669,5.669,0,0,1-.227.885A1.19,1.19,0,0,1,12.246,14h-.038a3.253,3.253,0,0,1-.881-.273,14.46,14.46,0,0,1-3.779-2.644,3.773,3.773,0,0,1-.321-.369A1.189,1.189,0,0,1,7,10,1.25,1.25,0,0,1,7.246,9.246Z" transform="translate(-7 -6)" fill="#200e32"/>
                  </svg>
                </div>
                <div class="swiper swiper-seabox  ms-3 mx-4 overflow-hidden pb-5 pt-2">
                  <div class="swiper-wrapper search_result datafetch3" id="datafetch3">
                
                
                  </div>
                </div>

                <div class="row srows">
                  <div class="col-sm-12 col-md-6 col-lg-6 pt-2">
                    <p class="ps-2">
                      <svg class="mx-2" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                        <path id="Filter_2" data-name="Filter 2"
                          d="M4.554,2H23.446A2.592,2.592,0,0,1,26,4.631V6.469a2.668,2.668,0,0,1-.765,1.876l-7.806,7.9a.7.7,0,0,1-.507.213l-6.536-.02a.709.709,0,0,1-.524-.234L2.689,8.309A2.675,2.675,0,0,1,2,6.509V4.632A2.594,2.594,0,0,1,4.554,2Zm6.182,16.589,5.826.018a.67.67,0,0,1,.657.678v3.277a.959.959,0,0,1-.544.869l-5.288,2.483a.907.907,0,0,1-.886-.066.962.962,0,0,1-.426-.8V19.267A.669.669,0,0,1,10.736,18.589Z"
                          transform="translate(-2 -2)" fill="#212341" fill-rule="evenodd" />
                      </svg>
                      کالاها
                      <svg class="mx-2" xmlns="http://www.w3.org/2000/svg" width="20" height="1" viewBox="0 0 20 1">
                        <g id="Rectangle_509" data-name="Rectangle 509" fill="#a9a9a9" stroke="#919191" stroke-width="1">
                          <rect width="20" height="1" stroke="none" />
                          <rect x="0.5" y="0.5" width="19" fill="none" />
                        </g>
                      </svg>
                    </p>
                    
                    <div class="search_result datafetch" id="datafetch">

                    </div>

                
                  </div>
                  <div class="col-sm-12 col-md-6 col-lg-6 pt-2">
                    <p class="ps-2">
                      <svg class="mx-2" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                        <path id="Category"
                          d="M5.048,2H9.1a3.058,3.058,0,0,1,3.048,3.073V9.164A3.05,3.05,0,0,1,9.1,12.236H5.048A3.058,3.058,0,0,1,2,9.164V5.073A3.066,3.066,0,0,1,5.048,2Zm0,13.764H9.1a3.051,3.051,0,0,1,3.048,3.073v4.091A3.058,3.058,0,0,1,9.1,26H5.048A3.065,3.065,0,0,1,2,22.928V18.837A3.059,3.059,0,0,1,5.048,15.764ZM22.952,2H18.9a3.058,3.058,0,0,0-3.048,3.073V9.164A3.05,3.05,0,0,0,18.9,12.236h4.056A3.058,3.058,0,0,0,26,9.164V5.073A3.066,3.066,0,0,0,22.952,2ZM18.9,15.764h4.056A3.059,3.059,0,0,1,26,18.837v4.091A3.065,3.065,0,0,1,22.952,26H18.9a3.058,3.058,0,0,1-3.048-3.072V18.837A3.051,3.051,0,0,1,18.9,15.764Z"
                          transform="translate(-2 -2)" fill="#212341" fill-rule="evenodd" />
                      </svg>
                      دسته بندی ها
                      <svg class="mx-2" xmlns="http://www.w3.org/2000/svg" width="20" height="1" viewBox="0 0 20 1">
                        <g id="Rectangle_509" data-name="Rectangle 509" fill="#a9a9a9" stroke="#919191" stroke-width="1">
                          <rect width="20" height="1" stroke="none" />
                          <rect x="0.5" y="0.5" width="19" fill="none" />
                        </g>
                      </svg>
                    </p>
                    <div class="search_result datafetch2" id="datafetch2">

                    </div>
                  
                  
                    
                  </div>
                </div>
              </div>
              <div class="col-lg-5 p-3 justify-content-between position-relative">
                <div class="swiper swiper-geabox overflow-hidden position-relative">
                  <div class="swiper-wrapper">
                  <?php
                  $options = get_option( 'kaveh_frame' );
                  $mkpicsearchslider = $options['search-pic-repeater'];
                  ?>
                  <?php
                  for ($i = 0; $i < count($mkpicsearchslider); $i++) {
                      ?>
                    
                    <div class="swiper-slide">
                      <img class="d-block rounded-4 m-2 w-75" src="<?php echo $mkpicsearchslider[$i]['searc-pic']; ?>" alt="">
                    </div>
                      <?php
                  }
                  ?>
                  
                   
                  </div>
                  <div class="swiper-pagination"></div>

                </div>
                <img class="d-inline rounded-4 m-2 w-50 nomobile" src="<?php echo $options['aj-search']; ?>" alt="">
                <img class="d-inline rounded-4 m-2 w-50 nomobile" src="<?php echo $options['aj-search2'] ?>" alt="">
              </div>
            </div>
          </div>
        </div>
         <script>


      var theForm<?php echo $clsid; ?> = document.getElementById('manod<?php echo $clsid; ?>');
      var theDiv<?php echo $clsid; ?> = document.getElementById('seeebox<?php echo $clsid; ?>');
      var theInput<?php echo $clsid; ?> = document.getElementById('maninpu<?php echo $clsid; ?>');
      var theOutput<?php echo $clsid; ?> = document.getElementById('keyword<?php echo $clsid; ?>');
      theInput<?php echo $clsid; ?>.oninput = function(rmv){
        theDiv<?php echo $clsid; ?>.classList.remove('d-none');
      };
      function hidePopup<?php echo $clsid; ?>() {
        theDiv<?php echo $clsid; ?>.classList.add('d-none');
      }
      theInput<?php echo $clsid; ?>.addEventListener('input', function (evt) {
        theOutput<?php echo $clsid; ?>.value = theInput<?php echo $clsid; ?>.value;
        theOutput<?php echo $clsid; ?>.focus();
       });
       theOutput<?php echo $clsid; ?>.addEventListener('input', function (evtt) {
        theInput<?php echo $clsid; ?>.value = theOutput<?php echo $clsid; ?>.value;
       });
      theForm<?php echo $clsid; ?>.addEventListener('submit', function(event) {
        event.preventDefault();
      });
  
    </script>
    <style>
      .elementor .seeebox img {
        height: auto;
        max-width: 100%;
      }
    </style>
    <!--end search popup -->
    <?php
  }


}
