<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Productscarouselthirdstkaveh extends Widget_Base{

  public function get_name(){
    return 'productscarouselthirdstkaveh';
  }
 
  public function get_title(){
    return esc_html__( 'کاروسل محصولات سبک سه', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentproductscarouselthirdstkaveh',
        [
          'label' => esc_html__( 'تنظیمات عنوان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
  
      $this->add_control(
          'titleproductscarouselthirdstkaveh',
          [
              'label' => esc_html__( 'عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'پرفروش ترین محصولات', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'tagheadingproductscarouselthirdstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H3',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $this->end_controls_section();

      $this->start_controls_section(
        'content2productscarouselthirdstkaveh',
        [
          'label' => esc_html__( 'تنظیمات محصولات', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
  $this->add_control(
    'stylecartproductscarouselthirdstkaveh',
    [
      'label' => esc_html__( 'طرح بندی باکس محصول', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'one',
      'options' => [
        'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
        'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
        'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
        'four'  => esc_html__( 'طرح بندی چهارم', 'kaveh-core' ),
        'five'  => esc_html__( 'طرح بندی پنجم', 'kaveh-core' ),
        'six'  => esc_html__( 'طرح بندی ششم', 'kaveh-core' ),
        'seven'  => esc_html__( 'طرح بندی هفتم', 'kaveh-core' ),
        'eight'  => esc_html__( 'طرح بندی هشتم', 'kaveh-core' ),
        'nine'  => esc_html__( 'طرح بندی نهم', 'kaveh-core' ),
        'ten'  => esc_html__( 'طرح بندی دهم', 'kaveh-core' ),
        'eleven'  => esc_html__( 'طرح بندی یازدهم', 'kaveh-core' ),
        'twelve'  => esc_html__( 'طرح بندی دوازدهم', 'kaveh-core' ),
        'thirteen'  => esc_html__( 'طرح بندی سیزدهم', 'kaveh-core' ),
        'fourteen'  => esc_html__( 'طرح بندی چهاردهم', 'kaveh-core' ),
        'fifteen'  => esc_html__( 'طرح بندی پانزدهم', 'kaveh-core' ),
        'sixteen'  => esc_html__( 'طرح بندی شانزدهم', 'kaveh-core' ),

      ],
    ]
    );
    $this->add_control(
      'pproductscarouselthirdstkaveh',
      [
        'label' => esc_html__( 'نمایش محصولات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'all',
        'options' => [
          'all'  => esc_html__( 'همه', 'kaveh-core' ),
          'cat'  => esc_html__( 'دسته بندی', 'kaveh-core' ),
  
        ],
      ]
      );
      $this->add_control(
        'psortproductscarouselthirdstkaveh',
        [
          'label' => esc_html__( 'مرتب سازی محصولات براساس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => '',
          'condition' => [
            'pproductscarouselthirdstkaveh' => 'all',
          ],
          'options' => [
            ''  => esc_html__( 'تاریخ', 'kaveh-core' ),
            '_price'  => esc_html__( 'قیمت', 'kaveh-core' ),
            '_wc_average_rating'  => esc_html__( 'محبوب ترین', 'kaveh-core' ),
            'total_sales'  => esc_html__( 'بیشترین فروش', 'kaveh-core' ),
    
          ],
        ]
        );
        $this->add_control(
          'psortiproductscarouselthirdstkaveh',
          [
            'label' => esc_html__( 'نوع مرتب سازی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'desc',
            'condition' => [
              'pproductscarouselthirdstkaveh' => 'all',
            ],
            'options' => [
              'asc'  => esc_html__( 'صعودی', 'kaveh-core' ),
              'desc'  => esc_html__( 'نزولی', 'kaveh-core' ),
            ],
          ]
          );
  $options2 = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $options2[$category->term_id] = $category->name;
}
$this->add_control(
    'catproductscarouselthirdstkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $options2,
      'condition' => [
        'pproductscarouselthirdstkaveh' => 'cat',
      ],
    ]
);
$this->end_controls_section();

$this->start_controls_section(
  'content3productscarouselthirdstkaveh',
  [
    'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);
$this->add_control(
  'productnumberproductscarouselthirdstkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 20,
    'step' => 1,
    'default' => 5,
  ]
);
$this->add_control(
  'productcolumnproductscarouselthirdstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 4,

  ]
);
$this->add_control(
  'productcolumn2productscarouselthirdstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 3,

  ]
);
$this->add_control(
  'productcolumn3productscarouselthirdstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 1,

  ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'style_productscarouselthirdstkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor2productscarouselthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .products-category-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titleproductscarouselthirdstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .products-category-title',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_productscarouselthirdstkaveh',
        [
          'label' => esc_html__( 'استایل باکس', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'bordercolorrproductscarouselthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .products-category-wrapper::after ' => 'border: 1px solid  {{VALUE}}',
          ],
        ]
      );
      
      $this->add_control(
        'dotscolorrproductscarouselthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ دایره ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .products-category-title::after' => 'background-color : {{VALUE}}',
            '{{WRAPPER}} .products-category-title::before' => 'background-color : {{VALUE}}',
          ],
        ]
      );
      
      $this->add_control(
        'arrowbackproductscarouselthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه فلش ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .products-category .swiper-button-next' => 'background-color : {{VALUE}}',
            '{{WRAPPER}} .products-category .swiper-button-prev' => 'background-color : {{VALUE}}',
          ],
        ]
      );
      
      $this->end_controls_section();

        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>

<section class="products-category">
      <div class="container">
        <div class="products-category-wrapper position-relative">
          <<?php echo  esc_attr($settings['tagheadingproductscarouselthirdstkaveh']); ?> class="products-category-title mx-auto position-relative">
            <span> <?php echo  esc_html($settings['titleproductscarouselthirdstkaveh']); ?> </span>
          </<?php echo  esc_attr($settings['tagheadingproductscarouselthirdstkaveh']); ?>>
          <div class="swiper swiper-products-category swiper-shadow overflow-hidden">
          <div class="swiper-wrapper">
            <?php if('cat'===$settings['pproductscarouselthirdstkaveh']){ ?>
              <?php 
                  
               $q_pc2_query_args = array(
                  'post_type' => 'product',
                  'posts_per_page' => $settings['productnumberproductscarouselthirdstkaveh'],
                  'order' => 'DESC',
                  'orderby' => 'date',
                  'tax_query' => array(
                      array(
                          'taxonomy' => 'product_cat',
                          'field' => 'tag_ID',
                          'terms' => $settings['catproductscarouselthirdstkaveh'],
                      ),
                  ),
                  'meta_query' => array(
                      array(
                          'key' => '_stock_status',
                          'value' => 'outofstock',
                          'compare' => 'NOT IN',
                      ),
                  ),
              );

                  // The Query
                  $pc2_query = new \WP_Query($q_pc2_query_args);
                  
                  // The Loop
                  if ( $pc2_query->have_posts() ) {
                    while ( $pc2_query->have_posts() ) {
                      $pc2_query->the_post(); ?>
            <div class="swiper-slide">
                <?php  $styleproduct=$settings['stylecartproductscarouselthirdstkaveh']; ?>
                <?php get_template_part("template-part/product-cart-$styleproduct"); ?>
                </div>
                <?php
                    // Reset Original Post Data
                      wp_reset_postdata();
                    }
                  }
                      
                      ?>
                  <?php }elseif('all'===$settings['pproductscarouselthirdstkaveh']){
                    // WP_Query args
                $ordvalue = $settings['psortproductscarouselthirdstkaveh'];
                $ordi = $settings['psortiproductscarouselthirdstkaveh'];
                $q_pc2_query_args = array(
                  'post_type' => array('product'),
                  'posts_per_page' => $settings['productnumberproductscarouselthirdstkaveh'],
                  'order' => $ordi,
                  'orderby' => 'meta_value_num',
                  'meta_key'       => $ordvalue,
                  'meta_query' => array(
                    array(
                        'key' => '_stock_status',
                        'value' => 'outofstock',
                        'compare' => 'NOT IN',
                    ),
                   ),
                
                );

                // The Query
                $pc2_query = new \WP_Query($q_pc2_query_args);

                // The Loop
                if ( $pc2_query->have_posts() ) {
                  while ( $pc2_query->have_posts() ) {
                    $pc2_query->the_post(); ?>
                    <div class="swiper-slide">
                    <?php  $styleproduct2=$settings['stylecartproductscarouselthirdstkaveh']; ?>
                    <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                    </div>
                    <?php
                    // Reset Original Post Data
                      wp_reset_postdata();
                    }
                  }
                      
                      ?>
                    <?php } ?>
            </div>
            <div class="swiper-button-prev"></div>
            <div class="swiper-button-next"></div>
          </div>
          </div>
        </div>
      </div>
    </section>
<script>
        function init<?php echo $clsid; ?>() {
    // Swiper New Products
    new Swiper(".swiper-products-category", {
    navigation: {
      prevEl: ".swiper-button-next",
      nextEl: ".swiper-button-prev",
    },
    breakpoints: {
      320: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3productscarouselthirdstkaveh']); ?>,
        spaceBetween: 4,
      },
      576: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3productscarouselthirdstkaveh']); ?>,
        spaceBetween: 8,
      },
      768: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn2productscarouselthirdstkaveh']); ?>,
        spaceBetween: 8,
      },
      992: {
        slidesPerView: <?php echo  esc_html($settings['productcolumnproductscarouselthirdstkaveh']); ?>,
        spaceBetween: 11,
      },
    },
  });
}
      if (window.Swiper) {
    // Swiper library already loaded, initialize Swiper instance
    init<?php echo $clsid; ?>();
  } else {
    // Swiper library not yet loaded, wait for it to load
    window.addEventListener("load", function() {
      init<?php echo $clsid; ?>();
    });
  }
</script>
    <?php
  }


}
