<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Categoryverticalcolkaveh extends Widget_Base{

  public function get_name(){
    return 'categoryverticalcolkaveh';
  }

  public function get_title(){
    return esc_html__( 'ستون دسته بندی ها عمودی', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentcategoryverticalcolkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'title1categoryverticalcolkaveh',
        [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => 'دسته بندی',
  
        ]
      );
      $this->add_control(
        'tagheadingcategoryverticalcolkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H3',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
          ],
        ]
      );
      $repeater = new \Elementor\Repeater();
    $repeater->add_control(
      'titleccategoryverticalcolkaveh',
      [
        'label' => esc_html__( 'نوشته', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'تجهیزات کوهنوردی',
      ]
    );
    $repeater->add_control(
      'linkcategoryverticalcolkaveh',
      [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );
    $this->add_control(
      'listcategoryverticalcolkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'titleccategoryverticalcolkaveh' => esc_html__( 'تجهیزات کوهنوردی', 'kaveh-core' ),
            'linkcategoryverticalcolkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    ); 
       $this->end_controls_section();
       $this->start_controls_section(
        'style_ccategoryverticalcolkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      
      $this->add_control(
        'textcolorcategoryverticalcolkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .category-slider-banner .category .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_ccategoryverticalcolkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .category-slider-banner .category .title',
        ]
      );
      $this->add_control(
        'bgcolorcategoryverticalcolkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .category-slider-banner .category' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_ccategoryverticalcolkaveh',
        [
          'label' => esc_html__( 'استایل دسته بندی ها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcatcolorcategoryverticalcolkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .category-slider-banner .category ul li a' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'textcatcolorhovercategoryverticalcolkaveh',
        [
          'label' => esc_html__( 'رنگ هاور عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .category-slider-banner .category ul li a:hover' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlecat_ccategoryverticalcolkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .category-slider-banner .category ul li a',
        ]
      );
      $this->add_control(
        'bgcatshcolorcategoryverticalcolkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه شیپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .category-slider-banner .category ul li a::before' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'bgcatcolorcategoryverticalcolkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .category-slider-banner .category ul' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'widthbgcategoryverticalcolkaveh',
        [
          'label' => esc_html__( 'عرض المان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .category-slider-banner .category' => 'max-width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
        <section class="category-slider-banner">
    
        <div class="category">
          <<?php echo  esc_attr($settings['tagheadingcategoryverticalcolkaveh']); ?> class="title text-center "> <?php echo  esc_html($settings['title1categoryverticalcolkaveh']); ?> </<?php echo  esc_attr($settings['tagheadingcategoryverticalcolkaveh']); ?>>
          <ul>
          <?php
              if ( $settings['listcategoryverticalcolkaveh'] ) {
              foreach (  $settings['listcategoryverticalcolkaveh'] as $item ) {
              ?>
            <li>
              <a href="<?php echo  esc_url($item['titleccategoryverticalcolkaveh']); ?>" class="d-block"> <?php echo  esc_html($item['titleccategoryverticalcolkaveh']); ?> </a>
            </li>
            <?php 
            }
              }
            ?>
          </ul>
       
        </div>
        </section>

    <?php
  }


}
