<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Categorycarouselfourthstkaveh extends Widget_Base{

  public function get_name(){
    return 'categorycarouselfourthstkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل دسته بندی ها سبک چهار', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  } 

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentcategorycarouselfourthstkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );

        $this->add_control(
          'titlecategorycarouselfourthstkaveh',
          [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'دسته بندی ها',
    
          ]
        );
        $this->add_control(
          'tagheadingcategorycarouselfourthstkaveh',
          [
            'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'H3',
            'options' => [
              'H1'  => esc_html__( 'H1', 'kaveh-core' ),
              'H2' => esc_html__( 'H2', 'kaveh-core' ),
              'H3' => esc_html__( 'H3', 'kaveh-core' ),
              'H4' => esc_html__( 'H4', 'kaveh-core' ),
              'H5' => esc_html__( 'H5', 'kaveh-core' ),
              'H6' => esc_html__( 'H6', 'kaveh-core' ),
              'p' => esc_html__( 'p', 'kaveh-core' ),
              'div' => esc_html__( 'div', 'kaveh-core' ),
              'span' => esc_html__( 'span', 'kaveh-core' ),
            ],
          ]
        );
        $this->add_control(
          'imgbgcategorycarouselfourthstkave',
          [
            'label' => esc_html__( 'تصویر پس زمینه عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'selectors' => [
              '{{WRAPPER}} .categories-sixteen-title::before' =>
                  'background: url({{URL}})',
          ],
          ]
        );
        
      $repeater = new \Elementor\Repeater();
    $repeater->add_control(
      'imgcategorycarouselfourthstkaveh',
      [
        'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $repeater->add_control(
      'linkcategorycarouselfourthstkaveh',
      [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );
    $this->add_control(
      'listcategorycarouselfourthstkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'linkcategorycarouselfourthstkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    ); 
       $this->end_controls_section();
       $this->start_controls_section(
        'content4categorycarouselfourthstkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'productcolumncategorycarouselfourthstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 0.5,
          'default' => 4,
      
        ]
      ); 
      $this->add_control(
        'productcolumn2categorycarouselfourthstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 0.5,
          'default' => 3,
      
        ]
      );
      $this->add_control(
        'productcolumn3categorycarouselfourthstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 0.5,
          'default' => 1.5,
      
        ]
      );
             $this->end_controls_section();
       $this->start_controls_section(
        'style3_categorycarouselfourthstkaveh',
        [
          'label' => esc_html__( 'استایل تصویر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'imgsizecategorycarouselfourthstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 294,
          ],
          'selectors' => [
            '{{WRAPPER}} .catca4' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      
      $this->end_controls_section();
      $this->start_controls_section(
        'style4_categorycarouselfourthstkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'imgbgsizecategorycarouselfourthstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر پس زمینه عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 384,
          ],
          'selectors' => [
            '{{WRAPPER}} .categories-sixteen-title::before' => 'max-width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_categorycarouselfourthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .categories-sixteen-title',
        ]
      );
      $this->add_control(
        'tccolorcategorycarouselfourthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .categories-sixteen-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->end_controls_section();
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
<div class="categories-sixteen">
      <div class="container">
        <<?php echo  esc_attr($settings['tagheadingcategorycarouselfourthstkaveh']); ?> class="categories-sixteen-title position-relative">
        <?php echo  esc_html($settings['titlecategorycarouselfourthstkaveh']); ?>
        </<?php echo  esc_attr($settings['tagheadingcategorycarouselfourthstkaveh']); ?>>
        <div class="swiper swiper-categories-sixteen overflow-hidden">
          <div class="swiper-wrapper">
          <?php
              if ( $settings['listcategorycarouselfourthstkaveh'] ) {
              foreach (  $settings['listcategorycarouselfourthstkaveh'] as $item ) {
              ?>
            <!-- Start Category -->
            <div class="swiper-slide">
              <a href="<?php echo  esc_url($item['linkcategorycarouselfourthstkaveh']); ?>" class="d-block">
                <img src="<?php echo esc_url($item['imgcategorycarouselfourthstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['imgcategorycarouselfourthstkaveh'] )); ?>" class="d-block catca4" />
              </a>
            </div>
            <!-- End Category -->
            <?php 
            }
              }
            ?>
          </div>
          <div class="swiper-button-next d-none"></div>
          <div class="swiper-button-prev d-none"></div>
        </div>
      </div>
    </div>
    <style>
      <?php echo '.elementor-element-' . $clsid . ''; ?> .categories-sixteen-title::before {
    -webkit-background-size: cover;
    -moz-background-size: cover;
    -o-background-size: cover;
    background-size: cover;
    object-fit: cover;
}
    </style>
    <?php if( \Elementor\Plugin::$instance->editor->is_edit_mode() ) { ?>
    <script>
      function init<?php echo $clsid; ?>() {
  // Swiper Categories Sixteen
  new Swiper(".swiper-categories-sixteen", {
    breakpoints: {
      320: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3categorycarouselfourthstkaveh']); ?>,
        spaceBetween: 8,
      },
      500: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn2categorycarouselfourthstkaveh']); ?>,
        spaceBetween: 8,
      },
      768: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn2categorycarouselfourthstkaveh']); ?>,
        spaceBetween: 12,
      },
      992: {
        slidesPerView: <?php echo  esc_html($settings['productcolumncategorycarouselfourthstkaveh']); ?>,
        spaceBetween: 30,
      },
    },
  });
}
  if (window.Swiper) {
    // Swiper library already loaded, initialize Swiper instance
    init<?php echo $clsid; ?>();
  } else {
    // Swiper library not yet loaded, wait for it to load
    window.addEventListener("load", function() {
      init<?php echo $clsid; ?>();
    });
  }
    </script>
    <?php } ?>
    <?php
  }


}
