<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Brandsgridkaveh extends Widget_Base{

  public function get_name(){
    return 'brandsgridkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان برند های شبکه ای', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['headerfooterkavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentbrandsgridkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
          'brandlogobrandsgridkaveh',
          [
            'label' => esc_html__( 'تصویر برند', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
              'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
          ]
          );
          $repeater->add_control(
            'sociallinkbrandsgridkaveh',
            [
                'label' => esc_html__( 'لینک', 'kaveh-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( '#', 'kaveh-core' ),
        
            ]
        );
        $this->add_control(
          'listbrandsgridkaveh',
          [
            'label' => esc_html__( 'شبکه های اجتماعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
              [
                'sociallinkbrandsgridkaveh' => esc_html__( '#', 'kaveh-core' ),
              ],
          ]
          ]
        
        ); 
        $this->end_controls_section();
        $this->start_controls_section(
          'style1_brandsgridkaveh',
          [
            'label' => esc_html__( 'استایل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          ]
        ); 
        $this->add_control(
          'imgsizebrandsgridkaveh',
          [
            'label' => esc_html__( 'سایز تصویر', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 200,
                'step' => 1,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-namad li a img' => 'height: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'beforecolorbrandsgridkaveh',
          [
            'label' => esc_html__( 'رنگ خط بالا', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .footer-four .footer-namad::after' => 'background-color: {{VALUE}}',
              '{{WRAPPER}} .footer-four-news-letter::after' => 'background-color: {{VALUE}}',
            ],
          ]
        );
        $this->end_controls_section();
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
  
?>
          <div class="footer-four">
            <ul class="footer-namad d-flex align-items-center flex-wrap flex-sm-nowrap">
                <?php
                if ( $settings['listbrandsgridkaveh'] ) {
                foreach (  $settings['listbrandsgridkaveh'] as $item ) {
                ?>
              <li>
                <a href="<?php echo  esc_url($item['sociallinkbrandsgridkaveh']); ?>">
                  <img src="<?php echo esc_url($item['brandlogobrandsgridkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['brandlogobrandsgridkaveh'] )); ?>" />
                </a>
              </li>
                <?php
                  }
                }
                  ?>
            </ul>
          </div>
    <?php
  }


}
