<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Bloglistkaveh extends Widget_Base{

  public function get_name(){
    return 'bloglistkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان بلاگ لیست', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentbloglistkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );

  $optionsblog = array();
  $categories = get_categories(array(
    'hide_empty' => false,
  )
  ); 
  foreach ( $categories as $key => $category ) {
      $optionsblog[$category->term_id] = $category->name;
  }
  $this->add_control(
      'catblogenfhess',
      [
        'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT2, 
        'multiple' => true,
        'options' => $optionsblog,
      ]
  );
  
$this->add_control(
  'productnumberbloglistkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 20,
    'step' => 1,
    'default' => 5,
  ]
);
       $this->end_controls_section();

          
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>

<ul class="footer-three-articles">
          <?php
           
                  // WP_Query args
              $q_query_args = array(
                'post_type' => array('post'),
                'cat' => $settings['catblogenfhess'],
                'posts_per_page' => $settings['productnumberbloglistkaveh'],
                'order' => 'DESC',
                'orderby' => 'date',
              );

              // The Query
              $query = new \WP_Query($q_query_args);
              
              // The Loop
              if ( $query->have_posts() ) {
                while ( $query->have_posts() ) {
                  $query->the_post();
                ?>
              <li class="d-flex align-items-center">
                <img src="<?php the_post_thumbnail_url(); ?>" alt="article" class="d-block w-100" />
                <div class="detail w-100">
                  <h2 class="mb-0 text-nowrap overflow-hidden">
                    <a href="<?php the_permalink(); ?>"><?php $tit=the_title(); echo wp_trim_words($tit, 6) ?></a>
                  </h2>
                  
                  <span class="d-block text-nowrap overflow-hidden"><?php $exp=get_the_excerpt(); echo wp_trim_words($exp, 7)  ?></span>

                 

                </div>
              </li>
              <?php 
                }
              }
                // There are no posts
              // Reset Original Post Data
              wp_reset_postdata();
              
                  ?>
              
            </ul>
    <?php
  }


}
