<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Aparatframekaveh extends Widget_Base{

  public function get_name(){
    return 'aparatframekaveh';
  }

  public function get_title(){
    return esc_html__( 'المان آپارات', 'kaveh-core' );
  }

  public function get_icon(){ 
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentaparatframekaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
        $this->add_control(
          'beforetitleaparatframekaveh',
          [
              'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'ویدیو', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'titleaparatframekaveh',
        [
            'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'معرفی شرکت', 'kaveh-core' ),
    
        ]
    );
      $this->add_control(
        'codeaparatframekaveh',
        [
            'label' => esc_html__( 'کد آی فریم ویدیو از آپارات', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::CODE,
            'language' => 'html',
            'rows' => 100, 
        ]
    ); 


        $this->end_controls_section();
        $this->start_controls_section(
          'style_aparatframekaveh',
          [
            'label' => esc_html__( 'استایل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          ]
        );
        $this->add_control(
          'titlecolor1aparatframekaveh',
          [
            'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .about-us-introduction-company-heading .sup-title' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'titletypeaparatframekaveh',
            'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .about-us-introduction-company-heading .sup-title',
          ]
        );
        $this->add_control(
          'titlecolor2aparatframekaveh',
          [
            'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .about-us-introduction-company-heading .title' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'titletype2aparatframekaveh',
            'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .about-us-introduction-company-heading .title',
          ]
        );
        $this->end_controls_section();
          
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
  
?>
    <div class="about-us-introduction-company">
      <div class="container">
        <!-- Start Heading -->
        <div class="about-us-introduction-company-heading position-relative">
          <div class="sup-title fw-light">
          <?php echo  esc_html($settings['beforetitleaparatframekaveh']); ?>
          </div>
          <div class="title">
          <?php echo  esc_html($settings['titleaparatframekaveh']); ?>
         </div>
        </div>
        <!-- End Heading -->
        <div class="video-box position-relative w-100 mx-auto">
        <?php echo  $settings['codeaparatframekaveh']; ?>
      </div>
    </div>
    <?php
  }


}
