<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Amazingoffersixthstkaveh extends Widget_Base{

  public function get_name(){
    return 'amazingoffersixthstkaveh';
  }

  public function get_title(){
    return esc_html__( 'پیشنهاد شگفت انگیز طرح شش', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'عناوین', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );

      $this->add_control(
          'titleamazingoffersixthstkaveh',
          [
              'label' => esc_html__( 'عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'پیشنهاد', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'title2amazingoffersixthstkaveh',
        [
            'label' => esc_html__( 'عنوان دوم', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'شگفت انگیز', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tagheadingamazingoffersixthstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
        ],
      ]
    ); 
      $this->add_control(
        'moreamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'نمایش دکمه بیشتر؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'buttonamazingoffersixthstkaveh',
        [
            'label' => esc_html__( 'دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'مشاهده همه', 'kaveh-core' ),
            'condition' => [
              'moreamazingoffersixthstkaveh' => 'yes',
            ],
    
        ]
    );
    $this->add_control(
      'buttonlinkamazingoffersixthstkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
          'condition' => [
            'moreamazingoffersixthstkaveh' => 'yes',
          ],
  
      ]
  );
  $this->end_controls_section();
  $this->start_controls_section(
    'content2amazingoffersixthstkaveh',
    [
      'label' => esc_html__( 'تنظیمات نمایش', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
  );
  $optionsst2 = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $optionsst2[$category->term_id] = $category->name;
}
$this->add_control(
    'catamazingoffersixthstkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $optionsst2,
    ]
);
$this->add_control(
  'productnumberamazingoffersixthstkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 20,
    'step' => 1,
    'default' => 5,
  ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'content3amazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'تصویر', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'bgcenteramazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'تصویر وسط باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fourteen .content::before' =>
                'background-image: url({{URL}})',
        ],
        ]
      );
      
      $this->end_controls_section();
      $this->start_controls_section(
        'content4amazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'دکمه سبد خرید', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'carttitleamazingoffersixthstkaveh',
        [
            'label' => esc_html__( 'متن دکمه سبد خرید', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'افزودن به سبد خرید', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'iconiamazingoffersixthstkaveh',
      [
        'label' => esc_html__( 'آیکون دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon icon-cart-3',
        ],
      ]
    ); 
      $this->end_controls_section();
      $this->start_controls_section(
        'style_amazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor2amazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fourteen .title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2_amazingoffersixthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-fourteen .title',
        ]
      );
      
      $this->add_control(
        'textcolor3amazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fourteen .title span' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title21_amazingoffersixthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان دوم', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-fourteen .title span',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_amazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'moreamazingoffersixthstkaveh' => 'yes',
          ],
        ]
      );
      
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_amazingoffersixthstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-outline-dark',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowamazingoffersixthstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-outline-dark',
        ]
      );
      $this->start_controls_tabs(
        'style_tabsamazingoffersixthstkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncoloramazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .btn-outline-dark' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncoloramazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .btn-outline-dark' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .btn-outline-dark' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderamazingoffersixthstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-outline-dark',
        ]
      );
      $this->add_control(
        'buttonbordersamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderamazingoffersixthstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .btn-outline-dark' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoveramazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .btn-outline-dark:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoveramazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .btn-outline-dark:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoveramazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .btn-outline-dark:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoveramazingoffersixthstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-outline-dark:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoveramazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoveramazingoffersixthstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .btn-outline-dark:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowamazingoffersixthstkavehh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .btn-outline-dark',
        ]
      );
      $this->add_control(
        'hr1amazingoffersixthstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .btn-outline-dark' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_amazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'استایل باکس', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'boxbgclamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
        ]
      ); 
      $this->add_control(
        'shapeclamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه شیپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fourteen .content::after' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->end_controls_section();
      $this->start_controls_section(
        'style5_amazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'استایل فلش ها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'arrowclazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'رنگ فلش ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
        ]
      ); 
      $this->add_control(
        'arrowbrclazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'رنگ حاشیه فلش ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
        ]
      ); 
      
      $this->end_controls_section();
      $this->start_controls_section(
        'style4_amazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'استایل محصولات', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'timertextclamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'رنگ عدد تایمر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fourteen-item .detail .timear li span' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'timerbgclamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه تایمر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fourteen-item .detail .timear li span' => 'background-color: {{VALUE}}',
          ],
        ]
      );  
      $this->add_control(
        'timertitleclamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته تایمر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fourteen-item .detail .timear li' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'hramazingoffersixthstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_cartamazingoffersixthstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-fourteen-item .detail .btn',
        ]
      ); 
      $this->add_control(
        'iconsizeazingoffereightstkaveh',
        [
          'label' => esc_html__( 'سایز آیکون دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' =>13,
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fourteen-item .detail .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowcartamazingoffersixthstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-fourteen-item .detail .btn',
        ]
      );
      $this->start_controls_tabs(
        'style_tabscartamazingoffersixthstkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabcartamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorcartamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fourteen-item .detail .btn' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'iconclbuttoncolorcartam',
        [
          'label' => esc_html__( 'رنگ آیکون دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fourteen-item .detail .btn i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorcartamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fourteen-item .detail .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiuscartamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه افزودن به سبد خرید بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fourteen-item .detail .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'bordercartamazingoffersixthstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-fourteen-item .detail .btn',
        ]
      );
      $this->add_control(
        'buttonborderscartamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'bordercartamazingoffersixthstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fourteen-item .detail .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabcartamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhovercartamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fourteen-item .detail .btn:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'iconclhoverbuttoncolorcartamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fourteen-item .detail .btn i:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhovercartamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fourteen-item .detail .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushovercartamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه افزودن به سبد خرید بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fourteen-item .detail .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhovercartamazingoffersixthstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-fourteen-item .detail .btn:hover',
        ]
      );
      $this->add_control(
        'buttonbordershovercartamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhovercartamazingoffersixthstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fourteen-item .detail .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowcartamazingoffersixthstkaveh',
          'label' => esc_html__( 'سایه دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-fourteen-item .detail .btn',
        ]
      );
      $this->add_control(
        'hr1cartamazingoffersixthstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingcartamazingoffersixthstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fourteen-item .detail .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );

      $this->end_controls_section();
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="amazing-offer-fourteen">
      <div class="container">
        <div class="amazing-offer-fourteen-wrapper position-relative d-flex flex-column flex-lg-row">
          <<?php echo  esc_attr($settings['tagheadingamazingoffersixthstkaveh']); ?> class="title position-absolute">
          <?php echo  esc_html($settings['titleamazingoffersixthstkaveh']); ?>
            <span class="d-block"><?php echo  esc_html($settings['title2amazingoffersixthstkaveh']); ?></span>
          </<?php echo  esc_attr($settings['tagheadingamazingoffersixthstkaveh']); ?>>
          <div class="right">
          <?php if("yes"===$settings['moreamazingoffersixthstkaveh']){?>
            <a href="<?php echo  esc_url($settings['buttonlinkamazingoffersixthstkaveh']); ?>" class="btn btn-outline-dark text-nowrap"><?php echo  esc_html($settings['buttonamazingoffersixthstkaveh']); ?></a>
            <?php } ?>
          </div>
          <div class="content position-relative">
            <div class="swiper swiper-amazing-offer-two">
              <div class="swiper-wrapper">
              <?php 
                  
                  // WP_Query args
                  $q_pce_query_args = array(
                    'post_type' => array('product'),
                    'posts_per_page' => $settings['productnumberamazingoffersixthstkaveh'],
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'tax_query' => array(
                      array(
                        "taxonomy" => "product_cat",
                        "field"    => "tag_ID",
                        "terms"    => $settings['catamazingoffersixthstkaveh'],
                      ),
                    ),
                    'meta_query' => array(
                array(
                    'key' => '_stock_status',
                    'value' => 'outofstock',
                    'compare' => 'NOT IN',
                ),
               ),
                    'post__in' => array_merge(array(0), wc_get_product_ids_on_sale())
                  
                  );
                  
                  // The Query
                  $pce_query = new \WP_Query($q_pce_query_args);
                  
                  // The Loop
                  if ( $pce_query->have_posts() ) {
                    while ( $pce_query->have_posts() ) {
                      $pce_query->the_post(); 
                      global $product;
                      $product = wc_get_product();
                      $product_id = $product->get_id();
                      $product_type = $product->get_type();
                      $sale_price_dates_from = $sale_price_dates_to = '';
                      $sale_price= $product->get_sale_price();
                      $normal_price= $product->get_regular_price();
                      $pr_id = get_the_ID();
                      $stocka=$product->get_stock_status();?>
                <!-- Start Slide -->
                <div class="swiper-slide">
                  <div class="amazing-offer-fourteen-item d-flex position-relative flex-column flex-lg-row">
                    <img src="<?php the_post_thumbnail_url(); ?>" alt="product"
                      class="d-block position-absolute start-0 bottom-0" />
                    <div class="detail">
                      <div class="title overflow-hidden">
                        <a href="<?php the_permalink(); ?>"><h2><?php the_title(); ?></h2></a>
                      </div>
                      <div class="options overflow-hidden">
                        <ul class="d-flex flex-wrap">
                        <?php
                    $product_attributes = array();

                  // Display weight and dimensions before attribute list.
                  $display_dimensions = apply_filters( 'wc_product_enable_dimensions_display', $product->has_weight() || $product->has_dimensions() );

                  if ( $display_dimensions && $product->has_weight() ) {
                    $product_attributes['weight'] = array(
                      'label' => __( 'Weight', 'woocommerce' ),
                      'value' => wc_format_weight( $product->get_weight() ),
                    );
                  }

                  if ( $display_dimensions && $product->has_dimensions() ) {
                    $product_attributes['dimensions'] = array(
                      'label' => __( 'Dimensions', 'woocommerce' ),
                      'value' => wc_format_dimensions( $product->get_dimensions( false ) ),
                    );
                  }

                  // Add product attributes to list.
                  $attributes = array_filter( $product->get_attributes(), 'wc_attributes_array_filter_visible' );

                  foreach ( $attributes as $attribute ) {
                    $values = array();

                    if ( $attribute->is_taxonomy() ) {
                      $attribute_taxonomy = $attribute->get_taxonomy_object();
                      $attribute_values   = wc_get_product_terms( $product->get_id(), $attribute->get_name(), array( 'fields' => 'all' ) );

                      foreach ( $attribute_values as $attribute_value ) {
                        $value_name = esc_html( $attribute_value->name );

                        if ( $attribute_taxonomy->attribute_public ) {
                          $values[] = '<a href="' . esc_url( get_term_link( $attribute_value->term_id, $attribute->get_name() ) ) . '" rel="tag">' . $value_name . '</a>';
                        } else {
                          $values[] = $value_name;
                        }
                      }
                    } else {
                      $values = $attribute->get_options();

                      foreach ( $values as &$value ) {
                        $value = make_clickable( esc_html( $value ) );
                      }
                    }

                    $product_attributes[ 'attribute_' . sanitize_title_with_dashes( $attribute->get_name() ) ] = array(
                      'label' => wc_attribute_label( $attribute->get_name() ),
                      'value' => apply_filters( 'woocommerce_attribute', wpautop( wptexturize( implode( ', ', $values ) ) ), $attribute, $values ),
                    );
                  }

                  ?>
                <?php $countme=0; ?>	
                <?php foreach ( $product_attributes as $product_attribute_key => $product_attribute ) : ?>
                <?php if($countme < 4): ?>	
                <li> <?php echo $product_attribute['label']; ?> : <?php echo str_replace( 'p>' , 'span>' , $product_attribute['value'] ); ?> </li>
                <?php $countme += 1; ?>
                <?php endif; ?>
                <?php endforeach; ?> 
                        </ul>
                      </div>
                      <div class="price d-flex align-items-center fw-light">
                        <div class="offer rounded-pill text-white d-flex align-items-center">
                        <?php if(!empty($normal_price) ) { ?>
                    <?php if("instock"==$stocka){ ?>
                    <?php if ( !$product->is_type( 'variable' ) ) { ?>
                      <del class="rounded-pill"> <?php echo $normal_price; ?> </del>
                      <?php }
                      }
                     } ?>
                      <?php
                      if(!empty($normal_price) ) { 
                      if("instock"==$stocka){ 
                      if(!empty($sale_price) ) { ?> 
                      % <?php
                      $percentage = round( ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100 );
                      echo $percentage;
                      ?> 
                      <?php } 
                      }
                     }?> 
                     </div>
                     <?php if(!empty($sale_price) ) { ?>
                    <?php if("instock"==$stocka){ ?>
                    <?php if ( !$product->is_type( 'variable' ) ) { ?>
                      <span><?php echo $sale_price; ?></span>
                      <?php echo get_woocommerce_currency_symbol(); ?>
                    <?php }else{ 
                      $price_v = $product->get_price_html(); 
                      echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                    } 
                     ?>
                    <?php }
                   } ?>
                      </div>
                      <a href="#" type="submit" name="add-to-cart" value="<?php echo $pr_id ?>" class="btn btn-danger-2 position-relative single_add_to_cart_button">
                        <i class="<?php echo  esc_attr($settings['iconiamazingoffersixthstkaveh']['value']); ?> me-1"></i>
                        <?php echo  esc_html($settings['carttitleamazingoffersixthstkaveh']); ?>
                      </a>
                      <ul class="images d-flex align-items-center">
                      <?php
                      $attachment_ids = $product->get_gallery_image_ids();
                      if ( $attachment_ids && $product->get_image_id() ) {
                        $cou=0;
                      foreach ( $attachment_ids as $attachment_id ) {
                      if($cou<3){
                      ?>
                        <li class="position-relative d-flex align-items-end justify-content-center">
                          <img src="<?php echo wp_get_attachment_url( $attachment_id ); ?>" alt="product"
                            class="d-block w-100" />
                        </li>
                        <?php
                        $cou+=1;
                          }
                        }
                        }
                        ?>                       
                        <?php
                        if ($date_from = get_post_meta($product_id, '_sale_price_dates_from', true)){
                            $sale_price_dates_from = date('Y-m-d 00:00:00', $date_from);
                        }
                        if ($date_to = get_post_meta($product_id, '_sale_price_dates_to', true)){
                            $sale_price_dates_to = date('Y-m-d 23:59:59', $date_to);
                        }
                        $deal_start_date = $sale_price_dates_from;
                        $deal_start_time = strtotime($deal_start_date);
                        $deal_end_date = $sale_price_dates_to;
                        $deal_end_time = strtotime($deal_end_date, current_time('timestamp'));
                        //$current_date = current_time( 'Y-m-d H:i:s', true );
                        $current_time = strtotime('NOW', current_time('timestamp'));
                        $time_diff = ($deal_end_time - $current_time); ?>
                      <?php if (!empty($deal_end_date)){ ?>
                      </ul>
                      <ul class="timear d-flex align-items-center position-absolute start-0 top-0"
                        data-time="<?php  echo $deal_end_date; ?>">
                        <li class="fw-light">
                          <span
                            class="second d-flex align-items-center justify-content-center rounded-circle">
                            00 </span>
                          ثانیه
                        </li>
                        <li class="fw-light">
                          <span
                            class="minute d-flex align-items-center justify-content-center rounded-circle">
                            00 </span>
                          دقیقه
                        </li>
                        <li class="fw-light">
                          <span class="hour d-flex align-items-center justify-content-center rounded-circle">
                            00 </span>
                          ساعت
                        </li>
                        <li class="fw-light">
                          <span class="day d-flex align-items-center justify-content-center rounded-circle">
                            00 </span>
                          روز
                        </li>
                      </ul>
                      <?php }else{} ?>
                    </div>
                  </div>
                </div>
                <!-- End Slide -->
                <?php   }
                  } else {
                    // There are no posts
                  }

                  // Reset Original Post Data
                  wp_reset_postdata();
                  

                  
                  ?>
              </div>
              <div
                class="swiper-btns position-absolute top-0 start-0 rounded-pill d-flex align-items-center justify-content-center">
                <button type="button"
                  class="swiper-button-prev position-relative top-0 start-0 bottom-0 end-0"></button>
                <button type="button"
                  class="swiper-button-next position-relative top-0 start-0 bottom-0 end-0"></button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <style>
      <?php echo '.elementor-element-' . $clsid . ''; ?> .amazing-offer-fourteen .content::before {
    -webkit-background-size: cover !important;
    -moz-background-size: cover !important;
    -o-background-size: cover !important;
    background-size: cover !important;
    object-fit: cover !important;
}
<?php echo '.elementor-element-' . $clsid . ''; ?> .amazing-offer-fourteen .swiper-btns {
    border: 2px solid <?php echo esc_html($settings['arrowbrclazingoffersevenstkaveh']); ?>;
}
<?php echo '.elementor-element-' . $clsid . ''; ?> .amazing-offer-fourteen .swiper-button-next::after, .amazing-offer-fourteen .swiper-button-prev::after {
    color: <?php echo esc_html($settings['arrowclazingoffersevenstkaveh']); ?>;
}
<?php echo '.elementor-element-' . $clsid . ''; ?> .amazing-offer-fourteen-wrapper::before {
    background-image: -webkit-linear-gradient(top, <?php echo esc_html($settings['boxbgclamazingoffersixthstkaveh']); ?>, rgba(255, 239, 241, 0.31), #fff);
    background-image: -moz-linear-gradient(top, <?php echo esc_html($settings['boxbgclamazingoffersixthstkaveh']); ?>, rgba(255, 239, 241, 0.31), #fff);
    background-image: -o-linear-gradient(top, <?php echo esc_html($settings['boxbgclamazingoffersixthstkaveh']); ?>, rgba(255, 239, 241, 0.31), #fff);
    background-image: linear-gradient(to bottom, <?php echo esc_html($settings['boxbgclamazingoffersixthstkaveh']); ?>, rgba(255, 239, 241, 0.31), #fff);
}
<?php echo '.elementor-element-' . $clsid . ''; ?> .amazing-offer-fourteen-item .detail .timear li span{
  color: #fff;
}
<?php echo '.elementor-element-' . $clsid . ''; ?> .amazing-offer-fourteen .title{
  color: #000;

}
    </style>
    <?php if( \Elementor\Plugin::$instance->editor->is_edit_mode() ) { ?>
      <script>
        function init<?php echo $clsid; ?>() {
  // Swiper Amazing Offer Two
  new Swiper(".swiper-amazing-offer-two", {
    loop: true,
    slidesPerView: 1,
    spaceBetween: 0,
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    autoplay: {
      delay: 5000,
      disableOnInteraction: false,
      pauseOnMouseEnter: true,
    },
    effect: "fade",
    fadeEffect: {
      crossFade: true,
    },
  });
}
  if (window.Swiper) {
    // Swiper library already loaded, initialize Swiper instance
    init<?php echo $clsid; ?>();
  } else {
    // Swiper library not yet loaded, wait for it to load
    window.addEventListener("load", function() {
      init<?php echo $clsid; ?>();
    });
  }

      </script>
    <?php } ?>
    <?php
  }


}
