<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Sliderseventhkaveh extends Widget_Base{

  public function get_name(){
    return 'sliderseventhkaveh';
  }

  public function get_title(){
    return esc_html__( 'اسلایدر سبک هفت', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  } 

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentsliderseventhkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      ); 
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'titlesliderseventhkaveh',
        [
            'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'فروش انواع', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'tagheading1sliderseventhkaveh',
      [
        'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H6',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'title2sliderseventhkaveh',
      [
          'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'صنایع دستی فلزی', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'tagheading2sliderseventhkaveh',
    [
      'label' => esc_html__( 'تگ عنوان اصلی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'H3',
      'options' => [
        'H1'  => esc_html__( 'H1', 'kaveh-core' ),
        'H2' => esc_html__( 'H2', 'kaveh-core' ),
        'H3' => esc_html__( 'H3', 'kaveh-core' ),
        'H4' => esc_html__( 'H4', 'kaveh-core' ),
        'H5' => esc_html__( 'H5', 'kaveh-core' ),
        'H6' => esc_html__( 'H6', 'kaveh-core' ),
        'p' => esc_html__( 'p', 'kaveh-core' ),
        'div' => esc_html__( 'div', 'kaveh-core' ),
        'span' => esc_html__( 'span', 'kaveh-core' ),
      ],
    ]
  );
      $repeater->add_control(
        'buttonsliderseventhkaveh',
        [
            'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'محصولات', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'iconbuttsliderseventhkaveh',
      [
        'label' => esc_html__( 'آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'isax isax-arrow-left4',
        ],
      ]
    );
    $repeater->add_control(
      'linkbuttonsliderseventhkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'backsliderseventhkaveh',
    [
      'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::MEDIA,
    ]
  );
      $this->add_control(
        'slidessliderseventhkaveh',
        [
          'label' => esc_html__( 'اسلاید ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::REPEATER,
          'default' => [
            [
              'titlesliderseventhkaveh' => esc_html__( 'فروش انواع', 'kaveh-core' ),
              'title2sliderseventhkaveh' => esc_html__( 'صنایع دستی فلزی', 'kaveh-core' ),
              'buttonsliderseventhkaveh' => esc_html__( 'محصولات', 'kaveh-core' ),
              'linkbuttonsliderseventhkaveh' => esc_html__( '#', 'kaveh-core' ),
            ],
          ],
          'fields' => $repeater->get_controls()
          ],
      );
      $this->add_control(
        'backjsliderseventhkaveh',
        [
          'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,     
          'selectors' => [
            '{{WRAPPER}} .landing-fiveteen::before' => 'background: url({{URL}})',
        ],       
        ]
      );
      
      $this->add_control(
        'backj2sliderseventhkaveh',
        [
          'label' => esc_html__( 'تصویر پس زمینه داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,    
          'selectors' => [
            '{{WRAPPER}} .landing-fiveteen-wrapper::before' => 'background: url({{URL}})',
        ],        
        ]
      );
       $this->end_controls_section();
       $this->start_controls_section(
        'content2sliderseventhkaveh',
        [
          'label' => esc_html__( 'برند ها', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      ); 
      $this->add_control(
        'showbrandssliderseventhkaveh',
        [
          'label' => esc_html__( 'نمایش برند ها؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $repeater = new \Elementor\Repeater();

      $repeater->add_control(
        'brandlogosliderseventhkaveh',
        [
          'label' => esc_html__( 'تصویر برند', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
        ]
        );
        $repeater->add_control(
          'linkbrandsliderseventhkaveh',
          [
              'label' => esc_html__( 'لینک برند', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( '#', 'kaveh-core' ),
      
          ]
      );
    $this->add_control(
      'brandssliderseventhkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'condition' => [
          'showbrandssliderseventhkaveh' => 'yes',
        ],
        'default' => [
          [
            'linksliderseventhkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );
      $this->end_controls_section();
      $this->start_controls_section(
        'content3sliderseventhkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل برند ها', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                  'condition' => [
                    'showbrandssliderseventhkaveh' => 'yes',
                  ],
        ]
      );
      $this->add_control(
        'productcolumnsliderseventhkaveh',
        [
          'label' => esc_html__( 'تعداد ستون برند ها در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 7,
          'step' => 1,
          'default' => 6,
      
        ]
      );
      $this->add_control(
        'productcolumn2sliderseventhkaveh',
        [
          'label' => esc_html__( 'تعداد ستون برند ها در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 3,
      
        ]
      );
      $this->add_control(
        'productcolumn3sliderseventhkaveh',
        [
          'label' => esc_html__( 'تعداد ستون برند ها در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 1,
          'default' => 1,
      
        ]
      );
             $this->end_controls_section();
             $this->start_controls_section(
              'style1_sliderseventhkaveh',
              [
                'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
              ]
             );
             $this->add_control(
              'titlestsliderseventhkaveh',
              [
                'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                  '{{WRAPPER}} .landing-fiveteen-wrapper .detail .sup-title .subsli7t' => 'color: {{VALUE}}',
                ],
              ]
             );
             $this->add_group_control(
              \Elementor\Group_Control_Typography::get_type(),
              [
                'name' => 'title_sliderseventhkaveh',
                'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
                'selector' => '{{WRAPPER}} .landing-fiveteen-wrapper .detail .sup-title .subsli7t',
              ]
             );
             $this->add_control(
              'titlepstsliderseventhkaveh',
              [
                'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                  '{{WRAPPER}} .landing-fiveteen-wrapper .detail .title .sli7t' => 'color: {{VALUE}}',
                ],
              ]
             );
             $this->add_group_control(
              \Elementor\Group_Control_Typography::get_type(),
              [
                'name' => 'p_sliderseventhkaveh',
                'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
                'selector' => '{{WRAPPER}} .landing-fiveteen-wrapper .detail .title .sli7t',
              ]
             );
             $this->end_controls_section();
             
             
             
             
             
             $this->start_controls_section(
               'style2_sliderseventhkaveh',
               [
                 'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
                 'tab' => \Elementor\Controls_Manager::TAB_STYLE, 
               ]
              );
              $this->add_group_control(
               \Elementor\Group_Control_Typography::get_type(),
               [
                 'name' => 'button_sliderseventhkaveh',
                 'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
                 'selector' => '{{WRAPPER}} .landing-fiveteen-wrapper .detail .btn',
               ]
             );
             $this->add_control(
               'iconsizesliderseventhkaveh',
               [
                 'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::SLIDER,
                 'size_units' => [ 'px', '%' ],
                 'range' => [
                   'px' => [
                     'min' => 0,
                     'max' => 200,
                     'step' => 5,
                   ],
                   '%' => [
                     'min' => 0,
                     'max' => 100,
                   ],
                 ],
                 'selectors' => [
                   '{{WRAPPER}} .landing-fiveteen-wrapper .detail .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
                 ],
               ]
             );
             $this->add_group_control(
               \Elementor\Group_Control_Text_Shadow::get_type(),
               [
                 'name' => 'text_shadowsliderseventhkaveh',
                 'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
                 'selector' => '{{WRAPPER}} .landing-fiveteen-wrapper .detail .btn',
               ]
             );
             $this->start_controls_tabs(
               'style_tabssliderseventhkaveh'
             );
             
             $this->start_controls_tab(
               'style_normal_tabsliderseventhkaveh',
               [
                 'label' => esc_html__( 'عادی', 'kaveh-core' ),
               ]
             );
             $this->add_control(
               'textbuttoncolorsliderseventhkaveh',
               [
                 'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::COLOR,
                 'selectors' => [
                   '{{WRAPPER}} .landing-fiveteen-wrapper .detail .btn' => 'color: {{VALUE}}',
                 ],
               ]
             ); 
             $this->add_control(
               'iconcolorsliderseventhkaveh',
               [
                 'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::COLOR,
                 'selectors' => [
                   '{{WRAPPER}} .landing-fiveteen-wrapper .detail .btn i' => 'color: {{VALUE}}',
                 ],
               ]
             ); 
             $this->add_control(
               'buttoncolorsliderseventhkaveh',
               [
                 'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::COLOR,
                 'selectors' => [
                   '{{WRAPPER}} .landing-fiveteen-wrapper .detail .btn' => 'background-color: {{VALUE}}',
                 ],
               ]
             ); 
             $this->add_control(
               'buttonradiussliderseventhkaveh',
               [
                 'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::DIMENSIONS,
                 'size_units' => [ 'px' ],
                 'selectors' => [
                   '{{WRAPPER}} .landing-fiveteen-wrapper .detail .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                 ],
               ]
             );
             $this->add_group_control(
               \Elementor\Group_Control_Border::get_type(),
               [
                 'name' => 'bordersliderseventhkaveh',
                 'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
                 'selector' => '{{WRAPPER}} .landing-fiveteen-wrapper .detail .btn',
               ]
             );
             $this->add_control(
               'buttonborderssliderseventhkaveh',
               [
                 'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::DIMENSIONS,
                 'size_units' => [ 'px' ],
                 'condition' => [
                   'bordersliderseventhkaveh!' => '',
                 ],
                 'selectors' => [
                   '{{WRAPPER}} .landing-fiveteen-wrapper .detail .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                 ],
               ]
             );
             $this->end_controls_tab();
             $this->start_controls_tab(
               'style_hove_tabsliderseventhkaveh',
               [
                 'label' => esc_html__( 'هاور', 'kaveh-core' ),
               ]
             );
             $this->add_control(
               'textbuttoncolorhoversliderseventhkaveh',
               [
                 'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::COLOR,
                 'selectors' => [
                   '{{WRAPPER}} .landing-fiveteen-wrapper .detail .btn:hover' => 'color: {{VALUE}}',
                 ],
               ]
             ); 
             $this->add_control(
               'iconcolorhoversliderseventhkaveh',
               [
                 'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::COLOR,
                 'selectors' => [
                   '{{WRAPPER}} .landing-fiveteen-wrapper .detail .btn:hover i' => 'color: {{VALUE}}',
                 ],
               ]
             ); 
             $this->add_control(
               'buttoncolorhoversliderseventhkaveh',
               [
                 'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::COLOR,
                 'selectors' => [
                   '{{WRAPPER}} .landing-fiveteen-wrapper .detail .btn:hover' => 'background-color: {{VALUE}}',
                 ],
               ]
             ); 
             $this->add_control(
               'buttonradiushoversliderseventhkaveh',
               [
                 'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::DIMENSIONS,
                 'size_units' => [ 'px' ],
                 'selectors' => [
                   '{{WRAPPER}} .landing-fiveteen-wrapper .detail .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                 ],
               ]
             );
             $this->add_group_control(
               \Elementor\Group_Control_Border::get_type(),
               [
                 'name' => 'borderhoversliderseventhkaveh',
                 'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
                 'selector' => '{{WRAPPER}} .landing-fiveteen-wrapper .detail .btn:hover',
               ]
             );
             $this->add_control(
               'buttonbordershoversliderseventhkaveh',
               [
                 'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::DIMENSIONS,
                 'size_units' => [ 'px' ],
                 'condition' => [
                   'borderhoversliderseventhkaveh!' => '',
                 ],
                 'selectors' => [
                   '{{WRAPPER}} .landing-fiveteen-wrapper .detail .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                 ],
               ]
             );
             $this->end_controls_tab();
             $this->end_controls_tabs();
             $this->add_control(
               'hr1sliderseventhkaveh',
               [
                 'type' => \Elementor\Controls_Manager::DIVIDER,
               ]
             );
             $this->add_group_control(
               \Elementor\Group_Control_Box_Shadow::get_type(),
               [
                 'name' => 'box_shadowsliderseventhkavehh',
                 'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
                 'selector' => '{{WRAPPER}} .landing-fiveteen-wrapper .detail .btn',
               ]
             );
             $this->add_control(
               'buttonpaddingsliderseventhkaveh',
               [
                 'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::DIMENSIONS,
                 'size_units' => [ 'px' ],
                 'selectors' => [
                   '{{WRAPPER}} .landing-fiveteen-wrapper .detail .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                 ],
               ]
             );
              $this->end_controls_section();
             
             
             
              $this->start_controls_section(
               'style3_sliderseventhkaveh',
               [
                 'label' => esc_html__( 'استایل تصاویر', 'kaveh-core' ),
                 'tab' => \Elementor\Controls_Manager::TAB_STYLE, 
               ]
              );
             $this->add_control(
               'widthmainsliderseventhkaveh',
               [
                 'label' => esc_html__( 'سایز تصویر', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::SLIDER,
                 'size_units' => [ 'px', '%' ],
                 'range' => [
                   'px' => [
                     'min' => 0,
                     'max' => 2000,
                     'step' => 5,
                   ],
                   '%' => [
                     'min' => 0,
                     'max' => 100,
                   ],
                 ],
                 'default' => [
                   'unit' => 'px',
                   'size' => 336,
                 ],
                 'selectors' => [
                   '{{WRAPPER}} .landing-fiveteen-wrapper .image img' => 'width: {{SIZE}}{{UNIT}};',
                 ],
               ]
             );
             $this->add_control(
               'width2bgsliderseventhkaveh',
               [
                 'label' => esc_html__( 'سایز تصویر پس زمینه', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::SLIDER,
                 'size_units' => [ 'px', '%' ],
                 'range' => [
                   'px' => [
                     'min' => 0,
                     'max' => 2000,
                     'step' => 5,
                   ],
                   '%' => [
                     'min' => 0,
                     'max' => 100,
                   ],
                 ],
                 'default' => [
                   'unit' => 'px',
                   'size' => 350,
                 ],
                 'selectors' => [
                   '{{WRAPPER}} .landing-fiveteen::before' => 'width: {{SIZE}}{{UNIT}};',
                 ],
               ]
             );
             $this->add_control(
               'widthmabrandinsliderseventhkaveh',
               [
                 'label' => esc_html__( 'سایز برند ها', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::SLIDER,
                 'size_units' => [ 'px', '%' ],
                 'range' => [
                   'px' => [
                     'min' => 0,
                     'max' => 2000,
                     'step' => 5,
                   ],
                   '%' => [
                     'min' => 0,
                     'max' => 100,
                   ],
                 ],
                 'default' => [
                   'unit' => 'px',
                   'size' => 90,
                 ],
                 'selectors' => [
                   '{{WRAPPER}} .slider7brandimg' => 'width: {{SIZE}}{{UNIT}};',
                 ],
               ]
             );
              $this->end_controls_section();
              $this->start_controls_section(
               'style4_sliderseventhkaveh',
               [
                 'label' => esc_html__( 'استایل عمومی', 'kaveh-core' ),
                 'tab' => \Elementor\Controls_Manager::TAB_STYLE,
               ]
              );
              $this->add_control(
               'bgmaincolorsliderseventhkaveh',
               [
                 'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::COLOR,
                 'selectors' => [
                   '{{WRAPPER}} .landing-fiveteen-wrapper::before' => 'background-color: {{VALUE}}',
                 ],
               ]
             ); 
             $this->add_control(
               'dotsbordercolor2sliderseventhkaveh',
               [
                 'label' => esc_html__( 'رنگ حاشیه نقطه ها', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::COLOR,
                 'selectors' => [
                  '{{WRAPPER}} .landing-fiveteen .swiper-pagination' => 'border: 2px solid {{VALUE}}',
                ],
               ]
             ); 
             $this->add_control(
               'dotscolor2sliderseventhkaveh',
               [
                 'label' => esc_html__( 'رنگ نقطه ها', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::COLOR,
                 'selectors' => [
                   '{{WRAPPER}} .landing-fiveteen .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
                 ],
               ]
             ); 
             $this->add_control(
               'heightmainsliderseventhkaveh',
               [
                 'label' => esc_html__( 'ارتفاع اسلایدر', 'kaveh-core' ),
                 'type' => \Elementor\Controls_Manager::SLIDER,
                 'size_units' => [ 'px', '%' ],
                 'range' => [
                   'px' => [
                     'min' => 0,
                     'max' => 2000,
                     'step' => 5,
                   ],
                   '%' => [
                     'min' => 0,
                     'max' => 100,
                   ],
                 ],
                 'selectors' => [
                   '{{WRAPPER}} .landing-fiveteen-wrapper' => 'height: {{SIZE}}{{UNIT}};',
                 ],
               ]
             );
              $this->end_controls_section();
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <!-- Start Landing -->
    <section class="landing-fiveteen position-relative">
      <div class="container">
        <div class="landing-fiveteen-wrapper position-relative">
          <div class="swiper swiper-landing">
            <div class="swiper-wrapper">
              <?php
              if ( $settings['slidessliderseventhkaveh'] ) {
              foreach (  $settings['slidessliderseventhkaveh'] as $item ) {
              ?>
              <!-- Start Slide -->
              <div class="swiper-slide">
                <div class="landing-fiveteen-item">
                  <div class="row align-items-center">
                    <div class="col-lg-6">
                      <div class="image overflow-hidden">
                        <img src="<?php echo esc_url($item['backsliderseventhkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['backsliderseventhkaveh'] )); ?>"
                          class="d-block me-auto me-lg-0 ms-auto mb-4 mb-lg-0" />
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="detail">
                        <div class="sup-title overflow-hidden">
                          <<?php echo  esc_html($item['tagheading1sliderseventhkaveh']); ?> class="d-block subsli7t"><?php echo  esc_html($item['titlesliderseventhkaveh']); ?></<?php echo  esc_html($item['tagheading1sliderseventhkaveh']); ?>>
                        </div>
                        <div class="title overflow-hidden">
                          <<?php echo  esc_html($item['tagheading2sliderseventhkaveh']); ?> class="mb-0 sli7t"><?php echo  esc_html($item['title2sliderseventhkaveh']); ?></<?php echo  esc_html($item['tagheading2sliderseventhkaveh']); ?>>
                        </div>
                        <a href="<?php echo  esc_url($item['linkbuttonsliderseventhkaveh']); ?>" class="btn btn-primary mt-4">
                        <?php echo  esc_html($item['buttonsliderseventhkaveh']); ?>
                          <i class="<?php echo  esc_attr($item['iconbuttsliderseventhkaveh']['value']); ?>"></i>
                        </a>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <!-- End Slide -->
             <?php
                }
              }
              ?>
            </div>
            <div class="swiper-button-next d-none"></div>
            <div class="swiper-button-prev d-none"></div>
            <div class="swiper-pagination"></div>
          </div>
        </div>
      </div>
    </section>
    <!-- End Landing -->
    <?php if("yes"===$settings['showbrandssliderseventhkaveh']){?>
    <!-- Start Brands -->
    <div class="brands brands-fiveteen">
      <div class="container">
        <div class="brands-wrapper position-relative">
          <div class="swiper swiper-brands overflow-hidden">
            <div class="swiper-wrapper">
            <?php
              if ( $settings['brandssliderseventhkaveh'] ) {
              foreach (  $settings['brandssliderseventhkaveh'] as $item ) {
              ?>
              <div class="swiper-slide">
                <a href="<?php echo  esc_url($item['linkbrandsliderseventhkaveh']); ?>" class="brands-item d-block">
                  <img class="slider7brandimg" src="<?php echo esc_url($item['brandlogosliderseventhkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['brandlogosliderseventhkaveh'] )); ?>" />
                </a>
              </div>
              <?php
                }
              }
              ?>
            </div>
            <div class="swiper-button-next d-none"></div>
            <div class="swiper-button-prev d-none"></div>
          </div>
        </div>
      </div>
    </div>
    <?php } ?>

    <style>
<?php echo '.elementor-element-' . $clsid . ''; ?> .landing-fiveteen::before {
    -webkit-background-size: cover !important;
    -moz-background-size: cover !important;
    -o-background-size: cover !important;
    background-size: cover !important;

}
<?php echo '.elementor-element-' . $clsid . ''; ?> .landing-fiveteen-wrapper::before {
    -webkit-background-size: cover !important;
    -moz-background-size: cover !important;
    -o-background-size: cover !important;
    background-size: cover !important;
}
    </style>

  <script>
          function init<?php echo $clsid; ?>() {
  // Swiper Landing
  new Swiper(".swiper-landing", {
    slidesPerView: 1,
    spaceBetween: 0,
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    pagination: {
      el: ".swiper-pagination",
      type: "bullets",
      clickable: true,
    },
    autoplay: {
      delay: 5000,
      disableOnInteraction: false,
      pauseOnMouseEnter: true,
    },
    effect: "fade",
    fadeEffect: {
      crossFade: true,
    },
    loop: true,
  });
  // Swiper Brands
  new Swiper(".swiper-brands", {
    loop: true,
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    breakpoints: {
      320: {
        slidesPerView: <?php echo  esc_attr($settings['productcolumn3sliderseventhkaveh']); ?>,
        spaceBetween: 4,
      },
      576: {
        slidesPerView: <?php echo  esc_attr($settings['productcolumn2sliderseventhkaveh']); ?>,
        spaceBetween: 8,
      },
      768: {
        slidesPerView: <?php echo  esc_attr($settings['productcolumn2sliderseventhkaveh']); ?>,
        spaceBetween: 12,
      },
      992: {
        slidesPerView: <?php echo  esc_attr($settings['productcolumnsliderseventhkaveh']); ?>,
        spaceBetween: 12,
      },
    },
  });
}
      if (window.Swiper) {
    // Swiper library already loaded, initialize Swiper instance
    init<?php echo $clsid; ?>();
  } else {
    // Swiper library not yet loaded, wait for it to load
    window.addEventListener("load", function() {
      init<?php echo $clsid; ?>();
    });
  }
  </script>
    <?php  
  }


}
