<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Productstabgridkaveh extends Widget_Base{

  public function get_name(){
    return 'productstabgridkaveh';
  }

  public function get_title(){
    return esc_html__( 'تب محصولات شبکه ای', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentproductstabgridkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
      'tabtitle1productstabgridkaveh',
      [
        'label' => esc_html__( 'عنوان تب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $repeater->add_control(
      'pproductstabgridkaveh',
      [
        'label' => esc_html__( 'نمایش محصولات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'all',
        'options' => [
          'all'  => esc_html__( 'همه', 'kaveh-core' ),
          'cat'  => esc_html__( 'دسته بندی', 'kaveh-core' ),
  
        ],
      ]
      );
      $repeater->add_control(
        'psortproductstabgridkaveh',
        [
          'label' => esc_html__( 'مرتب سازی محصولات براساس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => '',
          'condition' => [
            'pproductstabgridkaveh' => 'all',
          ],
          'options' => [
            ''  => esc_html__( 'تاریخ', 'kaveh-core' ),
            '_price'  => esc_html__( 'قیمت', 'kaveh-core' ),
            '_wc_average_rating'  => esc_html__( 'محبوب ترین', 'kaveh-core' ),
            'total_sales'  => esc_html__( 'بیشترین فروش', 'kaveh-core' ),
    
          ],
        ]
        );
        $repeater->add_control(
          'psortiproductstabgridkaveh',
          [
            'label' => esc_html__( 'نوع مرتب سازی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'desc',
            'condition' => [
              'pproductstabgridkaveh' => 'all',
            ],
            'options' => [
              'asc'  => esc_html__( 'صعودی', 'kaveh-core' ),
              'desc'  => esc_html__( 'نزولی', 'kaveh-core' ),
            ],
          ]
          );
    $taboptiongrid = array();
    $orderby = 'name';
    $order = 'asc';
    $hide_empty = false ;
    $cat_args = array(
        'orderby'    => $orderby,
        'order'      => $order,
        'hide_empty' => $hide_empty,
    );
    $product_categories = get_terms( 'product_cat', $cat_args );
    
    foreach ( $product_categories as $key => $category ) {
        $taboptiongrid[$category->term_id] = $category->name;
    }
    $repeater->add_control(
        'cat2productstabgridkaveh',
        [
          'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT2, 
          'multiple' => false,
          'options' => $taboptiongrid,
          'condition' => [
            'pproductstabgridkaveh' => 'cat',
          ],
        ]
    );
    $repeater->add_control(
      'productnumberproductstabgridkaveh',
      [
        'label' => esc_html__( 'تعداد محصولات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 20,
        'step' => 1,
        'default' => 8,
      ]
    );
    $this->add_control(
      'listproductstabgridkaveh',
      [
        'label' => esc_html__( 'تب ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tabtitle1productstabgridkaveh' => esc_html__( 'دسته بندی', 'kaveh-core' ),
          ],
        ],
      ]
    );

  $this->add_control(
    'styleproductstabgridkaveh',
    [
      'label' => esc_html__( 'طرح بندی باکس محصول', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'one',
      'options' => [
        'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
        'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
        'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
        'four'  => esc_html__( 'طرح بندی چهارم', 'kaveh-core' ),
        'five'  => esc_html__( 'طرح بندی پنجم', 'kaveh-core' ),
        'six'  => esc_html__( 'طرح بندی ششم', 'kaveh-core' ),
        'seven'  => esc_html__( 'طرح بندی هفتم', 'kaveh-core' ),
        'eight'  => esc_html__( 'طرح بندی هشتم', 'kaveh-core' ),
        'nine'  => esc_html__( 'طرح بندی نهم', 'kaveh-core' ),
        'ten'  => esc_html__( 'طرح بندی دهم', 'kaveh-core' ),
        'eleven'  => esc_html__( 'طرح بندی یازدهم', 'kaveh-core' ),
        'twelve'  => esc_html__( 'طرح بندی دوازدهم', 'kaveh-core' ),
        'thirteen'  => esc_html__( 'طرح بندی سیزدهم', 'kaveh-core' ),
        'fourteen'  => esc_html__( 'طرح بندی چهاردهم', 'kaveh-core' ),
        'fifteen'  => esc_html__( 'طرح بندی پانزدهم', 'kaveh-core' ),
        'sixteen'  => esc_html__( 'طرح بندی شانزدهم', 'kaveh-core' ),
      ],
    ]
    );

       $this->end_controls_section();
       $this->start_controls_section(
        'style1_productstabgridkaveh',
        [
          'label' => esc_html__( 'استایل تب ها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'buttontextcolorproductstabgridkaveh',
        [
          'label' => esc_html__( 'رنگ متن', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-products-three-tabs .nav-item .nav-link' => 'color: {{VALUE}}',
  
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'buttonst3_productstabgridkaveh',
          'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-products-three-tabs .nav-item .nav-link',
        ]
      ); 
      $this->add_control(
        'buttoncoloractivest3productstabgridkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه تب فعال', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-products-three-tabs .nav-item .nav-link.active' => 'background-color: {{VALUE}}',
            '{{WRAPPER}} .top-products-three-tabs .nav-item .nav-link:hover' => 'background-color: {{VALUE}}',
  
          ],
        ]
      ); 
      $this->add_control(
        'buttontextactivecolorproductstabgridkaveh',
        [
          'label' => esc_html__( 'رنگ متن در حالت فعال', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-products-three-tabs .nav-item .nav-link.active' => 'color: {{VALUE}}',
            '{{WRAPPER}} .top-products-three-tabs .nav-item .nav-link:hover' => 'color: {{VALUE}}',

  
          ],
        ]
      ); 
      $this->add_control(
        'buttonpaddingproductstabgridkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-products-three-tabs .nav-item .nav-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'buttonradius1productstabgridkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-products-three-tabs .nav-item .nav-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
  
         $this->end_controls_section();
          
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
  <section class="top-products-three">
    <div class="container position-relative">
      <!-- Start Tabs -->
      <ul class="nav nav-tabs top-products-three-tabs d-flex align-items-center">
      <?php
        $q=1;
        if ( $settings['listproductstabgridkaveh'] ) {
        foreach (  $settings['listproductstabgridkaveh'] as $item ) {
        ?>
        <li class="nav-item">
          <a href="#pro-<?php echo $q; ?>" class="nav-link <?php if(1===$q){?>active <?php }else{}?>" data-bs-toggle="tab"> <?php echo  esc_html($item['tabtitle1productstabgridkaveh']); ?> </a>
        </li>
        <?php 
      $q++;
      }
        }
      ?>
      </ul>
      <!-- End Tabs -->
      <div class="tab-content">
      <?php
        $s=1;
        if ( $settings['listproductstabgridkaveh'] ) {
        foreach (  $settings['listproductstabgridkaveh'] as $item ) {
        ?>
        <div id="pro-<?php echo $s; ?>" class="tab-pane fade <?php if(1==$s){?>active show<?php }else{}?>">
          <!-- Start Products -->
          <div class="row">
            <?php
          if('cat'===$item['pproductstabgridkaveh']){
                // WP_Query args
                $q_ptkg_query_args = array(
                    'post_type' => array('product'),
                    'posts_per_page' => $item['productnumberproductstabgridkaveh'],
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'tax_query' => array(
                    array(
                        "taxonomy" => "product_cat",
                        "field"    => "tag_ID",
                        "terms"    => $item['cat2productstabgridkaveh'],
                    ),
                    'meta_query' => array(
                      array(
                          'key' => '_stock_status',
                          'value' => 'outofstock',
                          'compare' => 'NOT IN',
                      ),
                     ),
                    ),
                    
                    
                );

                // The Query
                $ptkg_query = new \WP_Query($q_ptkg_query_args);

                // The Loop
                if ( $ptkg_query->have_posts() ) {
                    while ( $ptkg_query->have_posts() ) {
                    $ptkg_query->the_post(); ?>
            <div class="col-sm-6 col-md-4 col-lg-3">
                <?php  $styleproduct21=$settings['styleproductstabgridkaveh']; ?>
                 <?php get_template_part("template-part/product-cart-$styleproduct21"); ?>
            </div>
            <?php
                // Reset Original Post Data
                    wp_reset_postdata();
                }
                }
                    
                ?>
              <?php 
    
      }else{ 
      // WP_Query args
      $ordvalue = $item['psortproductstabgridkaveh'];
      $ordi = $item['psortiproductstabgridkaveh'];
      $q_ptkg_query_args = array(
        'post_type' => array('product'),
        'posts_per_page' => $item['productnumberproductstabgridkaveh'],
        'order' => $ordi,
        'orderby' => 'meta_value_num',
        'meta_key'       => $ordvalue,
        'meta_query' => array(
          array(
              'key' => '_stock_status',
              'value' => 'outofstock',
              'compare' => 'NOT IN',
          ),
         ),
       
      );

      // The Query
      $ptkg_query = new \WP_Query($q_ptkg_query_args);

      // The Loop
      if ( $ptkg_query->have_posts() ) {
        while ( $ptkg_query->have_posts() ) {
          $ptkg_query->the_post(); ?>
                      <div class="col-sm-6 col-md-4 col-lg-3 tbgrid">
                       <?php  $styleproduct21=$settings['styleproductstabgridkaveh']; ?>
                        <?php get_template_part("template-part/product-cart-$styleproduct21"); ?>
            </div>
            <?php
                // Reset Original Post Data
                    wp_reset_postdata();
                }
                    }
                        }
                  
                  ?>  
          </div>
          <!-- End Products -->
        </div>
        <?php
      $s++;
        }
          }
        
      ?>
      </div>
    </div>
  </section>
    <?php if( \Elementor\Plugin::$instance->editor->is_edit_mode() ) { ?>
    <script>
            function init<?php echo $clsid; ?>() {
              // Swiper Products
  new Swiper(".swiper-products", {
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    breakpoints: {
      320: {
        slidesPerView: 1,
        spaceBetween: 4,
      },
      500: {
        slidesPerView: 2,
        spaceBetween: 14,
      },
      768: {
        slidesPerView: 3,
        spaceBetween: 14,
      },
      992: {
        slidesPerView: 4,
        spaceBetween: 20,
      },
      1200: {
        slidesPerView: 4,
        spaceBetween: 31,
      },
    },
  });
  // Swiper Top products Two
  new Swiper(".swiper-top-products-two", {
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    breakpoints: {
      320: {
        slidesPerView: 1,
        spaceBetween: 4,
      },
      576: {
        slidesPerView: 2,
        spaceBetween: 8,
      },
      768: {
        slidesPerView: 3,
        spaceBetween: 8,
      },
      992: {
        slidesPerView: 4,
        spaceBetween: 12,
      },
      1200: {
        slidesPerView: 4,
        spaceBetween: 18,
      },
    },
  });
}
      if (window.Swiper) {
    // Swiper library already loaded, initialize Swiper instance
    init<?php echo $clsid; ?>();
  } else {
    // Swiper library not yet loaded, wait for it to load
    window.addEventListener("load", function() {
      init<?php echo $clsid; ?>();
    });
  }
    </script>
<?php  } ?>
    <?php
  }


}
