<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Productscarouselsecondstkaveh extends Widget_Base{

  public function get_name(){
    return 'productscarouselsecondstkaveh';
  }
 
  public function get_title(){
    return esc_html__( 'کاروسل محصولات سبک دو', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }
 
  protected function register_controls(){
    
    $this->start_controls_section(
        'contentproductscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'تنظیمات عنوان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
   
      $this->add_control(
          'titleproductscarouselsecondstkaveh',
          [
              'label' => esc_html__( 'عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'پرفروش ترین محصولات', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'tagheadingproductscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H3',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
  $this->end_controls_section();
  $this->start_controls_section(
    'content2productscarouselsecondstkaveh',
    [
      'label' => esc_html__( 'تنظیمات محصولات', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
  );
  $this->add_control(
    'stylecartproductscarouselsecondstkaveh',
    [
      'label' => esc_html__( 'طرح بندی باکس محصول', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'one',
      'options' => [
        'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
        'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
        'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
        'four'  => esc_html__( 'طرح بندی چهارم', 'kaveh-core' ),
        'five'  => esc_html__( 'طرح بندی پنجم', 'kaveh-core' ),
        'six'  => esc_html__( 'طرح بندی ششم', 'kaveh-core' ),
        'seven'  => esc_html__( 'طرح بندی هفتم', 'kaveh-core' ),
        'eight'  => esc_html__( 'طرح بندی هشتم', 'kaveh-core' ),
        'nine'  => esc_html__( 'طرح بندی نهم', 'kaveh-core' ),
        'ten'  => esc_html__( 'طرح بندی دهم', 'kaveh-core' ),
        'eleven'  => esc_html__( 'طرح بندی یازدهم', 'kaveh-core' ),
        'twelve'  => esc_html__( 'طرح بندی دوازدهم', 'kaveh-core' ),
        'thirteen'  => esc_html__( 'طرح بندی سیزدهم', 'kaveh-core' ),
        'fourteen'  => esc_html__( 'طرح بندی چهاردهم', 'kaveh-core' ),
        'fifteen'  => esc_html__( 'طرح بندی پانزدهم', 'kaveh-core' ),
        'sixteen'  => esc_html__( 'طرح بندی شانزدهم', 'kaveh-core' ),

      ],
    ]
    );
    $this->add_control(
      'pproductscarouselsecondstkaveh',
      [
        'label' => esc_html__( 'نمایش محصولات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'all',
        'options' => [
          'all'  => esc_html__( 'همه', 'kaveh-core' ),
          'cat'  => esc_html__( 'دسته بندی', 'kaveh-core' ),
  
        ],
      ]
      );
      $this->add_control(
        'psortproductscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'مرتب سازی محصولات براساس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => '',
          'condition' => [
            'pproductscarouselsecondstkaveh' => 'all',
          ],
          'options' => [
            ''  => esc_html__( 'تاریخ', 'kaveh-core' ),
            '_price'  => esc_html__( 'قیمت', 'kaveh-core' ),
            '_wc_average_rating'  => esc_html__( 'محبوب ترین', 'kaveh-core' ),
            'total_sales'  => esc_html__( 'بیشترین فروش', 'kaveh-core' ),
    
          ],
        ]
        );
        $this->add_control(
          'psortiproductscarouselsecondstkaveh',
          [
            'label' => esc_html__( 'نوع مرتب سازی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'desc',
            'condition' => [
              'pproductscarouselsecondstkaveh' => 'all',
            ],
            'options' => [
              'asc'  => esc_html__( 'صعودی', 'kaveh-core' ),
              'desc'  => esc_html__( 'نزولی', 'kaveh-core' ),
            ],
          ]
          );
  $options2 = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $options2[$category->term_id] = $category->name;
}
$this->add_control(
    'catproductscarouselsecondstkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $options2,
      'condition' => [
        'pproductscarouselsecondstkaveh' => 'cat',
      ],
    ]
);
$this->end_controls_section();
$this->start_controls_section(
  'content3productscarouselsecondstkaveh',
  [
    'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);
$this->add_control(
  'productnumberproductscarouselsecondstkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 20,
    'step' => 1,
    'default' => 5,
  ]
);
$this->add_control(
  'productcolumnproductscarouselsecondstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 4,

  ]
);
$this->add_control(
  'productcolumn2productscarouselsecondstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 3,

  ]
);
$this->add_control(
  'productcolumn3productscarouselsecondstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 1,

  ]
); 
       $this->end_controls_section();
       $this->start_controls_section(
        'style_productscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor2productscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-selling-products-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titleproductscarouselsecondstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .best-selling-products-title',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_productscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'استایل پس زمینه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'bgcolorproductscarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-selling-products::before' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->end_controls_section();
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>

<section class="best-selling-products position-relative">
      <div class="container">
        <<?php echo  esc_attr($settings['tagheadingproductscarouselsecondstkaveh']); ?> class="best-selling-products-title text-center"><?php echo  esc_html($settings['titleproductscarouselsecondstkaveh']); ?></<?php echo  esc_attr($settings['tagheadingproductscarouselsecondstkaveh']); ?>>
        <div class="swiper swiper-products swiper-shadow overflow-hidden">
          <div class="swiper-wrapper">
            <?php if('cat'===$settings['pproductscarouselsecondstkaveh']){ ?>
              <?php 
                  
                  // WP_Query args
                  $q_pc2_query_args = array(
                    'post_type' => array('product'),
                    'posts_per_page' => $settings['productnumberproductscarouselsecondstkaveh'],
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'tax_query' => array(
                      array(
                        "taxonomy" => "product_cat",
                        "field"    => "tag_ID",
                        "terms"    => $settings['catproductscarouselsecondstkaveh'],
                      ),
                    ),
                    'meta_query' => array(
                      array(
                          'key' => '_stock_status',
                          'value' => 'outofstock',
                          'compare' => 'NOT IN',
                      ),
                     ),
                     
                    
                  );

                  // The Query
                  $pc2_query = new \WP_Query($q_pc2_query_args);
                  
                  // The Loop
                  if ( $pc2_query->have_posts() ) {
                    while ( $pc2_query->have_posts() ) {
                      $pc2_query->the_post(); ?>
            <div class="swiper-slide">
             <?php  $styleproduct=$settings['stylecartproductscarouselsecondstkaveh']; ?>
            <?php get_template_part("template-part/product-cart-$styleproduct"); ?>
            </div>
            <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
                  
                  ?>
              <?php }elseif('all'===$settings['pproductscarouselsecondstkaveh']){
                // WP_Query args
            $ordvalue = $settings['psortproductscarouselsecondstkaveh'];
            $ordi = $settings['psortiproductscarouselsecondstkaveh'];
            $q_pc2_query_args = array(
              'post_type' => array('product'),
              'posts_per_page' => $settings['productnumberproductscarouselsecondstkaveh'],
              'order' => $ordi,
              'orderby' => 'meta_value_num',
              'meta_key'       => $ordvalue,
              'meta_query' => array(
                array(
                    'key' => '_stock_status',
                    'value' => 'outofstock',
                    'compare' => 'NOT IN',
                ),
               ),
             
            ); 

            // The Query
            $pc2_query = new \WP_Query($q_pc2_query_args);

            // The Loop
            if ( $pc2_query->have_posts() ) {
              while ( $pc2_query->have_posts() ) {
                $pc2_query->the_post(); ?>
                <div class="swiper-slide">
                <?php  $styleproduct2=$settings['stylecartproductscarouselsecondstkaveh']; ?>
                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                </div>
                <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
                  
                  ?>
                <?php } ?>
            </div>
          </div>
          <div class="swiper-button-next d-none"></div>
          <div class="swiper-button-prev d-none"></div>
        </div>
      </div>
    </section>
    <script>
            function init<?php echo $clsid; ?>() {
        // Swiper Products
  new Swiper(".swiper-products", {
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
      breakpoints: {
      320: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3productscarouselsecondstkaveh']); ?>,
        spaceBetween: 4,
      },
      500: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3productscarouselsecondstkaveh']); ?>,
        spaceBetween: 14,
      },
      768: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn2productscarouselsecondstkaveh']); ?>,
        spaceBetween: 14,
      },
      992: {
        slidesPerView: <?php echo  esc_html($settings['productcolumnproductscarouselsecondstkaveh']); ?>,
        spaceBetween: 20,
      },
      1200: {
        slidesPerView: <?php echo  esc_html($settings['productcolumnproductscarouselsecondstkaveh']); ?>,
        spaceBetween: 31,
      },
    },
  });
}
      if (window.Swiper) {
    // Swiper library already loaded, initialize Swiper instance
    init<?php echo $clsid; ?>();
  } else {
    // Swiper library not yet loaded, wait for it to load
    window.addEventListener("load", function() {
      init<?php echo $clsid; ?>();
    });
  }
    </script>
    <style>
      <?php echo '.elementor-element-' . $clsid . ''; ?> .top-sellers-two .swiper::before {
    content: "";
    right: 0;
    bottom: 190px;
    left: 0;
    width: 80%;
    -webkit-border-radius: 50px;
    -moz-border-radius: 50px;
    border-radius: 50px;
    background-color: #ee273a;
    height: 50px;
    margin: 0 auto;
}
    </style>
    <?php
  }


}
