<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Productscarouselkaveh extends Widget_Base{

  public function get_name(){
    return 'productscarouselkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل محصولات', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentproductscarouselkaveh',
        [
          'label' => esc_html__( 'تنظیمات عنوان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'styleheadingproductscarouselkaveh',
        [
          'label' => esc_html__( 'طرح بندی عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'one',
          'options' => [
            'one'  => esc_html__( 'طرح بندی یک', 'kaveh-core' ),
            'two'  => esc_html__( 'طرح بندی دو', 'kaveh-core' ),  
            'three'  => esc_html__( 'طرح بندی سه', 'kaveh-core' ),  
            'four'  => esc_html__( 'طرح بندی چهار', 'kaveh-core' ),  
            'five'  => esc_html__( 'طرح بندی پنج', 'kaveh-core' ),  
            'six'  => esc_html__( 'طرح بندی شش', 'kaveh-core' ),  
            'seven'  => esc_html__( 'طرح بندی هفت', 'kaveh-core' ),  
            'eight'  => esc_html__( 'طرح بندی هشت', 'kaveh-core' ),  
            'nine'  => esc_html__( 'طرح بندی نه', 'kaveh-core' ),  
          ],
        ]
        );
        $this->add_control(
          'iconproductscarouselkaveh',
          [
            'label' => esc_html__( 'آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::ICONS,
            'skin' => 'inline',
            'exclude_inline_options' => [ 'svg' ],
            'condition' => [
              'styleheadingproductscarouselkaveh' => 'two',
            ],
            'default' => [
              'value' => 'icon icon-footbal',
            ],
          ]
        ); 
        $this->add_control(
          'imgtitleproductscarouselkaveh',
          [
            'label' => esc_html__( 'تصویر کنار عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'selectors' => [
              '{{WRAPPER}} .best-selling-fiveteen .section-heading .detail::before' => 'background: url({{URL}})',
              '{{WRAPPER}} .new-products-fourteen .section-heading .detail::after' => 'background: url({{URL}})',

          ],
            'condition' => [
              'styleheadingproductscarouselkaveh' => ['eight','seven'],
            ],
          ]
        );
        
      $this->add_control(
          'titleproductscarouselkaveh',
          [
              'label' => esc_html__( 'عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'پرفروش ترین های', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'tagheading1productscarouselkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H3',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'title2productscarouselkaveh',
        [
            'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'گوشی موبایل', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tagheading2productscarouselkaveh',
      [
        'label' => esc_html__( 'تگ زیر عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H6',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
      $this->add_control(
        'moreproductscarouselkaveh',
        [
          'label' => esc_html__( 'نمایش دکمه بیشتر؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
          'condition' => [
            'styleheadingproductscarouselkaveh!' => 'seven',
          ],
        ]
      );
      $this->add_control(
        'buttonproductscarouselkaveh',
        [
            'label' => esc_html__( 'دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'مشاهده همه', 'kaveh-core' ),
            'condition' => [
              'moreproductscarouselkaveh' => 'yes',
            ],
            'condition' => [
              'styleheadingproductscarouselkaveh!' => 'seven',
            ],
    
        ]
    );
    $this->add_control(
      'buttonlinkproductscarouselkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
          'condition' => [
            'moreproductscarouselkaveh' => 'yes',
          ],
          'condition' => [
            'styleheadingproductscarouselkaveh!' => 'seven',
          ],
      ]
  );
  $this->end_controls_section();

  $this->start_controls_section(
    'content2productscarouselkaveh',
    [
      'label' => esc_html__( 'تنظیمات محصولات', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
  );
  $this->add_control(
    'pproductscarouselkaveh',
    [
      'label' => esc_html__( 'نمایش محصولات', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'all',
      'options' => [
        'all'  => esc_html__( 'همه', 'kaveh-core' ),
        'cat'  => esc_html__( 'دسته بندی', 'kaveh-core' ),

      ],
    ]
    );
    $this->add_control(
      'psortproductscarouselkaveh',
      [
        'label' => esc_html__( 'مرتب سازی محصولات براساس', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '',
        'condition' => [
          'pproductscarouselkaveh' => 'all',
        ],
        'options' => [
          ''  => esc_html__( 'تاریخ', 'kaveh-core' ),
          '_price'  => esc_html__( 'قیمت', 'kaveh-core' ),
          '_wc_average_rating'  => esc_html__( 'محبوب ترین', 'kaveh-core' ),
          'total_sales'  => esc_html__( 'بیشترین فروش', 'kaveh-core' ),
  
        ],
      ]
      );
      $this->add_control(
        'psortiproductscarouselkaveh',
        [
          'label' => esc_html__( 'نوع مرتب سازی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'desc',
          'condition' => [
            'pproductscarouselkaveh' => 'all',
          ],
          'options' => [
            'asc'  => esc_html__( 'صعودی', 'kaveh-core' ),
            'desc'  => esc_html__( 'نزولی', 'kaveh-core' ),
          ],
        ]
        );
  $this->add_control(
    'stylecartproductscarouselkaveh',
    [
      'label' => esc_html__( 'طرح بندی باکس محصول', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'one',
      'options' => [
        'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
        'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
        'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
        'four'  => esc_html__( 'طرح بندی چهارم', 'kaveh-core' ),
        'five'  => esc_html__( 'طرح بندی پنجم', 'kaveh-core' ),
        'six'  => esc_html__( 'طرح بندی ششم', 'kaveh-core' ),
        'seven'  => esc_html__( 'طرح بندی هفتم', 'kaveh-core' ),
        'eight'  => esc_html__( 'طرح بندی هشتم', 'kaveh-core' ),
        'nine'  => esc_html__( 'طرح بندی نهم', 'kaveh-core' ),
        'ten'  => esc_html__( 'طرح بندی دهم', 'kaveh-core' ),
        'eleven'  => esc_html__( 'طرح بندی یازدهم', 'kaveh-core' ),
        'twelve'  => esc_html__( 'طرح بندی دوازدهم', 'kaveh-core' ),
        'thirteen'  => esc_html__( 'طرح بندی سیزدهم', 'kaveh-core' ),
        'fourteen'  => esc_html__( 'طرح بندی چهاردهم', 'kaveh-core' ),
        'fifteen'  => esc_html__( 'طرح بندی پانزدهم', 'kaveh-core' ),
        'sixteen'  => esc_html__( 'طرح بندی شانزدهم', 'kaveh-core' ),

      ],
    ]
    );
    $this->add_control(
      'barproductscarouselkaveh',
      [
        'label' => esc_html__( 'نمایش نوار رنگی پس زمینه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'yes' => esc_html__( 'بله', 'kaveh-core' ),
        'no' => esc_html__( 'خیر', 'kaveh-core' ),
        'return_value' => 'yes',
        'default' => 'no',
        'condition' => [
          'styleheadingproductscarouselkaveh' => 'one',
        ],
      ]
    );
  $options2 = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $options2[$category->term_id] = $category->name;
}
$this->add_control(
    'catproductscarouselkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $options2,
      'condition' => [
        'pproductscarouselkaveh' => 'cat',
      ],
    ]
);
$this->end_controls_section();

$this->start_controls_section(
  'content3productscarouselkaveh',
  [
    'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);
$this->add_control(
  'overflow2productscarouselkaveh',
  [
    'label' => esc_html__( 'نمایش تمام عرض کاروسل', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'yes' => esc_html__( 'بله', 'kaveh-core' ),
    'no' => esc_html__( 'خیر', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'yes',
  ]
);
$this->add_control(
  'productnumberproductscarouselkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 20,
    'step' => 1,
    'default' => 5,
  ]
);
$this->add_control(
  'productcolumnproductscarouselkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 4,

  ]
);
$this->add_control(
  'productcolumn2productscarouselkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 3,

  ]
);
$this->add_control(
  'productcolumn3productscarouselkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 1,
    'default' => 1,

  ]
);
       $this->end_controls_section();
      $this->start_controls_section(
        'style_productscarouselkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor2productscarouselkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_productscarouselkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-title',
        ]
      );
      $this->add_control(
        'textcolor3productscarouselkaveh',
        [
          'label' => esc_html__( 'رنگ زیر عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-sub-title' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2_productscarouselkaveh',
          'label' => esc_html__( 'تایپوگرافی زیر عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-sub-title',
        ]
      );
      $this->add_control(
        'prtitleproductscarouselkave',
        [
          'label' => esc_html__( 'فاصله از راست', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 0,
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading .detail' => 'padding-right: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'hr1productscarouselkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleheadingproductscarouselkaveh!' => 'nine',
          ],
        ]
      ); 
      $this->add_control(
        'iconcolorproductscarouselkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleheadingproductscarouselkaveh' => 'two',
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-two .detail i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'iconsizeproductscarouselkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'condition' => [
            'styleheadingproductscarouselkaveh' => 'two',
          ],
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 31,
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-two .detail i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'shapecolorproductscarouselkaveh',
        [
          'label' => esc_html__( 'رنگ شیپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleheadingproductscarouselkaveh' => 'four',
          ],
          'selectors' => [
            '{{WRAPPER}} .consol-game .section-heading .detail::before' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'shapest51colorproductscarouselkaveh',
        [
          'label' => esc_html__( 'رنگ اول', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'default' => esc_html__( '#b3bbc7', 'kaveh-core' ),
          'condition' => [
            'styleheadingproductscarouselkaveh' => 'five',
          ],
        ]
      ); 
      $this->add_control(
        'shapest52colorproductscarouselkaveh',
        [
          'label' => esc_html__( 'رنگ دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'default' => esc_html__( '#FFFFFF00', 'kaveh-core' ),
          'condition' => [
            'styleheadingproductscarouselkaveh' => 'five',
          ],
        ]
      ); 
      $this->add_control(
        'shapest61colorproductscarouselkaveh',
        [
          'label' => esc_html__( 'رنگ اول', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'default' => esc_html__( '#00ff93', 'kaveh-core' ),
          'condition' => [
            'styleheadingproductscarouselkaveh' => 'six',
          ],
        ]
      ); 
      $this->add_control(
        'shapest62colorproductscarouselkaveh',
        [
          'label' => esc_html__( 'رنگ دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'default' => esc_html__( '#FFFFFF00', 'kaveh-core' ),
          'condition' => [
            'styleheadingproductscarouselkaveh' => 'six',
          ],
        ]
      ); 
      $this->add_control(
        'shapest71colorproductscarouselkaveh',
        [
          'label' => esc_html__( 'رنگ اول پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'default' => esc_html__( '#fff3f0', 'kaveh-core' ),
          'condition' => [
            'styleheadingproductscarouselkaveh' => 'seven',
          ],
        ]
      ); 
      $this->add_control(
        'shapest72colorproductscarouselkaveh',
        [
          'label' => esc_html__( 'رنگ دوم پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'default' => esc_html__( '#ecfcfc', 'kaveh-core' ),
          'condition' => [
            'styleheadingproductscarouselkaveh' => 'seven',
          ],
        ]
      ); 
      $this->add_control(
        'width7productscarouselkaveh',
        [
          'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'condition' => [
            'styleheadingproductscarouselkaveh' => ['eight','seven'],
          ],
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 20,
          ],
        ]
      ); 
      $this->add_control(
        'widthbg7productscarouselkaveh',
        [
          'label' => esc_html__( 'عرض تصویر پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'condition' => [
            'styleheadingproductscarouselkaveh' => 'seven',
          ],
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 53,
          ],
          'selectors' => [
            '{{WRAPPER}} .new-products-fourteen .section-heading .detail::before' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'heigthbg7productscarouselkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'condition' => [
            'styleheadingproductscarouselkaveh' => 'seven',
          ],
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 106,
          ],
          'selectors' => [
            '{{WRAPPER}} .new-products-fourteen .section-heading .detail::before' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'hr2productscarouselkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleheadingproductscarouselkaveh!' => 'nine',
          ],
        ]
      );
      $this->add_control(
        'textcolorback1productscarouselkaveh',
        [
          'label' => esc_html__( 'رنگ اول بک گراند', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleheadingproductscarouselkaveh' => 'two',
          ],
          'default' => '#fff9eb',

        ]
      ); 
      $this->add_control(
        'textcolorback2productscarouselkaveh',
        [
          'label' => esc_html__( 'رنگ دوم بک گراند', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleheadingproductscarouselkaveh' => 'two',
          ],
          'default' => '#fff',

        ]
      ); 
      $this->add_control(
        'buttonradiusst5productscarouselkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده بک گراند', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'styleheadingproductscarouselkaveh' => 'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .best-sellers-eleven .section-heading .detail::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'buttonradiusst6productscarouselkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده بک گراند', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'styleheadingproductscarouselkaveh' => 'six',
          ],
          'selectors' => [
            '{{WRAPPER}} .best-seller-products .section-heading .detail::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} .category-products-four .section-heading .detail::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

          ],
        ]
      );
      $this->add_control(
        'buttonradiusst7productscarouselkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده بک گراند', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'styleheadingproductscarouselkaveh' => 'seven',
          ],
          'selectors' => [
            '{{WRAPPER}} .new-products-fourteen .section-heading .detail::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_productscarouselkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'styleheadingproductscarouselkaveh!' => 'seven',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_productscarouselkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-link',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowproductscarouselkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-link',
        ]
      );
      $this->start_controls_tabs(
        'style_tabsproductscarouselkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabproductscarouselkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorproductscarouselkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-link' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorproductscarouselkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-link' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusproductscarouselkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderproductscarouselkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-link',
        ]
      );
      $this->add_control(
        'buttonbordersproductscarouselkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderbrandscarouselkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-link' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabproductscarouselkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoverproductscarouselkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-link:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoverproductscarouselkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .section-heading-link:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      );  
      $this->add_control(
        'buttonradiushoverproductscarouselkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-link:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoverproductscarouselkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-link:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoverproductscarouselkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderbrandscarouselkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-link:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowproductscarouselkavehh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .section-heading-link',
        ]
      );
      $this->add_control(
        'hr22productscarouselkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingproductscarouselkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'styleheadingproductscarouselkaveh!' => 'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_productscarouselkaveh',
        [
          'label' => esc_html__( 'استایل پس زمینه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'styleheadingproductscarouselkaveh' => 'nine',
          ],
        ]
      );
      $this->add_control(
        'bgcolor9productscarouselkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .best-selling-sixteen::before' => 'background: {{VALUE}}',
            '{{WRAPPER}} .best-selling-sixteen::after' => 'background: {{VALUE}}',

        ],
        ]
      ); 
      
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>

<section class="top-seller-home <?php if("yes"===$settings['barproductscarouselkaveh']){?>top-sellers-two<?php }?><?php if('two'===$settings['styleheadingproductscarouselkaveh']){ ?>top-seller-home-five<?php }elseif('three'===$settings['styleheadingproductscarouselkaveh']){ ?>products-category-two<?php }elseif('four'===$settings['styleheadingproductscarouselkaveh']){ ?>consol-game<?php }elseif('five'===$settings['styleheadingproductscarouselkaveh']){ ?>best-sellers-eleven<?php }elseif('six'===$settings['styleheadingproductscarouselkaveh']){ ?>best-seller-products<?php }elseif('seven'===$settings['styleheadingproductscarouselkaveh']){ ?>new-products-fourteen<?php }elseif('eight'===$settings['styleheadingproductscarouselkaveh']){ ?>best-selling-fiveteen<?php }elseif('nine'===$settings['styleheadingproductscarouselkaveh']){ ?>best-selling-sixteen<?php } ?>">
      <div class="container position-relative">
        <!-- Start Heading -->
          <?php if('one'===$settings['styleheadingproductscarouselkaveh']){ ?>
      <div
          class="section-heading position-relative d-flex align-items-sm-center justify-content-sm-between flex-column flex-sm-row">
          <div class="detail">
            <<?php echo  esc_attr($settings['tagheading1productscarouselkaveh']); ?> class="section-heading-title"><?php echo  esc_html($settings['titleproductscarouselkaveh']); ?></<?php echo  esc_attr($settings['tagheading1productscarouselkaveh']); ?>>
            <<?php echo  esc_attr($settings['tagheading2productscarouselkaveh']); ?> class="section-heading-sub-title"><?php echo  esc_html($settings['title2productscarouselkaveh']); ?></<?php echo  esc_attr($settings['tagheading2productscarouselkaveh']); ?>>
          </div>
          <?php if("yes"===$settings['moreproductscarouselkaveh']){?>
          <a href="<?php echo  esc_url($settings['buttonlinkproductscarouselkaveh']); ?>" class="section-heading-link btn btn-outline-dark"><?php echo  esc_html($settings['buttonproductscarouselkaveh']); ?></a>
        <?php } ?>
      </div> 
          <?php }elseif('two'===$settings['styleheadingproductscarouselkaveh']){?>
      <div
          class="section-heading section-heading-two position-relative d-flex align-items-sm-center justify-content-sm-between flex-column flex-sm-row">
            <div class="detail position-relative">
            <i class="<?php echo  esc_html($settings['iconproductscarouselkaveh']['value']); ?> position-absolute top-50 translate-middle-y start-0"></i>
            <<?php echo  esc_attr($settings['tagheading1productscarouselkaveh']); ?> class="section-heading-title"> <?php echo  esc_html($settings['titleproductscarouselkaveh']); ?> </<?php echo  esc_attr($settings['tagheading1productscarouselkaveh']); ?>>
            <<?php echo  esc_attr($settings['tagheading2productscarouselkaveh']); ?> class="section-heading-sub-title"> <?php echo  esc_html($settings['title2productscarouselkaveh']); ?></<?php echo  esc_attr($settings['tagheading2productscarouselkaveh']); ?>>
          </div>
          <?php if("yes"===$settings['moreproductscarouselkaveh']){?>
          <a href="<?php echo  esc_url($settings['buttonlinkproductscarouselkaveh']); ?>" class="section-heading-link btn btn-outline-dark"><?php echo  esc_html($settings['buttonproductscarouselkaveh']); ?></a>
        <style>
          <?php echo '.elementor-element-' . $clsid . ''; ?> .section-heading-two::after {

          background-image: -webkit-linear-gradient(right, <?php echo  esc_attr($settings['textcolorback1productscarouselkaveh']); ?>, <?php echo  esc_attr($settings['textcolorback2productscarouselkaveh']); ?>) !important;
          background-image: -moz-linear-gradient(right, <?php echo  esc_attr($settings['textcolorback1productscarouselkaveh']); ?>, <?php echo  esc_attr($settings['textcolorback2productscarouselkaveh']); ?>) !important;
          background-image: -o-linear-gradient(right, <?php echo  esc_attr($settings['textcolorback1productscarouselkaveh']); ?>, <?php echo  esc_attr($settings['textcolorback2productscarouselkaveh']); ?>) !important;
          background-image: linear-gradient(to left, <?php echo  esc_attr($settings['textcolorback1productscarouselkaveh']); ?>, <?php echo  esc_attr($settings['textcolorback2productscarouselkaveh']); ?>) !important;

      }
        </style>
          <?php } ?>
      </div>
      <?php }elseif('three'===$settings['styleheadingproductscarouselkaveh']){?>
        <div class="section-heading d-flex justify-content-between">
          <div class="detail position-relative">
            <<?php echo  esc_attr($settings['tagheading1productscarouselkaveh']); ?> class="section-heading-sub-title"><?php echo  esc_html($settings['titleproductscarouselkaveh']); ?></<?php echo  esc_attr($settings['tagheading1productscarouselkaveh']); ?>>
            <<?php echo  esc_attr($settings['tagheading2productscarouselkaveh']); ?> class="section-heading-title"><?php echo  esc_html($settings['title2productscarouselkaveh']); ?></<?php echo  esc_attr($settings['tagheading2productscarouselkaveh']); ?>>
          </div>
          <?php if("yes"===$settings['moreproductscarouselkaveh']){?>
          <a href="<?php echo  esc_url($settings['buttonlinkproductscarouselkaveh']); ?>" class="section-heading-link btn rounded-0 p-0"><?php echo  esc_html($settings['buttonproductscarouselkaveh']); ?></a>
          <?php } ?>

        </div>
        <?php }elseif('four'===$settings['styleheadingproductscarouselkaveh']){?>
        <div
          class="section-heading section-heading-three d-flex align-items-sm-center justify-content-sm-between flex-column flex-sm-row">
          <div class="detail position-relative">
            <<?php echo  esc_attr($settings['tagheading1productscarouselkaveh']); ?> class="section-heading-sub-title"><?php echo  esc_html($settings['titleproductscarouselkaveh']); ?></<?php echo  esc_attr($settings['tagheading1productscarouselkaveh']); ?>>
            <<?php echo  esc_attr($settings['tagheading2productscarouselkaveh']); ?> class="section-heading-title"><?php echo  esc_html($settings['title2productscarouselkaveh']); ?></<?php echo  esc_attr($settings['tagheading2productscarouselkaveh']); ?>>
          </div>
          <?php if("yes"===$settings['moreproductscarouselkaveh']){?>
          <a href="<?php echo  esc_url($settings['buttonlinkproductscarouselkaveh']); ?>" class="section-heading-link btn btn-outline-dark"><?php echo  esc_html($settings['buttonproductscarouselkaveh']); ?></a>
          <?php } ?>
        </div>
        <?php }elseif('five'===$settings['styleheadingproductscarouselkaveh']){?>
        <div class="section-heading d-flex align-items-sm-center justify-content-sm-between flex-column flex-sm-row"> 
          <div class="detail position-relative">
            <<?php echo  esc_attr($settings['tagheading1productscarouselkaveh']); ?> class="section-heading-title"><?php echo  esc_html($settings['titleproductscarouselkaveh']); ?></<?php echo  esc_attr($settings['tagheading1productscarouselkaveh']); ?>>
            <<?php echo  esc_attr($settings['tagheading2productscarouselkaveh']); ?> class="section-heading-sub-title"><?php echo  esc_html($settings['title2productscarouselkaveh']); ?></<?php echo  esc_attr($settings['tagheading2productscarouselkaveh']); ?>>
          </div>
          <?php if("yes"===$settings['moreproductscarouselkaveh']){?>
          <a href="<?php echo  esc_url($settings['buttonlinkproductscarouselkaveh']); ?>" class="section-heading-link btn btn-outline-dark"><?php echo  esc_html($settings['buttonproductscarouselkaveh']); ?></a>
          <?php } ?>
          <style>
            <?php echo '.elementor-element-' . $clsid . ''; ?> .best-sellers-eleven .section-heading .detail::before {
            background: -webkit-linear-gradient(186.43deg, <?php echo  esc_html($settings['shapest51colorproductscarouselkaveh']); ?> 17.81%, <?php echo  esc_html($settings['shapest52colorproductscarouselkaveh']); ?> 66.22%) !important;
            background: -moz-linear-gradient(186.43deg, <?php echo  esc_html($settings['shapest51colorproductscarouselkaveh']); ?> 17.81%, <?php echo  esc_html($settings['shapest52colorproductscarouselkaveh']); ?> 66.22%) !important;
            background: -o-linear-gradient(186.43deg, <?php echo  esc_html($settings['shapest51colorproductscarouselkaveh']); ?> 17.81%, <?php echo  esc_html($settings['shapest52colorproductscarouselkaveh']); ?> 66.22%) !important;
            background: linear-gradient(263.57deg, <?php echo  esc_html($settings['shapest51colorproductscarouselkaveh']); ?> 17.81%, <?php echo  esc_html($settings['shapest52colorproductscarouselkaveh']); ?> 66.22%) !important;
        }
          </style>
        </div>
        <?php }elseif('six'===$settings['styleheadingproductscarouselkaveh']){?>
        <div class="section-heading d-flex align-items-sm-center justify-content-sm-between flex-column flex-sm-row">
          <div class="detail position-relative">
            <<?php echo  esc_attr($settings['tagheading1productscarouselkaveh']); ?> class="section-heading-title"><?php echo  esc_html($settings['titleproductscarouselkaveh']); ?></<?php echo  esc_attr($settings['tagheading1productscarouselkaveh']); ?>>
            <<?php echo  esc_attr($settings['tagheading2productscarouselkaveh']); ?> class="section-heading-sub-title"><?php echo  esc_html($settings['title2productscarouselkaveh']); ?></<?php echo  esc_attr($settings['tagheading2productscarouselkaveh']); ?>>
          </div>
          <?php if("yes"===$settings['moreproductscarouselkaveh']){?>
          <a href="<?php echo  esc_url($settings['buttonlinkproductscarouselkaveh']); ?>" class="section-heading-link btn btn-outline-dark"><?php echo  esc_html($settings['buttonproductscarouselkaveh']); ?></a>
          <?php } ?>
          <style>
            <?php echo '.elementor-element-' . $clsid . ''; ?> .best-seller-products .section-heading .detail::before, .category-products-four .section-heading .detail::before {
            background: -webkit-linear-gradient(225deg, <?php echo  esc_html($settings['shapest61colorproductscarouselkaveh']); ?> -20%, <?php echo  esc_html($settings['shapest62colorproductscarouselkaveh']); ?> 64%);
            background: -moz-linear-gradient(225deg, <?php echo  esc_html($settings['shapest61colorproductscarouselkaveh']); ?> -20%, <?php echo  esc_html($settings['shapest62colorproductscarouselkaveh']); ?> 64%);
            background: -o-linear-gradient(225deg, <?php echo  esc_html($settings['shapest61colorproductscarouselkaveh']); ?> -20%, <?php echo  esc_html($settings['shapest62colorproductscarouselkaveh']); ?> 64%);
            background: linear-gradient(-135deg, <?php echo  esc_html($settings['shapest61colorproductscarouselkaveh']); ?> -20%, <?php echo  esc_html($settings['shapest62colorproductscarouselkaveh']); ?> 64%);
        }
          </style>
        </div>
        <?php }elseif('seven'===$settings['styleheadingproductscarouselkaveh']){?>
        <div class="section-heading">
          <div class="detail position-relative">
            <<?php echo  esc_attr($settings['tagheading1productscarouselkaveh']); ?> class="section-heading-title"><?php echo  esc_html($settings['titleproductscarouselkaveh']); ?></<?php echo  esc_attr($settings['tagheading1productscarouselkaveh']); ?>>
            <<?php echo  esc_attr($settings['tagheading2productscarouselkaveh']); ?> class="section-heading-sub-title"><?php echo  esc_html($settings['title2productscarouselkaveh']); ?></<?php echo  esc_attr($settings['tagheading2productscarouselkaveh']); ?>>
          </div>
        </div>
        <style>
          
          <?php echo '.elementor-element-' . $clsid . ''; ?> .new-products-fourteen .section-heading .detail::after {
            background-repeat: no-repeat !important;
            background-size: contain ;
            width: <?php echo  esc_html($settings['width7productscarouselkaveh']['size']); ?>px !important;
            height: <?php echo  esc_html($settings['width7productscarouselkaveh']['size']); ?>px !important;
        }

        <?php echo '.elementor-element-' . $clsid . ''; ?> .new-products-fourteen .section-heading .detail::before {
        background: -webkit-linear-gradient(top, <?php echo  esc_html($settings['shapest71colorproductscarouselkaveh']); ?>, <?php echo  esc_html($settings['shapest72colorproductscarouselkaveh']); ?>) !important;
        background: -moz-linear-gradient(top, <?php echo  esc_html($settings['shapest71colorproductscarouselkaveh']); ?>, <?php echo  esc_html($settings['shapest72colorproductscarouselkaveh']); ?>) !important;
        background: -o-linear-gradient(top, <?php echo  esc_html($settings['shapest71colorproductscarouselkaveh']); ?>, <?php echo  esc_html($settings['shapest72colorproductscarouselkaveh']); ?>) !important;
        background: linear-gradient(to bottom, <?php echo  esc_html($settings['shapest71colorproductscarouselkaveh']); ?>, <?php echo  esc_html($settings['shapest72colorproductscarouselkaveh']); ?>) !important;
    }
        </style>
        <?php }elseif('eight'===$settings['styleheadingproductscarouselkaveh']){?>
        <div class="section-heading d-flex align-items-sm-center justify-content-between flex-column flex-sm-row">
          <div class="detail position-relative">
            <<?php echo  esc_attr($settings['tagheading1productscarouselkaveh']); ?> class="section-heading-sub-title"> <?php echo  esc_html($settings['titleproductscarouselkaveh']); ?></<?php echo  esc_attr($settings['tagheading1productscarouselkaveh']); ?>>
            <<?php echo  esc_attr($settings['tagheading2productscarouselkaveh']); ?> class="section-heading-title"><?php echo  esc_html($settings['title2productscarouselkaveh']); ?></<?php echo  esc_attr($settings['tagheading2productscarouselkaveh']); ?>>
          </div>
          <?php if("yes"===$settings['moreproductscarouselkaveh']){?>
          <a href="<?php echo  esc_url($settings['buttonlinkproductscarouselkaveh']); ?>" class="section-heading-link btn btn-outline-dark"><?php echo  esc_html($settings['buttonproductscarouselkaveh']); ?></a>
          <?php } ?>
        </div>
        <style>
         <?php echo '.elementor-element-' . $clsid . ''; ?> .best-selling-fiveteen .section-heading .detail::before {

          width: <?php echo  esc_html($settings['width7productscarouselkaveh']['size']); ?>px;
          height: <?php echo  esc_html($settings['width7productscarouselkaveh']['size']); ?>px;
          background-size: contain ;
          background-repeat: no-repeat !important;
          -webkit-transform: unset; 
          -moz-transform: unset;
          -ms-transform: unset;
          -o-transform: unset;
          transform: unset; 
          top:0 !important;


         }
        </style>
        <?php }elseif('nine'===$settings['styleheadingproductscarouselkaveh']){?>
        <div
          class="section-heading d-flex align-items-sm-center justify-content-sm-between position-relative mb-0 flex-column flex-sm-row">
          <div class="detail position-relative mb-4 mb-sm-0">
            <<?php echo  esc_attr($settings['tagheading1productscarouselkaveh']); ?> class="section-heading-sub-title"><?php echo  esc_html($settings['titleproductscarouselkaveh']); ?></<?php echo  esc_attr($settings['tagheading1productscarouselkaveh']); ?>>
            <<?php echo  esc_attr($settings['tagheading2productscarouselkaveh']); ?> class="section-heading-title"><?php echo  esc_html($settings['title2productscarouselkaveh']); ?></<?php echo  esc_attr($settings['tagheading2productscarouselkaveh']); ?>>
          </div>
          <?php if("yes"===$settings['moreproductscarouselkaveh']){?>
          <a href="<?php echo  esc_url($settings['buttonlinkproductscarouselkaveh']); ?>" class="section-heading-link btn btn-warning"><?php echo  esc_html($settings['buttonproductscarouselkaveh']); ?></a>
          <?php }else{ ?>
            <style>
           <?php echo '.elementor-element-' . $clsid . ''; ?> .best-selling-sixteen .section-heading::after {
                background-color: unset;
            }
            </style>
            <?php
          } ?>
        </div>
          <?php } ?>
          
        <!-- End Heading -->
        <!-- Start Products -->
        <div class="swiper <?php if("yes"===$settings['barproductscarouselkaveh']){?>swiper-top-products-two<?php }else{?> swiper-products<?php } ?> <?php if("yes"==$settings['overflow2productscarouselkaveh']){}else{?>overflow-hidden<?php }?>">
        <div class="swiper-wrapper">
            <?php if('cat'===$settings['pproductscarouselkaveh']){ ?>
              <?php 
                  
                  // WP_Query args
                  $q_pc2_query_args = array(
                    'post_type' => array('product'),
                    'posts_per_page' => $settings['productnumberproductscarouselkaveh'],
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'tax_query' => array(
                      array(
                        "taxonomy" => "product_cat",
                        "field"    => "tag_ID",
                        "terms"    => $settings['catproductscarouselkaveh'],
                      ),
                    ),
                    'meta_query' => array(
                      array(
                          'key' => '_stock_status',
                          'value' => 'outofstock',
                          'compare' => 'NOT IN',
                      ),
                     ),
                     
                    
                  );

                  // The Query
                  $pc2_query = new \WP_Query($q_pc2_query_args);
                  
                  // The Loop
                  if ( $pc2_query->have_posts() ) {
                    while ( $pc2_query->have_posts() ) {
                      $pc2_query->the_post(); ?>
            <div class="swiper-slide">
             <?php  $styleproduct=$settings['stylecartproductscarouselkaveh']; ?>
            <?php get_template_part("template-part/product-cart-$styleproduct"); ?>
            </div>
            <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
                  
                  ?>
              <?php }elseif('all'===$settings['pproductscarouselkaveh']){
                // WP_Query args
            $ordvalue = $settings['psortproductscarouselkaveh'];
            $ordi = $settings['psortiproductscarouselkaveh'];
            $q_pc2_query_args = array(
              'post_type' => array('product'),
              'posts_per_page' => $settings['productnumberproductscarouselkaveh'],
              'order' => $ordi,
              'orderby' => 'meta_value_num',
              'meta_key'       => $ordvalue,
              'meta_query' => array(
                array(
                    'key' => '_stock_status',
                    'value' => 'outofstock',
                    'compare' => 'NOT IN',
                ),
               ),
             
            );
 
            // The Query
            $pc2_query = new \WP_Query($q_pc2_query_args);
          
            // The Loop
            if ( $pc2_query->have_posts() ) {
              while ( $pc2_query->have_posts() ) {
                $pc2_query->the_post(); ?>
                <div class="swiper-slide">
                <?php  $styleproduct2=$settings['stylecartproductscarouselkaveh']; ?>
                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                
                </div>
                <?php  ?>
                <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }

              
                  
                  ?>
                <?php } ?>
            </div>
          <?php if("yes"===$settings['moreproductscarouselkaveh']){?>
          <?php if('nine'==$settings['styleheadingproductscarouselkaveh']){ ?>
          <div class="swiper-button-next w-auto h-auto"></div>
          <div class="swiper-button-prev w-auto h-auto"></div>
            <?php }elseif('seven'!==$settings['styleheadingproductscarouselkaveh']){ ?>
              <div class="swiper-button-next"></div>
              <div class="swiper-button-prev"></div>
          <?php }
                  }
          ?>
          </div>
        <!-- End Products -->
      </div>
    </section>
    <script>
            function init<?php echo $clsid; ?>() {
        // Swiper Products
  new Swiper(".swiper-products", {
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
	freeMode: {
		enabled: true,
		sticky:false,
		momentumBounce:false,
		momentumRatio:1,
		momentumVelocityRatio:2,
	
  	},
    breakpoints: {
      320: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3productscarouselkaveh']); ?>,
        spaceBetween: 4,
      },
      500: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3productscarouselkaveh']); ?>,
        spaceBetween: 14,
      },
      768: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn2productscarouselkaveh']); ?>,
        spaceBetween: 14,
      },
      992: {
        slidesPerView: <?php echo  esc_html($settings['productcolumnproductscarouselkaveh']); ?>,
        spaceBetween: 20,
      },
      1200: {
        slidesPerView: <?php echo  esc_html($settings['productcolumnproductscarouselkaveh']); ?>,
        spaceBetween: 31,
      },
    },
  });
}
      if (window.Swiper) {
    // Swiper library already loaded, initialize Swiper instance
    init<?php echo $clsid; ?>();
  } else {
    // Swiper library not yet loaded, wait for it to load
    window.addEventListener("load", function() {
      init<?php echo $clsid; ?>();
    });
  }
    </script>
    <style>
      <?php echo '.elementor-element-' . $clsid . ''; ?> .top-sellers-two .swiper::before {
    content: "";
    right: 0;
    bottom: 190px;
    left: 0;
    width: 80%;
    -webkit-border-radius: 50px;
    -moz-border-radius: 50px;
    border-radius: 50px;
    background-color: #ee273a;
    height: 50px;
    margin: 0 auto;
}
.best-selling-fiveteen .section-heading .detail::before {
    -webkit-background-size: 100% 100% !important;
    -moz-background-size: 100% 100% !important;
    -o-background-size: 100% 100% !important;
    background-size: 100% 100% !important;
}
.new-products-fourteen .section-heading .detail::after {
    -webkit-background-size: 100% 100% !important;
    -moz-background-size: 100% 100% !important;
    -o-background-size: 100% 100% !important;
    background-size: 100% 100% !important;
}
    </style>
    <?php
  }


}
