<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Megamenuonekaveh extends Widget_Base{
 
  public function get_name(){
    return 'megamenuonekaveh';
  }

  public function get_title(){
    return esc_html__( 'المان مگا منو طرح اول', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['megamenufooterkavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'content1megamenuonekaveh',
        [
          'label' => esc_html__( 'تعداد تب', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'tabcountmegamenuonekaveh',
        [
          'label' => esc_html__( 'تعداد ستون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => '6',
          'options' => [
            '1'  => esc_html__( '1', 'kaveh-core' ),
            '2' => esc_html__( '2', 'kaveh-core' ),
            '3' => esc_html__( '3', 'kaveh-core' ),
            '4' => esc_html__( '4', 'kaveh-core' ),
            '5' => esc_html__( '5', 'kaveh-core' ),
          ],
        ]
      );

        $this->end_controls_section();

        $this->start_controls_section(
          'tab1megamenuonekaveh',
          [
            'label' => esc_html__( 'محتوای تب اول', 'kaveh-core' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
          ]
        );
        $this->add_control(
          'icon1megamenuonekaveh',
          [
            'label' => esc_html__( 'آیکون تب', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::ICONS,
            'skin' => 'inline',
            'exclude_inline_options' => [ 'svg' ],
            'default' => [
              'value' => 'icon icon-ball',
            ],
          ]
        ); 
        $this->add_control(
          'title1megamenuonekaveh',
          [
              'label' => esc_html__( 'عنوان تب', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'کالای دیجیتال', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'hrt1megamenuonekaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'titlecol1megamenuonekaveh',
        [
            'label' => esc_html__( 'عنوان ستون اول', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'لپ تاب', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'activeoffcol11megamenuonekaveh',
      [
        'label' => esc_html__( 'نمایش تخفیف', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
        'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
        'return_value' => 'yes',
        'default' => 'no',
      ]
    );
    $this->add_control(
      'offcol11megamenuonekaveh',
      [
          'label' => esc_html__( 'تخفیف', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'activeoffcol11megamenuonekaveh' => 'yes',
          ],
          'default' => esc_html__( '35%', 'kaveh-core' ),
  
      ]
  );
    $repeater = new \Elementor\Repeater(); 
      $repeater->add_control(
        'col1title1megamenuonekaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'مک بوک ۲۰۲۲', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'col1link1megamenuonekaveh',
      [
          'label' => esc_html__( 'لینک', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
    $this->add_control(
      'listcol1megamenuonekaveh',
      [
        'label' => esc_html__( 'لیست ستون اول', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'col1title1megamenuonekaveh' => esc_html__( 'مک بوک ۲۰۲۲', 'kaveh-core' ),
            'col1link1megamenuonekaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );
    $this->add_control(
      'hrl1megamenuonekaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_control(
      'titlecol21megamenuonekaveh',
      [
          'label' => esc_html__( 'عنوان ستون دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'لپ تاب', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'activeoffcol21megamenuonekaveh',
    [
      'label' => esc_html__( 'نمایش تخفیف', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
      'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
      'return_value' => 'yes',
      'default' => 'no',
    ]
  );
  $this->add_control(
    'offcol21megamenuonekaveh',
    [
        'label' => esc_html__( 'تخفیف', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'activeoffcol21megamenuonekaveh' => 'yes',
        ],
        'default' => esc_html__( '35%', 'kaveh-core' ),

    ]
);
  $repeater = new \Elementor\Repeater(); 
    $repeater->add_control(
      'col2title1megamenuonekaveh',
      [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'مک بوک ۲۰۲۲', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'col2link1megamenuonekaveh',
    [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( '#', 'kaveh-core' ),

    ]
);
  $this->add_control(
    'listcol21megamenuonekaveh',
    [
      'label' => esc_html__( 'لیست ستون دوم', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::REPEATER,
      'fields' => $repeater->get_controls(),
      'default' => [
        [
          'col2title1megamenuonekaveh' => esc_html__( 'مک بوک ۲۰۲۲', 'kaveh-core' ),
          'col2link1megamenuonekaveh' => esc_html__( '#', 'kaveh-core' ),
        ],
    ]
    ]
  
  );
  $this->add_control(
    'hrl21megamenuonekaveh',
    [
      'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
  );
  $this->add_control(
    'imagecol31megamenuonekaveh',
    [
      'label' => esc_html__( 'تصویر ستون سوم', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::MEDIA,
    ]
  );
  $this->add_control(
    'activeoffcol31megamenuonekaveh',
    [
      'label' => esc_html__( 'نمایش تخفیف', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
      'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
      'return_value' => 'yes',
      'default' => 'no',
    ]
  );
  $this->add_control(
    'offcol31megamenuonekaveh',
    [
        'label' => esc_html__( 'تخفیف', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'activeoffcol31megamenuonekaveh' => 'yes',
        ],
        'default' => esc_html__( '35%', 'kaveh-core' ),

    ]
);
$this->add_control(
  'activecol3button1megamenuonekaveh',
  [
    'label' => esc_html__( 'نمایش دکمه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
    'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'yes',
  ]
);
$this->add_control(
  'col3buttontitle1megamenuonekaveh',
  [
      'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'condition' => [
        'activecol3button1megamenuonekaveh' => 'yes',
      ],
      'default' => esc_html__( 'خرید کنید', 'kaveh-core' ),

  ]
);
$this->add_control(
'col3buttonlink1megamenuonekaveh',
[
    'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'condition' => [
      'activecol3button1megamenuonekaveh' => 'yes',
    ],
    'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
  'hrl31megamenuonekaveh',
  [
    'type' => \Elementor\Controls_Manager::DIVIDER,
  ]
);
$taboptiongrid = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);
$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $taboptiongrid[$category->term_id] = $category->name;
}
$this->add_control(
    'cat1col41megamenuonekaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $taboptiongrid,
    ]
);
$this->add_control(
  'productnumber1megamenuonekaveh',
  [
    'label' => esc_html__( 'تعداد محصولات', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 20,
    'step' => 1,
    'default' => 6,
  ]
);
$this->add_control(
  'col4buttontitle1megamenuonekaveh',
  [
      'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( 'خرید کنید', 'kaveh-core' ),

  ]
);
$this->add_control(
'col4buttonlink1megamenuonekaveh',
[
    'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( '#', 'kaveh-core' ),

]
);
        $this->end_controls_section();
        $this->start_controls_section(
          'tab2megamenuonekaveh',
          [
            'label' => esc_html__( 'محتوای تب دوم', 'kaveh-core' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'condition' => [
                      'tabcountmegamenuonekaveh' => ['2','3','4','5','6'],
    ],
          ]
        );
        $this->add_control(
          'icon2megamenuonekaveh',
          [
            'label' => esc_html__( 'آیکون تب', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::ICONS,
            'skin' => 'inline',
            'exclude_inline_options' => [ 'svg' ],
            'default' => [
              'value' => 'icon icon-ball',
            ],
          ]
        ); 
        $this->add_control(
          'title2megamenuonekaveh',
          [
              'label' => esc_html__( 'عنوان تب', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'کالای دیجیتال', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'hrt2megamenuonekaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'titlecol2megamenuonekaveh',
        [
            'label' => esc_html__( 'عنوان ستون اول', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'لپ تاب', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'activeoffcol12megamenuonekaveh',
      [
        'label' => esc_html__( 'نمایش تخفیف', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
        'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
        'return_value' => 'yes',
        'default' => 'no',
      ]
    );
    $this->add_control(
      'offcol12megamenuonekaveh',
      [
          'label' => esc_html__( 'تخفیف', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'activeoffcol12megamenuonekaveh' => 'yes',
          ],
          'default' => esc_html__( '35%', 'kaveh-core' ),
  
      ]
  );
    $repeater = new \Elementor\Repeater(); 
      $repeater->add_control(
        'col1title2megamenuonekaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'مک بوک ۲۰۲۲', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'col1link2megamenuonekaveh',
      [
          'label' => esc_html__( 'لینک', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
    $this->add_control(
      'listcol2megamenuonekaveh',
      [
        'label' => esc_html__( 'لیست ستون اول', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'col1title2megamenuonekaveh' => esc_html__( 'مک بوک ۲۰۲۲', 'kaveh-core' ),
            'col1link2megamenuonekaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );
    $this->add_control(
      'hrl2megamenuonekaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_control(
      'titlecol22megamenuonekaveh',
      [
          'label' => esc_html__( 'عنوان ستون دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'لپ تاب', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'activeoffcol22megamenuonekaveh',
    [
      'label' => esc_html__( 'نمایش تخفیف', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
      'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
      'return_value' => 'yes',
      'default' => 'no',
    ]
  );
  $this->add_control(
    'offcol22megamenuonekaveh',
    [
        'label' => esc_html__( 'تخفیف', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'activeoffcol22megamenuonekaveh' => 'yes',
        ],
        'default' => esc_html__( '35%', 'kaveh-core' ),

    ]
);
  $repeater = new \Elementor\Repeater(); 
    $repeater->add_control(
      'col2title2megamenuonekaveh',
      [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'مک بوک ۲۰۲۲', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'col2link2megamenuonekaveh',
    [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( '#', 'kaveh-core' ),

    ]
);
  $this->add_control(
    'listcol22megamenuonekaveh',
    [
      'label' => esc_html__( 'لیست ستون دوم', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::REPEATER,
      'fields' => $repeater->get_controls(),
      'default' => [
        [
          'col2title2megamenuonekaveh' => esc_html__( 'مک بوک ۲۰۲۲', 'kaveh-core' ),
          'col2link2megamenuonekaveh' => esc_html__( '#', 'kaveh-core' ),
        ],
    ]
    ]
  
  );
  $this->add_control(
    'hrl22megamenuonekaveh',
    [
      'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
  );
  $this->add_control(
    'imagecol32megamenuonekaveh',
    [
      'label' => esc_html__( 'تصویر ستون سوم', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::MEDIA,
    ]
  );
  $this->add_control(
    'activeoffcol32megamenuonekaveh',
    [
      'label' => esc_html__( 'نمایش تخفیف', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
      'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
      'return_value' => 'yes',
      'default' => 'no',
    ]
  );
  $this->add_control(
    'offcol32megamenuonekaveh',
    [
        'label' => esc_html__( 'تخفیف', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'activeoffcol32megamenuonekaveh' => 'yes',
        ],
        'default' => esc_html__( '35%', 'kaveh-core' ),

    ]
);
$this->add_control(
  'activecol3button2megamenuonekaveh',
  [
    'label' => esc_html__( 'نمایش دکمه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
    'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'yes',
  ]
);
$this->add_control(
  'col3buttontitle2megamenuonekaveh',
  [
      'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'condition' => [
        'activecol3button2megamenuonekaveh' => 'yes',
      ],
      'default' => esc_html__( 'خرید کنید', 'kaveh-core' ),

  ]
);
$this->add_control(
'col3buttonlink2megamenuonekaveh',
[
    'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'condition' => [
      'activecol3button2megamenuonekaveh' => 'yes',
    ],
    'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
  'hrl32megamenuonekaveh',
  [
    'type' => \Elementor\Controls_Manager::DIVIDER,
  ]
);
$taboptiongrid = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);
$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $taboptiongrid[$category->term_id] = $category->name;
}
$this->add_control(
    'cat1col42megamenuonekaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $taboptiongrid,
    ]
);
$this->add_control(
  'productnumber2megamenuonekaveh',
  [
    'label' => esc_html__( 'تعداد محصولات', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 20,
    'step' => 1,
    'default' => 6,
  ]
);
$this->add_control(
  'col4buttontitle2megamenuonekaveh',
  [
      'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( 'خرید کنید', 'kaveh-core' ),

  ]
);
$this->add_control(
'col4buttonlink2megamenuonekaveh',
[
    'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( '#', 'kaveh-core' ),

]
);
        $this->end_controls_section();
        $this->start_controls_section(
          'tab3megamenuonekaveh',
          [
            'label' => esc_html__( 'محتوای تب سوم', 'kaveh-core' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'condition' => [
                      'tabcountmegamenuonekaveh' => ['3','4','5','6'],
      
    ],
          ]
        );
        $this->add_control(
          'icon3megamenuonekaveh',
          [
            'label' => esc_html__( 'آیکون تب', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::ICONS,
            'skin' => 'inline',
            'exclude_inline_options' => [ 'svg' ],
            'default' => [
              'value' => 'icon icon-ball',
            ],
          ]
        ); 
        $this->add_control(
          'title3megamenuonekaveh',
          [
              'label' => esc_html__( 'عنوان تب', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'کالای دیجیتال', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'hrt3megamenuonekaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'titlecol3megamenuonekaveh',
        [
            'label' => esc_html__( 'عنوان ستون اول', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'لپ تاب', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'activeoffcol13megamenuonekaveh',
      [
        'label' => esc_html__( 'نمایش تخفیف', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
        'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
        'return_value' => 'yes',
        'default' => 'no',
      ]
    );
    $this->add_control(
      'offcol13megamenuonekaveh',
      [
          'label' => esc_html__( 'تخفیف', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'activeoffcol13megamenuonekaveh' => 'yes',
          ],
          'default' => esc_html__( '35%', 'kaveh-core' ),
  
      ]
  );
    $repeater = new \Elementor\Repeater(); 
      $repeater->add_control(
        'col1title3megamenuonekaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'مک بوک ۲۰۲۲', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'col1link3megamenuonekaveh',
      [
          'label' => esc_html__( 'لینک', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
    $this->add_control(
      'listcol3megamenuonekaveh',
      [
        'label' => esc_html__( 'لیست ستون اول', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'col1title3megamenuonekaveh' => esc_html__( 'مک بوک ۲۰۲۲', 'kaveh-core' ),
            'col1link3megamenuonekaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );
    $this->add_control(
      'hrl3megamenuonekaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_control(
      'titlecol23megamenuonekaveh',
      [
          'label' => esc_html__( 'عنوان ستون دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'لپ تاب', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'activeoffcol23megamenuonekaveh',
    [
      'label' => esc_html__( 'نمایش تخفیف', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
      'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
      'return_value' => 'yes',
      'default' => 'no',
    ]
  );
  $this->add_control(
    'offcol23megamenuonekaveh',
    [
        'label' => esc_html__( 'تخفیف', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'activeoffcol23megamenuonekaveh' => 'yes',
        ],
        'default' => esc_html__( '35%', 'kaveh-core' ),

    ]
);
  $repeater = new \Elementor\Repeater(); 
    $repeater->add_control(
      'col2title3megamenuonekaveh',
      [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'مک بوک ۲۰۲۲', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'col2link3megamenuonekaveh',
    [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( '#', 'kaveh-core' ),

    ]
);
  $this->add_control(
    'listcol23megamenuonekaveh',
    [
      'label' => esc_html__( 'لیست ستون دوم', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::REPEATER,
      'fields' => $repeater->get_controls(),
      'default' => [
        [
          'col2title3megamenuonekaveh' => esc_html__( 'مک بوک ۲۰۲۲', 'kaveh-core' ),
          'col2link3megamenuonekaveh' => esc_html__( '#', 'kaveh-core' ),
        ],
    ]
    ]
  
  );
  $this->add_control(
    'hrl23megamenuonekaveh',
    [
      'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
  );
  $this->add_control(
    'imagecol33megamenuonekaveh',
    [
      'label' => esc_html__( 'تصویر ستون سوم', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::MEDIA,
    ]
  );
  $this->add_control(
    'activeoffcol33megamenuonekaveh',
    [
      'label' => esc_html__( 'نمایش تخفیف', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
      'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
      'return_value' => 'yes',
      'default' => 'no',
    ]
  );
  $this->add_control(
    'offcol33megamenuonekaveh',
    [
        'label' => esc_html__( 'تخفیف', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'activeoffcol33megamenuonekaveh' => 'yes',
        ],
        'default' => esc_html__( '35%', 'kaveh-core' ),

    ]
);
$this->add_control(
  'activecol3button3megamenuonekaveh',
  [
    'label' => esc_html__( 'نمایش دکمه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
    'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'yes',
  ]
);
$this->add_control(
  'col3buttontitle3megamenuonekaveh',
  [
      'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'condition' => [
        'activecol3button3megamenuonekaveh' => 'yes',
      ],
      'default' => esc_html__( 'خرید کنید', 'kaveh-core' ),

  ]
);
$this->add_control(
'col3buttonlink3megamenuonekaveh',
[
    'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'condition' => [
      'activecol3button3megamenuonekaveh' => 'yes',
    ],
    'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
  'hrl33megamenuonekaveh',
  [
    'type' => \Elementor\Controls_Manager::DIVIDER,
  ]
);
$taboptiongrid = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);
$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $taboptiongrid[$category->term_id] = $category->name;
}
$this->add_control(
    'cat1col43megamenuonekaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $taboptiongrid,
    ]
);
$this->add_control(
  'productnumber3megamenuonekaveh',
  [
    'label' => esc_html__( 'تعداد محصولات', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 20,
    'step' => 1,
    'default' => 6,
  ]
);
$this->add_control(
  'col4buttontitle3megamenuonekaveh',
  [
      'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( 'خرید کنید', 'kaveh-core' ),

  ]
);
$this->add_control(
'col4buttonlink3megamenuonekaveh',
[
    'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( '#', 'kaveh-core' ),

]
);
        $this->end_controls_section();
        $this->start_controls_section(
          'tab4megamenuonekaveh',
          [
            'label' => esc_html__( 'محتوای تب چهارم', 'kaveh-core' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'condition' => [
                      'tabcountmegamenuonekaveh' => ['4','5','6'],
    ],
          ]
        );
        $this->add_control(
          'icon4megamenuonekaveh',
          [
            'label' => esc_html__( 'آیکون تب', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::ICONS,
            'skin' => 'inline',
            'exclude_inline_options' => [ 'svg' ],
            'default' => [
              'value' => 'icon icon-ball',
            ],
          ]
        ); 
        $this->add_control(
          'title4megamenuonekaveh',
          [
              'label' => esc_html__( 'عنوان تب', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'کالای دیجیتال', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'hrt4megamenuonekaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'titlecol4megamenuonekaveh',
        [
            'label' => esc_html__( 'عنوان ستون اول', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'لپ تاب', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'activeoffcol14megamenuonekaveh',
      [
        'label' => esc_html__( 'نمایش تخفیف', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
        'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
        'return_value' => 'yes',
        'default' => 'no',
      ]
    );
    $this->add_control(
      'offcol14megamenuonekaveh',
      [
          'label' => esc_html__( 'تخفیف', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'activeoffcol14megamenuonekaveh' => 'yes',
          ],
          'default' => esc_html__( '35%', 'kaveh-core' ),
  
      ]
  );
    $repeater = new \Elementor\Repeater(); 
      $repeater->add_control(
        'col1title4megamenuonekaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'مک بوک ۲۰۲۲', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'col1link4megamenuonekaveh',
      [
          'label' => esc_html__( 'لینک', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
    $this->add_control(
      'listcol4megamenuonekaveh',
      [
        'label' => esc_html__( 'لیست ستون اول', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'col1title4megamenuonekaveh' => esc_html__( 'مک بوک ۲۰۲۲', 'kaveh-core' ),
            'col1link4megamenuonekaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );
    $this->add_control(
      'hrl4megamenuonekaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_control(
      'titlecol24megamenuonekaveh',
      [
          'label' => esc_html__( 'عنوان ستون دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'لپ تاب', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'activeoffcol24megamenuonekaveh',
    [
      'label' => esc_html__( 'نمایش تخفیف', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
      'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
      'return_value' => 'yes',
      'default' => 'no',
    ]
  );
  $this->add_control(
    'offcol24megamenuonekaveh',
    [
        'label' => esc_html__( 'تخفیف', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'activeoffcol24megamenuonekaveh' => 'yes',
        ],
        'default' => esc_html__( '35%', 'kaveh-core' ),

    ]
);
  $repeater = new \Elementor\Repeater(); 
    $repeater->add_control(
      'col2title4megamenuonekaveh',
      [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'مک بوک ۲۰۲۲', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'col2link4megamenuonekaveh',
    [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( '#', 'kaveh-core' ),

    ]
);
  $this->add_control(
    'listcol24megamenuonekaveh',
    [
      'label' => esc_html__( 'لیست ستون دوم', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::REPEATER,
      'fields' => $repeater->get_controls(),
      'default' => [
        [
          'col2title4megamenuonekaveh' => esc_html__( 'مک بوک ۲۰۲۲', 'kaveh-core' ),
          'col2link4megamenuonekaveh' => esc_html__( '#', 'kaveh-core' ),
        ],
    ]
    ]
  
  );
  $this->add_control(
    'hrl24megamenuonekaveh',
    [
      'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
  );
  $this->add_control(
    'imagecol34megamenuonekaveh',
    [
      'label' => esc_html__( 'تصویر ستون سوم', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::MEDIA,
    ]
  );
  $this->add_control(
    'activeoffcol34megamenuonekaveh',
    [
      'label' => esc_html__( 'نمایش تخفیف', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
      'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
      'return_value' => 'yes',
      'default' => 'no',
    ]
  );
  $this->add_control(
    'offcol34megamenuonekaveh',
    [
        'label' => esc_html__( 'تخفیف', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'activeoffcol34megamenuonekaveh' => 'yes',
        ],
        'default' => esc_html__( '35%', 'kaveh-core' ),

    ]
);
$this->add_control(
  'activecol3button4megamenuonekaveh',
  [
    'label' => esc_html__( 'نمایش دکمه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
    'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'yes',
  ]
);
$this->add_control(
  'col3buttontitle4megamenuonekaveh',
  [
      'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'condition' => [
        'activecol3button4megamenuonekaveh' => 'yes',
      ],
      'default' => esc_html__( 'خرید کنید', 'kaveh-core' ),

  ]
);
$this->add_control(
'col3buttonlink4megamenuonekaveh',
[
    'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'condition' => [
      'activecol3button4megamenuonekaveh' => 'yes',
    ],
    'default' => esc_html__( '#', 'kaveh-core' ),

]
);
$this->add_control(
  'hrl34megamenuonekaveh',
  [
    'type' => \Elementor\Controls_Manager::DIVIDER,
  ]
);
$taboptiongrid = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);
$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $taboptiongrid[$category->term_id] = $category->name;
}
$this->add_control(
    'cat1col44megamenuonekaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $taboptiongrid,
    ]
);
$this->add_control(
  'productnumber4megamenuonekaveh',
  [
    'label' => esc_html__( 'تعداد محصولات', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 20,
    'step' => 1,
    'default' => 6,
  ]
);
$this->add_control(
  'col4buttontitle4megamenuonekaveh',
  [
      'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( 'خرید کنید', 'kaveh-core' ),

  ]
);
$this->add_control(
'col4buttonlink4megamenuonekaveh',
[
    'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( '#', 'kaveh-core' ),

]
);
        $this->end_controls_section();
        $this->start_controls_section(
          'tab5megamenuonekaveh',
          [
            'label' => esc_html__( 'محتوای تب پنجم', 'kaveh-core' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'condition' => [
                      'tabcountmegamenuonekaveh' => ['5','6'],
        ],
          ]
        );
        $this->add_control(
          'icon5megamenuonekaveh',
          [
            'label' => esc_html__( 'آیکون تب', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::ICONS,
            'skin' => 'inline',
            'exclude_inline_options' => [ 'svg' ],
            'default' => [
              'value' => 'icon icon-ball',
            ],
          ]
        ); 
        $this->add_control(
          'title5megamenuonekaveh',
          [
              'label' => esc_html__( 'عنوان تب', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'کالای دیجیتال', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'hrt5megamenuonekaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'titlecol5megamenuonekaveh',
        [
            'label' => esc_html__( 'عنوان ستون اول', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'لپ تاب', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'activeoffcol15megamenuonekaveh',
      [
        'label' => esc_html__( 'نمایش تخفیف', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
        'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
        'return_value' => 'yes',
        'default' => 'no',
      ]
    );
    $this->add_control(
      'offcol15megamenuonekaveh',
      [
          'label' => esc_html__( 'تخفیف', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'condition' => [
            'activeoffcol15megamenuonekaveh' => 'yes',
          ],
          'default' => esc_html__( '35%', 'kaveh-core' ),
  
      ]
  );
    $repeater = new \Elementor\Repeater(); 
      $repeater->add_control(
        'col1title5megamenuonekaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'مک بوک ۲۰۲۲', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'col1link5megamenuonekaveh',
      [
          'label' => esc_html__( 'لینک', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
    $this->add_control(
      'listcol5megamenuonekaveh',
      [
        'label' => esc_html__( 'لیست ستون اول', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'col1title5megamenuonekaveh' => esc_html__( 'مک بوک ۲۰۲۲', 'kaveh-core' ),
            'col1link5megamenuonekaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );
    $this->add_control(
      'hrl5megamenuonekaveh',
      [
        'type' => \Elementor\Controls_Manager::DIVIDER,
      ]
    );
    $this->add_control(
      'titlecol25megamenuonekaveh',
      [
          'label' => esc_html__( 'عنوان ستون دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'لپ تاب', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'activeoffcol25megamenuonekaveh',
    [
      'label' => esc_html__( 'نمایش تخفیف', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
      'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
      'return_value' => 'yes',
      'default' => 'no',
    ]
  );
  $this->add_control(
    'offcol25megamenuonekaveh',
    [
        'label' => esc_html__( 'تخفیف', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'activeoffcol25megamenuonekaveh' => 'yes',
        ],
        'default' => esc_html__( '35%', 'kaveh-core' ),

    ]
);
  $repeater = new \Elementor\Repeater(); 
    $repeater->add_control(
      'col2title5megamenuonekaveh',
      [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'مک بوک ۲۰۲۲', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'col2link5megamenuonekaveh',
    [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( '#', 'kaveh-core' ),

    ]
);
  $this->add_control(
    'listcol25megamenuonekaveh',
    [
      'label' => esc_html__( 'لیست ستون دوم', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::REPEATER,
      'fields' => $repeater->get_controls(),
      'default' => [
        [
          'col2title5megamenuonekaveh' => esc_html__( 'مک بوک ۲۰۲۲', 'kaveh-core' ),
          'col2link5megamenuonekaveh' => esc_html__( '#', 'kaveh-core' ),
        ],
    ]
    ]
  
  );
  $this->add_control(
    'hrl25megamenuonekaveh',
    [
      'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
  );
  $this->add_control(
    'imagecol35megamenuonekaveh',
    [
      'label' => esc_html__( 'تصویر ستون سوم', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::MEDIA,
    ]
  );
  $this->add_control(
    'activeoffcol35megamenuonekaveh',
    [
      'label' => esc_html__( 'نمایش تخفیف', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SWITCHER,
      'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
      'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
      'return_value' => 'yes',
      'default' => 'no',
    ]
  );
  $this->add_control(
    'offcol35megamenuonekaveh',
    [
        'label' => esc_html__( 'تخفیف', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'activeoffcol35megamenuonekaveh' => 'yes',
        ],
        'default' => esc_html__( '35%', 'kaveh-core' ),

    ]
);
$this->add_control(
  'activecol3button5megamenuonekaveh',
  [
    'label' => esc_html__( 'نمایش دکمه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
    'label_off' => esc_html__( 'غیرفعال', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'yes',
  ]
);
$this->add_control(
  'col3buttontitle5megamenuonekaveh',
  [
      'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'condition' => [
        'activecol3button5megamenuonekaveh' => 'yes',
      ],
      'default' => esc_html__( 'خرید کنید', 'kaveh-core' ),

  ]
);
$this->add_control(
'col3buttonlink5megamenuonekaveh',
[
    'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'condition' => [
      'activecol3button5megamenuonekaveh' => 'yes',
    ],
    'default' => esc_html__( '#', 'kaveh-core' ),

]
); 
$this->add_control(
  'hrl35megamenuonekaveh',
  [
    'type' => \Elementor\Controls_Manager::DIVIDER,
  ]
);
$taboptiongrid = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);
$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $taboptiongrid[$category->term_id] = $category->name;
}
$this->add_control(
    'cat1col45megamenuonekaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $taboptiongrid,
    ]
);
$this->add_control(
  'productnumber5megamenuonekaveh',
  [
    'label' => esc_html__( 'تعداد محصولات', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 20,
    'step' => 1,
    'default' => 6,
  ]
);
$this->add_control(
  'col4buttontitle5megamenuonekaveh',
  [
      'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => esc_html__( 'خرید کنید', 'kaveh-core' ),

  ]
);
$this->add_control(
'col4buttonlink5megamenuonekaveh',
[
    'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'default' => esc_html__( '#', 'kaveh-core' ),

]
);
        $this->end_controls_section();
      $this->start_controls_section(
          'style1megamenuonekaveh',
          [
            'label' => esc_html__( 'استایل تب ها', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          ]
        );
        $this->add_control(
          'bficonsize1megamenuonekaveh',
          [
            'label' => esc_html__( 'سایز آیکون قبل از نوشته', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 200,
                'step' => 1,
              ],
            ],
            'default' => [
              'unit' => 'px',
              'size' => 22,
            ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-tabs span i' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->start_controls_tabs(
              'style_tabsmegamenuonekaveh'
            );
      
            $this->start_controls_tab(
              'style_normal_tabmegamenuonekaveh',
              [
                'label' => esc_html__( 'عادی', 'kaveh-core' ),
              ]
            );
            $this->add_control(
              'beforeic1colormegamenuonekaveh',
              [
                'label' => esc_html__( 'رنگ آیکون قبل متن', 'kaveh-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                  '{{WRAPPER}} .megamenu-tabs span i' => 'color: {{VALUE}}',
                ],
              ]
            ); 
            $this->add_group_control(
              \Elementor\Group_Control_Typography::get_type(),
              [
                'name' => 'txttypomegamenuonekaveh',
                'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),
                'selector' => '{{WRAPPER}} .megamenu-tabs span',
              ]
            );
            $this->add_control(
              'text1colormegamenuonekaveh',
              [
                'label' => esc_html__( 'رنگ نوشته', 'kaveh-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                  '{{WRAPPER}} .megamenu-tabs span' => 'color: {{VALUE}}',
                ],
              ]
            ); 
            $this->add_control(
              'afteric1colormegamenuonekaveh',
              [
                'label' => esc_html__( 'رنگ آیکون بعد متن', 'kaveh-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                  '{{WRAPPER}} .megamenu-tabs span::after' => 'color: {{VALUE}}',
                ],
              ]
            ); 
            $this->end_controls_tab();
            $this->start_controls_tab(
              'style_hove_tabmegamenuonekaveh',
              [
                'label' => esc_html__( 'هاور', 'kaveh-core' ),
              ]
            );
            $this->add_control(
              'beforeic1colorhovermegamenuonekaveh',
              [
                'label' => esc_html__( 'رنگ آیکون قبل متن', 'kaveh-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                  '{{WRAPPER}} .megamenu-tabs span.active:hover i' => 'color: {{VALUE}}',
                  '{{WRAPPER}} .megamenu-tabs span.active i' => 'color: {{VALUE}}',
      
                ],
              ]
            ); 
            $this->add_group_control(
              \Elementor\Group_Control_Typography::get_type(),
              [
                'name' => 'txttypohovermegamenuonekaveh',
                'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),
                'selector' => '{{WRAPPER}} .megamenu-tabs span:hover,{{WRAPPER}} .megamenu-tabs span.active',
              ]
            );
            $this->add_control(
              'text1colorhovermegamenuonekaveh',
              [
                'label' => esc_html__( 'رنگ نوشته', 'kaveh-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                  '{{WRAPPER}} .megamenu-tabs span:hover::after' => 'color: {{VALUE}}',
                  '{{WRAPPER}} .megamenu-tabs span.active' => 'color: {{VALUE}}',
      
                ],
              ]
            ); 
            $this->add_control(
              'afteric1hovercolormegamenuonekaveh',
              [
                'label' => esc_html__( 'رنگ آیکون بعد متن', 'kaveh-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                  '{{WRAPPER}} .megamenu-tabs span.active::after' => 'color: {{VALUE}}',
                ],
              ]
            ); 
            $this->end_controls_tab();
            $this->end_controls_tabs();
                  
        $this->add_control(
          'hr1megamenuonekaveh',
          [
            'type' => \Elementor\Controls_Manager::DIVIDER,
          ]
        );
        $this->add_control(
          'bgcolortabmegamenuonekaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه تب فعال', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-tabs span:hover' => 'background-color: {{VALUE}}',
              '{{WRAPPER}} .megamenu-tabs span.active' => 'background-color: {{VALUE}}',
      
            ],
          ]
        ); 
        $this->add_control(
          'borderradiustabmegamenuonekaveh',
          [
            'label' => esc_html__( 'گوشه خمیده تب', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-tabs span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
          'style2megamenuonekaveh',
          [
            'label' => esc_html__( 'استایل محتوای تب ها', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'colmaint1megamenuonekaveh',
            'label' => esc_html__( 'تایپوگرافی عنوان ستون ها', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .megamenu-tab-contents-item .right ul li.title',
          ]
        );
        $this->add_control(
          'colmaintityp1rmegamenuonekaveh',
          [
            'label' => esc_html__( 'رنگ عنوان ستون ها', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-tab-contents-item .right ul li.title' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'hr2megamenuonekaveh',
          [
            'type' => \Elementor\Controls_Manager::DIVIDER,
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'colmaint2megamenuonekaveh',
            'label' => esc_html__( 'تایپوگرافی زیر منوها', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .megamenu-tab-contents-item .right ul li a',
          ]
        );
        $this->add_control(
          'colmaintity2prmegamenuonekaveh',
          [
            'label' => esc_html__( 'رنگ زیر منوها', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-tab-contents-item .right ul li a' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'bficonsize2megamenuonekaveh',
          [
            'label' => esc_html__( 'سایز آیکون بعد از نوشته', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 200,
                'step' => 1,
              ],
            ],
            'default' => [
              'unit' => 'px',
              'size' => 8,
            ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-tab-contents-item .right ul li a::after' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'bgcolorcoltabmegamenuonekaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه هاور زیرمنو', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu li a:hover' => 'background-color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'hr3megamenuonekaveh',
          [
            'type' => \Elementor\Controls_Manager::DIVIDER,
          ]
        );
        $this->add_control(
          'bgcolorrowtabmegamenuonekaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه محتوای تب', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-tab-contents-item .right' => 'background-color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'borderradius1tabmegamenuonekaveh',
          [
            'label' => esc_html__( 'گوشه خمیده محتوای تب', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-tab-contents-item .right' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'offerintity2prmegamenuonekaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه تخفیف', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-tab-contents-item .right ul li a' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->end_controls_section();
        $this->start_controls_section(
          'style3megamenuonekaveh',
          [
            'label' => esc_html__( 'استایل دکمه روی تصویر', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          ]
        );
        $this->add_control(
          'imageradiushover5megamenuonekaveh',
          [
            'label' => esc_html__( 'گوشه خمیده تصویر', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-product img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->start_controls_tabs(
          'style_tabs4megamenuonekaveh'
        );
        
        $this->start_controls_tab(
          'style_normal_tab4megamenuonekaveh',
          [
            'label' => esc_html__( 'عادی', 'kaveh-core' ),
          ]
        );
        $this->add_control(
          'textbuttoncolor4megamenuonekaveh',
          [
            'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-product .btn' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'buttoncolor4megamenuonekaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-product .btn' => 'background-color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'buttonradius4megamenuonekaveh',
          [
            'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-product .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Border::get_type(),
          [
            'name' => 'border4megamenuonekaveh',
            'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .megamenu-product .btn',
          ]
        );
        $this->add_control(
          'buttonborders4megamenuonekaveh',
          [
            'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'condition' => [
              'border4megamenuonekaveh!' => '',
            ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-product .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            ],
          ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
          'style_hove_tab4megamenuonekaveh',
          [
            'label' => esc_html__( 'هاور', 'kaveh-core' ),
          ]
        );
        $this->add_control(
          'textbuttoncolorhover4megamenuonekaveh',
          [
            'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-product .btn:hover' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'buttoncolorhover4megamenuonekaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-product .btn:hover' => 'background-color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'buttonradiushover4megamenuonekaveh',
          [
            'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-product .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Border::get_type(),
          [
            'name' => 'borderhover4megamenuonekaveh',
            'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .megamenu-product .btn:hover',
          ]
        );
        $this->add_control(
          'buttonbordershover4megamenuonekaveh',
          [
            'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'condition' => [
              'borderhover4megamenuonekaveh!' => '',
            ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-product .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            ],
          ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
          'hr4megamenuonekaveh',
          [
            'type' => \Elementor\Controls_Manager::DIVIDER,
          ]
        );
        
        $this->add_control(
          'bficonsize4megamenuonekaveh',
          [
            'label' => esc_html__( 'سایز آیکون بعد از نوشته', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 200,
                'step' => 1,
              ],
            ],
            'default' => [
              'unit' => 'px',
              'size' => 10,
            ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-product .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        
        $this->add_group_control(
          \Elementor\Group_Control_Box_Shadow::get_type(),
          [
            'name' => 'box_shadow4megamenuonekavehh',
            'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .megamenu-product .btn',
          ]
        );
        $this->add_control(
          'buttonpadding4megamenuonekaveh',
          [
            'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-product .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
          'style4megamenuonekaveh',
          [
            'label' => esc_html__( 'استایل ستون محصولات', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          ]
        );
        $this->add_control(
          'bgproduct5megamenuonekaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه تصویر محصولات', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .bgpromegamenu1' => 'background-color: {{VALUE}} !important',
            ],
          ]
        ); 
        $this->add_control(
          'subjpro5megamenuonekaveh',
          [
            'label' => esc_html__( 'رنگ عنوان محصولات', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-tab-contents-item .categories li h2' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'productradiushover5megamenuonekaveh',
          [
            'label' => esc_html__( 'گوشه خمیده محصولات', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .bgpromegamenu1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            ],
          ]
        );
        $this->add_control(
          'hr7megamenuonekaveh',
          [
            'type' => \Elementor\Controls_Manager::DIVIDER,
          ]
        );
        $this->start_controls_tabs(
          'style_tabs5megamenuonekaveh'
        );
        
        $this->start_controls_tab(
          'style_normal_tab5megamenuonekaveh',
          [
            'label' => esc_html__( 'عادی', 'kaveh-core' ),
          ]
        );
        $this->add_control(
          'textbuttoncolor5megamenuonekaveh',
          [
            'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-tab-contents-item .categories .btn' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'iconbuttoncolor5megamenuonekaveh',
          [
            'label' => esc_html__( 'رنگ آیکون دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-tab-contents-item .categories .btn i' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'buttoncolor5megamenuonekaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-tab-contents-item .categories .btn' => 'background-color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'buttonradius5megamenuonekaveh',
          [
            'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-tab-contents-item .categories .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Border::get_type(),
          [
            'name' => 'border5megamenuonekaveh',
            'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .megamenu-tab-contents-item .categories .btn',
          ]
        );
        $this->add_control(
          'buttonborders5megamenuonekaveh',
          [
            'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'condition' => [
              'border5megamenuonekaveh!' => '',
            ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-tab-contents-item .categories .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            ],
          ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
          'style_hove_tab5megamenuonekaveh',
          [
            'label' => esc_html__( 'هاور', 'kaveh-core' ),
          ]
        );
        $this->add_control(
          'textbuttoncolorhover5megamenuonekaveh',
          [
            'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-tab-contents-item .categories .btn:hover' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'iconbuttoncolorhover5megamenuonekaveh',
          [
            'label' => esc_html__( 'رنگ آیکون دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-tab-contents-item .categories .btn:hover i' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'buttoncolorhover5megamenuonekaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu-tab-contents-item .categories .btn:hover' => 'background-color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'buttonradiushover5megamenuonekaveh',
          [
            'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-tab-contents-item .categories .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Border::get_type(),
          [
            'name' => 'borderhover5megamenuonekaveh',
            'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .megamenu-tab-contents-item .categories .btn:hover',
          ]
        );
        $this->add_control(
          'buttonbordershover5megamenuonekaveh',
          [
            'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'condition' => [
              'borderhover5megamenuonekaveh!' => '',
            ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-tab-contents-item .categories .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            ],
          ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
          'hr5megamenuonekaveh',
          [
            'type' => \Elementor\Controls_Manager::DIVIDER,
          ]
        );
        
        $this->add_control(
          'bficonsize5megamenuonekaveh',
          [
            'label' => esc_html__( 'سایز آیکون بعد از نوشته', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 200,
                'step' => 1,
              ],
            ],
            'default' => [
              'unit' => 'px',
              'size' => 10,
            ],
            'selectors' => [
              '{{WRAPPER}} .megamenu-tab-contents-item .categories .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        
        $this->add_group_control(
          \Elementor\Group_Control_Box_Shadow::get_type(),
          [
            'name' => 'box_shadow5megamenuonekavehh',
            'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .megamenu-tab-contents-item .categories .btn',
          ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
          'style5megamenuonekaveh',
          [
            'label' => esc_html__( 'استایل عمومی مگامنو', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          ]
        );
        $this->add_control(
          'bgmegamenucolor5megamenuonekaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه مگامنو', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .megamenu' => 'background-color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'megamenuradiushover5megamenuonekaveh',
          [
            'label' => esc_html__( 'گوشه خمیده تصویر', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .megamenu' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->end_controls_section();

        }
 


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
  
?>
            <div class="megamenu position-absolute w-100 start-0 top-100">
              <div class="megamenu-tabs w-100">
              <?php $tabco=(int)$settings['tabcountmegamenuonekaveh'];?>
                <?php 
                 for($a=1;$a <= $tabco; $a++ ){ 
                  ?>
                <span class="d-flex align-items-center position-relative <?php if($a==1){ ?>active<?php } ?>" data-target="megamenu-<?php echo $a; ?>">
                  <i class="<?php echo  esc_attr($settings['icon'.$a.'megamenuonekaveh']['value']); ?>"></i>
                   <?php echo  esc_html($settings['title'.$a.'megamenuonekaveh']); ?>
                </span>
              <?php }?>
              </div>
              <div class="megamenu-tab-contents w-100">
              <?php $tabco=$settings['tabcountmegamenuonekaveh'];?>
                <?php $a=1; for($a=1;$a <= $tabco;$a++){ ?>
                <div id="megamenu-<?php echo $a; ?>" class="megamenu-tab-contents-item <?php if($a==1){ ?>active<?php } ?>">
                  <div class="right d-flex align-items-center w-100">
                    <ul>
                      <li class="title <?php if("yes"===$settings['activeoffcol1'.$a.'megamenuonekaveh']){?>offer<?php } ?>"> 
                        <?php if("yes"===$settings['activeoffcol1'.$a.'megamenuonekaveh']){?>
                        <span class="text-center text-white fw-bold d-inline-block"> <?php echo  esc_html($settings['offcol1'.$a.'megamenuonekaveh']); ?> </span>
                        <?php } ?>
                        <?php echo  esc_html($settings['titlecol'.$a.'megamenuonekaveh']); ?></li>
                        <?php
                        if ( $settings['listcol'.$a.'megamenuonekaveh'] ) {
                        foreach (  $settings['listcol'.$a.'megamenuonekaveh'] as $item ) {
                        ?>
                      <li>
                        <a href="<?php echo  esc_url($item['col1link'.$a.'megamenuonekaveh']); ?>" class="d-block"><?php echo  esc_html($item['col1title'.$a.'megamenuonekaveh']); ?></a>
                      </li>
                      <?php
                        }
                      }
                      ?>
                    </ul>
                    <ul>
                      <li class="title <?php if("yes"===$settings['activeoffcol2'.$a.'megamenuonekaveh']){?>offer<?php } ?>">
                      <?php if("yes"===$settings['activeoffcol2'.$a.'megamenuonekaveh']){?>
                        <span class="text-center text-white fw-bold d-inline-block"> <?php echo  esc_html($settings['offcol2'.$a.'megamenuonekaveh']); ?> </span>
                        <?php } ?>
                        <?php echo  esc_html($settings['titlecol2'.$a.'megamenuonekaveh']); ?>
                      </li>
                      <?php
                        if ( $settings['listcol2'.$a.'megamenuonekaveh'] ) {
                        foreach (  $settings['listcol2'.$a.'megamenuonekaveh'] as $item ) {
                        ?>
                      <li>
                      <a href="<?php echo  esc_url($item['col2link'.$a.'megamenuonekaveh']); ?>" class="d-block"><?php echo  esc_html($item['col2title'.$a.'megamenuonekaveh']); ?></a>
                      </li>
                      <?php
                        }
                      }
                      ?> 
                    </ul>
                    <div class="megamenu-product position-relative">
                      <img src="<?php echo  esc_html($settings['imagecol3'.$a.'megamenuonekaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $settings['imagecol3'.$a.'megamenuonekaveh'] )); ?>" class="d-block w-100" />
                      <?php if("yes"===$settings['activeoffcol3'.$a.'megamenuonekaveh']){?>
                      <span class="offer position-absolute top-0 end-0 text-white fw-bold text-center"> <?php echo  esc_html($settings['offcol3'.$a.'megamenuonekaveh']); ?> </span>
                      <?php } ?>
                      <?php if("yes"===$settings['activecol3button'.$a.'megamenuonekaveh']){?>
                      <a href="<?php echo  esc_url($settings['col3buttonlink'.$a.'megamenuonekaveh']); ?>" class="btn btn-success position-absolute">
                       <?php echo  esc_html($settings['col3buttontitle'.$a.'megamenuonekaveh']); ?>
                        <i class="icon-arrow-left"></i>
                      </a>
                      <?php } ?>
                    </div>
                  </div>
                  <div class="categories w-100 position-relative">
                    <ul class="d-flex align-items-center flex-wrap">
                      <?php            
                      // WP_Query args
                      $q_mega_query_args = array(
                      'post_type' => array('product'),
                      'posts_per_page' => $settings['productnumber'.$a.'megamenuonekaveh'],
                      'order' => 'DESC',
                      'orderby' => 'date',
                      'tax_query' => array(
                      array(
                      "taxonomy" => "product_cat",
                      "field"    => "tag_ID",
                      "terms"    => $settings['cat1col4'.$a.'megamenuonekaveh'],
                      ),
                      'meta_query' => array(
                        array(
                            'key' => '_stock_status',
                            'value' => 'outofstock',
                            'compare' => 'NOT IN',
                        ),
                       ),
                      ),


                      );

                      // The Query
                      $mega_query = new \WP_Query($q_mega_query_args);

                      // The Loop
                      if ( $mega_query->have_posts() ) {
                      while ( $mega_query->have_posts() ) {
                      $mega_query->the_post(); ?>
                      <li class="position-relative w-100">
                        <a href="<?php the_permalink(); ?>" class="stretched-link"></a>
                        <div class="image d-flex align-items-center justify-content-center mx-auto bg-white bgpromegamenu1">
                          <img src="<?php the_post_thumbnail_url('thumbnail'); ?>" alt="product" />
                        </div>
                        <h2 class="mb-0 text-truncate text-center"> <?php the_title(); ?></h2>
                      </li>
                      <?php
                      // Reset Original Post Data
                      wp_reset_postdata();
                      }
                      }

                      ?>
                    </ul>
                    <a href="<?php echo  esc_url($settings['col4buttonlink'.$a.'megamenuonekaveh']); ?>" class="btn btn-dark position-absolute start-50 bottom-0 translate-middle-x p-0 w-100">
                    <?php echo  esc_html($settings['col4buttontitle'.$a.'megamenuonekaveh']); ?>
                      <i class="icon-angle-down"></i>
                    </a>
                  </div>
                </div>
                <?php } ?>
              </div>
            </div>
           <?php if( \Elementor\Plugin::$instance->editor->is_edit_mode() ) : ?>
<style>
  .megamenu-two {
    transform: unset !important;
    z-index: 99 !important;
}
.megamenu {
    transform: unset!important;
    z-index: 99 !important;
}
</style>
<script> 
    // Megamenu
    const tabsMegamenu = document.querySelectorAll(
    ".megamenu-tabs span, .megamenu-two-tabs-item"
  );

  if (tabsMegamenu.length > 0) {
    tabsMegamenu.forEach((tab) => {
      tab.addEventListener("mouseover", (ev) => {
        const el = ev.currentTarget,
          id = el.dataset.target,
          content = document.getElementById(id);

        if (content) {
          [...el.parentElement.children].map((tabItems) => {
            const id = tabItems.dataset.target;

            tabItems.classList.remove("active");
            document.getElementById(id).classList.remove("active");
          });

          el.classList.add("active");
          content.classList.add("active");

          content.style.opacity = 0;

          setTimeout(() => {
            content.style.opacity = 1;
            content.removeAttribute("style");
          }, 50);
        }
      });
    });
  }
</script>
<?php endif; ?>
    <?php
  }


}
