<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Headingkaveh extends Widget_Base{

  public function get_name(){
    return 'headingkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان هدینگ', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentheadingkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'styledotheadingkaveh',
        [
          'label' => esc_html__( 'استایل المان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'one',
          'options' => [
            'one'  => esc_html__( 'طرح یک', 'kaveh-core' ),
            'two'  => esc_html__( 'طرح دو', 'kaveh-core' ),
            'three'  => esc_html__( 'طرح سه', 'kaveh-core' ),
            'four'  => esc_html__( 'طرح چهار', 'kaveh-core' ),
            'five'  => esc_html__( 'طرح پنج', 'kaveh-core' ),
          ],
        ]
        ); 
        $this->add_control(
          'beforetitleheadingkaveh',
          [
              'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
              'condition' => [
                'styledotheadingkaveh' => ['two','three','four','five' ],
              ],
      
          ]
      );
      $this->add_control(
        'tagheading1headingkaveh',
        [
          'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H6',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
          ],
          'condition' => [
            'styledotheadingkaveh' => 'two',
          ],
        ]
      );
      $this->add_control(
        'titleheadingkaveh',
        [
            'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'عنوان اصلی' , 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tagheading2headingkaveh',
      [
        'label' => esc_html__( 'تگ عنوان اصلی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );

    $this->add_control(
      'titlelinkheadingkaveh',
      [
          'label' => esc_html__( 'لینک', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#' , 'kaveh-core' ),
          'condition' => [
            'styledotheadingkaveh!' => ['four','five'],
          ],
  
      ]
  );  
  $this->add_control(
    'title3headingkaveh',
    [
        'label' => esc_html__( 'زیر عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( 'زیرعنوان' , 'kaveh-core' ),
        'condition' => [
            'styledotheadingkaveh' => 'five',
          ],

    ]
);
$this->add_control(
  'tagheading3headingkaveh',
  [
    'label' => esc_html__( 'تگ زیر عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SELECT,
    'default' => 'H3',
    'condition' => [
            'styledotheadingkaveh' => 'five',
          ],
    'options' => [
      'H1'  => esc_html__( 'H1', 'kaveh-core' ),
      'H2' => esc_html__( 'H2', 'kaveh-core' ),
      'H3' => esc_html__( 'H3', 'kaveh-core' ),
      'H4' => esc_html__( 'H4', 'kaveh-core' ),
      'H5' => esc_html__( 'H5', 'kaveh-core' ),
      'H6' => esc_html__( 'H6', 'kaveh-core' ),
      'p' => esc_html__( 'p', 'kaveh-core' ),
      'div' => esc_html__( 'div', 'kaveh-core' ),
      'span' => esc_html__( 'span', 'kaveh-core' ),
    ],
  ]
);
$this->add_control(
    'desc3headingkaveh',
    [
        'label' => esc_html__( 'توضیحات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__( 'فروش ویژه انواع برند های عینک آفتابی' , 'kaveh-core' ),
        'condition' => [
            'styledotheadingkaveh' => 'five',
          ],

    ]
);
  $this->add_control(
    'text_alignheadingkaveh',
    [
      'label' => esc_html__( 'چیدمان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::CHOOSE,
      'options' => [
        'left' => [
          'title' => esc_html__( 'چپ چین', 'kaveh-core' ),
          'icon' => 'eicon-text-align-left',
        ],
        'center' => [
          'title' => esc_html__( 'وسط چین', 'kaveh-core' ),
          'icon' => 'eicon-text-align-center',
        ],
        'right' => [
          'title' => esc_html__( 'راست چین', 'kaveh-core' ),
          'icon' => 'eicon-text-align-right',
        ],
      ],
      'condition' => [
        'styledotheadingkaveh!' => ['one','five'],
      ],
      'toggle' => true,
    ]
  );
        $this->end_controls_section();
        $this->start_controls_section(
          'styleheadingkaveh',
          [
            'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'title1_headingkaveh',
            'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .headfkaveh',
            'condition' => [
              'styledotheadingkaveh' => ['two','three','four' ],
            ],
          ]
        );
        $this->add_control(
          't1colorheadingkaveh',
          [
            'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .headfkaveh' => 'color: {{VALUE}}',
              'condition' => [
                'styledotheadingkaveh' => ['two','three','four' ],
              ],
            ],
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'title2headingkaveh',
            'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .headkaveh',
          ]
        );
        $this->add_control(
          't2colorheadingkaveh',
          [
            'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .headkaveh' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->add_control(
          'mtheadingkaveh',
          [
            'label' => esc_html__( 'فاصله شیپ از بالا', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'condition' => [
              'styledotheadingkaveh' => 'one',
            ],
            'range' => [
              'px' => [
                'min' => -200,
                'max' => 200,
                'step' => 1,
              ],
              '%' => [
                'min' => -50,
                'max' => 50,
              ],
            ],
            'default' => [
              'unit' => 'px',
              'size' => 22,
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-name-shop::after' => 'margin-top: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          't1shapebgcolorheadingkaveh',
          [
            'label' => esc_html__( 'رنگ شیپ', 'kaveh-core' ),
            'condition' => [
              'styledotheadingkaveh' => 'one',
            ],
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .footer-name-shop::after' => 'background-color: {{VALUE}}',
            ],
          ]
        );
        $this->add_control(
          't3shapebgcolorheadingkaveh',
          [
            'label' => esc_html__( 'رنگ شیپ', 'kaveh-core' ),
            'condition' => [
              'styledotheadingkaveh' => 'three',
            ],
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .footer-three-titr::before' => 'background-color: {{VALUE}}',
            ],
          ]
        );

$this->add_group_control(
  \Elementor\Group_Control_Typography::get_type(),
  [
    'name' => 'title3headingkaveh',
    'label' => esc_html__( 'تایپوگرافی زیر عنوان', 'kaveh-core' ),
    'selector' => '{{WRAPPER}} .zheadkaveh',
    'condition' => [
      'styledotheadingkaveh' => 'five',
    ],
  ]
);
$this->add_control(
  't3colorheadingkaveh',
  [
    'label' => esc_html__( 'رنگ زیر عنوان', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::COLOR,
    'condition' => [
      'styledotheadingkaveh' => 'five',
    ],
    'selectors' => [
      '{{WRAPPER}} .zheadkaveh' => 'color: {{VALUE}}',
    ],
  ]
);
$this->add_group_control(
  \Elementor\Group_Control_Typography::get_type(),
  [
    'name' => 'desc4headingkaveh',
    'label' => esc_html__( 'تایپوگرافی توضیحات', 'kaveh-core' ),
    'condition' => [
      'styledotheadingkaveh' => 'five',
    ],
    'selector' => '{{WRAPPER}} .deskaveh',
  ]
);
$this->add_control(
  'des4colorheadingkaveh',
  [
    'label' => esc_html__( 'رنگ توضیحات', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::COLOR,
    'condition' => [
      'styledotheadingkaveh' => 'five',
    ],
    'selectors' => [
      '{{WRAPPER}} .deskaveh' => 'color: {{VALUE}}',
    ],
  ]
);
        $this->end_controls_section();
          
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
  
?>
          <?php if('one'===$settings['styledotheadingkaveh']){ ?>
            <a href="<?php echo  esc_url($settings['titlelinkheadingkaveh']); ?>" class="footer-name-shop position-relative <?php if("left"===$settings['text_alignheadingkaveh']){ ?>text-end<?php }elseif("center"===$settings['text_alignheadingkaveh']){ ?>text-center<?php }elseif("right"===$settings['text_alignheadingkaveh']){ ?>text-right<?php } ?>"><<?php echo  esc_attr($settings['tagheading2headingkaveh']); ?> class="headkaveh"><?php echo  esc_html($settings['titleheadingkaveh']); ?></<?php echo  esc_attr($settings['tagheading2headingkaveh']); ?>></a>
          <?php }elseif('two'===$settings['styledotheadingkaveh']){ ?>
              <div class="section-heading">
          <div class="detail">
            <a href="<?php echo  esc_url($settings['titlelinkheadingkaveh']); ?>" class="<?php if("left"===$settings['text_alignheadingkaveh']){ ?>text-end<?php }elseif("center"===$settings['text_alignheadingkaveh']){ ?>text-center<?php }elseif("right"===$settings['text_alignheadingkaveh']){ ?>text-right<?php } ?>">
            <<?php echo  esc_attr($settings['tagheading1headingkaveh']); ?> class="section-heading-sub-title headfkaveh"><?php echo  esc_html($settings['beforetitleheadingkaveh']); ?></<?php echo  esc_attr($settings['tagheading1headingkaveh']); ?>>
            <<?php echo  esc_attr($settings['tagheading2headingkaveh']); ?> class="section-heading-title headkaveh"><?php echo  esc_html($settings['titleheadingkaveh']); ?></<?php echo  esc_attr($settings['tagheading2headingkaveh']); ?>>
            </a>
          </div>
          </div>
          <?php }elseif('three'===$settings['styledotheadingkaveh']){ ?>
            <a href="<?php echo  esc_url($settings['titlelinkheadingkaveh']); ?>" class="<?php if("left"===$settings['text_alignheadingkaveh']){ ?>text-end<?php }elseif("center"===$settings['text_alignheadingkaveh']){ ?>text-center<?php }elseif("right"===$settings['text_alignheadingkaveh']){ ?>text-right<?php } ?>">
            <<?php echo  esc_attr($settings['tagheading2headingkaveh']); ?> class="footer-three-titr headfkaveh">
            <?php echo  esc_html($settings['beforetitleheadingkaveh']); ?>
              <span class="headkaveh"><?php echo  esc_html($settings['titleheadingkaveh']); ?></span>
            </<?php echo  esc_attr($settings['tagheading2headingkaveh']); ?>>
            </a>
            <?php }elseif('four'===$settings['styledotheadingkaveh']){ ?>
          <div class="footer-four">
            <<?php echo  esc_attr($settings['tagheading2headingkaveh']); ?> class="titr headkaveh <?php if("left"===$settings['text_alignheadingkaveh']){ ?>text-end<?php }elseif("center"===$settings['text_alignheadingkaveh']){ ?>text-center<?php }elseif("right"===$settings['text_alignheadingkaveh']){ ?>text-right<?php } ?>"> <b class="headfkaveh"><?php echo  esc_html($settings['beforetitleheadingkaveh']); ?></b> <?php echo  esc_html($settings['titleheadingkaveh']); ?></<?php echo  esc_attr($settings['tagheading2headingkaveh']); ?>>
          </div>
          <?php }elseif('five'===$settings['styledotheadingkaveh']){ ?>
            <div class="about-us-landing">
            <div class="content position-relative about-us-landing">
              <<?php echo  esc_attr($settings['tagheading2headingkaveh']); ?> class="title mb-0 headkaveh"> <span class="headfkaveh"> <?php echo  esc_html($settings['beforetitleheadingkaveh']); ?> </span> <?php echo  esc_html($settings['titleheadingkaveh']); ?> </<?php echo  esc_attr($settings['tagheading2headingkaveh']); ?>>
              <<?php echo  esc_attr($settings['tagheading3headingkaveh']); ?> class="sub-title zheadkaveh"> <?php echo  esc_html($settings['title3headingkaveh']); ?></<?php echo  esc_attr($settings['tagheading3headingkaveh']); ?>>
              <div class="description position-relative deskaveh"> <?php echo  esc_html($settings['desc3headingkaveh']); ?></div>
            </div>
            </div>
            <?php }?>
<style>
  <?php echo '.elementor-element-' . $clsid . ''; ?> .footer-name-shop::after {
    margin-top: 22px;
    }
</style> 
    <?php
  }


}
