<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Sliderfirstkaveh extends Widget_Base{

  public function get_name(){
    return 'sliderfirstkaveh';
  }

  public function get_title(){
    return esc_html__( 'اسلایدر سبک اول', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentsliderfirstkaveh',
        [
          'label' => esc_html__( 'Content', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'style1sliderfirstkaveh',
        [
          'label' => esc_html__( 'طرح بندی اسلایدر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'one',
          'options' => [
            'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
            'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
            'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
            'four'  => esc_html__( 'طرح بندی چهارم', 'kaveh-core' ),
    
          ],
        ]
        ); 
      $repeater = new \Elementor\Repeater();

      $repeater->add_control(
        'backsliderfirstkaveh',
        [
          'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
      );
      $repeater->add_control(
        'linksliderfirstkaveh',
        [
            'label' => esc_html__( 'لینک اسلاید', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( '#', 'kaveh-core' ),
    
        ]
    );
      $this->add_control(
        'slidessliderfirstkaveh',
        [
          'label' => esc_html__( 'اسلاید ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::REPEATER,
          'fields' => $repeater->get_controls(),
          ],
      );
      $this->add_control(
        'arrowssliderfirstkaveh',
        [
          'label' => esc_html__( 'نمایش فلش ها؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'bulletssliderfirstkaveh',
        [
          'label' => esc_html__( 'نمایش نقطه ها؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
          'condition' => [
            'style1sliderfirstkaveh' => ['one','three','four'],
          ],
        ]
      );
      $this->end_controls_section();

      $this->start_controls_section(
        'style1_sliderfirstkaveh',
        [
          'label' => esc_html__( 'استایل اسلایدر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'heightbgsliderfirstkaveh',
        [
          'label' => esc_html__( 'ارتفاع اسلایدر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'condition' => [
            'style1sliderfirstkaveh' => 'one',
          ],
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => '%',
            'size' => 100,
          ],
          'selectors' => [
            '{{WRAPPER}} .slider-banner-home .carousel, .slider-banner-home .carousel-inner, .slider-banner-home .carousel-item, .slider-banner-home .carousel-item img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'height2bgsliderfirstkaveh',
        [
          'label' => esc_html__( 'ارتفاع اسلایدر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'condition' => [
            'style1sliderfirstkaveh' => 'two',
          ],
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => '%',
            'size' => 100,
          ],
          'selectors' => [
            '{{WRAPPER}} .slider-home img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'height3bgsliderfirstkaveh',
        [
          'label' => esc_html__( 'ارتفاع اسلایدر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'condition' => [
            'style1sliderfirstkaveh' => 'three',
          ],
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => '%',
            'size' => 100,
          ],
          'selectors' => [
            '{{WRAPPER}} .category-slider-banner .left .carousel-item img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
    
      $this->add_control(
        'height4bgsliderfirstkaveh',
        [
          'label' => esc_html__( 'ارتفاع اسلایدر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'condition' => [
            'style1sliderfirstkaveh' => 'four',
          ],
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => '%',
            'size' => 100,
          ],
          'selectors' => [
            '{{WRAPPER}} .slider-banners-ten-item img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
       $this->end_controls_section();

          
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
      <?php if('one'===$settings['style1sliderfirstkaveh']){ ?>
       <div class="slider-banner-home">
            <div id="slider-home" class="carousel carousel-fade" data-bs-ride="carousel">
            <?php if("yes"===$settings['bulletssliderfirstkaveh']){?>
              <div class="carousel-indicators d-none d-md-block">
              <?php
              $j=0;
              if ( $settings['slidessliderfirstkaveh'] ) {
              foreach (  $settings['slidessliderfirstkaveh'] as $item ) {
              ?>
                <button type="button" data-bs-target="#slider-home" data-bs-slide-to="<?php echo $j ; ?>" class="<?php if($j==0){ ?>active<?php }else{}?>"
                  aria-current="true" aria-label="Slide <?php echo $j ;?>"></button>
                  <?php
                $j++;
                }
              }
                ?>
              </div>
              <?php } ?>
              <div class="carousel-inner">
              <?php
              $i=0;
              if ( $settings['slidessliderfirstkaveh'] ) {
              foreach (  $settings['slidessliderfirstkaveh'] as $item ) {
              ?>
                <div class="carousel-item <?php if($i==0){ ?>active<?php }else{}?>">
                  <a href="<?php echo  esc_url($item['linksliderfirstkaveh']); ?>">
                    <img src="<?php echo esc_url($item['backsliderfirstkaveh']['url']); ?>" class="d-block w-100" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['backsliderfirstkaveh'] )); ?>">
                  </a>
                </div>
                <?php
                $i++;
                }
              }
                ?>
        </div>
              <?php if("yes"===$settings['arrowssliderfirstkaveh']){?>
              <button class="carousel-control-prev d-none d-md-block" type="button" data-bs-target="#slider-home"
                data-bs-slide="prev">
                <i class="icon-angle-right"></i>
              </button>
              <button class="carousel-control-next d-none d-md-block" type="button" data-bs-target="#slider-home"
                data-bs-slide="next">
                <i class="icon-angle-left"></i>
              </button>
          <?php } ?>
            </div>
          </div>
  <?php }elseif('two'===$settings['style1sliderfirstkaveh']){ ?>
    <div class="slider-home">
      <div class="swiper swiper-slider-home position-relative">
        <div class="swiper-wrapper">
        <?php
              if ( $settings['slidessliderfirstkaveh'] ) {
              foreach (  $settings['slidessliderfirstkaveh'] as $item ) {
              ?>
          <div class="swiper-slide">
            <a href="<?php echo  esc_url($item['linksliderfirstkaveh']); ?>">
              <img src="<?php echo esc_url($item['backsliderfirstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['backsliderfirstkaveh'] )); ?>" class="w-100 d-block" />
            </a>
          </div>
          <?php
                }
              }
                ?>
        </div>
        <?php if("yes"===$settings['arrowssliderfirstkaveh']){?>
        <div class="swiper-button-next d-none d-md-flex"></div>
        <div class="swiper-button-prev d-none d-md-flex"></div>
        <?php } ?>

      </div>
    </div>
    <?php }elseif('three'===$settings['style1sliderfirstkaveh']){ ?>
     <section class="category-slider-banner"> 
      <div class="left">
          <div id="slider-eight" class="carousel carousel-fade" data-bs-ride="carousel">
          <?php if("yes"===$settings['bulletssliderfirstkaveh']){?>
            <div class="carousel-indicators">
            <?php
              $j=0;
              if ( $settings['slidessliderfirstkaveh'] ) {
              foreach (  $settings['slidessliderfirstkaveh'] as $item ) {
              ?>
              <button type="button" data-bs-target="#slider-eight" data-bs-slide-to="<?php echo $j ; ?>" class="<?php if($j==0){ ?>active<?php }else{}?>"
                aria-current="true" aria-label="Slide <?php echo $j ;?>"></button>
                <?php
                $j++;
                }
              }
                ?>
            </div>
            <?php } ?>
            <div class="carousel-inner">
            <?php
              $i=0;
              if ( $settings['slidessliderfirstkaveh'] ) {
              foreach (  $settings['slidessliderfirstkaveh'] as $item ) {
              ?>
              <div class="carousel-item <?php if($i==0){ ?>active<?php }else{}?>">
              <a href="<?php echo  esc_url($item['linksliderfirstkaveh']); ?>">
                <img src="<?php echo esc_url($item['backsliderfirstkaveh']['url']); ?>" class="d-block w-100" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['backsliderfirstkaveh'] )); ?>" />
                </a>
              </div>
              <?php
                $i++;
                }
              }
                ?>
            </div>
            <?php if("yes"===$settings['arrowssliderfirstkaveh']){?>
            <button class="carousel-control-prev" type="button" data-bs-target="#slider-eight" data-bs-slide="prev">
              <i class="icon-angle-right"></i>
            </button>
            <button class="carousel-control-next" type="button" data-bs-target="#slider-eight" data-bs-slide="next">
              <i class="icon-angle-left"></i>
            </button>
            <?php } ?>
          </div>
          </div>
     </section>
          <?php }elseif('four'===$settings['style1sliderfirstkaveh']){ ?>
    <div class="slider-banners-ten">
      <div class="container">
        <!-- Start Carousel -->
        <div class="swiper swiper-slider-ten position-relative">
          <div class="swiper-wrapper">
          <?php
              if ( $settings['slidessliderfirstkaveh'] ) {
              foreach (  $settings['slidessliderfirstkaveh'] as $item ) {
              ?>
            <!-- Start Slide -->
            <div class="swiper-slide">
              <div class="slider-banners-ten-item">
                <a href="<?php echo  esc_url($item['linksliderfirstkaveh']); ?>">
                  <img src="<?php echo esc_url($item['backsliderfirstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['backsliderfirstkaveh'] )); ?>" class="d-block w-100" />
                </a>
              </div>
            </div>
            <!-- End Slide -->
            <?php
                }
              }
                ?>
          </div>
          <div class="swiper-bottom d-flex align-items-center justify-content-center">
          <?php if("yes"===$settings['arrowssliderfirstkaveh']){?>
            <div class="swiper-button-prev"></div>
            <?php } ?>
          <?php if("yes"===$settings['bulletssliderfirstkaveh']){?>

            <div class="swiper-pagination"></div>
            <?php } ?>

            <?php if("yes"===$settings['arrowssliderfirstkaveh']){?>
            <div class="swiper-button-next"></div>
            <?php } ?>
          </div>
        </div>
        <!-- End Carousel -->
      </div>
    </div>
    <?php } ?>
    <?php if( \Elementor\Plugin::$instance->editor->is_edit_mode() ) { ?>
    <script>
       function init<?php echo $clsid; ?>() {
  // Swiper Slider Home
  new Swiper(".swiper-slider-home", {
    slidesPerView: 1,
    spaceBetween: 0,
    autoplay: {
      delay: 5000,
      disableOnInteraction: false,
      pauseOnMouseEnter: true,
    },
    effect: "fade",
    fadeEffect: {
      crossFade: true,
    },
    loop: true,
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
  });
    // Swiper Slider Ten
    new Swiper(".swiper-slider-ten", {
    loop: true,
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    slidesPerView: 1,
    spaceBetween: 0,
    pagination: {
      el: ".swiper-pagination",
      type: "bullets",
      clickable: true,
    },
    autoplay: {
      delay: 3000,
    },
    effect: "fade",
    fadeEffect: {
      crossFade: true,
    },
    loop: true,
  });
}
      if (window.Swiper) {
    // Swiper library already loaded, initialize Swiper instance
    init<?php echo $clsid; ?>();
  } else {
    // Swiper library not yet loaded, wait for it to load
    window.addEventListener("load", function() {
      init<?php echo $clsid; ?>();
    });
  }
  
    </script>
    <?php  } ?>
    <?php
  }


}
