<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Slidereighthkaveh extends Widget_Base{

  public function get_name(){
    return 'slidereighthkaveh';
  }
 
  public function get_title(){
    return esc_html__( 'اسلایدر سبک هشت', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentslidereighthkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      ); 
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'titleslidereighthkaveh',
        [
            'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'تخفیف ویژه نوشیدنی ها', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'tagheading1slidereighthkaveh',
      [
        'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H6',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'title2slidereighthkaveh',
      [
          'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'جشنواره زمستانی', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'tagheading2slidereighthkaveh',
    [
      'label' => esc_html__( 'تگ عنوان اصلی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'H3',
      'options' => [
        'H1'  => esc_html__( 'H1', 'kaveh-core' ),
        'H2' => esc_html__( 'H2', 'kaveh-core' ),
        'H3' => esc_html__( 'H3', 'kaveh-core' ),
        'H4' => esc_html__( 'H4', 'kaveh-core' ),
        'H5' => esc_html__( 'H5', 'kaveh-core' ),
        'H6' => esc_html__( 'H6', 'kaveh-core' ),
        'p' => esc_html__( 'p', 'kaveh-core' ),
        'div' => esc_html__( 'div', 'kaveh-core' ),
        'span' => esc_html__( 'span', 'kaveh-core' ),
      ],
    ]
  );
      $repeater->add_control(
        'buttonslidereighthkaveh',
        [
            'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'محصولات', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'iconbuttslidereighthkaveh',
      [
        'label' => esc_html__( 'آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'isax isax-arrow-left4',
        ],
      ]
    );
    $repeater->add_control(
      'linkbuttonslidereighthkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'backslidereighthkaveh',
    [
      'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::MEDIA,
    ]
  );
      $this->add_control(
        'slidesslidereighthkaveh',
        [
          'label' => esc_html__( 'اسلاید ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::REPEATER,
          'default' => [
            [
              'titleslidereighthkaveh' => esc_html__( 'تخفیف ویژه نوشیدنی ها' , 'kaveh-core' ),
              'title2slidereighthkaveh' => esc_html__( 'جشنواره زمستانی', 'kaveh-core' ),
              'buttonslidereighthkaveh' => esc_html__( 'محصولات', 'kaveh-core' ),
              'linkbuttonslidereighthkaveh' => esc_html__( '#', 'kaveh-core' ),
            ],
          ],
          'fields' => $repeater->get_controls()
          ],
      );
      $this->add_control(
        'backjslidereighthkaveh',
        [
          'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,   
          'selectors' => [
            '{{WRAPPER}} .landing-sixteen::before' =>
                'background: url({{URL}})',
        ],         
        ]
      );
     
       $this->end_controls_section();
       $this->start_controls_section(
        'style1_slidereighthkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
       );
       $this->add_control(
        'titlestslidereighthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-sixteen-item .sup-title .subsli8t' => 'color: {{VALUE}}',
          ],
        ]
       );
       $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_slidereighthkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-sixteen-item .sup-title .subsli8t',
        ]
       );
       $this->add_control(
        'titlepstslidereighthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-sixteen-item .title .sli8t' => 'color: {{VALUE}}',
          ],
        ]
       );
       $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'p_slidereighthkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-sixteen-item .title .sli8t',
        ]
       );
       $this->end_controls_section();
       
       
       
       
       
       $this->start_controls_section(
         'style2_slidereighthkaveh',
         [
           'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
           'tab' => \Elementor\Controls_Manager::TAB_STYLE, 
         ]
        );
        $this->add_group_control(
         \Elementor\Group_Control_Typography::get_type(),
         [
           'name' => 'button_slidereighthkaveh',
           'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
           'selector' => '{{WRAPPER}} .landing-sixteen-item .btn',
         ]
       );
       $this->add_control(
         'iconsizeslidereighthkaveh',
         [
           'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::SLIDER,
           'size_units' => [ 'px', '%' ],
           'range' => [
             'px' => [
               'min' => 0,
               'max' => 200,
               'step' => 5,
             ],
             '%' => [
               'min' => 0,
               'max' => 100,
             ],
           ],
           'selectors' => [
             '{{WRAPPER}} .landing-sixteen-item .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
           ],
         ]
       );
       $this->add_group_control(
         \Elementor\Group_Control_Text_Shadow::get_type(),
         [
           'name' => 'text_shadowslidereighthkaveh',
           'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
           'selector' => '{{WRAPPER}} .landing-sixteen-item .btn',
         ]
       );
       $this->start_controls_tabs(
         'style_tabsslidereighthkaveh'
       );
       
       $this->start_controls_tab(
         'style_normal_tabslidereighthkaveh',
         [
           'label' => esc_html__( 'عادی', 'kaveh-core' ),
         ]
       );
       $this->add_control(
         'textbuttoncolorslidereighthkaveh',
         [
           'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-sixteen-item .btn' => 'color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'iconcolorslidereighthkaveh',
         [
           'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-sixteen-item .btn i' => 'color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'buttoncolorslidereighthkaveh',
         [
           'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-sixteen-item .btn' => 'background-color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'buttonradiusslidereighthkaveh',
         [
           'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px' ],
           'selectors' => [
             '{{WRAPPER}} .landing-sixteen-item .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
           ],
         ]
       );
       $this->add_group_control(
         \Elementor\Group_Control_Border::get_type(),
         [
           'name' => 'borderslidereighthkaveh',
           'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
           'selector' => '{{WRAPPER}} .landing-sixteen-item .btn',
         ]
       );
       $this->add_control(
         'buttonbordersslidereighthkaveh',
         [
           'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px' ],
           'condition' => [
             'borderslidereighthkaveh!' => '',
           ],
           'selectors' => [
             '{{WRAPPER}} .landing-sixteen-item .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
           ],
         ]
       );
       $this->end_controls_tab();
       $this->start_controls_tab(
         'style_hove_tabslidereighthkaveh',
         [
           'label' => esc_html__( 'هاور', 'kaveh-core' ),
         ]
       );
       $this->add_control(
         'textbuttoncolorhoverslidereighthkaveh',
         [
           'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-sixteen-item .btn:hover' => 'color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'iconcolorhoverslidereighthkaveh',
         [
           'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-sixteen-item .btn:hover i' => 'color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'buttoncolorhoverslidereighthkaveh',
         [
           'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-sixteen-item .btn:hover' => 'background-color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'buttonradiushoverslidereighthkaveh',
         [
           'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px' ],
           'selectors' => [
             '{{WRAPPER}} .landing-sixteen-item .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
           ],
         ]
       );
       $this->add_group_control(
         \Elementor\Group_Control_Border::get_type(),
         [
           'name' => 'borderhoverslidereighthkaveh',
           'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
           'selector' => '{{WRAPPER}} .landing-sixteen-item .btn:hover',
         ]
       );
       $this->add_control(
         'buttonbordershoverslidereighthkaveh',
         [
           'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px' ],
           'condition' => [
             'borderhoverslidereighthkaveh!' => '',
           ],
           'selectors' => [
             '{{WRAPPER}} .landing-sixteen-item .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
           ],
         ]
       );
       $this->end_controls_tab();
       $this->end_controls_tabs();
       $this->add_control(
         'hr1slidereighthkaveh',
         [
           'type' => \Elementor\Controls_Manager::DIVIDER,
         ]
       );
       $this->add_group_control(
         \Elementor\Group_Control_Box_Shadow::get_type(),
         [
           'name' => 'box_shadowslidereighthkavehh',
           'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
           'selector' => '{{WRAPPER}} .landing-sixteen-item .btn',
         ]
       );
       $this->add_control(
         'buttonpaddingslidereighthkaveh',
         [
           'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px' ],
           'selectors' => [
             '{{WRAPPER}} .landing-sixteen-item .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
           ],
         ]
       );
        $this->end_controls_section();
       
       
       
        $this->start_controls_section(
         'style3_slidereighthkaveh',
         [
           'label' => esc_html__( 'استایل تصاویر', 'kaveh-core' ),
           'tab' => \Elementor\Controls_Manager::TAB_STYLE, 
         ]
        );
       $this->add_control(
         'widthmainslidereighthkaveh',
         [
           'label' => esc_html__( 'سایز تصویر', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::SLIDER,
           'size_units' => [ 'px', '%' ],
           'range' => [
             'px' => [
               'min' => 0,
               'max' => 2000,
               'step' => 5,
             ],
             '%' => [
               'min' => 0,
               'max' => 100,
             ],
           ],
           'default' => [
             'unit' => 'px',
             'size' => 605,
           ],
           'selectors' => [
             '{{WRAPPER}} .landing-sixteen-item .image img' => 'width: {{SIZE}}{{UNIT}};',
           ],
         ]
       );
        $this->end_controls_section();
        $this->start_controls_section(
         'style4_slidereighthkaveh',
         [
           'label' => esc_html__( 'استایل عمومی', 'kaveh-core' ),
           'tab' => \Elementor\Controls_Manager::TAB_STYLE,
         ]
        );
        $this->add_control(
         'bgmaincolorslidereighthkaveh',
         [
           'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-sixteen::before' => 'background-color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'dotscolor2slidereighthkaveh',
         [
           'label' => esc_html__( 'رنگ پس زمینه نقطه ها', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-sixteen .swiper-pagination' => 'background-color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'dotsbordercolor2slidereighthkaveh',
         [
           'label' => esc_html__( 'رنگ حاشیه نقطه ها', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-sixteen .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'heightmainslidereighthkaveh',
         [
           'label' => esc_html__( 'ارتفاع اسلایدر', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::SLIDER,
           'size_units' => [ 'px', '%' ],
           'range' => [
             'px' => [
               'min' => 0,
               'max' => 2000,
               'step' => 5,
             ],
             '%' => [
               'min' => 0,
               'max' => 100,
             ],
           ],
           'selectors' => [
             '{{WRAPPER}} .landing-sixteen-item' => 'height: {{SIZE}}{{UNIT}};',
           ],
         ]
       );
        $this->end_controls_section();
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
<section class="landing-sixteen position-relative">
      <div class="container">
        <div class="swiper swiper-landing">
          <div class="swiper-wrapper">
              <?php
              if ( $settings['slidesslidereighthkaveh'] ) {
              foreach (  $settings['slidesslidereighthkaveh'] as $item ) {
              ?>
            <!-- Start Slide -->
            <div class="swiper-slide">
              <div class="landing-sixteen-item">
                <div class="row align-items-center">
                  <div class="col-lg-6">
                    <div class="image position-relative overflow-hidden">
                      <img src="<?php echo esc_url($item['backslidereighthkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['backslidereighthkaveh'] )); ?>" class="d-block" />
                    </div>
                  </div>
                  <div class="col-lg-6">
                    <div class="sup-title overflow-hidden">
                      <<?php echo  esc_html($item['tagheading1slidereighthkaveh']); ?> class="d-block subsli8t"><?php echo  esc_html($item['titleslidereighthkaveh']); ?></<?php echo  esc_html($item['tagheading1slidereighthkaveh']); ?>>
                    </div>
                    <div class="title overflow-hidden">
                      <<?php echo  esc_html($item['tagheading2slidereighthkaveh']); ?> class="mb-3 sli8t"><?php echo  esc_html($item['title2slidereighthkaveh']); ?></<?php echo  esc_html($item['tagheading2slidereighthkaveh']); ?>>
                    </div>
                    <a href="<?php echo  esc_url($item['linkbuttonslidereighthkaveh']); ?>" class="btn btn-primary">
                    <?php echo  esc_html($item['buttonslidereighthkaveh']); ?>
                      <i class="<?php echo  esc_attr($item['iconbuttslidereighthkaveh']['value']); ?>"></i>
                    </a>
                  </div>
                </div>
              </div>
            </div>
            <!-- End Slide -->
            <?php
                }
              }
              ?>
          </div>
          <div class="swiper-button-next d-none"></div>
          <div class="swiper-button-prev d-none"></div>
          <div class="swiper-pagination rounded-pill"></div>
        </div>
      </div>
    </section>
    <style>
      <?php echo '.elementor-element-' . $clsid . ''; ?> .landing-sixteen::before {
    -webkit-background-size: cover;
    -moz-background-size: cover;
    -o-background-size: cover;
    background-size: cover;
}
    </style>
    <?php if( \Elementor\Plugin::$instance->editor->is_edit_mode() ) { ?>

  <script>
      function init<?php echo $clsid; ?>() {
  // Swiper Landing
  new Swiper(".swiper-landing", {
    slidesPerView: 1,
    spaceBetween: 0,
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    pagination: {
      el: ".swiper-pagination",
      type: "bullets",
      clickable: true,
    },
    autoplay: {
      delay: 5000,
      disableOnInteraction: false,
      pauseOnMouseEnter: true,
    },
    effect: "fade",
    fadeEffect: {
      crossFade: true,
    },
    loop: true,
  });
}
      if (window.Swiper) {
    // Swiper library already loaded, initialize Swiper instance
    init<?php echo $clsid; ?>();
  } else {
    // Swiper library not yet loaded, wait for it to load
    window.addEventListener("load", function() {
      init<?php echo $clsid; ?>();
    });
  }
  </script>
    <?php } 
  }


}
