<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Categorygridsecondstkaveh extends Widget_Base{

  public function get_name(){
    return 'categorygridsecondstkaveh';
  }

  public function get_title(){
    return esc_html__( 'دسته بندی شبکه ای سبک دو', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentcategorygridsecondstkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'titlecategorygridsecondstkaveh',
        [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => 'دسته بندی ها',
  
        ]
      );
      $this->add_control(
        'tagheadingtcategorygridsecondstkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H2',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'imgcategorygridsecondstkaveh',
        [
          'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
        ]
      );
      $repeater->add_control(
      'title1categorygridsecondstkaveh',
      [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'دسته بندی',

      ]
    );
    $repeater->add_control(
      'tagheadingccategorygridsecondstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان دسته بندی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'linkcategorygridsecondstkaveh',
      [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );
    $this->add_control(
      'listcategorygridsecondstkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'title1categorygridsecondstkaveh' => esc_html__( 'عنوان', 'kaveh-core' ),
            'linkcategorygridsecondstkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    );  
       $this->end_controls_section();
       $this->start_controls_section(
        'content2categorygridsecondstkaveh',
        [
          'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'imgbgcategorygridsecondstkaveh',
        [
          'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'selectors' => [
            '{{WRAPPER}} .price-day::after' =>
                'background-image: url({{URL}})',
        ],
        ]
      );
      
      $this->end_controls_section();
      $this->start_controls_section(
        'content3categorygridsecondstkaveh',
        [
          'label' => esc_html__( 'تنظیمات نمایش', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'colcategorygridsecondstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => '4',
          'options' => [
            '1'  => esc_html__( '1', 'kaveh-core' ),
            '2' => esc_html__( '2', 'kaveh-core' ),
            '3' => esc_html__( '3', 'kaveh-core' ),
            '4' => esc_html__( '4', 'kaveh-core' ),
            '6' => esc_html__( '6', 'kaveh-core' ),
  
          ],
        ]
      );
      $this->end_controls_section();
       $this->start_controls_section(
        'style_categorygridsecondstkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolorcategorygridsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .price-day-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_categorygridsecondstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .price-day-title',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_categorygridsecondstkaveh',
        [
          'label' => esc_html__( 'استایل دسته بندی ها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'imgsizecategorygridsecondstkaveh',
        [
          'label' => esc_html__( 'سایز تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' =>64,
          ],
          'selectors' => [
            '{{WRAPPER}} .imgcatg2' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'bgcolorcategorygridsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .price-day-item' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'boxradiuscategorygridsecondstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده باکس بیرونی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .price-day-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'boxradius2categorygridsecondstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده باکس داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .price-day-item::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_categorygridsecondstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان دسته بندی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .price-day-item .tcatg2',
        ]
      );
      $this->add_control(
        'tccolorcategorygridsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .price-day-item .tcatg2' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'tcbgcolorcategorygridsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه عنوان دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .price-day-item .tcatg2' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'tbradius2categorygridsecondstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .price-day-item .tcatg2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'buttonpaddingcategorygridsecondstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .price-day-item .tcatg2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'tcmtcategorygridsecondstkaveh',
        [
          'label' => esc_html__( 'فاصله از بالا تصویر دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => -300,
              'max' => 300,
              'step' => 1,
            ],
            '%' => [
              'min' => -50,
              'max' => 50,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' =>15,
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_categorygridsecondstkaveh',
        [
          'label' => esc_html__( 'استایل المان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'tcbgcolorrowcategorygridsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .price-day' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->end_controls_section();
 
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>

<section class="price-day position-relative overflow-hidden">
      <div class="container">
        <<?php echo  esc_attr($settings['tagheadingtcategorygridsecondstkaveh']); ?> class="price-day-title text-center"><?php echo  esc_html($settings['titlecategorygridsecondstkaveh']); ?></<?php echo  esc_attr($settings['tagheadingtcategorygridsecondstkaveh']); ?>>
        <!-- Start Items -->
        <div class="row">
        <?php
              if ( $settings['listcategorygridsecondstkaveh'] ) {
              foreach (  $settings['listcategorygridsecondstkaveh'] as $item ) {
              ?>
          <!-- Start Item -->
          <div class="<?php if('1'===$settings['colcategorygridsecondstkaveh']){ ?>col-lg-12<?php }elseif('2'===$settings['colcategorygridsecondstkaveh']){?>col-lg-6<?php }elseif('3'===$settings['colcategorygridsecondstkaveh']){?>col-lg-4<?php }elseif('4'===$settings['colcategorygridsecondstkaveh']){?>col-lg-3<?php }elseif('6'===$settings['colcategorygridsecondstkaveh']){?>col-lg-2<?php } ?> col-md-4">
            <div class="price-day-item position-relative text-center">
              <a href="<?php echo  esc_url($item['linkcategorygridsecondstkaveh']); ?>" class="stretched-link"></a>
              <img src="<?php echo esc_url($item['imgcategorygridsecondstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['imgcategorygridsecondstkaveh'] )); ?>" class="d-block mx-auto imgcatg2" />
              <<?php echo  esc_attr($item['tagheadingccategorygridsecondstkaveh']); ?> class="tcatg2"><?php echo  esc_html($item['title1categorygridsecondstkaveh']); ?></<?php echo  esc_attr($item['tagheadingccategorygridsecondstkaveh']); ?>>
            </div>
          </div>
          <!-- Start Item -->
          <?php 
            }
              }
            ?>
        </div>
        <!-- End Items -->
      </div>
    </section>
    <style>
<?php echo '.elementor-element-' . $clsid . ''; ?> .price-day-item .tcatg2 {
    -webkit-transform: translateY(<?php echo  esc_html($settings['tcmtcategorygridsecondstkaveh']['size']); echo  esc_html($settings['tcmtcategorygridsecondstkaveh']['unit']); ?>);
    -moz-transform: translateY(<?php echo  esc_html($settings['tcmtcategorygridsecondstkaveh']['size']); echo  esc_html($settings['tcmtcategorygridsecondstkaveh']['unit']); ?>);
    -ms-transform: translateY(<?php echo  esc_html($settings['tcmtcategorygridsecondstkaveh']['size']); echo  esc_html($settings['tcmtcategorygridsecondstkaveh']['unit']); ?>);
    -o-transform: translateY(<?php echo  esc_html($settings['tcmtcategorygridsecondstkaveh']['size']); echo  esc_html($settings['tcmtcategorygridsecondstkaveh']['unit']); ?>);
    transform: translateY(<?php echo  esc_html($settings['tcmtcategorygridsecondstkaveh']['size']); echo  esc_html($settings['tcmtcategorygridsecondstkaveh']['unit']); ?>);
}
<?php echo '.elementor-element-' . $clsid . ''; ?> .price-day::after {
    background-color: #2b5d5e;
    -webkit-background-size: cover;
    -moz-background-size: cover;
    -o-background-size: cover;
    background-size: cover;
    object-fit: cover;
}
    </style>
    <?php
  }


}
