<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Categorycarouselthirdstkaveh extends Widget_Base{

  public function get_name(){
    return 'categorycarouselthirdstkaveh';
  }

  public function get_title(){
    return esc_html__( 'دسته بندی ها سبک سه', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentcategorycarouselthirdstkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
      'title1categorycarouselthirdstkaveh',
      [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'دسته بندی',

      ]
    );
    $repeater->add_control(
      'tagheadingcategorycarouselthirdstkaveh',
      [
        'label' => esc_html__( 'تگ زیر عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H6',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'styleboxcategorycarouselthirdstkaveh',
      [
        'label' => esc_html__( 'نمایش عکس یا متن؟', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'img',
        'options' => [
          'img'  => esc_html__( 'نمایش تصویر', 'kaveh-core' ),
          'title'  => esc_html__( 'نمایش متن', 'kaveh-core' ),
  
        ],
      ]
      ); 
    $repeater->add_control(
      'imgcategorycarouselthirdstkaveh',
      [
        'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'condition' => [
          'styleboxcategorycarouselthirdstkaveh' => 'img',
        ],
      ]
    );
    $repeater->add_control(
      'bigtitlecategorycarouselthirdstkaveh',
      [
        'label' => esc_html__( 'نوشته', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '+۷۹',
        'condition' => [
          'styleboxcategorycarouselthirdstkaveh' => 'title',
        ],
      ]
    );
    $repeater->add_control(
      'linkcategorycarouselthirdstkaveh',
      [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );
    $this->add_control(
      'listcategorycarouselthirdstkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'title1categorycarouselthirdstkaveh' => esc_html__( 'عنوان', 'kaveh-core' ),
            'linkcategorycarouselthirdstkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    ); 
    $this->add_control(
      'colcategorycarouselthirdstkaveh',
      [
        'label' => esc_html__( 'تعداد ستون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '2',
        'options' => [
          '1'  => esc_html__( '1', 'kaveh-core' ),
          '2' => esc_html__( '2', 'kaveh-core' ),
          '3' => esc_html__( '3', 'kaveh-core' ),
          '4' => esc_html__( '4', 'kaveh-core' ),
          '6' => esc_html__( '6', 'kaveh-core' ),

        ],
      ]
    );
       $this->end_controls_section();
       $this->start_controls_section(
        'style_categorycarouselthirdstkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor2categorycarouselthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}}  .top-category-four-item .cat3t' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_categorycarouselthirdstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}}  .top-category-four-item .cat3t',
        ]
      );
      $this->add_control(
        'pcolor3categorycarouselthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته بولد', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-four-item span' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'p3_categorycarouselthirdstkaveh',
          'label' => esc_html__( 'تایپوگرافی نوشته بولد ', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-category-four-item span',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_categorycarouselthirdstkaveh',
        [
          'label' => esc_html__( 'استایل تصاویر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      
        $this->add_control(
          'widthimgcategorycarouselthirdstkaveh',
          [
            'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 2000,
                'step' => 5,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ], 
            ],
            'default' => [
              'unit' => 'px',
              'size' => 100,
            ],
            'selectors' => [
              '{{WRAPPER}} .top-category-four img' => 'width: {{SIZE}}{{UNIT}} !important;',
            ],
          ]
        );
        $this->add_control(
          'maxwidthimgcategorycarouselthirdstkaveh',
          [
            'label' => esc_html__( 'بیشترین عرض تصویر', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 2000,
                'step' => 5,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ], 
            ],
            'default' => [
              'unit' => 'px',
              'size' => 120,
            ],
            'selectors' => [
              '{{WRAPPER}} .top-category-four-item .image' => 'max-width: {{SIZE}}{{UNIT}} !important;',
            ],
          ]
        );
        
        $this->add_control(
          'heigthimgcategorycarouselthirdstkaveh',
          [
            'label' => esc_html__( 'ارتفاع تصویر', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 2000,
                'step' => 5,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'selectors' => [
              '{{WRAPPER}} .top-category-four img' => 'height: {{SIZE}}{{UNIT}} !important;',
            ],
          ]
        );
        $this->add_control(
          'maxheigthimgcategorycarouselthirdstkaveh',
          [
            'label' => esc_html__( 'بیشترین ارتفاع تصویر', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 2000,
                'step' => 5,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'selectors' => [
              '{{WRAPPER}} .top-category-four-item .image' => 'max-height: {{SIZE}}{{UNIT}} !important;',
            ],
          ]
        );
      $this->end_controls_section();

      $this->start_controls_section(
        'style3_categorycarouselthirdstkaveh',
        [
          'label' => esc_html__( 'استایل باکس', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );

      $this->start_controls_tabs(
        'style_tabscategorycarouselthirdstkaveh'
      );

      $this->start_controls_tab(
        'style_normal_tabcategorycarouselthirdstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );

      $this->add_control(
        'buttoncolorcategorycarouselthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-four-item' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiuscategorycarouselthirdstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-category-four-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'bordercategorycarouselthirdstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-category-four-item',
        ]
      );
      $this->add_control(
        'buttonborderscategorycarouselthirdstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderbrandscarouselkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-category-four-item' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabcategorycarouselthirdstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'buttoncolorhovercategorycarouselthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-category-four-item:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushovercategorycarouselthirdstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-category-four-item:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhovercategorycarouselthirdstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-category-four-item:hover',
        ]
      );
      $this->add_control(
        'buttonbordershovercategorycarouselthirdstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderbrandscarouselkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-category-four-item:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hr1categorycarouselthirdstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowcategorycarouselthirdstkavehh',
          'label' => esc_html__( 'سایه باکس', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-category-four-item',
        ]
      );
      $this->add_control(
        'buttonpaddingcategorycarouselthirdstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-category-four-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();


        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>

<section class="top-category-four position-relative">
      <div class="container">
        <div class="row">
        <?php
              if ( $settings['listcategorycarouselthirdstkaveh'] ) {
              foreach (  $settings['listcategorycarouselthirdstkaveh'] as $item ) {
              ?>
          <div class="<?php if('1'===$settings['colcategorycarouselthirdstkaveh']){ ?>col-lg-12<?php }elseif('2'===$settings['colcategorycarouselthirdstkaveh']){?>col-lg-6<?php }elseif('3'===$settings['colcategorycarouselthirdstkaveh']){?>col-lg-4<?php }elseif('4'===$settings['colcategorycarouselthirdstkaveh']){?>col-lg-3<?php }elseif('6'===$settings['colcategorycarouselthirdstkaveh']){?>col-lg-2<?php } ?>">
            <div
              class="top-category-four-item position-relative d-flex align-items-center justify-content-center flex-column">
              <a href="<?php echo  esc_url($item['linkcategorycarouselthirdstkaveh']); ?>" class="stretched-link"></a>
              <?php if('img'===$item['styleboxcategorycarouselthirdstkaveh']){ ?>
              <div class="image mx-auto d-flex align-items-center justify-content-center">
                <img src="<?php echo esc_url($item['imgcategorycarouselthirdstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['imgcategorycarouselthirdstkaveh'] )); ?>" />
              </div>
              <?php }elseif('title'===$item['styleboxcategorycarouselthirdstkaveh']){ ?>
                <span> <?php echo  esc_html($item['bigtitlecategorycarouselthirdstkaveh']); ?></span>
                <?php } ?>
              <<?php echo  esc_attr($item['tagheadingcategorycarouselthirdstkaveh']); ?> class="text-center cat3t"> <?php echo  esc_html($item['title1categorycarouselthirdstkaveh']); ?> </<?php echo  esc_attr($item['tagheadingcategorycarouselthirdstkaveh']); ?>>
            </div>
          </div>
          <?php 
            }
              }
            ?>
        </div>
      </div>
    </section>
    <?php
  }


}
