<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Amazingofferthirdstkaveh extends Widget_Base{

  public function get_name(){
    return 'amazingofferthirdstkaveh';
  }

  public function get_title(){
    return esc_html__( 'پیشنهاد شگفت انگیز طرح سه', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentamazingofferthirdstkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );  
  
      $this->add_control(
          'titleamazingofferthirdstkaveh',
          [
              'label' => esc_html__( 'عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'پیشنهاد', 'kaveh-core' ),
      
          ]
      );
    $this->add_control(
      'subtitleamazingofferthirdstkaveh',
      [
          'label' => esc_html__( 'زیرعنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'شگفت انگیز', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'tagheadingamazingofferthirdstkaveh',
    [
      'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'H4',
      'options' => [
        'H1'  => esc_html__( 'H1', 'kaveh-core' ),
        'H2' => esc_html__( 'H2', 'kaveh-core' ),
        'H3' => esc_html__( 'H3', 'kaveh-core' ),
        'H4' => esc_html__( 'H4', 'kaveh-core' ),
        'H5' => esc_html__( 'H5', 'kaveh-core' ),
        'H6' => esc_html__( 'H6', 'kaveh-core' ),
        'p' => esc_html__( 'p', 'kaveh-core' ),
        'div' => esc_html__( 'div', 'kaveh-core' ),
      ],
    ]
  );
      $this->add_control(
        'moreamazingofferthirdstkaveh',
        [
          'label' => esc_html__( 'نمایش دکمه بیشتر؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'buttonamazingofferthirdstkaveh',
        [
            'label' => esc_html__( 'دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'مشاهده همه', 'kaveh-core' ),
            'condition' => [
              'moreamazingofferthirdstkaveh' => 'yes',
            ],
    
        ]
    );
    $this->add_control(
      'buttonlinkamazingofferthirdstkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
          'condition' => [
            'moreamazingofferthirdstkaveh' => 'yes',
          ],
  
      ]
  );
  $this->add_control(
    'styleboxamazingofferthirdstkaveh',
    [
      'label' => esc_html__( 'طرح بندی المان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'one',
      'options' => [
        'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
        'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),

      ],
    ]
    ); 
    $this->add_control(
      'imgback1amazingofferthirdstkaveh',
      [
        'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-three-wrapper::before' =>
              'background-image: url({{URL}})',
      ],
        'condition' => [
          'styleboxamazingofferthirdstkaveh' => 'one',
        ],
      ]
    );
    
    $this->add_control(
      'imgbackamazingofferthirdstkaveh',
      [
        'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-six-wrapper::after' =>
              'background-image: url({{URL}})',
      ],
        'condition' => [
          'styleboxamazingofferthirdstkaveh' => 'two',
        ],
      ]
    );
    
  $optionsst2 = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $optionsst2[$category->term_id] = $category->name;
}
$this->add_control(
    'catamazingofferthirdstkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $optionsst2,
    ]
);
$this->add_control(
  'productnumberamazingofferthirdstkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 20,
    'step' => 1,
    'default' => 5,
  ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'style_tamazingofferthirdstkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      ); 
      $this->add_control(
        'title1stamazingofferthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-three .title .amzof3t' => 'color: {{VALUE}}',
            '{{WRAPPER}} .amazing-offer-six-title .amzof31t' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title1_amazingofferthirdstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-three .title .amzof3t, {{WRAPPER}} .amazing-offer-six-title .amzof31t',
        ]
      ); 

      $this->end_controls_section();
      $this->start_controls_section(
        'style2_amazingofferthirdstkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_amazingofferthirdstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-three .title .btn,{{WRAPPER}} .amazing-offer-six-title .btn',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowamazingofferthirdstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-three .title .btn,.amazing-offer-six-title .btn',
        ]
      );
      $this->start_controls_tabs(
        'style_tabsamazingofferthirdstkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabamazingofferthirdstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncoloramazingofferthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-three .title .btn' => 'color: {{VALUE}}',
            '{{WRAPPER}} .amazing-offer-six-title .btn' => 'color: {{VALUE}}',

          ],
        ]
      ); 
      $this->add_control(
        'buttoncoloramazingofferthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-six-title .btn' => 'background-color: {{VALUE}}',
            '{{WRAPPER}} .amazing-offer-three .title .btn' => 'background-color: {{VALUE}}',

          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusamazingofferthirdstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-three .title .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} .amazing-offer-six-title .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderamazingofferthirdstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-three .title .btn,{{WRAPPER}} .amazing-offer-six-title .btn',
        ]
      );
      $this->add_control(
        'buttonbordersamazingofferthirdstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderamazingofferthirdstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-three .title .btn,.amazing-offer-six-title .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabamazingofferthirdstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoveramazingofferthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-three .title .btn' => 'color: {{VALUE}}',
            '{{WRAPPER}} .amazing-offer-six-title .btn:hover' => 'color: {{VALUE}}',

          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoveramazingofferthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-three .title .btn,.amazing-offer-six-title .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoveramazingofferthirdstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-three .title .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} .amazing-offer-six-title .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoveramazingofferthirdstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-three .title .btn,{{WRAPPER}} .amazing-offer-six-title .btn:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoveramazingofferthirdstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoveramazingofferthirdstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-three .title .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
            '{{WRAPPER}} .amazing-offer-six-title .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',

          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowamazingofferthirdstkavehh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-three .title .btn,{{WRAPPER}} .amazing-offer-six-title .btn',
        ]
      );
      $this->add_control(
        'hr1amazingofferthirdstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingamazingofferthirdstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-three .title .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} .amazing-offer-six-title .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

          ],
        ]
      );
      $this->end_controls_section(); 
      $this->start_controls_section(
        'style3_tamazingofferthirdstkaveh',
        [
          'label' => esc_html__( 'استایل باکس', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      ); 
      $this->add_control(
        'imagewidthamazingofferthirdstkavehh',
        [
          'label' => esc_html__( 'عرض تصویر پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxamazingofferthirdstkaveh' => 'one',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-three-wrapper::before' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'imageheightamazingofferthirdstkavehh',
        [
          'label' => esc_html__( 'ارتفاع تصویر پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxamazingofferthirdstkaveh' => 'one',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-three-wrapper::before' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );

      $this->add_control(
        'imagewidth2amazingofferthirdstkavehh',
        [
          'label' => esc_html__( 'عرض تصویر پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxamazingofferthirdstkaveh' => 'two',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-six-wrapper::after' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'imageheight2amazingofferthirdstkavehh',
        [
          'label' => esc_html__( 'ارتفاع تصویر پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxamazingofferthirdstkaveh' => 'two',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-six-wrapper::after' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'imagetop1amazingoffersecondstkaveh',
        [
          'label' => esc_html__( 'فاصله از بالا', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxamazingofferthirdstkaveh' => 'one',
          ],
          'range' => [
            'px' => [
              'min' => -2000,
              'max' => 2000,
              'step' => 5,
            ],
            '%' => [
              'min' => -100,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-three-wrapper::before' => 'top: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'imagetop2amazingoffersecondstkaveh',
        [
          'label' => esc_html__( 'فاصله از بالا', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxamazingofferthirdstkaveh' => 'two',
          ],
          'range' => [
            'px' => [
              'min' => -2000,
              'max' => 2000,
              'step' => 5,
            ],
            '%' => [
              'min' => -100,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-six-wrapper::after' => 'top: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'bgcoloramazingofferthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-three-wrapper::after' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'bgcolortimeramazingofferthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه تایمر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-three-timer li span' => 'background-color: {{VALUE}}',
            '{{WRAPPER}} .amazing-offer-six-timear li span' => 'background-color: {{VALUE}}',

          ],
        ]
      ); 
      $this->add_control(
        'boxradiusamazingofferthirdstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-three-wrapper::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} .amazing-offer-six .container::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

          ],
        ]
      );
      $this->end_controls_section(); 

        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>

    <?php if('one'===$settings['styleboxamazingofferthirdstkaveh']){ ?>
    <section class="amazing-offer-three">
      <div class="container">
        <div class="amazing-offer-three-wrapper position-relative d-flex flex-column flex-lg-row">
          <div
            class="title text-white d-flex d-lg-block align-items-sm-center justify-content-sm-between flex-column flex-sm-row">
            <<?php echo  esc_attr($settings['tagheadingamazingofferthirdstkaveh']); ?> class="amzof3t">
            <?php echo  esc_html($settings['titleamazingofferthirdstkaveh']); ?>
              <span class="fw-light d-block"> <?php echo  esc_html($settings['subtitleamazingofferthirdstkaveh']); ?> </span>
            </<?php echo  esc_attr($settings['tagheadingamazingofferthirdstkaveh']); ?>>
            <?php if("yes"===$settings['moreamazingofferthirdstkaveh']){?>
            <a href="<?php echo  esc_url($settings['buttonlinkamazingofferthirdstkaveh']); ?>" class="btn btn-outline-light"> <?php echo  esc_html($settings['buttonamazingofferthirdstkaveh']); ?> </a>
            <?php } ?> 
          </div>
          <div class="swiper-button-next swiper-button-next1"></div>
          <div class="swiper-button-prev swiper-button-prev1"></div>
          <div class="swiper swiper-amazing-offer-three position-relative">
            <div class="swiper-wrapper">
            <?php 
                  
                  // WP_Query args
                  $q_pce_query_args = array(
                    'post_type' => array('product'),
                    'posts_per_page' => $settings['productnumberamazingofferthirdstkaveh'],
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'tax_query' => array(
                      array(
                        "taxonomy" => "product_cat",
                        "field"    => "tag_ID",
                        "terms"    => $settings['catamazingofferthirdstkaveh'],
                      ),
                    ),
                    'meta_query' => array(
                array(
                    'key' => '_stock_status',
                    'value' => 'outofstock',
                    'compare' => 'NOT IN',
                ),
               ),
                    'post__in' => array_merge(array(0), wc_get_product_ids_on_sale())
                  
                  );
                  
                  // The Query
                  $pce_query = new \WP_Query($q_pce_query_args);
                  
                  // The Loop
                  if ( $pce_query->have_posts() ) {
                    while ( $pce_query->have_posts() ) {
                      $pce_query->the_post(); ?>
              <div class="swiper-slide">
                <div class="amazing-offer-three-item">
                  <a href="<?php the_permalink(); ?>"></a>
                  <?php
                    global $product;
                    $product = wc_get_product();
                    $product_id = $product->get_id();
                    $product_type = $product->get_type();
                    $sale_price_dates_from = $sale_price_dates_to = '';
                    $sale_price= $product->get_sale_price();
                    $normal_price= $product->get_regular_price();
                    $pr_id = get_the_ID();
                    $stocka=$product->get_stock_status(); 

                    if ($date_from = get_post_meta($product_id, '_sale_price_dates_from', true)){
                        $sale_price_dates_from = date('Y-m-d 00:00:00', $date_from);
                    }
                    if ($date_to = get_post_meta($product_id, '_sale_price_dates_to', true)){
                        $sale_price_dates_to = date('Y-m-d 23:59:59', $date_to);
                    }
                    $deal_start_date = $sale_price_dates_from;
                    $deal_start_time = strtotime($deal_start_date);
                    $deal_end_date = $sale_price_dates_to;
                    $deal_end_time = strtotime($deal_end_date, current_time('timestamp'));
                    //$current_date = current_time( 'Y-m-d H:i:s', true );
                    $current_time = strtotime('NOW', current_time('timestamp'));
                    $time_diff = ($deal_end_time - $current_time); ?>
                 <?php if("instock"==$stocka){ ?>
                  <?php if (!empty($deal_end_date)){ ?>
                  <ul class="amazing-offer-three-timer d-flex align-items-center" data-time="<?php  echo $deal_end_date; ?>">
                    <li>
                      <span class="second"> 00 </span>
                      ثانیه
                    </li>
                    <li>
                      <span class="minute"> 00 </span>
                      دقیقه
                    </li>
                    <li>
                      <span class="hour"> 00 </span>
                      ساعت
                    </li>
                    <li>
                      <span class="day"> 00 </span>
                      روز
                    </li>
                  </ul>
                  <?php }else{} }?>
                  <div class="image">
                  <img src="<?php the_post_thumbnail_url(); ?>" alt="amazing-offer-three" />
                </div>
                <div class="detail">
                  <h2> <?php the_title(); ?> </h2>
                  <ul>
                  <?php
                    $product_attributes = array();

                  // Display weight and dimensions before attribute list.
                  $display_dimensions = apply_filters( 'wc_product_enable_dimensions_display', $product->has_weight() || $product->has_dimensions() );

                  if ( $display_dimensions && $product->has_weight() ) {
                    $product_attributes['weight'] = array(
                      'label' => __( 'Weight', 'woocommerce' ),
                      'value' => wc_format_weight( $product->get_weight() ),
                    );
                  }

                  if ( $display_dimensions && $product->has_dimensions() ) {
                    $product_attributes['dimensions'] = array(
                      'label' => __( 'Dimensions', 'woocommerce' ),
                      'value' => wc_format_dimensions( $product->get_dimensions( false ) ),
                    );
                  }

                  // Add product attributes to list.
                  $attributes = array_filter( $product->get_attributes(), 'wc_attributes_array_filter_visible' );

                  foreach ( $attributes as $attribute ) {
                    $values = array();

                    if ( $attribute->is_taxonomy() ) {
                      $attribute_taxonomy = $attribute->get_taxonomy_object();
                      $attribute_values   = wc_get_product_terms( $product->get_id(), $attribute->get_name(), array( 'fields' => 'all' ) );

                      foreach ( $attribute_values as $attribute_value ) {
                        $value_name = esc_html( $attribute_value->name );

                        if ( $attribute_taxonomy->attribute_public ) {
                          $values[] = '<a href="' . esc_url( get_term_link( $attribute_value->term_id, $attribute->get_name() ) ) . '" rel="tag">' . $value_name . '</a>';
                        } else {
                          $values[] = $value_name;
                        }
                      }
                    } else {
                      $values = $attribute->get_options();

                      foreach ( $values as &$value ) {
                        $value = make_clickable( esc_html( $value ) );
                      }
                    }

                    $product_attributes[ 'attribute_' . sanitize_title_with_dashes( $attribute->get_name() ) ] = array(
                      'label' => wc_attribute_label( $attribute->get_name() ),
                      'value' => apply_filters( 'woocommerce_attribute', wpautop( wptexturize( implode( ', ', $values ) ) ), $attribute, $values ),
                    );
                  }

                  ?>
                <?php $countme=0; ?>	
                <?php foreach ( $product_attributes as $product_attribute_key => $product_attribute ) : ?>
                <?php if($countme < 4): ?>	
                <li> <?php echo $product_attribute['label']; ?> : <?php echo str_replace( 'p>' , 'span>' , $product_attribute['value'] ); ?> </li>
                <?php $countme += 1; ?>
                <?php endif; ?>
                <?php endforeach; ?>
                  </ul>
                  <div class="d-flex align-items-center flex-wrap">
                  <div class="offer d-flex align-items-center position-relative">
                        <?php if(!empty($normal_price) ) { ?>
                    <?php if("instock"==$stocka){ ?>
                    <?php if ( !$product->is_type( 'variable' ) ) { ?>
                      <del class="rounded-pill"> <?php echo $normal_price; ?> </del>
                      <?php }
                      }
                     } ?>
                      <?php
                      if(!empty($normal_price) ) { 
                      if("instock"==$stocka){ 
                      if(!empty($sale_price) ) { ?>
                      <span class="rounded-pill"> 
                      % <?php
                      $percentage = round( ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100 );
                      echo $percentage;
                      ?> 
                      </span>
                      <?php } 
                      }
                     }?> 
                    </div>
                    <?php if(!empty($sale_price) ) { ?>
                    <?php if("instock"==$stocka){ ?>
                    <?php if ( !$product->is_type( 'variable' ) ) { ?>
                    <div class="price d-flex align-items-center">
                    <?php echo $sale_price; ?>
                      <span class="fw-light"> <?php echo get_woocommerce_currency_symbol(); ?></span>
                    </div>
                    <?php }else{ 
                      $price_v = $product->get_price_html(); 
                      echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                    } 
                     ?>
                    <?php }
                   } ?>
                  </div>
                </div>
                </div>
              </div>
              <?php   }
            } else {
              // There are no posts
            }

            // Reset Original Post Data
            wp_reset_postdata();
            

            
            ?>
            </div>
          </div>
        </div>
      </div>
    </section>
    <?php }elseif('two'===$settings['styleboxamazingofferthirdstkaveh']){ ?>
      <section class="amazing-offer-six">
      <div class="container d-flex position-relative flex-column flex-lg-row">
        <!-- Start Title -->
        <div class="amazing-offer-six-title text-nowrap">
          <<?php echo  esc_attr($settings['tagheadingamazingofferthirdstkaveh']); ?> class="amzof31t">
            <span class="fw-light d-block"> <?php echo  esc_html($settings['titleamazingofferthirdstkaveh']); ?> </span>
            <?php echo  esc_html($settings['subtitleamazingofferthirdstkaveh']); ?> 
          </<?php echo  esc_attr($settings['tagheadingamazingofferthirdstkaveh']); ?>>
          <?php if("yes"===$settings['moreamazingofferthirdstkaveh']){?>
          <a href="<?php echo  esc_url($settings['buttonlinkamazingofferthirdstkaveh']); ?>" class="btn btn-outline-dark">
          <?php echo  esc_html($settings['buttonamazingofferthirdstkaveh']); ?>
          </a>
          <?php } ?>
        </div>
        <!-- End Title -->
        <div class="amazing-offer-six-wrapper position-relative">
          <!-- Start Products -->
          <div class="swiper swiper-amazing-offer-two">
            <div class="swiper-wrapper">
            <?php 
                  
                  // WP_Query args
                  $q_pce_query_args = array(
                    'post_type' => array('product'),
                    'posts_per_page' => $settings['productnumberamazingofferthirdstkaveh'],
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'tax_query' => array(
                      array(
                        "taxonomy" => "product_cat",
                        "field"    => "tag_ID",
                        "terms"    => $settings['catamazingofferthirdstkaveh'],
                      ),
                    ),
                    'meta_query' => array(
                array(
                    'key' => '_stock_status',
                    'value' => 'outofstock',
                    'compare' => 'NOT IN',
                ),
               ),
                    'post__in' => array_merge(array(0), wc_get_product_ids_on_sale())
                  
                  );
                  
                  // The Query
                  $pce_query = new \WP_Query($q_pce_query_args);
                  
                  // The Loop
                  if ( $pce_query->have_posts() ) {
                    while ( $pce_query->have_posts() ) {
                      $pce_query->the_post(); ?>
              <div class="swiper-slide">
                <div class="amazing-offer-six-item d-flex align-items-center position-relative flex-column flex-md-row">
                  <a href="<?php the_permalink(); ?>" class="stretched-link"></a>
                      <!-- Start Timear -->
                        <?php
                        global $product;
                        $product = wc_get_product();
                        $product_id = $product->get_id();
                        $product_type = $product->get_type();
                        $sale_price_dates_from = $sale_price_dates_to = '';
                        $sale_price= $product->get_sale_price();
                        $normal_price= $product->get_regular_price();
                        $pr_id = get_the_ID();
                        $stocka=$product->get_stock_status(); 

                        if ($date_from = get_post_meta($product_id, '_sale_price_dates_from', true)){
                            $sale_price_dates_from = date('Y-m-d 00:00:00', $date_from);
                        }
                        if ($date_to = get_post_meta($product_id, '_sale_price_dates_to', true)){
                            $sale_price_dates_to = date('Y-m-d 23:59:59', $date_to);
                        }
                        $deal_start_date = $sale_price_dates_from;
                        $deal_start_time = strtotime($deal_start_date);
                        $deal_end_date = $sale_price_dates_to;
                        $deal_end_time = strtotime($deal_end_date, current_time('timestamp'));
                        //$current_date = current_time( 'Y-m-d H:i:s', true );
                        $current_time = strtotime('NOW', current_time('timestamp'));
                        $time_diff = ($deal_end_time - $current_time); ?>
                       <?php if("instock"==$stocka){ ?>
                      <?php if (!empty($deal_end_date)){ ?>
                      <ul class="amazing-offer-six-timear position-absolute top-0 start-0" data-time="<?php  echo $deal_end_date; ?>">
                          <li class="text-center">
                            <span class="day d-block rounded-circle text-center text-white"> 00 </span>
                            روز
                          </li>
                          <li class="text-center">
                            <span class="hour d-block rounded-circle text-center text-white"> 00 </span>
                            ساعت
                          </li>
                          <li class="text-center">
                            <span class="minute d-block rounded-circle text-center text-white"> 00 </span>
                            دقیقه
                          </li>
                          <li class="text-center">
                            <span class="second d-block rounded-circle text-center text-white"> 00 </span>
                            ثانیه
                          </li>
                      </ul>
                     <!-- End Timear -->
                     <?php }else{} } ?>
                  <div class="image">
                    <img src="<?php the_post_thumbnail_url(); ?>" alt="product" />
                  </div>
                  <div class="detail">
                    <h2><?php the_title(); ?></h2>
                    <ul class="info">
                    <?php
                    $product_attributes = array();

                  // Display weight and dimensions before attribute list.
                  $display_dimensions = apply_filters( 'wc_product_enable_dimensions_display', $product->has_weight() || $product->has_dimensions() );

                  if ( $display_dimensions && $product->has_weight() ) {
                    $product_attributes['weight'] = array(
                      'label' => __( 'Weight', 'woocommerce' ),
                      'value' => wc_format_weight( $product->get_weight() ),
                    );
                  }

                  if ( $display_dimensions && $product->has_dimensions() ) {
                    $product_attributes['dimensions'] = array(
                      'label' => __( 'Dimensions', 'woocommerce' ),
                      'value' => wc_format_dimensions( $product->get_dimensions( false ) ),
                    );
                  }

                  // Add product attributes to list.
                  $attributes = array_filter( $product->get_attributes(), 'wc_attributes_array_filter_visible' );

                  foreach ( $attributes as $attribute ) {
                    $values = array();

                    if ( $attribute->is_taxonomy() ) {
                      $attribute_taxonomy = $attribute->get_taxonomy_object();
                      $attribute_values   = wc_get_product_terms( $product->get_id(), $attribute->get_name(), array( 'fields' => 'all' ) );

                      foreach ( $attribute_values as $attribute_value ) {
                        $value_name = esc_html( $attribute_value->name );

                        if ( $attribute_taxonomy->attribute_public ) {
                          $values[] = '<a href="' . esc_url( get_term_link( $attribute_value->term_id, $attribute->get_name() ) ) . '" rel="tag">' . $value_name . '</a>';
                        } else {
                          $values[] = $value_name;
                        }
                      }
                    } else {
                      $values = $attribute->get_options();

                      foreach ( $values as &$value ) {
                        $value = make_clickable( esc_html( $value ) );
                      }
                    }

                    $product_attributes[ 'attribute_' . sanitize_title_with_dashes( $attribute->get_name() ) ] = array(
                      'label' => wc_attribute_label( $attribute->get_name() ),
                      'value' => apply_filters( 'woocommerce_attribute', wpautop( wptexturize( implode( ', ', $values ) ) ), $attribute, $values ),
                    );
                  }

                  ?>
                <?php $countme=0; ?>	
                <?php foreach ( $product_attributes as $product_attribute_key => $product_attribute ) : ?>
                <?php if($countme < 4): ?>	
                <li> <?php echo $product_attribute['label']; ?> : <?php echo str_replace( 'p>' , 'span>' , $product_attribute['value'] ); ?> </li>
                <?php $countme += 1; ?>
                <?php endif; ?>
                <?php endforeach; ?>
                    </ul>
                    <div class="d-flex align-items-center">
                    <div class="offer d-flex align-items-center position-relative">
                        <?php if(!empty($normal_price) ) { ?>
                    <?php if("instock"==$stocka){ ?>
                    <?php if ( !$product->is_type( 'variable' ) ) { ?>
                      <del class="rounded-pill"> <?php echo $normal_price; ?> </del>
                      <?php }
                      }
                     } ?>
                      <?php
                      if(!empty($normal_price) ) { 
                      if("instock"==$stocka){ 
                      if(!empty($sale_price) ) { ?>
                      <span class="rounded-pill"> 
                      % <?php
                      $percentage = round( ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100 );
                      echo $percentage;
                      ?> 
                      </span>
                      <?php } 
                      }
                     }?> 
                    </div>
                    <?php if(!empty($sale_price) ) { ?>
                    <?php if("instock"==$stocka){ ?>
                    <?php if ( !$product->is_type( 'variable' ) ) { ?>
                    <div class="price d-flex align-items-center">
                    <?php echo $sale_price; ?>
                      <span class="fw-light"> <?php echo get_woocommerce_currency_symbol(); ?></span>
                    </div>
                    <?php }else{ 
                      $price_v = $product->get_price_html(); 
                      echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                    } 
                     ?>
                    <?php }
                   } ?>
                    </div>
                  </div>
                </div>
              </div>
              <?php   }
            } else {
              // There are no posts
            }

            // Reset Original Post Data
            wp_reset_postdata();
            

            
            ?>
            </div>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
          </div>
          <!-- End Products -->
        </div>
      </div>
    </section>
    <?php } ?>
<style>
  <?php echo '.elementor-element-' . $clsid . ''; ?> .amazing-offer-six-wrapper::after {
    background-size: cover !important;
}
<?php echo '.elementor-element-' . $clsid . ''; ?> .amazing-offer-six .container::after {
    content: "";
    top: 0;
    left: 0;
    width: 100%;
    height: 68%;
    background-image: -webkit-linear-gradient(top, <?php echo esc_html($settings['bgcoloramazingofferthirdstkaveh']); ?>, #fff0);
    background-image: -moz-linear-gradient(top, <?php echo esc_html($settings['bgcoloramazingofferthirdstkaveh']); ?>, #fff0);
    background-image: -o-linear-gradient(top, <?php echo esc_html($settings['bgcoloramazingofferthirdstkaveh']); ?>, #fff0);
    background-image: linear-gradient(to bottom, <?php echo esc_html($settings['bgcoloramazingofferthirdstkaveh']); ?>, #fff0);
    z-index: -8;
}
</style>
      <script>
         function init<?php echo $clsid; ?>() {
  // Swiper Slider Home
  new Swiper(".swiper-amazing-offer-three", {
    slidesPerView: 1,
    spaceBetween: 0,
    autoplay: {
      delay: 5000,
      disableOnInteraction: false,
      pauseOnMouseEnter: true,
    },
    effect: "fade",
    fadeEffect: {
      crossFade: true,
    },
    loop: true,
    navigation: {
      nextEl: ".swiper-button-next1",
      prevEl: ".swiper-button-prev1",
    },
  });
  // Swiper Amazing Offer Two
  new Swiper(".swiper-amazing-offer-two", {
    loop: true,
    slidesPerView: 1,
    spaceBetween: 0,
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    autoplay: {
      delay: 5000,
      disableOnInteraction: false,
      pauseOnMouseEnter: true,
    },
    effect: "fade",
    fadeEffect: {
      crossFade: true,
    },
  });
}
if (window.Swiper) {
    // Swiper library already loaded, initialize Swiper instance
    init<?php echo $clsid; ?>();
  } else {
    // Swiper library not yet loaded, wait for it to load
    window.addEventListener("load", function() {
      init<?php echo $clsid; ?>();
    });
  }
      </script>
    <?php
  }


}
