<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Amazingoffersevenstkaveh extends Widget_Base{

  public function get_name(){
    return 'amazingoffersevenstkaveh';
  }

  public function get_title(){
    return esc_html__( 'پیشنهاد شگفت انگیز طرح هفت', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }
 
  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'عناوین', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );

      $this->add_control(
          'titleamazingoffersevenstkaveh',
          [
              'label' => esc_html__( 'عنوان', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'پیشنهاد', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'title2amazingoffersevenstkaveh',
        [
            'label' => esc_html__( 'عنوان دوم', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'شگفت انگیز', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tagheadingamazingoffersevenstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
      $this->add_control(
        'moreamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'نمایش دکمه بیشتر؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'buttonamazingoffersevenstkaveh',
        [
            'label' => esc_html__( 'دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'مشاهده همه', 'kaveh-core' ),
            'condition' => [
              'moreamazingoffersevenstkaveh' => 'yes',
            ],
    
        ]
    );
    $this->add_control(
      'buttonlinkamazingoffersevenstkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
          'condition' => [
            'moreamazingoffersevenstkaveh' => 'yes',
          ],
  
      ]
  );
  $this->end_controls_section();
  $this->start_controls_section(
    'content2amazingoffersevenstkaveh',
    [
      'label' => esc_html__( 'تنظیمات نمایش', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
  );
  $optionsst2 = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $optionsst2[$category->term_id] = $category->name;
}
$this->add_control(
    'catamazingoffersevenstkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $optionsst2,
    ]
);
$this->add_control(
  'productnumberamazingoffersevenstkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 20,
    'step' => 1,
    'default' => 5,
  ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'content3amazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'تصویر', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'rightbalamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'پس زمینه بال راست', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-wrapper::before' =>
                'background-image: url({{URL}})',
        ],
        ]
      );
      
      $this->end_controls_section();
      $this->start_controls_section(
        'content4amazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'دکمه سبد خرید', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'carttitleamazingoffersevenstkaveh',
        [
            'label' => esc_html__( 'متن دکمه سبد خرید', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'افزودن به سبد خرید', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'iconiamazingoffersevenstkaveh',
      [
        'label' => esc_html__( 'آیکون دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon icon-cart-3',
        ],
      ]
    ); 
      $this->end_controls_section();
      $this->start_controls_section(
        'style_amazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor2amazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-wrapper .right .title b' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2_amazingoffersevenstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-fiveteen-wrapper .right .title b',
        ]
      );
      
      $this->add_control(
        'textcolor3amazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-wrapper .right .title' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title21_amazingoffersevenstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان دوم', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-fiveteen-wrapper .right .title',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_amazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'moreamazingoffersevenstkaveh' => 'yes',
          ],
        ]
      );
      
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_amazingoffersevenstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-fiveteen-wrapper .right .btn',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowamazingoffersevenstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-fiveteen-wrapper .right .btn',
        ]
      );
      $this->start_controls_tabs(
        'style_tabsamazingoffersevenstkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncoloramazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-wrapper .right .btn' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncoloramazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-wrapper .right .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-wrapper .right .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderamazingoffersevenstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-fiveteen-wrapper .right .btn',
        ]
      );
      $this->add_control(
        'buttonbordersamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderamazingoffersevenstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-wrapper .right .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoveramazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-wrapper .right .btn:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoveramazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-wrapper .right .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoveramazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-wrapper .right .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoveramazingoffersevenstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-fiveteen-wrapper .right .btn:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoveramazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoveramazingoffersevenstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-wrapper .right .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowamazingoffersevenstkavehh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-fiveteen-wrapper .right .btn',
        ]
      );
      $this->add_control(
        'hr1amazingoffersevenstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-wrapper .right .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_amazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'استایل بال ها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'rightballbgclamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه بال راست', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-wrapper::before' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'leftballbgclamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه بال چپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-wrapper::after' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->end_controls_section();
      $this->start_controls_section(
        'style5_amazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'استایل فلش ها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'arrowclazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'رنگ فلش ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
        ]
      ); 
      $this->add_control(
        'arrowbrclazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'رنگ حاشیه فلش ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
        ]
      ); 

      $this->end_controls_section();
      $this->start_controls_section(
        'style4_amazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'استایل محصولات', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'timertextclamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'رنگ عدد تایمر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-item .timear span' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'timerbgclamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه تایمر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-item .timear span' => 'background-color: {{VALUE}}',
          ],
        ]
      );  
      $this->add_control(
        'timertitleclamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته تایمر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-item .amaze8tiu li' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'hramazingoffersevenstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_cartamazingoffersevenstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-fiveteen-item .detail .content .btn',
        ]
      ); 
      $this->add_control(
        'iconsizeazingoffereightstkaveh',
        [
          'label' => esc_html__( 'سایز آیکون دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' =>13,
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-item .detail .content .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowcartamazingoffersevenstkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-fiveteen-item .detail .content .btn',
        ]
      );
      $this->start_controls_tabs(
        'style_tabscartamazingoffersevenstkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabcartamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorcartamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-item .detail .content .btn' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'iconclbuttoncolorcartam',
        [
          'label' => esc_html__( 'رنگ آیکون دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-item .detail .content .btn i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorcartamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-item .detail .content .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiuscartamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه افزودن به سبد خرید بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-item .detail .content .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'bordercartamazingoffersevenstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-fiveteen-item .detail .content .btn',
        ]
      );
      $this->add_control(
        'buttonborderscartamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'bordercartamazingoffersevenstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-item .detail .content .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabcartamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhovercartamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-item .detail .content .btn:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'iconclhoverbuttoncolorcartamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-item .detail .content .btn i:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhovercartamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-item .detail .content .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushovercartamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه افزودن به سبد خرید بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-item .detail .content .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhovercartamazingoffersevenstkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-fiveteen-item .detail .content .btn:hover',
        ]
      );
      $this->add_control(
        'buttonbordershovercartamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhovercartamazingoffersevenstkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-item .detail .content .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowcartamazingoffersevenstkaveh',
          'label' => esc_html__( 'سایه دکمه افزودن به سبد خرید', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-fiveteen-item .detail .content .btn',
        ]
      );
      $this->add_control(
        'hr1cartamazingoffersevenstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingcartamazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen-item .detail .content .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style6_amazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'استایل کاروسل', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'bordercarousel5amazingoffersevenstkaveh',
        [
          'label' => esc_html__( 'رنگ حاضیه و نوشته کاروسل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-fiveteen .swiper-pagination-bullet-active span' => 'color: {{VALUE}}',
            '{{WRAPPER}} .amazing-offer-fiveteen .swiper-pagination-bullet-active' => 'border-color: {{VALUE}}',

          ],
        ]
      ); 
      $this->end_controls_section();

        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
<section class="amazing-offer-fiveteen">
      <div class="container">
        <div class="amazing-offer-fiveteen-wrapper position-relative d-flex flex-column flex-lg-row">
          <div class="right d-flex d-lg-block align-items-center justify-content-between">
            <<?php echo  esc_attr($settings['tagheadingamazingoffersevenstkaveh']); ?> class="title text-nowrap">
              <b class="d-block"> <?php echo  esc_html($settings['titleamazingoffersevenstkaveh']); ?> </b>
              <?php echo  esc_html($settings['title2amazingoffersevenstkaveh']); ?>
            </<?php echo  esc_attr($settings['tagheadingamazingoffersevenstkaveh']); ?>>
            <?php if("yes"===$settings['moreamazingoffersevenstkaveh']){?>
            <a href="<?php echo  esc_url($settings['buttonlinkamazingoffersevenstkaveh']); ?>" class="btn btn-outline-light text-nowrap"> <?php echo  esc_html($settings['buttonamazingoffersevenstkaveh']); ?></a>
            <?php } ?>
          </div>
          <div class="left">
            <div class="swiper swiper-amazing-offer-fiveteen">
              <div class="swiper-wrapper">
              <?php 
                  
                  // WP_Query args
                  $q_pce_query_args = array(
                    'post_type' => array('product'),
                    'posts_per_page' => $settings['productnumberamazingoffersevenstkaveh'],
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'tax_query' => array(
                      array(
                        "taxonomy" => "product_cat",
                        "field"    => "tag_ID",
                        "terms"    => $settings['catamazingoffersevenstkaveh'],
                      ),
                    ),
                    'meta_query' => array(
                array(
                    'key' => '_stock_status',
                    'value' => 'outofstock',
                    'compare' => 'NOT IN',
                ),
               ),
                    'post__in' => array_merge(array(0), wc_get_product_ids_on_sale())
                  
                  );
                  
                  // The Query
                  $pce_query = new \WP_Query($q_pce_query_args);
                  
                  // The Loop
                  if ( $pce_query->have_posts() ) {
                    while ( $pce_query->have_posts() ) {
                      $pce_query->the_post(); ?>
                <!-- Start Slide -->
                <div class="swiper-slide">
                  <div
                    class="amazing-offer-fiveteen-item d-flex align-items-center position-relative flex-column flex-lg-row">
                    <a href="<?php the_permalink(); ?>" class="stretched-link"></a>
                    <?php
                        global $product;
                        $product = wc_get_product();
                        $product_id = $product->get_id();
                        $product_type = $product->get_type();
                        $sale_price_dates_from = $sale_price_dates_to = '';
                        $sale_price= $product->get_sale_price();
                        $normal_price= $product->get_regular_price();
                        $pr_id = get_the_ID();
                        $stocka=$product->get_stock_status();

                        if ($date_from = get_post_meta($product_id, '_sale_price_dates_from', true)){
                            $sale_price_dates_from = date('Y-m-d 00:00:00', $date_from);
                        }
                        if ($date_to = get_post_meta($product_id, '_sale_price_dates_to', true)){
                            $sale_price_dates_to = date('Y-m-d 23:59:59', $date_to);
                        }
                        $deal_start_date = $sale_price_dates_from;
                        $deal_start_time = strtotime($deal_start_date);
                        $deal_end_date = $sale_price_dates_to;
                        $deal_end_time = strtotime($deal_end_date, current_time('timestamp'));
                        //$current_date = current_time( 'Y-m-d H:i:s', true );
                        $current_time = strtotime('NOW', current_time('timestamp'));
                        $time_diff = ($deal_end_time - $current_time); ?>
                      <?php if (!empty($deal_end_date)){ ?>
                    <ul class="timear position-absolute start-0 bottom-0 d-flex align-items-center mb-0 amaze8tiu"
                      data-time="<?php  echo $deal_end_date; ?>">
                      <li class="fw-light text-center">
                        <span
                          class="second amaze8ti d-flex align-items-center justify-content-center rounded-circle mb-1">
                          00 </span>
                        ثانیه
                      </li>
                      <li class="fw-light text-center">
                        <span
                          class="minute amaze8ti d-flex align-items-center justify-content-center rounded-circle mb-1">
                          00 </span>
                        دقیقه
                      </li>
                      <li class="fw-light text-center">
                        <span
                          class="hour amaze8ti d-flex align-items-center justify-content-center rounded-circle mb-1">
                          00 </span>
                        ساعت
                      </li>
                      <li class="fw-light text-center">
                        <span
                          class="day amaze8ti d-flex align-items-center justify-content-center rounded-circle mb-1">
                          00 </span>
                        روز
                      </li>
                    </ul>
                    <?php }else{} ?>
                    <div class="image rounded-circle bg-white d-flex align-items-center justify-content-center">
                      <img src="<?php the_post_thumbnail_url(); ?>" alt="product" class="w-100 d-block" />
                    </div>
                    <div class="detail position-relative">
                      <div class="content">
                        <div class="title overflow-hidden">
                          <h2><?php the_title(); ?></h2>
                        </div>
                        <div class="options overflow-hidden">
                          <ul class="d-flex flex-wrap">
                          <?php
                    $product_attributes = array();

                  // Display weight and dimensions before attribute list.
                  $display_dimensions = apply_filters( 'wc_product_enable_dimensions_display', $product->has_weight() || $product->has_dimensions() );

                  if ( $display_dimensions && $product->has_weight() ) {
                    $product_attributes['weight'] = array(
                      'label' => __( 'Weight', 'woocommerce' ),
                      'value' => wc_format_weight( $product->get_weight() ),
                    );
                  }

                  if ( $display_dimensions && $product->has_dimensions() ) {
                    $product_attributes['dimensions'] = array(
                      'label' => __( 'Dimensions', 'woocommerce' ),
                      'value' => wc_format_dimensions( $product->get_dimensions( false ) ),
                    );
                  }

                  // Add product attributes to list.
                  $attributes = array_filter( $product->get_attributes(), 'wc_attributes_array_filter_visible' );

                  foreach ( $attributes as $attribute ) {
                    $values = array();

                    if ( $attribute->is_taxonomy() ) {
                      $attribute_taxonomy = $attribute->get_taxonomy_object();
                      $attribute_values   = wc_get_product_terms( $product->get_id(), $attribute->get_name(), array( 'fields' => 'all' ) );

                      foreach ( $attribute_values as $attribute_value ) {
                        $value_name = esc_html( $attribute_value->name );

                        if ( $attribute_taxonomy->attribute_public ) {
                          $values[] = '<a href="' . esc_url( get_term_link( $attribute_value->term_id, $attribute->get_name() ) ) . '" rel="tag">' . $value_name . '</a>';
                        } else {
                          $values[] = $value_name;
                        }
                      }
                    } else {
                      $values = $attribute->get_options();

                      foreach ( $values as &$value ) {
                        $value = make_clickable( esc_html( $value ) );
                      }
                    }

                    $product_attributes[ 'attribute_' . sanitize_title_with_dashes( $attribute->get_name() ) ] = array(
                      'label' => wc_attribute_label( $attribute->get_name() ),
                      'value' => apply_filters( 'woocommerce_attribute', wpautop( wptexturize( implode( ', ', $values ) ) ), $attribute, $values ),
                    );
                  }

                  ?>
                <?php $countme=0; ?>	
                <?php foreach ( $product_attributes as $product_attribute_key => $product_attribute ) : ?>
                <?php if($countme < 3): ?>	
                <li> <?php echo $product_attribute['label']; ?> : <?php echo str_replace( 'p>' , 'span>' , $product_attribute['value'] ); ?> </li>
                <?php $countme += 1; ?>
                <?php endif; ?>
                <?php endforeach; ?> 
                          </ul>
                        </div>
                        <div class="offer d-flex align-items-center rounded-pill text-white">
                        <?php if(!empty($normal_price) ) { ?>
                    <?php if("instock"==$stocka){ ?>
                    <?php if ( !$product->is_type( 'variable' ) ) { ?>
                      <del class="rounded-pill"> <?php echo $normal_price; ?> </del>
                      <?php }
                      }
                     } ?>
                      <?php
                      if(!empty($normal_price) ) { 
                      if("instock"==$stocka){ 
                      if(!empty($sale_price) ) { ?> 
                      % <?php
                      $percentage = round( ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100 );
                      echo $percentage;
                      ?> 
                      <?php } 
                      }
                     }?> 
                     </div>
                     <?php if(!empty($sale_price) ) { ?>
                    <?php if("instock"==$stocka){ ?>
                    <?php if ( !$product->is_type( 'variable' ) ) { ?>
                      <div class="price fw-light">
                      <span><?php echo $sale_price; ?></span>
                      <?php echo get_woocommerce_currency_symbol(); ?>
                    </div>
                    <?php }else{ 
                      $price_v = $product->get_price_html(); 
                      echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
                    } 
                     ?>
                    <?php }
                   } ?>
                        <a href="#" type="submit" name="add-to-cart" value="<?php echo $pr_id ?>" class="btn btn-danger-2 position-relative mt-3 single_add_to_cart_button">
                          <i class="<?php echo  esc_attr($settings['iconiamazingoffersevenstkaveh']['value']); ?> me-1"></i>
                          <?php echo  esc_html($settings['carttitleamazingoffersevenstkaveh']); ?>
                        </a>
                      </div>
                    </div>
                  </div>
                </div>
                <!-- End Slide -->
                <?php   }
                  } else {
                    // There are no posts
                  }

                  // Reset Original Post Data
                  wp_reset_postdata();
                  

                  
                  ?>
              </div>
              <div class="swiper-btns d-flex align-items-center position-absolute top-0 start-0 justify-content-center">
                <div class="swiper-button-prev position-relative top-0 start-0 bottom-0 end-0 w-auto h-auto"></div>
                <div class="swiper-button-next position-relative top-0 start-0 bottom-0 end-0 w-auto h-auto"></div>
              </div>
              <div class="swiper-pagination"></div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <style>
      <?php echo '.elementor-element-' . $clsid . ''; ?> .amazing-offer-fiveteen-wrapper::before {
    background-color: #c9a781 ;
    -webkit-background-size: cover !important;
    -moz-background-size: cover !important;
    -o-background-size: cover !important;
    background-size: cover !important;
    object-fit: cover !important;
}
<?php echo '.elementor-element-' . $clsid . ''; ?> .amazing-offer-fiveteen-item .timear span {
    color: #fff;
}
<?php echo '.elementor-element-' . $clsid . ''; ?> .amazing-offer-fiveteen .swiper-btns {
    border: 2px solid <?php echo esc_html($settings['arrowbrclazingoffersevenstkaveh']); ?>;
}
<?php echo '.elementor-element-' . $clsid . ''; ?> .amazing-offer-fiveteen .swiper-button-next::after, .amazing-offer-fiveteen .swiper-button-prev::after {
    color: <?php echo esc_html($settings['arrowclazingoffersevenstkaveh']); ?>;
}
    </style>
      <script>
function init<?php echo $clsid; ?>() {
  // Swiper Amazing Offer Fiveteen
  const amazingOfferFiveteen = new Swiper(".swiper-amazing-offer-fiveteen", {
    slidesPerView: 1,
    spaceBetween: 0,
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    pagination: {
      el: ".swiper-pagination",
      type: "bullets",
      clickable: true,
      renderBullet: (index, className) => {
        const slidesImg = document.querySelectorAll(
            ".amazing-offer-fiveteen-item .image img"
          ),
          slidesName = document.querySelectorAll(
            ".amazing-offer-fiveteen-item h2"
          );

        return `<div class="swiper-pagination-bullet d-flex align-items-center">
  <img src="${slidesImg[index].src}" alt="${slidesName[index].textContent}" />
  <span>${slidesName[index].textContent}</span>
</div>`;
      },
    },
    autoplay: {
      delay: 5000,
      disableOnInteraction: false,
      pauseOnMouseEnter: true,
    },
    effect: "fade",
    fadeEffect: {
      crossFade: true,
    },
    on: {
      paginationUpdate: (swiper, paginationEl) => {
        const active = paginationEl.querySelector(
            ".swiper-pagination-bullet-active"
          ),
          prev = active.previousElementSibling,
          oldPrev = paginationEl.querySelector(
            ".swiper-pagination-bullet-prev"
          );

        if (prev !== null) {
          if (oldPrev) {
            oldPrev.classList.remove("swiper-pagination-bullet-prev");
          }

          prev.classList.add("swiper-pagination-bullet-prev");
        }
      },
    },
  });

}
if (window.Swiper) {
    // Swiper library already loaded, initialize Swiper instance
    init<?php echo $clsid; ?>();
  } else {
    // Swiper library not yet loaded, wait for it to load
    window.addEventListener("load", function() {
      init<?php echo $clsid; ?>();
    });
  }
      </script>
    <?php
  }


}
