<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Amazingofferfourthstkaveh extends Widget_Base{

  public function get_name(){
    return 'amazingofferfourthstkaveh';
  }

  public function get_title(){
    return esc_html__( 'پیشنهاد شگفت انگیز طرح چهار', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentamazingofferfourthstkaveh',
        [
          'label' => esc_html__( 'عناوین', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      ); 
  
      $this->add_control(
          'titleamazingofferfourthstkaveh',
          [
              'label' => esc_html__( 'عنوان بولد', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'پیشنهاد', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'title2amazingofferfourthstkaveh',
        [
            'label' => esc_html__( 'عنوان اول', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'شگفت انگیز', 'kaveh-core' ),
    
        ]
    ); 
    $this->add_control(
      'tagheading1amazingofferfourthstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H6',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $this->add_control(
      'title3amazingofferfourthstkaveh',
      [
          'label' => esc_html__( 'عنوان دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( ' محصولات تخفیف دار', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'tagheading2amazingofferfourthstkaveh',
    [
      'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'H3',
      'options' => [
        'H1'  => esc_html__( 'H1', 'kaveh-core' ),
        'H2' => esc_html__( 'H2', 'kaveh-core' ),
        'H3' => esc_html__( 'H3', 'kaveh-core' ),
        'H4' => esc_html__( 'H4', 'kaveh-core' ),
        'H5' => esc_html__( 'H5', 'kaveh-core' ),
        'H6' => esc_html__( 'H6', 'kaveh-core' ),
        'p' => esc_html__( 'p', 'kaveh-core' ),
        'div' => esc_html__( 'div', 'kaveh-core' ),
        'span' => esc_html__( 'span', 'kaveh-core' ),
      ],
    ]
  );
  $this->end_controls_section();
  $this->start_controls_section(
    'content2amazingofferfourthstkaveh',
    [
      'label' => esc_html__( 'تصاویر', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
  ); 
    $this->add_control(
      'imgbackamazingofferfourthstkaveh',
      [
        'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-seven ' =>
              'background-image: url({{URL}})',
      ],
      ]
    );
    
    $this->add_control(
      'imgback2amazingofferfourthstkaveh',
      [
        'label' => esc_html__( 'تصویر پس زمینه باکس', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'selectors' => [
          '{{WRAPPER}} .amazing-offer-seven-item::before ' =>
              'background-image: url({{URL}})',
      ],
      ]
    );
    
    $this->end_controls_section();
    $this->start_controls_section(
      'content3amazingofferfourthstkaveh',
      [
        'label' => esc_html__( 'تنظیمات محصولات', 'kaveh-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    ); 
  $optionsst2 = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $optionsst2[$category->term_id] = $category->name;
}
$this->add_control(
    'catamazingofferfourthstkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $optionsst2,
    ]
);
$this->add_control(
  'productnumberamazingofferfourthstkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 20,
    'step' => 1,
    'default' => 5,
  ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'style_amazingofferfourthstkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolorboldamazingofferfourthstkaveh',
        [
          'label' => esc_html__( 'رنگ بخش بولد عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-seven .section-heading-title b' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'textcolor2amazingofferfourthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-seven .section-heading-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2_amazingofferfourthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-seven .section-heading-title',
        ]
      );
      
      $this->add_control(
        'textcolor3amazingofferfourthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-seven .section-heading-sub-title' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title21_amazingofferfourthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان دوم', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .amazing-offer-seven .section-heading-sub-title',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_amazingofferfourthstkaveh',
        [
          'label' => esc_html__( 'استایل باکس', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'bgcoloramazingofferfourthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-seven' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'bgboxcoloramazingofferfourthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-seven-wrapper::before' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'raduisboxamazingofferfourthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-seven-wrapper::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'bgbox2coloramazingofferfourthstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه باکس دو', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-seven-item' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'raduisbox2amazingofferfourthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده باکس دو', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .amazing-offer-seven-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();

        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="amazing-offer-seven position-relative">
      <div class="container">
        <!-- Start Heading -->
        <div class="section-heading d-flex justify-content-between">
          <div class="detail position-relative">
            <<?php echo  esc_attr($settings['tagheading1amazingofferfourthstkaveh']); ?> class="section-heading-title"> <b> <?php echo  esc_html($settings['titleamazingofferfourthstkaveh']); ?> </b><?php echo  esc_html($settings['title2amazingofferfourthstkaveh']); ?></<?php echo  esc_attr($settings['tagheading1amazingofferfourthstkaveh']); ?>>
            <<?php echo  esc_attr($settings['tagheading2amazingofferfourthstkaveh']); ?> class="section-heading-sub-title"><?php echo  esc_html($settings['title3amazingofferfourthstkaveh']); ?></<?php echo  esc_attr($settings['tagheading2amazingofferfourthstkaveh']); ?>>
          </div>
        </div>
        <!-- End Heading -->
        <div class="amazing-offer-seven-wrapper position-relative">
          <div class="swiper swiper-amazing-offer-two position-relative">
            <div class="swiper-wrapper position-relative">
            <?php 
                  
                  // WP_Query args
                  $q_pce_query_args = array(
                    'post_type' => array('product'),
                    'posts_per_page' => $settings['productnumberamazingofferfourthstkaveh'],
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'tax_query' => array(
                      array(
                        "taxonomy" => "product_cat",
                        "field"    => "tag_ID",
                        "terms"    => $settings['catamazingofferfourthstkaveh'],
                      ),
                    ),
                    'meta_query' => array(
                      array(
                          'key' => '_stock_status',
                          'value' => 'outofstock',
                          'compare' => 'NOT IN',
                      ),
                     ),
                    'post__in' => array_merge(array(0), wc_get_product_ids_on_sale())
                  
                  );
                  
                  // The Query
                  $pce_query = new \WP_Query($q_pce_query_args);
                  
                  // The Loop
                  if ( $pce_query->have_posts() ) {
                    while ( $pce_query->have_posts() ) {
                      $pce_query->the_post(); 
                      global $product;
                      $sale_price= $product->get_sale_price();
                      $normal_price= $product->get_regular_price();
                      $pr_id = get_the_ID();
                      $stocka=$product->get_stock_status(); ?>
              <!-- Start Item -->
              <div class="swiper-slide">
<div class="amazing-offer-seven-item d-flex position-relative">
  <div class="image">
    <img src="<?php the_post_thumbnail_url(); ?>" alt="product" />
  </div>
  <div class="content w-100">
    <div class="title overflow-hidden">
      <a href="<?php the_permalink(); ?>">
      <h2><?php the_title(); ?></h2></a>
    </div>
  <div class="price-options d-flex">
      <div class="price">
        <div class="offer d-flex align-items-center">
        <?php if(!empty($normal_price) ) { ?>
        <?php if("instock"==$stocka){ ?>
        <?php if ( !$product->is_type( 'variable' ) ) { ?>
        <del class="rounded-pill"> <?php echo $normal_price; ?> </del>
      <?php }
      }
     } ?>
      <?php
      if("instock"==$stocka){ 
      if(!empty($sale_price) ) { ?> 
      <span class="rounded-pill"> 
      % <?php
      $percentage = round( ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100 );
      echo $percentage;
      ?> 
      </span>
      <?php } 
      }
     ?> 
     </div>
     <?php if(!empty($sale_price) ){ ?>
    <?php if("instock"==$stocka){ ?>
    <?php if ( !$product->is_type( 'variable' ) ) { ?>
      <span><?php echo $sale_price; ?></span>
      <?php echo get_woocommerce_currency_symbol(); ?>
    <?php }else{ 
      $price_v = $product->get_price_html(); 
      echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);
    } 
     ?>
    <?php } }
    ?>
    </div>
      <ul>
              <?php
            $product_attributes = array();

          // Display weight and dimensions before attribute list.
          $display_dimensions = apply_filters( 'wc_product_enable_dimensions_display', $product->has_weight() || $product->has_dimensions() );

          if ( $display_dimensions && $product->has_weight() ) {
            $product_attributes['weight'] = array(
              'label' => __( 'Weight', 'woocommerce' ),
              'value' => wc_format_weight( $product->get_weight() ),
            );
          }

          if ( $display_dimensions && $product->has_dimensions() ) {
            $product_attributes['dimensions'] = array(
              'label' => __( 'Dimensions', 'woocommerce' ),
              'value' => wc_format_dimensions( $product->get_dimensions( false ) ),
            );
          }

          // Add product attributes to list.
          $attributes = array_filter( $product->get_attributes(), 'wc_attributes_array_filter_visible' );

          foreach ( $attributes as $attribute ) {
            $values = array();

            if ( $attribute->is_taxonomy() ) {
              $attribute_taxonomy = $attribute->get_taxonomy_object();
              $attribute_values   = wc_get_product_terms( $product->get_id(), $attribute->get_name(), array( 'fields' => 'all' ) );

              foreach ( $attribute_values as $attribute_value ) {
                $value_name = esc_html( $attribute_value->name );

                if ( $attribute_taxonomy->attribute_public ) {
                  $values[] = '<a href="' . esc_url( get_term_link( $attribute_value->term_id, $attribute->get_name() ) ) . '" rel="tag">' . $value_name . '</a>';
                } else {
                  $values[] = $value_name;
                }
              }
            } else {
              $values = $attribute->get_options();

              foreach ( $values as &$value ) {
                $value = make_clickable( esc_html( $value ) );
              }
            }

            $product_attributes[ 'attribute_' . sanitize_title_with_dashes( $attribute->get_name() ) ] = array(
              'label' => wc_attribute_label( $attribute->get_name() ),
              'value' => apply_filters( 'woocommerce_attribute', wpautop( wptexturize( implode( ', ', $values ) ) ), $attribute, $values ),
            );
          }

          ?>
        <?php $countme=0; ?>	
        <?php foreach ( $product_attributes as $product_attribute_key => $product_attribute ) : ?>
        <?php if($countme < 4): ?>	
        <li> <?php echo $product_attribute['label']; ?> : <?php echo str_replace( 'p>' , 'span>' , $product_attribute['value'] ); ?> </li>
        <?php $countme += 1; ?>
        <?php endif; ?>
        <?php endforeach; ?>
      </ul>
      <?php
      if(!empty($normal_price) ) { 
      if("instock"==$stocka){ 
      if(!empty($sale_price) ) { ?> 
      <div class="progress-circle position-relative ms-0 ms-md-auto" data-val="<?php echo $percentage; ?>%">
        <svg>
          <?php $perc=round($percentage * 4.14 * 10)/10; ?>
          <circle cx="76" cy="76" r="66" fill="none" stroke="#FF2F60" stroke-dasharray="<?php echo $perc; ?>, 414">
          </circle>
        </svg>
      </div>
      <?php } 
      }
     }?> 
    </div>
    <div class="btns position-absolute bottom-0 d-flex align-items-center">
      <a href="#" class="btn btn-danger-3 rounded-pill single_add_to_cart_button" type="submit" name="add-to-cart" value="<?php echo $pr_id ?>"> +&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;خرید </a>
      <a href="#" class="btn btn-add-favorite rounded-pill" id="amzoff4wish">
        <?php echo do_shortcode( '[woosw id="".<?php echo get_the_ID(); ?>.""]' ); ?>
        افزودن به علاقه مندی
      </a>
    </div>
  </div>
</div>
</div>
              <!-- End Item -->
              <?php   }
            } else {
              // There are no posts
            }

            // Reset Original Post Data
            wp_reset_postdata();
            

            
            ?>
            </div>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
          </div>
        </div>
      </div>
    </section>
<style>
<?php echo '.elementor-element-' . $clsid . ''; ?> .amazing-offer-seven {
    background-size: cover;
    object-fit: cover;
    background-color: #2d365d ;
}
<?php echo '.elementor-element-' . $clsid . ''; ?> .amazing-offer-seven-item::before {
    -webkit-background-size: cover !important;
    -moz-background-size: cover !important;
    -o-background-size: cover !important;
    background-size: cover !important;
    object-fit: cover !important;
}
</style>
      <script>
function init<?php echo $clsid; ?>() {
  // Swiper Slider Home
  new Swiper(".swiper-amazing-offer-three", {
    slidesPerView: 1,
    spaceBetween: 0,
    autoplay: {
      delay: 5000,
      disableOnInteraction: false,
      pauseOnMouseEnter: true,
    },
    effect: "fade",
    fadeEffect: {
      crossFade: true,
    },
    loop: true,
    navigation: {
      nextEl: ".swiper-button-next1",
      prevEl: ".swiper-button-prev1",
    },
  });
  // Swiper Amazing Offer Two
  new Swiper(".swiper-amazing-offer-two", {
    loop: true,
    slidesPerView: 1,
    spaceBetween: 0,
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    autoplay: {
      delay: 5000,
      disableOnInteraction: false,
      pauseOnMouseEnter: true,
    },
    effect: "fade",
    fadeEffect: {
      crossFade: true,
    },
  });
}
  if (window.Swiper) {
    // Swiper library already loaded, initialize Swiper instance
    init<?php echo $clsid; ?>();
  } else {
    // Swiper library not yet loaded, wait for it to load
    window.addEventListener("load", function() {
      init<?php echo $clsid; ?>();
    });
  }
      </script>
    <?php
  }


}
