<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Aboutusthirdstkaveh extends Widget_Base{

  public function get_name(){
    return 'aboutusthirdstkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان درباره ما سبک سه', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentaboutusthirdstkaveh',
        [
          'label' => esc_html__( 'تنظیمات المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      ); 
      $this->add_control(
        'styleboxaboutusthirdstkaveh',
        [
          'label' => esc_html__( 'طرح بندی المان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'one',
          'options' => [
            'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
            'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
            'three'  => esc_html__( 'طرح بندی سه', 'kaveh-core' ),
            'four'  => esc_html__( 'طرح بندی چهار', 'kaveh-core' ),

    
          ],
        ]
        );
      $this->end_controls_section();
      $this->start_controls_section(
        'content4aboutusthirdstkaveh',
        [
          'label' => esc_html__( 'محتوا', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      ); 
      $this->add_control(
          'title1aboutusthirdstkaveh',
          [
              'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'فروشگاه', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'title2aboutusthirdstkaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'کاوه', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tagheadingaboutusthirdstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
        ],
      ]
    );
    $this->add_control(
      'descaboutusthirdstkaveh',
      [
          'label' => esc_html__( 'توضیحات', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXTAREA,
          'default' => esc_html__( 'با بیش از سی سال سابقه خدمت به مشتریان در زمینه فروش ابزارآلات صنعتی و کارگاهی را دارا می باشد و با گردهم آوردن متخصصان این عرصه بالغ بر ده سال است که برند را به صورت تخصصی در زمینه ابزار آلات عرضه کرده است. همچنین برای ارائه هرچه تمام تر فعالیت خود از سال فروشگاه اینترنتی ابزار را راه اندازی نموده است.', 'kaveh-core' ),
  
      ]
  );
  $this->end_controls_section();
  $this->start_controls_section(
    'content2aboutusthirdstkaveh',
    [
      'label' => esc_html__( 'شبکه های اجتماعی', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
              'condition' => [
                'styleboxaboutusthirdstkaveh' => 'one',
              ],
    ]
  ); 
  $repeater = new \Elementor\Repeater();
    $repeater->add_control(
      'socialaboutusthirdstkaveh',
      [
        'label' => esc_html__( 'آیکون شبکه اجتماعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon-instagram',
        ],
      ]
    ); 
    $repeater->add_control(
      'sociallinkaboutusthirdstkaveh',
      [
          'label' => esc_html__( 'لینک', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
  $this->add_control(
    'listaboutusthirdstkaveh',
    [
      'label' => esc_html__( 'شبکه های اجتماعی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::REPEATER,
      'fields' => $repeater->get_controls(),
      'condition' => [
        'styleboxaboutusthirdstkaveh' => 'one',
      ],
      'default' => [
        [
          'socialaboutusthirdstkaveh' => esc_html__( 'icon-instagram', 'kaveh-core' ),
          'sociallinkaboutusthirdstkaveh' => esc_html__( '#', 'kaveh-core' ),
        ],
    ]
    ]
  
  );
  $this->end_controls_section();
  $this->start_controls_section(
    'content3aboutusthirdstkaveh',
    [
      'label' => esc_html__( 'تصاویر', 'kaveh-core' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
  ); 
$this->add_control(
  'imgaboutusthirdstkaveh',
  [
    'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
    'condition' => [
      'styleboxaboutusthirdstkaveh' => [ 'three' , 'four'  ],
    ],
    'type' => \Elementor\Controls_Manager::MEDIA,
  ]
);
$this->add_control(
  'imgaboutusbacksecondstkaveh',
  [
    'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
    'selectors' => [
      '{{WRAPPER}} .about-us-home-six' =>
          'background-image: url({{URL}})',
          '{{WRAPPER}} .about-us-sixteen' =>
          'background-image: url({{URL}})',
          '{{WRAPPER}} .about-us-home-ten' =>
          'background-image: url({{URL}})',
  ],
  ]
);

       $this->end_controls_section();
       $this->start_controls_section(
        'style_aboutusthirdstkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor1aboutusthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about3rd .about3rdtitle ' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title1_aboutusthirdstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .about3rd .about3rdtitle ',
        ]
      );
      $this->add_control(
        'textcolor2aboutusthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}}  .about3rd .about3rdtitle span' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2_aboutusthirdstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}}  .about3rd .about3rdtitle span',
        ]
      );
      $this->add_control(
        'beforetaboutusthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ خط زیر عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}}  .about3rd .about3rdtitle::after' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'pcolor2aboutusthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ متن', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}}  .about3rd .about3rdp' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'p_aboutusthirdstkaveh',
          'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}}  .about3rd .about3rdp',
        ]
      );
      
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_aboutussecondstkaveh',
        [
          'label' => esc_html__( 'استایل شبکه های اجتماعی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'styleboxaboutusthirdstkaveh' => 'one',
          ],
        ]
      );
      $this->add_control(
        'iconsizeaboutussecondstkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 300,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' =>20,
          ],
          'selectors' => [
            '{{WRAPPER}} .about-us-home-six .content .socials li a' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->start_controls_tabs(
        'style5_tabsaboutussecondstkaveh'
      );
      $this->start_controls_tab(
        'style1_normal_tababoutussecondstkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbutton1coloraboutussecondstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home-six .content .socials li a' => 'color: {{VALUE}}',
          ],
        ]
      );  
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hover1_tababoutussecondstkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbutton1colorhoveraboutussecondstkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .about-us-home-six .content .socials li a:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->end_controls_section();
      $this->start_controls_section(
        'style4_aboutussecondstkaveh',
        [
          'label' => esc_html__( 'استایل باکس', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'rowaboutussecondstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .about3rd ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'backcolor1aboutusthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}}  .about-us-home-six' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'backcolor2aboutusthirdstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه باکس نوشته ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxaboutusthirdstkaveh' => 'two',
          ],
          'selectors' => [
            '{{WRAPPER}}  .about-us-home-ten-box' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'backradiuscolor2aboutusthirdstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده باکس نوشته ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ,'%'],
          'condition' => [
            'styleboxaboutusthirdstkaveh' => 'two',
          ],
          'selectors' => [
            '{{WRAPPER}}  .about-us-home-ten-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'rowabout2ussecondstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی باکس نوشته ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxaboutusthirdstkaveh' => 'two',
          ],
          'size_units' => [ 'px' ,'%'],
          'selectors' => [
            '{{WRAPPER}} .about-us-home-ten-box ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'bgsizeaboutusthirdstkaveh',
        [
          'label' => esc_html__( 'سایز تصویر پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'condition' => [
            'styleboxaboutusthirdstkaveh' => 'three',
      
          ],
          'default' => 'cover',
          'options' => [
            'cover'  => esc_html__( 'کاور', 'kaveh-core' ),
            'custom'  => esc_html__( 'سفارشی', 'kaveh-core' ),  
          ],
        ]
        );
      
        $this->add_control(
          'widthbg7aboutusthirdstkaveh',
          [
            'label' => esc_html__( 'عرض تصویر پس زمینه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'condition' => [
              'styleboxaboutusthirdstkaveh' => 'three',
              'bgsizeaboutusthirdstkaveh' => 'custom',
                ],
            'size_units' => [ 'px', '%' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 2000,
                'step' => 5,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
          ]
        );
        $this->add_control(
          'heigthbg7aboutusthirdstkaveh',
          [
            'label' => esc_html__( 'ارتفاع تصویر پس زمینه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'condition' => [
                'styleboxaboutusthirdstkaveh' => 'three',
                'bgsizeaboutusthirdstkaveh' => 'custom',
            ],
            'size_units' => [ 'px', '%' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 2000,
                'step' => 5,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
          ]
        );
        $this->add_control(
          'width8aboutusthirdstkaveh',
          [
            'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'condition' => [
              'styleboxaboutusthirdstkaveh' => 'three',
                ],
            'size_units' => [ 'px', '%' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 2000,
                'step' => 5,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'selectors' => [
              '{{WRAPPER}} .about-us-fourteen .container::after' => 'width: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'width9aboutusthirdstkaveh',
          [
            'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'condition' => [
              'styleboxaboutusthirdstkaveh' => 'four',
                ],
            'size_units' => [ 'px', '%' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 2000,
                'step' => 5,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'selectors' => [
              '{{WRAPPER}} .about3-4 img' => 'width: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'height9aboutusthirdstkaveh',
          [
            'label' => esc_html__( 'ارتفاع تصویر', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'condition' => [
              'styleboxaboutusthirdstkaveh' => 'four',
                ],
            'size_units' => [ 'px', '%' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 2000,
                'step' => 5,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'selectors' => [
              '{{WRAPPER}} .about3-4 img' => 'height: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
      $this->end_controls_section();

        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <?php if('one'===$settings['styleboxaboutusthirdstkaveh']){ ?>
    <section class="about-us-home-six about3rd">
      <div class="container d-flex align-items-center flex-column flex-lg-row">
        <img src="<?php echo esc_url($settings['imgaboutusthirdstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $settings['imgaboutusthirdstkaveh'] )); ?>" class="d-block w-100" />
        <div class="content">
          <<?php echo  esc_attr($settings['tagheadingaboutusthirdstkaveh']); ?> class="position-relative about3rdtitle">
            <?php echo  esc_html($settings['title1aboutusthirdstkaveh']); ?>
          <span class="d-block"> <?php echo  esc_html($settings['title2aboutusthirdstkaveh']); ?> </span>

          </<?php echo  esc_attr($settings['tagheadingaboutusthirdstkaveh']); ?>>
          <p class="about3rdp">
          <?php echo  esc_html($settings['descaboutusthirdstkaveh']); ?>
          </p>
          <ul class="socials d-flex align-items-center">
          <?php
              if ( $settings['listaboutusthirdstkaveh'] ) {
              foreach (  $settings['listaboutusthirdstkaveh'] as $item ) {
              ?>
            <li>
              <a href="<?php echo  esc_url($item['sociallinkaboutusthirdstkaveh']); ?>" class="d-block">
                <i class="<?php echo  esc_attr($item['socialaboutusthirdstkaveh']['value']); ?>"></i>
              </a>
            </li>
            <?php 
            }
              }
            ?>
          </ul>
        </div>
      </div>
    </section>
    <style>
    </style>
    <?php }elseif('two'===$settings['styleboxaboutusthirdstkaveh']){ ?>
    <section class="about-us-home-ten position-relative about3rd">
      <div class="container d-flex justify-content-end">
        <div class="about-us-home-ten-box position-relative">
          <<?php echo  esc_attr($settings['tagheadingaboutusthirdstkaveh']); ?> class="position-relative about3rdtitle">
          <?php echo  esc_html($settings['title1aboutusthirdstkaveh']); ?>
            <span class="d-block"><?php echo  esc_html($settings['title2aboutusthirdstkaveh']); ?></span>
          </<?php echo  esc_attr($settings['tagheadingaboutusthirdstkaveh']); ?>>
          <p class="about3rdp"><?php echo  esc_html($settings['descaboutusthirdstkaveh']); ?></p>
        </div>
      </div>
    </section>
    <?php }elseif('three'===$settings['styleboxaboutusthirdstkaveh']){ ?>
     <section class="about-us-fourteen position-relative about3rd">
      <div class="container position-relative">
        <div class="content">
          <<?php echo  esc_attr($settings['tagheadingaboutusthirdstkaveh']); ?> class="title position-relative pb-4 mb-4 about3rdtitle">
          <?php echo  esc_html($settings['title1aboutusthirdstkaveh']); ?>
            <span class="d-block"><?php echo  esc_html($settings['title2aboutusthirdstkaveh']); ?></span>
          </<?php echo  esc_attr($settings['tagheadingaboutusthirdstkaveh']); ?>>
          <p class="about3rdp">
          <?php echo  esc_html($settings['descaboutusthirdstkaveh']); ?>
          </p>
        </div>
      </div>
    </section>
    <style>
      <?php echo '.elementor-element-' . $clsid . ''; ?> .about-us-fourteen .container::after {
    background: url("<?php echo esc_url($settings['imgaboutusthirdstkaveh']['url']); ?>") 0 0 no-repeat;
    -webkit-background-size: contain !important;
    -moz-background-size: contain !important;
    -o-background-size: contain !important;
    background-size: contain !important;
    object-fit: cover;
  }
<?php if('custom'===$settings['bgsizeaboutusthirdstkaveh']){ ?>
  <?php echo '.elementor-element-' . $clsid . ''; ?> .about-us-fourteen {
    margin: 0;
    background: #ffebec url("<?php echo esc_url($settings['imgaboutusbacksecondstkaveh']['url']); ?>") right 0 no-repeat;
    -webkit-background-size: <?php echo esc_html($settings['widthbg7aboutusthirdstkaveh']['size']); echo esc_html($settings['widthbg7aboutusthirdstkaveh']['unit']); ?> <?php echo esc_html($settings['heigthbg7aboutusthirdstkaveh']['size']);echo esc_html($settings['heigthbg7aboutusthirdstkaveh']['unit']); ?> !important;
    -moz-background-size: <?php echo esc_html($settings['widthbg7aboutusthirdstkaveh']['size']); echo esc_html($settings['widthbg7aboutusthirdstkaveh']['unit']); ?> <?php echo esc_html($settings['heigthbg7aboutusthirdstkaveh']['size']);echo esc_html($settings['heigthbg7aboutusthirdstkaveh']['unit']); ?> !important;
    -o-background-size: <?php echo esc_html($settings['widthbg7aboutusthirdstkaveh']['size']); echo esc_html($settings['widthbg7aboutusthirdstkaveh']['unit']); ?> <?php echo esc_html($settings['heigthbg7aboutusthirdstkaveh']['size']);echo esc_html($settings['heigthbg7aboutusthirdstkaveh']['unit']); ?> !important;
    background-size: <?php echo esc_html($settings['widthbg7aboutusthirdstkaveh']['size']); echo esc_html($settings['widthbg7aboutusthirdstkaveh']['unit']); ?> <?php echo esc_html($settings['heigthbg7aboutusthirdstkaveh']['size']);echo esc_html($settings['heigthbg7aboutusthirdstkaveh']['unit']); ?> !important;
}
<?php }elseif('cover'===$settings['bgsizeaboutusthirdstkaveh']){ ?>
  <?php echo '.elementor-element-' . $clsid . ''; ?> .about-us-fourteen {
    margin: 0;
    background: #ffebec url("<?php echo esc_url($settings['imgaboutusbacksecondstkaveh']['url']); ?>") right 0 no-repeat;
    -webkit-background-size: cover !important;
    -moz-background-size: cover !important;
    -o-background-size: cover !important;
    background-size: cover !important;
}
<?php } ?>
    </style>
    <?php }elseif('four'===$settings['styleboxaboutusthirdstkaveh']){ ?>
      <section class="about-us-sixteen position-relative about3rd">
      <div class="container">
        <div class="about-us-sixteen-wrapper position-relative">
          <div class="row align-items-center">
            <div class="col-lg-6 about3-4">
              <img src="<?php echo esc_url($settings['imgaboutusthirdstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $settings['imgaboutusthirdstkaveh'] )); ?>" class="d-block" />
            </div>
            <div class="col-lg-6">
              <div class="content position-relative">
                <<?php echo  esc_attr($settings['tagheadingaboutusthirdstkaveh']); ?> class="title position-relative mb-4 pb-4 about3rdtitle">
                <?php echo  esc_html($settings['title1aboutusthirdstkaveh']); ?>
                <span class="d-block"><?php echo  esc_html($settings['title2aboutusthirdstkaveh']); ?></span>
                </<?php echo  esc_attr($settings['tagheadingaboutusthirdstkaveh']); ?>>
                <p class="about3rdp mb-0"><?php echo  esc_html($settings['descaboutusthirdstkaveh']); ?></p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <style>
      <?php echo '.elementor-element-' . $clsid . ''; ?> .about-us-sixteen::before {
    background-image: -webkit-linear-gradient(269.92deg, rgba(33, 35, 65, 0) 14.14%, <?php echo esc_html($settings['backcoloraboutusthirdstkaveh']); ?> 84.74%);
    background-image: -moz-linear-gradient(269.92deg, rgba(33, 35, 65, 0) 14.14%, <?php echo esc_html($settings['backcoloraboutusthirdstkaveh']); ?> 84.74%);
    background-image: -o-linear-gradient(269.92deg, rgba(33, 35, 65, 0) 14.14%, <?php echo esc_html($settings['backcoloraboutusthirdstkaveh']); ?> 84.74%);
    background-image: linear-gradient(180.08deg, rgba(33, 35, 65, 0) 14.14%, <?php echo esc_html($settings['backcoloraboutusthirdstkaveh']); ?> 84.74%);
    z-index: -2;
}
<?php echo '.elementor-element-' . $clsid . ''; ?> .about-us-sixteen {
    padding: 19px 0 39px;
    -webkit-background-size: cover !important;
    -moz-background-size: cover !important;
    -o-background-size: cover !important;
    background-size: cover !important;
    object-fit: cover;

}
    </style>
    <?php } ?>

    <style>
<?php echo '.elementor-element-' . $clsid . ''; ?> .about-us-home-ten {
    -webkit-background-size: cover !important;
    -moz-background-size: cover !important;
    -o-background-size: cover !important;
    background-size: cover !important;
    background-attachment: fixed !important;

}
<?php echo '.elementor-element-' . $clsid . ''; ?> .about-us-home-ten::before {

    background-image: -webkit-linear-gradient(225deg, rgba(33, 35, 65, 0), <?php echo esc_html($settings['backcoloraboutusthirdstkaveh']); ?> 50%);
    background-image: -moz-linear-gradient(225deg, rgba(33, 35, 65, 0), <?php echo esc_html($settings['backcoloraboutusthirdstkaveh']); ?> 50%);
    background-image: -o-linear-gradient(225deg, rgba(33, 35, 65, 0), <?php echo esc_html($settings['backcoloraboutusthirdstkaveh']); ?> 50%);
    background-image: linear-gradient(-135deg, rgba(33, 35, 65, 0), <?php echo esc_html($settings['backcoloraboutusthirdstkaveh']); ?> 50%);
}

    </style>
    <?php
  }


}
