<?php
namespace Skb_Cife;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

/*--------------------------
*   Class iconly Icon Manager
* -------------------------*/
class Skb_Cife_Iconly_Icon_Manager{

    private static $instance = null;

    public static function instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    function __construct(){
        $this->init();
    }

    public function init() {

        // Custom icon filter
        add_filter( 'elementor/icons_manager/additional_tabs', [ $this,'skb_cife_iconly_icon'] );  

    }

	public function skb_cife_iconly_icon( $iconly_icons_args = array() ) {

	    // Append new icons
	    $iconly_icons = array(
		


			'Activity',
  

			'Add-User',
			  
			
			'Arrow-Down',
			  
			
			'Arrow-Down-2',
			  
			
			'Arrow-Down-3',
			  
			
			'Arrow-Down-Circle',
			  
			
			'Arrow-Down-Square',
			  
			
			'Arrow-Left',
			  
			
			'Arrow-Left-2',
			  
			
			'Arrow-Left-3',
			  
			
			'Arrow-Left-Circle',
			  
			
			'Arrow-Left-Square',
			  
			
			'Arrow-Right',
			  
			
			'Arrow-Right-2',
			  
			
			'Arrow-Right-3',
			  
			
			'Arrow-Right-Circle',
			  
			
			'Arrow-Right-Square',
			  
			
			'Arrow-Up',
			  
			
			'Arrow-Up-2',
			  
			
			'Arrow-Up-3',
			  
			
			'Arrow-Up-Circle',
			  
			
			'Arrow-Up-Square',
			  
			
			'Bag',
			  
			
			'Bag-2',
			  
			
			'Bookmark',
			  
			
			'Buy',
			  
			
			'Calendar',
			  
			
			'Call',
			  
			
			'Call-Missed',
			  
			
			'Call-Silent',
			  
			
			'Calling',
			  
			
			'Camera',
			  
			
			'Category',
			  
			
			'Chart',
			  
			
			'Chat',
			  
			
			'Close-Square',
			  
			
			'Danger',
			  
			
			'Delete',
			  
			
			'Discount',
			  
			
			'Discovery',
			  
			
			'Document',
			  
			
			'Download',
			  
			
			'Edit',
			  
			
			'Edit-Square',
			  
			
			'Filter',
			  
			
			'Filter-2',
			  
			
			'Folder',
			  
			
			'Game',
			  
			
			'Graph',
			  
			
			'Heart',
			  
			
			'Hide',
			  
			
			'Home',
			  
			
			'Image',
			  
			
			'Image-2',
			  
			
			'Info-Circle',
			  
			
			'Info-Square',
			  
			
			'Location',
			  
			
			'Lock',
			  
			
			'Login',
			  
			
			'Logout',
			  
			
			'Message',
			  
			
			'More-Circle',
			  
			
			'More-Square',
			  
			
			'Notification',
			  
			
			'Paper',
			  
			
			'Paper-Download',
			  
			
			'Paper-Fail',
			  
			
			'Paper-Negative',
			  
			
			'Paper-Plus',
			  
			
			'Paper-Upload',
			  
			
			'Password',
			  
			
			'Play',
			  
			
			'Plus',
			  
			
			'Profile',
			  
			
			'Scan',
			  
			
			'Search',
			  
			
			'Send',
			  
			
			'Setting',
			  
			
			'Shield-Done',
			  
			
			'Shield-Fail',
			  
			
			'Show',
			  
			
			'Star',
			  
			
			'Swap',
			  
			
			'Tick-Square',
			  
			
			'Ticket',
			  
			
			'Ticket-Star',
			  
			
			'Time-Circle',
			  
			
			'Time-Square',
			  
			
			'Unlock',
			  
			
			'Upload',
			  
			
			'User2',
			  
			
			'User3',
			  
			
			'Video',
			  
			
			'Voice',
			  
			
			'Voice-2',
			  
			
			'Volume-Down',
			  
			
			'Volume-Off',
			  
			
			'Volume-Up',
			  
			
			'Wallet',
			  
			
			'Work',
			  
			
			
			
			  
			
			
	    );
	    
	    $iconly_icons_args['skb_cife-iconly-icon'] = array(
	        'name'          => 'skb_cife-iconly-icon',
	        'label'         => esc_html__( 'کتابخانه iconly', 'skb_cife' ),
	        'labelIcon'     => 'iconly-Arrow-Right-3',
	        'prefix'        => 'iconly-',
	        'displayPrefix' => '',
	        'url'           => get_template_directory_uri().'/assets/css/iconly.css',
	        'icons'         => $iconly_icons,
	        'ver'           => 1.0,
	    );

	    return $iconly_icons_args;
	}



}
Skb_Cife_Iconly_Icon_Manager::instance();