<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Uptotopkaveh extends Widget_Base{

  public function get_name(){
    return 'uptotopkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان بازگشت به بالا', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['headerfooterkavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentuptotopkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'iconuptotopkaveh',
        [
          'label' => esc_html__( 'آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::ICONS,
          'skin' => 'inline',
          'exclude_inline_options' => [ 'svg' ],
          'default' => [
            'value' => 'icon-angle-up',
          ],
        ]
      );
 
        $this->end_controls_section();
        $this->start_controls_section(
          'styleuptotopkaveh',
          [
            'label' => esc_html__( 'استایل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          ]
        );
        $this->add_control(
          'iconsizetotopkaveh',
          [
            'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 200,
                'step' => 1,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'default' => [
              'unit' => 'px',
              'size' => 12,
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-scroll-header' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          't1coloruptotopkaveh',
          [
            'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .footer-scroll-header' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->add_control(
          't2coloruptotopkaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .footer-scroll-header' => 'background-color: {{VALUE}}',
            ],
          ]
        );
        $this->add_control(
          'widthtotopkaveh',
          [
            'label' => esc_html__( 'عرض', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 1000,
                'step' => 1,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'default' => [
              'unit' => 'px',
              'size' => 55,
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-scroll-header' => 'width: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'heighttotopkaveh',
          [
            'label' => esc_html__( 'ارتفاع', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 1000,
                'step' => 1,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'default' => [
              'unit' => 'px',
              'size' => 55,
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-scroll-header' => 'height: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->add_group_control(
          \Elementor\Group_Control_Box_Shadow::get_type(),
          [
            'name' => 'box_shadowtotopkaveh',
            'label' => esc_html__( 'سایه', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .footer-scroll-header',
          ]
        );
        $this->end_controls_section();
          
        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
  
?>
        <button type="button" class="footer-scroll-header rounded-circle text-center d-block mx-auto"
          data-to-header="true">
          <i class="<?php echo  esc_attr($settings['iconuptotopkaveh']['value']); ?>"></i>
        </button>

    <?php
  }


}
