<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Productstablekaveh extends Widget_Base{

  public function get_name(){
    return 'productstablekaveh';
  }

  public function get_title(){
    return esc_html__( 'جدول محصولات', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentproductstablekaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
          'titleproductstablekaveh',
          [
              'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'قیمت روز', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'tagheading1productstablekaveh',
        [
          'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H3',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'title2productstablekaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'تیر آهن', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tagheading2productstablekaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
  $this->add_control(
    'pproductstablekaveh',
    [
      'label' => esc_html__( 'نمایش محصولات', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'all',
      'options' => [
        'all'  => esc_html__( 'همه', 'kaveh-core' ),
        'cat'  => esc_html__( 'دسته بندی', 'kaveh-core' ),

      ],
    ]
    );
    $this->add_control(
      'psortproductstablekaveh',
      [
        'label' => esc_html__( 'مرتب سازی محصولات براساس', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '',
        'condition' => [
          'pproductstablekaveh' => 'all',
        ],
        'options' => [
          ''  => esc_html__( 'تاریخ', 'kaveh-core' ),
          '_price'  => esc_html__( 'قیمت', 'kaveh-core' ),
          '_wc_average_rating'  => esc_html__( 'محبوب ترین', 'kaveh-core' ),
          'total_sales'  => esc_html__( 'بیشترین فروش', 'kaveh-core' ),
  
        ],
      ]
      );
      $this->add_control(
        'psortiproductstablekaveh',
        [
          'label' => esc_html__( 'نوع مرتب سازی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'desc',
          'condition' => [
            'pproductstablekaveh' => 'all',
          ],
          'options' => [
            'asc'  => esc_html__( 'صعودی', 'kaveh-core' ),
            'desc'  => esc_html__( 'نزولی', 'kaveh-core' ),
          ],
        ]
        );

        $options2 = array();
      $orderby = 'name';
      $order = 'asc';
      $hide_empty = false ;
      $cat_args = array(
          'orderby'    => $orderby,
          'order'      => $order,
          'hide_empty' => $hide_empty,
      );

      $product_categories = get_terms( 'product_cat', $cat_args );

      foreach ( $product_categories as $key => $category ) {
          $options2[$category->term_id] = $category->name;
      }
      $this->add_control(
          'catproductstablekaveh',
          [
            'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SELECT2, 
            'multiple' => true,
            'options' => $options2,
            'condition' => [
              'pproductstablekaveh' => 'cat',
            ],
          ]
      );
      $this->add_control(
        'productnumberproductstablekaveh',
        [
          'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 20,
          'step' => 1,
          'default' => 5,
        ]
      );
            $this->end_controls_section();
                
      $this->start_controls_section(
        'styleproductstablekaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title1_productstablekaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .price-day-girder .section-heading-sub-title',
        ]
      );
      $this->add_control(
        't1colorproductstablekaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .price-day-girder .section-heading-sub-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2productstablekaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .price-day-girder .section-heading-title',
        ]
      );
      $this->add_control(
        't2colorproductstablekaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .price-day-girder .section-heading-title' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2productstablekaveh',
        [
          'label' => esc_html__( 'استایل محصولات', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'trcolorproductstablekaveh',
        [
          'label' => esc_html__( 'رنگ حاشیه ردیف', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .table tbody tr td:first-child::after' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->end_controls_section();
        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
<div class="price-day-girder">
      <div class="container">
        <!-- Start Heading -->
        <div class="section-heading d-flex align-items-sm-center justify-content-sm-between flex-column flex-sm-row">
          <div class="detail position-relative">
            <<?php echo  esc_attr($settings['tagheading1productstablekaveh']); ?> class="section-heading-sub-title"><?php echo  esc_html($settings['titleproductstablekaveh']); ?></<?php echo  esc_attr($settings['tagheading1productstablekaveh']); ?>>
            <<?php echo  esc_attr($settings['tagheading2productstablekaveh']); ?> class="section-heading-title"><?php echo  esc_html($settings['title2productstablekaveh']); ?></<?php echo  esc_attr($settings['tagheading2productstablekaveh']); ?>>
          </div>
        </div>
        <!-- End Heading -->
        <!-- Start Table -->
        <div class="table-responsive">
          <table class="table">
            <thead>
              <tr>
                <th> کد </th>
                <th> نام </th>
                <th> سایز </th>
                <th> محل تحویل </th>
                <th> واحد </th>
                <th> قیمت (تومان) </th>
                <th> عملیات </th>
              </tr>
            </thead>
            <tbody>
            <?php if('cat'===$settings['pproductstablekaveh']){                   
                  // WP_Query args
                  $q_pc2_query_args = array(
                    'post_type' => array('product'),
                    'posts_per_page' => $settings['productnumberproductstablekaveh'],
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'tax_query' => array(
                      array(
                        "taxonomy" => "product_cat",
                        "field"    => "tag_ID",
                        "terms"    => $settings['catproductstablekaveh'],
                      ),
                    ),
                    'meta_query' => array(
                      array(
                          'key' => '_stock_status',
                          'value' => 'outofstock',
                          'compare' => 'NOT IN',
                      ),
                     ),
                     
                    
                  );

                  // The Query
                  $pc2_query = new \WP_Query($q_pc2_query_args);
                  
                  // The Loop
                  if ( $pc2_query->have_posts() ) {
                    while ( $pc2_query->have_posts() ) {
                      $pc2_query->the_post(); ?>
              <tr>
                <td>
                  <span class="badge badge-danger rounded-pill"> ۰۷۹۱ </span>
                </td>
                <td class="name">
                  <a href="<?php the_permalink(); ?>" class="fw-bold"><?php the_title(); ?></a>
                </td>
                <td>
                  <span class="badge badge-secondary"> ۹۰۷ </span>
                </td>
                <td> بنگاه تهران </td>
                <td class="vahid"> شاخه </td>
                <td class="price fw-bold">
                  <i class="icon-angle-up-fill"></i>
                  ۷٫۷۹۹٫۷۹۹٫۰۰۰
                </td>
                <td class="icons d-flex align-items-center">
                  <a href="#">
                    <i class="icon-cart-3"></i>
                  </a>
                  <a href="#">
                    <i class="icon-chart"></i>
                  </a>
                </td>
              </tr>
              <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
                  
                  ?>
              <?php }elseif('all'===$settings['pproductstablekaveh']){
                // WP_Query args
            $ordvalue = $settings['psortproductstablekaveh'];
            $ordi = $settings['psortiproductstablekaveh'];
            $q_pc2_query_args = array(
              'post_type' => array('product'),
              'posts_per_page' => $settings['productnumberproductstablekaveh'],
              'order' => $ordi,
              'orderby' => 'meta_value_num',
              'meta_key'       => $ordvalue,
              'meta_query' => array(
                array(
                    'key' => '_stock_status',
                    'value' => 'outofstock',
                    'compare' => 'NOT IN',
                ),
               ),
             
            );
 
            // The Query
            $pc2_query = new \WP_Query($q_pc2_query_args);

            // The Loop
            if ( $pc2_query->have_posts() ) {
              while ( $pc2_query->have_posts() ) {
                $pc2_query->the_post(); ?>
              <tr>
                <td>
                  <span class="badge badge-danger rounded-pill"> ۰۷۹۱ </span>
                </td>
                <td class="name">
                  <a href="<?php the_permalink(); ?>" class="fw-bold"><?php the_title(); ?></a>
                </td>
                <td>
                  <span class="badge badge-secondary"> ۹۰۷ </span>
                </td>
                <td> بنگاه تهران </td>
                <td class="vahid"> شاخه </td>
                <td class="price fw-bold">
                  <i class="icon-angle-up-fill"></i>
                  ۷٫۷۹۹٫۷۹۹٫۰۰۰
                </td>
                <td class="icons d-flex align-items-center">
                  <a href="#">
                    <i class="icon-cart-3"></i>
                  </a>
                  <a href="#">
                    <i class="icon-chart"></i>
                  </a>
                </td>
              </tr>
              <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
                  
                  ?>
                <?php } ?>
            </tbody>
          </table>
        </div>
        <!-- End Table -->
      </div>
    </div>
    <?php
  }


}
