<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Productstabkaveh extends Widget_Base{

  public function get_name(){
    return 'productstabkaveh';
  }

  public function get_title(){
    return esc_html__( 'تب محصولات کاروسل', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentproductstabkaveh',
        [
          'label' => esc_html__( 'تب ها', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'tabstyproductstabkaveh',
        [
          'label' => esc_html__( 'استایل تب ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => '1style',
          'options' => [
            '1style'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
            '2style'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
            '3style'  => esc_html__( 'طرح بندی سه', 'kaveh-core' ),
            '4style'  => esc_html__( 'طرح بندی چهار', 'kaveh-core' ),

          ],
        ]
        );
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
      'tabtitle1productstabkaveh',
      [
        'label' => esc_html__( 'عنوان تب', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $repeater->add_control(
      'pproductstabkaveh',
      [
        'label' => esc_html__( 'نمایش محصولات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'all',
        'options' => [
          'all'  => esc_html__( 'همه', 'kaveh-core' ),
          'cat'  => esc_html__( 'دسته بندی', 'kaveh-core' ),
  
        ],
      ]
      );
      $repeater->add_control(
        'psortproductstabkaveh',
        [
          'label' => esc_html__( 'مرتب سازی محصولات براساس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => '',
          'condition' => [
            'pproductstabkaveh' => 'all',
          ],
          'options' => [
            ''  => esc_html__( 'تاریخ', 'kaveh-core' ),
            '_price'  => esc_html__( 'قیمت', 'kaveh-core' ),
            '_wc_average_rating'  => esc_html__( 'محبوب ترین', 'kaveh-core' ),
            'total_sales'  => esc_html__( 'بیشترین فروش', 'kaveh-core' ),
    
          ],
        ]
        );
        $repeater->add_control(
          'psortiproductstabkaveh',
          [
            'label' => esc_html__( 'نوع مرتب سازی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'desc',
            'condition' => [
              'pproductstabkaveh' => 'all',
            ],
            'options' => [
              'asc'  => esc_html__( 'صعودی', 'kaveh-core' ),
              'desc'  => esc_html__( 'نزولی', 'kaveh-core' ),
            ],
          ]
          );
    $taboption = array();
    $orderby = 'name';
    $order = 'asc';
    $hide_empty = false ;
    $cat_args = array(
        'orderby'    => $orderby,
        'order'      => $order,
        'hide_empty' => $hide_empty,
    );
    $product_categories = get_terms( 'product_cat', $cat_args );
    
    foreach ( $product_categories as $key => $category ) {
        $taboption[$category->term_id] = $category->name;
    }
    $repeater->add_control(
        'cat2productstabkaveh',
        [
          'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT2, 
          'multiple' => false,
          'options' => $taboption,
          'condition' => [
            'pproductstabkaveh' => 'cat',
          ],
        ]
    );
    $repeater->add_control(
      'productnumberproductstabkaveh',
      [
        'label' => esc_html__( 'تعداد محصولات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 20,
        'step' => 1,
        'default' => 8,
      ]
    );
    $this->add_control(
      'listproductstabkaveh',
      [
        'label' => esc_html__( 'تب ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tabtitle1productstabkaveh' => esc_html__( 'دسته بندی', 'kaveh-core' ),
          ],
        ],
      ]
    );

    $this->end_controls_section();
    $this->start_controls_section(
      'content2productstabkaveh',
      [
        'label' => esc_html__( 'تنظیمات نمایش', 'kaveh-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'styleproductstabkaveh',
      [
        'label' => esc_html__( 'طرح بندی باکس محصول', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'one',
        'options' => [
          'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
          'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
          'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
          'four'  => esc_html__( 'طرح بندی چهارم', 'kaveh-core' ),
          'five'  => esc_html__( 'طرح بندی پنجم', 'kaveh-core' ),
          'six'  => esc_html__( 'طرح بندی ششم', 'kaveh-core' ),
          'seven'  => esc_html__( 'طرح بندی هفتم', 'kaveh-core' ),
          'eight'  => esc_html__( 'طرح بندی هشتم', 'kaveh-core' ),
          'nine'  => esc_html__( 'طرح بندی نهم', 'kaveh-core' ),
          'ten'  => esc_html__( 'طرح بندی دهم', 'kaveh-core' ),
          'eleven'  => esc_html__( 'طرح بندی یازدهم', 'kaveh-core' ),
          'twelve'  => esc_html__( 'طرح بندی دوازدهم', 'kaveh-core' ),
          'thirteen'  => esc_html__( 'طرح بندی سیزدهم', 'kaveh-core' ),
          'fourteen'  => esc_html__( 'طرح بندی چهاردهم', 'kaveh-core' ),
          'fifteen'  => esc_html__( 'طرح بندی پانزدهم', 'kaveh-core' ),
          'sixteen'  => esc_html__( 'طرح بندی شانزدهم', 'kaveh-core' ),
  
        ],
      ]
      );
    $this->add_control(
      'productcolumnproductstabkaveh',
      [
        'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 1,
        'default' => 4,
    
      ]
    );
    $this->add_control(
      'productcolumn2productstabkaveh',
      [
        'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 1,
        'default' => 3,
    
      ]
    );
    $this->add_control(
      'productcolumn3productstabkaveh',
      [
        'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::NUMBER,
        'min' => 0,
        'max' => 5,
        'step' => 1,
        'default' => 1,
    
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'style1_productstabkaveh',
      [
        'label' => esc_html__( 'استایل تب ها', 'kaveh-core' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'button_productstabkaveh',
        'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .top-products-tabs .nav-item .nav-link',
        'condition' => [
          'tabstyproductstabkaveh' => '1style',
        ],
      ]
    ); 
    $this->add_control(
      'buttontextcolorproductstabkaveh',
      [
        'label' => esc_html__( 'رنگ متن', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'tabstyproductstabkaveh' => ['1style','2style','3style'],
        ],
        'selectors' => [
          '{{WRAPPER}} .top-products-tabs .nav-item .nav-link' => 'color: {{VALUE}}',
          '{{WRAPPER}} .top-products-two-tabs .nav-item .nav-link' => 'color: {{VALUE}}',
          '{{WRAPPER}} .top-seller-products-two-tabs li' => 'color: {{VALUE}}',
        ],
      ]
    ); 
    $this->add_control(
      'buttoncoloractiveproductstabkaveh',
      [
        'label' => esc_html__( 'رنگ پس زمینه تب فعال', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'tabstyproductstabkaveh' => '1style',
        ],
        'selectors' => [
          '{{WRAPPER}} .top-products-tabs .nav-item .nav-link.active' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .top-products-tabs .nav-item .nav-link:hover' => 'background-color: {{VALUE}}',


        ],
      ]
    );  
    $this->add_control(
      'buttontextactivecolorproductstabkaveh',
      [
        'label' => esc_html__( 'رنگ متن در حالت فعال', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'tabstyproductstabkaveh' => ['1style','2style','3style'],
        ],
        'selectors' => [
          '{{WRAPPER}} .top-products-tabs .nav-item .nav-link.active, .top-products-tabs .nav-item .nav-link:hover, .top-products-two-tabs .nav-item .nav-link.active, .top-products-two-tabs .nav-item .nav-link:hover, .top-seller-products-two-tabs li.active, .top-seller-products-two-tabs li:hover' => 'color: {{VALUE}}',

        ],
      ]
    ); 
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'buttonst2_productstabkaveh',
        'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .top-products-two-tabs .nav-item .nav-link',
        'condition' => [
          'tabstyproductstabkaveh' => '2style',
        ],
      ]
    ); 

    $this->add_control(
      'buttoncoloractivest2productstabkaveh',
      [
        'label' => esc_html__( 'رنگ پس زمینه تب فعال', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'tabstyproductstabkaveh' => '2style',
        ],
        'selectors' => [
          '{{WRAPPER}} .top-products-two-tabs .nav-item .nav-link.active' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .top-products-two-tabs .nav-item .nav-link:hover' => 'background-color: {{VALUE}}',


        ],
      ]
    ); 
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'buttonst3_productstabkaveh',
        'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),
        'selector' => '{{WRAPPER}} .top-seller-products-two-tabs li',
        'condition' => [
          'tabstyproductstabkaveh' => '3style',
        ],
      ]
    ); 

    $this->add_control(
      'buttoncoloractivest3productstabkaveh',
      [
        'label' => esc_html__( 'رنگ پس زمینه تب فعال', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'tabstyproductstabkaveh' => '3style',
        ],
        'selectors' => [
          '{{WRAPPER}} .top-seller-products-two-tabs li.active, .top-seller-products-two-tabs li:hover' => 'background-color: {{VALUE}}',

        ],
      ]
    ); 
    $this->add_control(
      'buttonpaddingproductstabkaveh',
      [
        'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'condition' => [
          'tabstyproductstabkaveh' => '1style',
        ],
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .top-products-tabs .nav-item .nav-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'buttonradius1productstabkaveh',
      [
        'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'condition' => [
          'tabstyproductstabkaveh' => '1style',
        ],
        'selectors' => [
          '{{WRAPPER}} .top-products-tabs .nav-item .nav-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'buttonpadding2productstabkaveh',
      [
        'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'condition' => [
          'tabstyproductstabkaveh' => '3style',
        ],
        'size_units' => [ 'px' ],
        'selectors' => [
          '{{WRAPPER}} .top-seller-products-two-tabs li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'buttonradius2productstabkaveh',
      [
        'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => [ 'px' ],
        'condition' => [
          'tabstyproductstabkaveh' => '3style',
        ],
        'selectors' => [
          '{{WRAPPER}} .top-seller-products-two-tabs li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'buttonshadowproductstabkave',
        'label' => esc_html__( 'سایه دکمه در حالت فعال', 'kaveh-core' ),
        'condition' => [
          'tabstyproductstabkaveh' => '1style',
        ],
        'selector' => '{{WRAPPER}} .top-products-tabs .nav-item .nav-link.active,{{WRAPPER}}  .top-products-tabs .nav-item .nav-link:hover',
        
      ]
    );
    $this->add_control(
      'buttontextcolor4productstabkaveh',
      [
        'label' => esc_html__( 'رنگ متن', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
        'tabstyproductstabkaveh' => '4style',
      ],
        'selectors' => [
          '{{WRAPPER}} .top-products-six .nav-pills .nav-item' => 'color: {{VALUE}}',
  
        ],
      ]
    ); 
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'buttonst4_productstabkaveh',
        'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),
        'condition' => [
        'tabstyproductstabkaveh' => '4style',
      ],
        'selector' => '{{WRAPPER}} .top-products-six .nav-pills .nav-item',
      ]
    ); 
    $this->add_control(
      'buttontextactive4colorproductstabkaveh',
      [
        'label' => esc_html__( 'رنگ متن در حالت فعال', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
        'tabstyproductstabkaveh' => '4style',
      ],
        'selectors' => [
          '{{WRAPPER}} .top-products-six .nav-pills .nav-item.active' => 'color: {{VALUE}}',
        ],
      ]
    ); 

    $this->add_control(
      'buttoncoloractivest4productstabkaveh',
      [
        'label' => esc_html__( 'رنگ پس زمینه و تب فعال', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
        'condition' => [
          'tabstyproductstabkaveh' => '4style',
        ],
        'selectors' => [
          '{{WRAPPER}} .top-products-six .nav-pills .nav-item.active' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .top-products-six .nav-pills .nav-item::before' => 'background: {{VALUE}}',
          '{{WRAPPER}} .top-products-six .nav-pills .nav-item::after' => 'background: {{VALUE}}',
          '{{WRAPPER}} .top-products-six-wrapper::before' => 'background-color: {{VALUE}}',
        ],
      ]
    ); 
       $this->end_controls_section();

          
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <?php if('1style'===$settings['tabstyproductstabkaveh']){ ?>
    <section class="top-products position-relative">
      <div class="container position-relative">
        <!-- Start Tabs -->
        <ul class="nav nav-tabs top-products-tabs d-flex align-items-center position-relative border-0">
        <?php
              $q=1;
              if ( $settings['listproductstabkaveh'] ) {
              foreach (  $settings['listproductstabkaveh'] as $item ) {
              ?>
          <li class="nav-item">
            <a href="#pro-<?php echo $clsid.$q; ?>" class="nav-link <?php if(1===$q){?>active <?php }else{}?>" data-bs-toggle="tab"> <?php echo  esc_html($item['tabtitle1productstabkaveh']); ?></a>
          </li>
          <?php 
            $q++;
            }
              }
            ?>
        </ul>
        <!-- End Tabs -->
        <!-- Start Tab Content -->
        <div class="tab-content">
        <?php
              $k=1;
              if ( $settings['listproductstabkaveh'] ) {
              foreach (  $settings['listproductstabkaveh'] as $item ) {
              ?>
          <div id="pro-<?php echo $clsid.$k; ?>" class="tab-pane fade <?php if(1===$k){?>active show<?php }else{}?>">
            <!-- Start Products -->
            <div class="swiper swiper-products">
              <div class="swiper-wrapper">
            <?php            
            if('cat'===$item['pproductstabkaveh']){
             // WP_Query args
            $q_ptk_query_args = array(
              'post_type' => array('product'),
              'posts_per_page' => $item['productnumberproductstabkaveh'],
              'order' => 'DESC',
              'orderby' => 'date',
              'tax_query' => array(
                array(
                  "taxonomy" => "product_cat",
                  "field"    => "tag_ID",
                  "terms"    => $item['cat2productstabkaveh'],
                ),
              ),
                'meta_query' => array(
                  array(
                      'key' => '_stock_status',
                      'value' => 'outofstock',
                      'compare' => 'NOT IN',
                  ),
                 ),
              
            );

            // The Query
            $ptk_query = new \WP_Query($q_ptk_query_args);

            // The Loop
            if ( $ptk_query->have_posts() ) {
              while ( $ptk_query->have_posts() ) {
                $ptk_query->the_post(); ?>
                <div class="swiper-slide">
                <?php  $styleproduct2=$settings['styleproductstabkaveh']; ?>
                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                </div>
                <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
                  
                  ?>
              </div>
              <div class="swiper-button-next d-none"></div>
              <div class="swiper-button-prev d-none"></div>
            </div>
            <!-- End Products -->
          </div>
          <?php 
           $k++;
            }else{
                           // WP_Query args
            $ordvalue = $item['psortproductstabkaveh'];
            $ordi = $item['psortiproductstabkaveh'];
            $q_ptk_query_args = array(
              'post_type' => array('product'),
              'posts_per_page' => $item['productnumberproductstabkaveh'],
              'order' => $ordi,
              'orderby' => 'meta_value_num',
              'meta_key'       => $ordvalue,
              'meta_query' => array(
                array(
                    'key' => '_stock_status',
                    'value' => 'outofstock',
                    'compare' => 'NOT IN',
                ),
               ),
             
            );

            // The Query
            $ptk_query = new \WP_Query($q_ptk_query_args);

            // The Loop
            if ( $ptk_query->have_posts() ) {
              while ( $ptk_query->have_posts() ) {
                $ptk_query->the_post(); ?>
                <div class="swiper-slide">
                <?php  $styleproduct2=$settings['styleproductstabkaveh']; ?>
                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                </div>
                <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
                  
                  ?>
              </div>
              <div class="swiper-button-next d-none"></div>
              <div class="swiper-button-prev d-none"></div>
            </div>
            <!-- End Products -->
          </div>
          <?php 
           $k++;
            }
              }
                }
              
            ?>
        </div>
        <!-- End Tab Content -->
      </div>
    </section>
    <?php }elseif('2style'===$settings['tabstyproductstabkaveh']){ ?>
    <section class="top-products-two">
      <div class="container">
        <!-- Start Tabs -->
        <ul class="nav nav-tab top-products-two-tabs d-flex border-bottom-0">
        <?php
        $q=1;
        if ( $settings['listproductstabkaveh'] ) {
        foreach (  $settings['listproductstabkaveh'] as $item ) {
        ?>
          <li class="nav-item">
            <a href="#pro-<?php echo $q; ?>" class="nav-link <?php if(1===$q){?>active <?php }else{}?>" data-bs-toggle="tab"> <?php echo  esc_html($item['tabtitle1productstabkaveh']); ?></a>
          </li>
          <?php 
      $q++;
      }
        }
      ?>
        </ul>
        <!-- End Tabs -->
        <!-- Start Tab Content -->
        <div class="top-products-two-wrapper position-relative">
          <div class="tab-content">
          <?php
        $s=1;
        if ( $settings['listproductstabkaveh'] ) {
        foreach (  $settings['listproductstabkaveh'] as $item ) {
        ?>
            <div id="pro-<?php echo $s; ?>" class="tab-pane fade <?php if(1==$s){?>active show<?php }else{}?>">
              <div class="swiper swiper-top-products-two overflow-hidden">
                <div class="swiper-wrapper">
                <?php            
                if('cat'===$item['pproductstabkaveh']){
                // WP_Query args
                $q_ptk_query_args = array(
                    'post_type' => array('product'),
                    'posts_per_page' => $item['productnumberproductstabkaveh'],
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'tax_query' => array(
                    array(
                        "taxonomy" => "product_cat",
                        "field"    => "tag_ID",
                        "terms"    => $item['cat2productstabkaveh'],
                    ),
                  ),
                    'meta_query' => array(
                      array(
                          'key' => '_stock_status',
                          'value' => 'outofstock',
                          'compare' => 'NOT IN',
                      ),
                     ),
                  
                    
                    
                );

                // The Query
                $ptk_query = new \WP_Query($q_ptk_query_args);

                // The Loop
                if ( $ptk_query->have_posts() ) {
                    while ( $ptk_query->have_posts() ) {
                    $ptk_query->the_post(); ?>
                    <div class="swiper-slide">
                    <?php  $styleproduct2=$settings['styleproductstabkaveh']; ?>
                    <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                </div>
                <?php
                // Reset Original Post Data
                    wp_reset_postdata();
                }
                }
                    
                ?>
              <?php 
    
      }else{
                     // WP_Query args
      $ordvalue = $item['psortproductstabkaveh'];
      $ordi = $item['psortiproductstabkaveh'];
      $q_ptk_query_args = array(
        'post_type' => array('product'),
        'posts_per_page' => $item['productnumberproductstabkaveh'],
        'order' => $ordi,
        'orderby' => 'meta_value_num',
        'meta_key'       => $ordvalue,
        'meta_query' => array(
          array(
              'key' => '_stock_status',
              'value' => 'outofstock',
              'compare' => 'NOT IN',
          ),
         ),
       
      );

      // The Query
      $ptk_query = new \WP_Query($q_ptk_query_args);

      // The Loop
      if ( $ptk_query->have_posts() ) {
        while ( $ptk_query->have_posts() ) {
          $ptk_query->the_post(); ?>
          <div class="swiper-slide">
          <?php  $styleproduct2=$settings['styleproductstabkaveh']; ?>
          <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
          </div>
          <?php
          // Reset Original Post Data
            wp_reset_postdata();
          }
        }
            
            ?>
        <!-- End Tab Content -->
        <?php 
     
      }
      ?>
                  </div>
            </div>
          </div>
      <?php
      $s++;
        }
          }
        
      ?>
            </div>
        </div>
      </div>
    </section>
    <?php }elseif('3style'===$settings['tabstyproductstabkaveh']){ ?>
    <section class="top-seller-products-two">
      <div class="container">
        <!-- Strat Tabs -->
        <ul class="top-seller-products-two-tabs nav nav-pills justify-content-center">
        <?php
              $q=1;
              if ( $settings['listproductstabkaveh'] ) {
              foreach (  $settings['listproductstabkaveh'] as $item ) {
              ?>
          <li data-bs-toggle="pill" data-bs-target="#top-seller-products-two-<?php echo $q; ?>" class="<?php if(1===$q){?>active <?php }else{}?>"> <?php echo  esc_html($item['tabtitle1productstabkaveh']); ?></li>
          <?php 
            $q++;
            }
              }
            ?>
        </ul>
        <!-- End Tabs -->
        <!-- Start Tab Content -->
        <div class="tab-content">
        <?php
              $k=1;
              if ( $settings['listproductstabkaveh'] ) {
              foreach (  $settings['listproductstabkaveh'] as $item ) {
              ?>
          <div id="top-seller-products-two-<?php echo $k; ?>" class="tab-pane fade <?php if(1===$k){?>active show<?php }else{}?>">
            <div class="swiper swiper-products swiper-shadow overflow-hidden">
          <div class="swiper-wrapper">
              <?php            
            if('cat'===$item['pproductstabkaveh']){
             // WP_Query args
            $q_ptk_query_args = array(
              'post_type' => array('product'),
              'posts_per_page' => $item['productnumberproductstabkaveh'],
              'order' => 'DESC',
              'orderby' => 'date',
              'tax_query' => array(
                array(
                  "taxonomy" => "product_cat",
                  "field"    => "tag_ID",
                  "terms"    => $item['cat2productstabkaveh'],
                ),
              ),
              'meta_query' => array(
                array(
                    'key' => '_stock_status',
                    'value' => 'outofstock',
                    'compare' => 'NOT IN',
                ),
               ),
              
              
            );

            // The Query
            $ptk_query = new \WP_Query($q_ptk_query_args);

            // The Loop
            if ( $ptk_query->have_posts() ) {
              while ( $ptk_query->have_posts() ) {
                $ptk_query->the_post(); ?>
                <div class="swiper-slide">
                <?php  $styleproduct2=$settings['styleproductstabkaveh']; ?>
                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                </div>
                <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
            }else{
              // WP_Query args
              $ordvalue = $item['psortproductstabkaveh'];
              $ordi = $item['psortiproductstabkaveh'];
              $q_ptk_query_args = array(
              'post_type' => array('product'),
              'posts_per_page' => $item['productnumberproductstabkaveh'],
              'order' => $ordi,
              'orderby' => 'meta_value_num',
              'meta_key'       => $ordvalue,
              'meta_query' => array(
                array(
                    'key' => '_stock_status',
                    'value' => 'outofstock',
                    'compare' => 'NOT IN',
                ),
               ),

              );

              // The Query
              $ptk_query = new \WP_Query($q_ptk_query_args);

              // The Loop
              if ( $ptk_query->have_posts() ) {
              while ( $ptk_query->have_posts() ) {
                $ptk_query->the_post(); ?>
                <div class="swiper-slide">
                <?php  $styleproduct2=$settings['styleproductstabkaveh']; ?>
                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                </div>
                <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
            }
                  
                  ?>
              </div>
              <div class="swiper-button-next d-none"></div>
              <div class="swiper-button-prev d-none"></div>
            </div>
          </div>
          <?php 
           $k++;
            }
              }
              
            ?>
        </div>
        <!-- End Tab Content -->
      </div>
    </section>
    <?php }elseif('4style'===$settings['tabstyproductstabkaveh']){ ?>
    <section class="top-products-six <?php if('gray'===$settings['tabcolorproductstabkaveh']){ ?>gray<?php } ?>">
      <div class="container">
        <!-- Start Tabs -->
        <ul class="nav nav-pills justify-content-center">
        <?php
              $q=1;
              if ( $settings['listproductstabkaveh'] ) {
              foreach (  $settings['listproductstabkaveh'] as $item ) {
              ?>
          <li class="nav-item <?php if(1===$q){?>active <?php }else{}?>" data-bs-toggle="pill" data-bs-target="#top-products-six-<?php if('gray'===$settings['tabcolorproductstabkaveh']){ ?>gray-<?php }  echo $q; ?>"><?php echo  esc_html($item['tabtitle1productstabkaveh']); ?></li>
          <?php 
            $q++;
            }
              }
            ?>
        </ul>
        <!-- End Tabs -->
        <div class="top-products-six-wrapper position-relative">
          <!-- Start Tab Content -->
          <div class="tab-content">
          <?php
              $k=1;
              if ( $settings['listproductstabkaveh'] ) {
              foreach (  $settings['listproductstabkaveh'] as $item ) {
              ?>
            <div id="top-products-six-<?php if('gray'===$settings['tabcolorproductstabkaveh']){ ?>gray-<?php } ?><?php echo $k; ?>" class="tab-pane fade <?php if(1===$k){?>active show<?php }else{}?>">
              <div class="swiper swiper-products">
                <div class="swiper-wrapper">
                <?php            
            if('cat'===$item['pproductstabkaveh']){
             // WP_Query args
            $q_ptk_query_args = array(
              'post_type' => array('product'),
              'posts_per_page' => $item['productnumberproductstabkaveh'],
              'order' => 'DESC',
              'orderby' => 'date',
              'tax_query' => array(
                array(
                  "taxonomy" => "product_cat",
                  "field"    => "tag_ID",
                  "terms"    => $item['cat2productstabkaveh'],
                ),
              ),
              'meta_query' => array(
                array(
                    'key' => '_stock_status',
                    'value' => 'outofstock',
                    'compare' => 'NOT IN',
                ),
               ),
              
              
            );

            // The Query
            $ptk_query = new \WP_Query($q_ptk_query_args);

            // The Loop
            if ( $ptk_query->have_posts() ) {
              while ( $ptk_query->have_posts() ) {
                $ptk_query->the_post(); ?>
                <div class="swiper-slide">
                <?php  $styleproduct2=$settings['styleproductstabkaveh']; ?>
                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                </div>
                <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
            }else{
              // WP_Query args
              $ordvalue = $item['psortproductstabkaveh'];
              $ordi = $item['psortiproductstabkaveh'];
              $q_ptk_query_args = array(
              'post_type' => array('product'),
              'posts_per_page' => $item['productnumberproductstabkaveh'],
              'order' => $ordi,
              'orderby' => 'meta_value_num',
              'meta_key'       => $ordvalue,
              'meta_query' => array(
                array(
                    'key' => '_stock_status',
                    'value' => 'outofstock',
                    'compare' => 'NOT IN',
                ),
               ),

              );

              // The Query
              $ptk_query = new \WP_Query($q_ptk_query_args);

              // The Loop
              if ( $ptk_query->have_posts() ) {
              while ( $ptk_query->have_posts() ) {
                $ptk_query->the_post(); ?>
                <div class="swiper-slide">
                <?php  $styleproduct2=$settings['styleproductstabkaveh']; ?>
                <?php get_template_part("template-part/product-cart-$styleproduct2"); ?>
                </div>
                <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
            }
                  
                  ?>
                </div>
                <div class="swiper-button-next d-none"></div>
                <div class="swiper-button-prev d-none"></div>
              </div>
            </div>
            <?php 
           $k++;
            }
              }
              
            ?>
          </div>
          <!-- End Tab Content -->
        </div>
      </div>
    </section>
      <?php }else{}?>

    <script>
            function init<?php echo $clsid; ?>() {
              // Swiper Products
  new Swiper(".swiper-products", {
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    breakpoints: {
      320: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3productstabkaveh']); ?>,
        spaceBetween: 4,
      },
      500: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3productstabkaveh']); ?>,
        spaceBetween: 14,
      },
      768: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn2productstabkaveh']); ?>,
        spaceBetween: 14,
      },
      992: {
        slidesPerView: <?php echo  esc_html($settings['productcolumnproductstabkaveh']); ?>,
        spaceBetween: 20,
      },
      1200: {
        slidesPerView: <?php echo  esc_html($settings['productcolumnproductstabkaveh']); ?>,
        spaceBetween: 31,
      },
    },
  });
  // Swiper Top products Two
  new Swiper(".swiper-top-products-two", {
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    breakpoints: {
      320: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3productstabkaveh']); ?>,
        spaceBetween: 4,
      },
      500: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3productstabkaveh']); ?>,
        spaceBetween: 14,
      },
      768: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn2productstabkaveh']); ?>,
        spaceBetween: 14,
      },
      992: {
        slidesPerView: <?php echo  esc_html($settings['productcolumnproductstabkaveh']); ?>,
        spaceBetween: 20,
      },
      1200: {
        slidesPerView: <?php echo  esc_html($settings['productcolumnproductstabkaveh']); ?>,
        spaceBetween: 31,
      },
    },
  });
}
      if (window.Swiper) {
    // Swiper library already loaded, initialize Swiper instance
    init<?php echo $clsid; ?>();
  } else {
    // Swiper library not yet loaded, wait for it to load
    window.addEventListener("load", function() {
      init<?php echo $clsid; ?>();
    });
  }
    </script>
    <?php
  }


}
