<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Productscarouselfourthstkaveh extends Widget_Base{

  public function get_name(){
    return 'productscarouselfourthstkaveh';
  }
 
  public function get_title(){
    return esc_html__( 'کاروسل محصولات سبک چهار', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentproductscarouselfourthstkaveh',
        [
          'label' => esc_html__( 'عنوان المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
  
      $this->add_control(
          'titleproductscarouselfourthstkaveh',
          [
              'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'پرفروش ترین محصولات', 'kaveh-core' ),
      
          ]
      );
      $this->add_control(
        'title2productscarouselfourthstkaveh',
        [
            'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'پوشاک ورزشی', 'kaveh-core' ),
    
        ]
    );
    $this->add_control(
      'tagheadingproductscarouselfourthstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'content2productscarouselfourthstkaveh',
      [
        'label' => esc_html__( 'تصاویر', 'kaveh-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );
$this->add_control(
  'imgproductscarouselfourthstkaveh',
  [
    'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
    'selectors' => [
      '{{WRAPPER}} .new-products-category-title::after' =>
          'background: url({{URL}})',
          '{{WRAPPER}} .new-products-category-title::before' =>
          'background: url({{URL}})',
  ],
  ]
);

$this->add_control(
  'imgbgproductscarouselfourthstkaveh',
  [
    'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
    'selectors' => [
      '{{WRAPPER}} .new-products-category-title' =>
          'background: url({{URL}})',
  ],
  ]
);

$this->end_controls_section();
$this->start_controls_section(
  'content3productscarouselfourthstkaveh',
  [
    'label' => esc_html__( 'تنظیمات محصولات', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);
    $this->add_control(
      'pproductscarouselfourthstkaveh',
      [
        'label' => esc_html__( 'نمایش محصولات', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'all',
        'options' => [
          'all'  => esc_html__( 'همه', 'kaveh-core' ),
          'cat'  => esc_html__( 'دسته بندی', 'kaveh-core' ),
  
        ],
      ]
      );
      $this->add_control(
        'psortproductscarouselfourthstkaveh',
        [
          'label' => esc_html__( 'مرتب سازی محصولات براساس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => '',
          'condition' => [
            'pproductscarouselfourthstkaveh' => 'all',
          ],
          'options' => [
            ''  => esc_html__( 'تاریخ', 'kaveh-core' ),
            '_price'  => esc_html__( 'قیمت', 'kaveh-core' ),
            '_wc_average_rating'  => esc_html__( 'محبوب ترین', 'kaveh-core' ),
            'total_sales'  => esc_html__( 'بیشترین فروش', 'kaveh-core' ),
    
          ],
        ]
        );
        $this->add_control(
          'psortiproductscarouselfourthstkaveh',
          [
            'label' => esc_html__( 'نوع مرتب سازی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'desc',
            'condition' => [
              'pproductscarouselfourthstkaveh' => 'all',
            ],
            'options' => [
              'asc'  => esc_html__( 'صعودی', 'kaveh-core' ),
              'desc'  => esc_html__( 'نزولی', 'kaveh-core' ),
            ],
          ]
          );
  $options4 = array();
$orderby = 'name';
$order = 'asc';
$hide_empty = false ;
$cat_args = array(
    'orderby'    => $orderby,
    'order'      => $order,
    'hide_empty' => $hide_empty,
);

$product_categories = get_terms( 'product_cat', $cat_args );

foreach ( $product_categories as $key => $category ) {
    $options4[$category->term_id] = $category->name;
}
$this->add_control(
    'catproductscarouselfourthstkaveh',
    [
      'label' => esc_html__( 'انتخاب دسته بندی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT2, 
      'multiple' => true,
      'options' => $options4,
      'condition' => [
        'pproductscarouselfourthstkaveh' => 'cat',
      ],
    ]
);
$this->end_controls_section();
$this->start_controls_section(
  'content4productscarouselfourthstkaveh',
  [
    'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);
$this->add_control(
  'showarrowsproductscarouselfourthstkaveh',
  [
    'label' => esc_html__( 'نمایش جهت ها؟', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'yes' => esc_html__( 'بله', 'kaveh-core' ),
    'no' => esc_html__( 'خیر', 'kaveh-core' ),
    'return_value' => 'yes',
    'default' => 'yes',
  ]
);
$this->add_control(
  'productnumberproductscarouselfourthstkaveh',
  [
    'label' => esc_html__( 'تعداد محصولات نمایش داده شده', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 20,
    'step' => 1,
    'default' => 5,
  ]
);
$this->add_control(
  'productcolumnproductscarouselfourthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.5,
    'default' => 3,

  ]
); 
$this->add_control(
  'productcolumn2productscarouselfourthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.5,
    'default' => 2,

  ]
);
$this->add_control(
  'productcolumn3productscarouselfourthstkaveh',
  [
    'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::NUMBER,
    'min' => 0,
    'max' => 5,
    'step' => 0.5,
    'default' => 1.5,

  ]
);
       $this->end_controls_section();
       $this->start_controls_section(
        'style_productscarouselfourthstkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor3productscarouselfourthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}}  .new-products-category-title .prcr4 span' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2_productscarouselfourthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .new-products-category-title .prcr4 span',
        ]
      );
      $this->add_control(
        'textcolor2productscarouselfourthstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}}  .new-products-category-title .prcr4' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_productscarouselfourthstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}}  .new-products-category-title .prcr4',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_productscarouselfourthstkaveh',
        [
          'label' => esc_html__( 'استایل تصاویر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'widthbgproductscarouselfourthstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'selectors' => [
            '{{WRAPPER}} .new-products-category-title::after' => 'width: {{SIZE}}{{UNIT}};',
            '{{WRAPPER}} .new-products-category-title::before' => 'width: {{SIZE}}{{UNIT}};',
          ],
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
          ],
        ]
      );
      $this->add_control(
        'rightbgproductscarouselfourthstkaveh',
        [
          'label' => esc_html__( 'فاصله از راست', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => -500,
              'max' => 500,
              'step' => 5,
            ],
            '%' => [
              'min' => -100,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .new-products-category-title::after, .new-products-category-title::before' => 'right: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_productscarouselfourthstkaveh',
        [
          'label' => esc_html__( 'استایل باکس', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'borderradiusproductscarouselfourthstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .new-products-category-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style5_productscarouselfourthstkaveh',
        [
          'label' => esc_html__( 'استایل جهت های کاروسل', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'showarrowsproductscarouselfourthstkaveh' => 'yes',
          ],
        ]
      );
      $this->add_control(
        'arrowscolorproductscarouselfourthstkaveh',
        [
          'label' => esc_html__( 'رنگ جهت های کاروسل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .new-products-category .swiper-button-next' => 'border : 2px solid  {{VALUE}}',
            '{{WRAPPER}} .new-products-category .swiper-button-prev' => 'border : 2px solid  {{VALUE}}',
            '{{WRAPPER}} .new-products-category .swiper-button-next::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .new-products-category .swiper-button-prev::after' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->end_controls_section();


        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>

<section class="new-products-category">
      <div class="container d-flex position-relative flex-column flex-sm-row">
        <div class="new-products-category-title position-relative">
          <<?php echo  esc_attr($settings['tagheadingproductscarouselfourthstkaveh']); ?> class="position-absolute prcr4">
            <span class="d-block"> <?php echo  esc_html($settings['titleproductscarouselfourthstkaveh']); ?> </span>
            <?php echo  esc_html($settings['title2productscarouselfourthstkaveh']); ?>
          </<?php echo  esc_attr($settings['tagheadingproductscarouselfourthstkaveh']); ?>>
        </div>
        <div class="swiper swiper-new-products-category overflow-hidden">

        <div class="swiper-wrapper">
            <?php if('cat'===$settings['pproductscarouselfourthstkaveh']){ ?>
              <?php 
                  
                  // WP_Query args
                  $q_pc4_query_args = array(
                    'post_type' => array('product'),
                    'posts_per_page' => $settings['productnumberproductscarouselfourthstkaveh'],
                    'order' => 'DESC',
                    'orderby' => 'date',
                    'tax_query' => array(
                      array(
                        "taxonomy" => "product_cat",
                        "field"    => "tag_ID",
                        "terms"    => $settings['catproductscarouselfourthstkaveh'],
                      ),
                    ),
                    'meta_query' => array(
                      array(
                          'key' => '_stock_status',
                          'value' => 'outofstock',
                          'compare' => 'NOT IN',
                      ),
                     ),
                     
                    
                  );

                  // The Query
                  $pc4_query = new \WP_Query($q_pc4_query_args);
                  
                  // The Loop
                  if ( $pc4_query->have_posts() ) {
                    while ( $pc4_query->have_posts() ) {
                      $pc4_query->the_post(); 
                      global $product;
                      $sale_price= $product->get_sale_price();
                      $normal_price= $product->get_regular_price();
                      $pr_id = get_the_ID();
                      $stocka=$product->get_stock_status();
                      ?>
                      <div class="swiper-slide">
                      <div class="product product-ten">
                          <div class="product-image">
                          <?php
                          if("instock"!=$stocka){ ?>
                            <div class="status">
                              ناموجود
                            </div>
                            <?php } ?>
                            <a href="<?php the_permalink(); ?>">
                              <img src="<?php the_post_thumbnail_url('medium'); ?>" alt="<?php the_title(); ?>">
                            </a>
                          </div>
                          <div class="detail">
                          <?php if("instock"==$stocka){ ?>
                          <?php if ( !$product->is_type( 'variable' ) ) { ?>
                          <?php if(!empty($sale_price) ) { ?>
                          <div class="offer">
                            <?php echo $normal_price; ?>
                          </div>
                          <div class="price">
                            <?php echo number_format($sale_price, 0, '.', ','); ?>
                            <span> <?php echo get_woocommerce_currency_symbol(); ?> </span>
                          </div>
                          <?php }else{ ?>
                            <div class="price nor10p">
                            <?php echo number_format($normal_price, 0, '.', ','); ?>
                            <span> <?php echo get_woocommerce_currency_symbol(); ?></span>
                          </div>
                          <?php } ?>
                          <?php }else{ ?>
                            <div><?php
                            $price_v = $product->get_price_html(); 
                            echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);?>
                            </div><?php
                          } 
                          ?>
                          <?php }else
                          {
                            ?>
                            <div class="mt-p10"></div>
                            <?php
                          }?>
                              <?php if(empty($normal_price) ) { ?>
                              <div class="mt-p101"></div>
                              <?php } ?>
                            <h2>
                              <a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a>
                            </h2>
                            <?php if(!empty($normal_price) ) { ?>
                            <?php if("instock"==$stocka){ ?>
                            <button type="button" class="add-to-cart single_add_to_cart_button position-relative cart11" value="<?php echo $pr_id; ?>">
                              <span> + </span>
                              <span> افزودن به سبد خرید </span>
                            </button>
                            <?php }
                            } ?>
                          </div>
                        </div>

                      </div>
            <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
                  
                  ?>
              <?php }elseif('all'===$settings['pproductscarouselfourthstkaveh']){
                // WP_Query args
            $ordvalue = $settings['psortproductscarouselfourthstkaveh'];
            $ordi = $settings['psortiproductscarouselfourthstkaveh'];
            $q_pc4_query_args = array(
              'post_type' => array('product'),
              'posts_per_page' => $settings['productnumberproductscarouselfourthstkaveh'],
              'order' => $ordi,
              'orderby' => 'meta_value_num',
              'meta_key'       => $ordvalue,
              'meta_query' => array(
                array(
                    'key' => '_stock_status',
                    'value' => 'outofstock',
                    'compare' => 'NOT IN',
                ),
               ),
             
            );

            // The Query
            $pc4_query = new \WP_Query($q_pc4_query_args);

            // The Loop
            if ( $pc4_query->have_posts() ) {
              while ( $pc4_query->have_posts() ) {
                $pc4_query->the_post();
                global $product;
                $sale_price= $product->get_sale_price();
                $normal_price= $product->get_regular_price();
                $pr_id = get_the_ID();
                $stocka=$product->get_stock_status(); ?> 
        <div class="swiper-slide">
        <div class="product product-ten">
                          <div class="product-image">
                          <?php
                          if("instock"!=$stocka){ ?>
                            <div class="status">
                              ناموجود
                            </div>
                            <?php } ?>
                            <a href="<?php the_permalink(); ?>">
                              <img src="<?php the_post_thumbnail_url('medium'); ?>" alt="<?php the_title(); ?>">
                            </a>
                          </div>
                          <div class="detail">
                          <?php if("instock"==$stocka){ ?>
                          <?php if ( !$product->is_type( 'variable' ) ) { ?>
                          <?php if(!empty($sale_price) ) { ?>
                          <div class="offer">
                            <?php echo $normal_price; ?>
                          </div>
                          <div class="price">
                            <?php echo number_format($sale_price, 0, '.', ','); ?>
                            <span> <?php echo get_woocommerce_currency_symbol(); ?> </span>
                          </div>
                          <?php }else{ ?>
                            <div class="price nor10p">
                            <?php echo number_format($normal_price, 0, '.', ','); ?>
                            <span> <?php echo get_woocommerce_currency_symbol(); ?></span>
                          </div>
                          <?php } ?>
                          <?php }else{ ?>
                            <div><?php
                            $price_v = $product->get_price_html(); 
                            echo str_replace("&ndash;","<span class=\"dashvar\"> – </span>", $price_v);?>
                            </div><?php
                          } 
                          ?>
                          <?php }else
                          {
                            ?>
                            <div class="mt-p10"></div>
                            <?php
                          }?>
                              <?php if(empty($normal_price) ) { ?>
                              <div class="mt-p101"></div>
                              <?php } ?>
                            <h2>
                              <a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a>
                            </h2>
                            <?php if(!empty($normal_price) ) { ?>
                            <?php if("instock"==$stocka){ ?>
                            <button type="button" class="add-to-cart single_add_to_cart_button position-relative cart11" value="<?php echo $pr_id; ?>">
                              <span> + </span>
                              <span> افزودن به سبد خرید </span>
                            </button>
                            <?php }
                            } ?>
                          </div>
                        </div>
                </div>
                <?php
                // Reset Original Post Data
                  wp_reset_postdata();
                }
              }
                  
                  ?>
                <?php } ?>
            </div>
          <?php if('yes'===$settings['showarrowsproductscarouselfourthstkaveh']){ ?>
          <div class="swiper-button-next"></div>
          <div class="swiper-button-prev"></div>
          <?php } ?>
        </div>
      </div>
    </section>
    <style>
      <?php echo '.elementor-element-' . $clsid . ''; ?> .new-products-category-title::after, .new-products-category-title::before {
    background-repeat: no-repeat !important;    
}
<?php echo '.elementor-element-' . $clsid . ''; ?> .new-products-category-title {
    background-size: cover !important;

} 
<?php echo '.elementor-element-' . $clsid . ''; ?> .new-products-category-title::after, .new-products-category-title::before {
  -webkit-background-size: contain !important;
    -moz-background-size: contain !important;
    -o-background-size: contain !important;
    background-size: contain !important;
    object-fit: cover ;
}
    </style>

<script>
   function init<?php echo $clsid; ?>() {
  // Swiper New Products Category
  new Swiper(".swiper-new-products-category", {
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    breakpoints: {
      320: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3productscarouselfourthstkaveh']); ?>,
        spaceBetween: 0,
      },
      576: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn2productscarouselfourthstkaveh']); ?>,
        spaceBetween: 0,
      },
      768: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn2productscarouselfourthstkaveh']); ?>,
        spaceBetween: 0,
      },
      992: {
        slidesPerView: <?php echo  esc_html($settings['productcolumnproductscarouselfourthstkaveh']); ?>,
        spaceBetween: 0,
      },
    },
  });
}
      if (window.Swiper) {
    // Swiper library already loaded, initialize Swiper instance
    init<?php echo $clsid; ?>();
  } else {
    // Swiper library not yet loaded, wait for it to load
    window.addEventListener("load", function() {
      init<?php echo $clsid; ?>();
    });
  }
</script>
    <?php
  }


}
