<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Priceboxkaveh extends Widget_Base{

  public function get_name(){
    return 'priceboxkaveh';
  }

  public function get_title(){
    return esc_html__( 'جدول قیمت کاوه', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentpriceboxkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'stylepriceboxkaveh',
        [
          'label' => esc_html__( 'استایل باکس', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'one',
          'options' => [
            'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
            'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),

          ],
        ]
        );
      $this->add_control(
        'titlepriceboxkaveh',
        [
          'label' => esc_html__( 'عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => 'سری بازی یک',
  
        ]
      );
      $this->add_control(
        'tagheadingpriceboxkaveh',
        [
          'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'H3',
          'options' => [
            'H1'  => esc_html__( 'H1', 'kaveh-core' ),
            'H2' => esc_html__( 'H2', 'kaveh-core' ),
            'H3' => esc_html__( 'H3', 'kaveh-core' ),
            'H4' => esc_html__( 'H4', 'kaveh-core' ),
            'H5' => esc_html__( 'H5', 'kaveh-core' ),
            'H6' => esc_html__( 'H6', 'kaveh-core' ),
            'p' => esc_html__( 'p', 'kaveh-core' ),
            'div' => esc_html__( 'div', 'kaveh-core' ),
            'span' => esc_html__( 'span', 'kaveh-core' ),
          ],
        ]
      );
      $this->add_control(
        'activepriceboxkaveh',
        [
          'label' => esc_html__( 'آیا فعال باشد؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'label_on' => esc_html__( 'فعال', 'kaveh-core' ),
          'label_off' => esc_html__( 'ساده', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'no',
        ]
      );
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
      'title1priceboxkaveh',
      [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Fifa 2022',

      ]
    );
    $this->add_control(
      'listpriceboxkaveh',
      [
        'label' => esc_html__( 'ویژگی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'title1priceboxkaveh' => esc_html__( 'Fifa 2022', 'kaveh-core' ),
          ],
      ]
      ]
    
    );  
    $this->add_control(
      'pricepriceboxkaveh',
      [
        'label' => esc_html__( 'قیمت', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '۷٫۹۹۰٫۰۰۰',

      ]
    );
    $this->add_control(
      '1pricepriceboxkaveh',
      [
        'label' => esc_html__( 'پیش از واحد', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'هزار',

      ]
    );
    $this->add_control(
      '2pricepriceboxkaveh',
      [
        'label' => esc_html__( 'واحد پولی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'تومان',

      ]
    );
    $this->add_control(
      'buttonpriceboxkaveh',
      [
        'label' => esc_html__( 'متن دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'خرید',

      ]
    );
    $this->add_control(
      'buttonlinkpriceboxkaveh',
      [
        'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',

      ]
    );
       $this->end_controls_section();
       $this->start_controls_section(
        'content2priceboxkaveh',
        [
          'label' => esc_html__( 'تصویر', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                  'condition' => [
                    'stylepriceboxkaveh' => 'two',
                  ],
        ]
      );
      $this->add_control(
        'imgpriceboxkaveh',
        [
          'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'selectors' => [
            '{{WRAPPER}} .sale-ready-cases-item::after' =>
                'background: url({{URL}})',
        ],
          'condition' => [
            'stylepriceboxkaveh' => 'two',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style_priceboxkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolor2priceboxkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .readycase .readyti' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title2_priceboxkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .readycase .readyti',
        ]
      );

      $this->add_control(
        'textcolor3priceboxkaveh',
        [
          'label' => esc_html__( 'رنگ ویژگی ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .readycase ul li' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title21_priceboxkaveh',
          'label' => esc_html__( 'تایپوگرافی ویژگی ها', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .readycase ul li',
        ]
      );
      $this->add_control(
        'hr1priceboxkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'textpricecolor3priceboxkaveh',
        [
          'label' => esc_html__( 'رنگ قیمت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'stylepriceboxkaveh' => 'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .readycase .price' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titleprice_priceboxkaveh',
          'label' => esc_html__( 'تایپوگرافی قیمت', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .readycase .price',
          'condition' => [
            'stylepriceboxkaveh' => 'one',
          ],
        ]
      );
      $this->add_control(
        'textpricecolor2priceboxkaveh',
        [
          'label' => esc_html__( 'رنگ قیمت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'stylepriceboxkaveh' => 'two',
          ],
          'selectors' => [
            '{{WRAPPER}} .sale-ready-cases-item .price > span' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titleprice2_priceboxkaveh',
          'label' => esc_html__( 'تایپوگرافی قیمت', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .sale-ready-cases-item .price > span',
          'condition' => [
            'stylepriceboxkaveh' => 'two',
          ],
        ]
      );

      $this->add_control(
        'textcurrencycolor3priceboxkaveh',
        [
          'label' => esc_html__( 'رنگ واحد پولی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .readycase .price > div' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlecurrency_priceboxkaveh',
          'label' => esc_html__( 'تایپوگرافی واحد پولی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .readycase .price > div',
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style2_priceboxkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_priceboxkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .readycase .btn',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowpriceboxkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .readycase .btn',
        ]
      );
      $this->start_controls_tabs(
        'style_tabspriceboxkaveh'
      );

      $this->start_controls_tab(
        'style_normal_tabpriceboxkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorpriceboxkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .readycase .btn' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorpriceboxkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .readycase .btn' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiuspriceboxkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .readycase .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderpriceboxkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .readycase .btn',
        ]
      );
      $this->add_control(
        'buttonborderspriceboxkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderpriceboxkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .readycase .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabpriceboxkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoverpriceboxkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .readycase .btn:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoverpriceboxkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .readycase .btn:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoverpriceboxkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .readycase .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoverpriceboxkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .readycase .btn:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoverpriceboxkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoverpriceboxkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .readycase .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowpriceboxkavehh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .readycase .btn',
        ]
      );
      $this->add_control(
        'hr2priceboxkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingpriceboxkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .readycase .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
      $this->start_controls_section(
        'style3_priceboxkaveh',
        [
          'label' => esc_html__( 'استایل باکس', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'stylepriceboxkaveh' => 'one',
          ],
        ]
      );
      $this->add_control(
        'firstcolorbox1priceboxkaveh',
        [
          'label' => esc_html__( 'رنگ اول پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
        ]
      ); 
      $this->end_controls_section();
      $this->start_controls_section(
        'style4_priceboxkaveh',
        [
          'label' => esc_html__( 'استایل باکس', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'stylepriceboxkaveh' => 'two',
          ],
        ]
      );
      $this->start_controls_tabs(
        'stylebox2_tabspriceboxkaveh'
      );
      
      $this->start_controls_tab(
        'stylebox2_tabpriceboxkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'firstcolorbox2priceboxkaveh',
        [
          'label' => esc_html__( 'رنگ اول پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
        ]
      ); 
      
      $this->end_controls_tab();
      $this->start_controls_tab(
        'styleboxhove2_tabpriceboxkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'firstcolorbox2hover1priceboxkaveh',
        [
          'label' => esc_html__( 'رنگ اول پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
        ]
      ); 
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->end_controls_section();
      
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
             <?php if('one'===$settings['stylepriceboxkaveh']){ ?>
          <div class="ready-cases-item readycase <?php if("yes"===$settings['activepriceboxkaveh']){?>active<?php } ?> position-relative">
              <<?php echo  esc_attr($settings['tagheadingpriceboxkaveh']); ?> class="text-center readyti"><?php echo  esc_html($settings['titlepriceboxkaveh']); ?></<?php echo  esc_attr($settings['tagheadingpriceboxkaveh']); ?>>
              <ul class="text-center text-white position-relative">
              <?php
              if ( $settings['listpriceboxkaveh'] ) {
              foreach (  $settings['listpriceboxkaveh'] as $item ) {
              ?>
                <li> <?php echo  esc_html($item['title1priceboxkaveh']); ?> </li>
                <?php 
            }
              }
            ?>
              </ul>
              <div class="price d-flex align-items-center justify-content-center">
              <?php echo  esc_html($settings['pricepriceboxkaveh']); ?>
                <div>
                <?php echo  esc_html($settings['1pricepriceboxkaveh']); ?>
                  <span class="d-block"><?php echo  esc_html($settings['2pricepriceboxkaveh']); ?></span>
                </div>
              </div>
              <a href="<?php echo  esc_html($settings['buttonlinkpriceboxkaveh']); ?>" class="btn btn-purple w-100 d-block mx-auto"><?php echo  esc_html($settings['buttonpriceboxkaveh']); ?></a>
          </div>
          <style>
            <?php echo '.elementor-element-' . $clsid . ''; ?> .ready-cases-item::before {
            background-image: -webkit-linear-gradient(top, <?php echo  esc_html($settings['firstcolorbox1priceboxkaveh']); ?>, rgba(29, 30, 57, 0.22), rgba(33, 35, 65, 0)) !important;
            background-image: -moz-linear-gradient(top, <?php echo  esc_html($settings['firstcolorbox1priceboxkaveh']); ?>, rgba(29, 30, 57, 0.22), rgba(33, 35, 65, 0)) !important;
            background-image: -o-linear-gradient(top, <?php echo  esc_html($settings['firstcolorbox1priceboxkaveh']); ?>, rgba(29, 30, 57, 0.22), rgba(33, 35, 65, 0)) !important;
            background-image: linear-gradient(to bottom, <?php echo  esc_html($settings['firstcolorbox1priceboxkaveh']); ?>, rgba(29, 30, 57, 0.22), rgba(33, 35, 65, 0)) !important;
        }
          </style>
          <?php }elseif('two'===$settings['stylepriceboxkaveh']){?>
            <div class="sale-ready-cases-item readycase <?php if("yes"===$settings['activepriceboxkaveh']){?>active<?php } ?> position-relative">
              <<?php echo  esc_attr($settings['tagheadingpriceboxkaveh']); ?> class="text-center mb-0 readyti"><?php echo  esc_html($settings['titlepriceboxkaveh']); ?></<?php echo  esc_attr($settings['tagheadingpriceboxkaveh']); ?>>
              <ul class="text-white text-center position-relative">
                  <?php
                  if ( $settings['listpriceboxkaveh'] ) {
                  foreach (  $settings['listpriceboxkaveh'] as $item ) {
                  ?>
                    <li> <?php echo  esc_html($item['title1priceboxkaveh']); ?> </li>
                    <?php 
                }
                  }
                ?>
              </ul>
              <div class="price d-flex align-items-center justify-content-center mb-4">
                <span>  <?php echo  esc_html($settings['pricepriceboxkaveh']); ?></span>
                <div>
                <?php echo  esc_html($settings['1pricepriceboxkaveh']); ?>
                  <span class="d-block"> <?php echo  esc_html($settings['2pricepriceboxkaveh']); ?> </span>
                </div>
              </div>
              <a href="<?php echo  esc_html($settings['buttonlinkpriceboxkaveh']); ?>" class="btn btn-purple d-block mx-auto"><?php echo  esc_html($settings['buttonpriceboxkaveh']); ?></a>
            </div>
            <style>
             <?php echo '.elementor-element-' . $clsid . ''; ?> .sale-ready-cases-item::after {
              -webkit-background-size: cover !important;
              -moz-background-size: cover !important;
              -o-background-size: cover !important;
              background-size:  cover !important;
              object-fit: cover !important;
                }
                <?php echo '.elementor-element-' . $clsid . ''; ?> .sale-ready-cases-item.active::before {
                background-image: -webkit-linear-gradient(top, <?php echo  esc_html($settings['firstcolorbox2hover1priceboxkaveh']); ?>, <?php echo  esc_html($settings['firstcolorbox2hover1priceboxkaveh']); ?>, rgba(33, 35, 65, 0) 90%) !important;
                background-image: -moz-linear-gradient(top, <?php echo  esc_html($settings['firstcolorbox2hover1priceboxkaveh']); ?>, <?php echo  esc_html($settings['firstcolorbox2hover1priceboxkaveh']); ?>, rgba(33, 35, 65, 0) 90%) !important;
                background-image: -o-linear-gradient(top, <?php echo  esc_html($settings['firstcolorbox2hover1priceboxkaveh']); ?>, <?php echo  esc_html($settings['firstcolorbox2hover1priceboxkaveh']); ?>, rgba(33, 35, 65, 0) 90%) !important;
                background-image: linear-gradient(to bottom, <?php echo  esc_html($settings['firstcolorbox2hover1priceboxkaveh']); ?>, <?php echo  esc_html($settings['firstcolorbox2hover1priceboxkaveh']); ?>, rgba(33, 35, 65, 0) 90%) !important;
            }
            <?php echo '.elementor-element-' . $clsid . ''; ?> .sale-ready-cases-item::before {
            background-image: -webkit-linear-gradient(top, <?php echo  esc_html($settings['firstcolorbox2priceboxkaveh']); ?>, rgba(29, 30, 57, 0.22), rgba(33, 35, 65, 0)) !important;
            background-image: -moz-linear-gradient(top, <?php echo  esc_html($settings['firstcolorbox2priceboxkaveh']); ?>, rgba(29, 30, 57, 0.22), rgba(33, 35, 65, 0)) !important;
            background-image: -o-linear-gradient(top, <?php echo  esc_html($settings['firstcolorbox2priceboxkaveh']); ?>, rgba(29, 30, 57, 0.22), rgba(33, 35, 65, 0)) !important;
            background-image: linear-gradient(to bottom, <?php echo  esc_html($settings['firstcolorbox2priceboxkaveh']); ?>, rgba(29, 30, 57, 0.22), rgba(33, 35, 65, 0)) !important;
            }
            <?php echo '.elementor-element-' . $clsid . ''; ?> .row .sale-ready-cases-item:hover::before {
              background-image: -webkit-linear-gradient(top, <?php echo  esc_html($settings['firstcolorbox2hover1priceboxkaveh']); ?>, <?php echo  esc_html($settings['firstcolorbox2hover1priceboxkaveh']); ?>, rgba(33, 35, 65, 0) 90%) !important;
                background-image: -moz-linear-gradient(top, <?php echo  esc_html($settings['firstcolorbox2hover1priceboxkaveh']); ?>, <?php echo  esc_html($settings['firstcolorbox2hover1priceboxkaveh']); ?>, rgba(33, 35, 65, 0) 90%) !important;
                background-image: -o-linear-gradient(top, <?php echo  esc_html($settings['firstcolorbox2hover1priceboxkaveh']); ?>, <?php echo  esc_html($settings['firstcolorbox2hover1priceboxkaveh']); ?>, rgba(33, 35, 65, 0) 90%) !important;
                background-image: linear-gradient(to bottom, <?php echo  esc_html($settings['firstcolorbox2hover1priceboxkaveh']); ?>, <?php echo  esc_html($settings['firstcolorbox2hover1priceboxkaveh']); ?>, rgba(33, 35, 65, 0) 90%) !important;
            }
            </style>
          <?php } ?>

    <?php
  }


}
