<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Loginandsignupkaveh extends Widget_Base{

  public function get_name(){
    return 'loginandsignupkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان حساب کاربری', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['headerfooterkavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentloginandsignupkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'styleboxloginandsignupkaveh',
        [
          'label' => esc_html__( 'طرح بندی المان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'one',
          'options' => [
            'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
            'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
            'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
            'four'  => esc_html__( 'طرح بندی چهار', 'kaveh-core' ),
            'five'  => esc_html__( 'طرح بندی پنج', 'kaveh-core' ),
          ],
        ]
        ); 
      $this->add_control(
          'titleloginandsignupkaveh',
          [
              'label' => esc_html__( 'متن', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => esc_html__( 'ورود/ثبت نام', 'kaveh-core' ),
              'condition' => [
                'styleboxloginandsignupkaveh!' => ['four','five'],
              ],
      
          ]
      ); 
      $this->add_control(
        'title2loginandsignupkaveh',
        [
            'label' => esc_html__( 'متن نگهدارنده سرج', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'جستجو...', 'kaveh-core' ),
            'condition' => [
              'styleboxloginandsignupkaveh' =>'three',
            ],

    
        ]
    ); 
    $this->add_control(
      'iconele4loginandsignupkave',
      [
        'label' => esc_html__( 'آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'condition' => [
          'styleboxloginandsignupkaveh' => ['four','five'],
        ],
        'default' => [
          'value' => 'icon-user-circle',
          'library' => 'fa-solid',
        ],
      ]
    );
      $this->add_control(
        'showiconbeforeloginandsignupkaveh',
        [
          'label' => esc_html__( 'نمایش آیکون قبل از نوشته؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' => 'one',
          ],
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
          $this->add_control(
            'iconeleloginandsignupkave',
            [
              'label' => esc_html__( 'آیکون', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::ICONS,
              'skin' => 'inline',
              'exclude_inline_options' => [ 'svg' ],
              'condition' => [
                'showiconbeforeloginandsignupkaveh' => 'yes',
                'styleboxloginandsignupkaveh' => 'one',
              ],
              'default' => [
                'value' => 'icon-user-circle',
                'library' => 'fa-solid',
              ],
            ]
          );
          $this->add_control(
            'showiconafterloginandsignupkaveh',
            [
              'label' => esc_html__( 'نمایش آیکون بعد از نوشته؟', 'kaveh-core' ),
              'type' => \Elementor\Controls_Manager::SWITCHER,
              'yes' => esc_html__( 'بله', 'kaveh-core' ),
              'no' => esc_html__( 'خیر', 'kaveh-core' ),
              'condition' => [
                'styleboxloginandsignupkaveh' => ['one', 'two'],
              ],
              'return_value' => 'yes',
              'default' => 'yes',
            ]
          );
              $this->add_control(
                'iconeleafterloginandsignupkave',
                [
                  'label' => esc_html__( 'Icon', 'kaveh-core' ),
                  'type' => \Elementor\Controls_Manager::ICONS,
                  'skin' => 'inline',
                  'exclude_inline_options' => [ 'svg' ],
                  'condition' => [
                    'showiconafterloginandsignupkaveh' => 'yes',
                    'styleboxloginandsignupkaveh' => ['one', 'two'],

                  ],
                  'default' => [
                    'value' => 'icon-angle-left',
                    'library' => 'fa-solid',
                  ],
                ]
              );
       $this->end_controls_section();
       $this->start_controls_section(
        'styleloginandsignupkave',
        [
          'label' => esc_html__( 'استایل', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'iconsize11loginandsignupkaveh',
        [
          'label' => esc_html__( 'سایز آیکون قبل از نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
            'showiconbeforeloginandsignupkaveh' => 'yes',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 24,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a i:first-child' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_loginandsignupkaveh',
          'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),          
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'selector' => '{{WRAPPER}} .top-header-auth > a',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button2_loginandsignupkaveh',
          'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),          
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'selector' => '{{WRAPPER}} .top-header-eight .top-header-auth > a',
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button3_loginandsignupkaveh',
          'label' => esc_html__( 'تایپوگرافی متن', 'kaveh-core' ),          
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selector' => '{{WRAPPER}} .top-header-nine .top-header-auth > a',
        ]
      );
      $this->add_control(
        'iconsize12loginandsignupkaveh',
        [
          'label' => esc_html__( 'سایز آیکون بعد از نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
            'showiconafterloginandsignupkaveh' => 'yes',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 11,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a i:last-child' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconsize2loginandsignupkaveh',
        [
          'label' => esc_html__( 'سایز آیکون بعد از نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
            'showiconafterloginandsignupkaveh' => 'yes',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 11,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eight .top-header-auth > a i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconsize3loginandsignupkaveh',
        [
          'label' => esc_html__( 'سایز آیکون بعد از نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 16,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-four-btn-search' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconsize4loginandsignupkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'four',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 28,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-twelve .top-header-auth > a i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconsize5loginandsignupkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 22,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'width1loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 174,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'width3loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض بخش نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 126,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-auth > a' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'width31loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 172,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'width5loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 50,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'height1loginandsignupkaveh',
        [
          'label' => esc_html__( 'ارتفاع دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 50,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'height3loginandsignupkaveh',
        [
          'label' => esc_html__( 'ارتفاع دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 40,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-auth > a' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'height5loginandsignupkaveh',
        [
          'label' => esc_html__( 'ارتفاع دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 68,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabsloginandsignupkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabloginandsignupkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
        ]
      );
      $this->add_control(
        'icon11buttoncolorloginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون قبل از نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
            'showiconbeforeloginandsignupkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a i:first-child' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'textbuttoncolorloginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'icon12buttoncolorloginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون بعد از نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
            'showiconafterloginandsignupkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a i:last-child' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorloginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiusloginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده  ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderloginandsignupkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'selector' => '{{WRAPPER}} .top-header-auth > a',
        ]
      );
      $this->add_control(
        'buttonbordersloginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderloginandsignupkaveh!' => '',
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabloginandsignupkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
        ]
      );
      $this->add_control(
        'icon11buttonhovercolorloginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون قبل از نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
            'showiconbeforeloginandsignupkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a:hover i:first-child' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'textbuttoncolorhoverloginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'icon12buttonhovercolorloginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون بعد از نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
            'showiconafterloginandsignupkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a:hover i:last-child' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoverloginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoverloginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoverloginandsignupkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'selector' => '{{WRAPPER}} .top-header-auth > a:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoverloginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoverloginandsignupkaveh!' => '',
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-auth > a:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hrerloginandsignupkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow1loginandsignupkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'one',
          ],
          'selector' => '{{WRAPPER}} .top-header-auth > a',
        ]
      );



      $this->start_controls_tabs(
        'style_tabs2loginandsignupkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tab2loginandsignupkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
        ]
      );
      $this->add_control(
        'textbuttoncolor2loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eight .top-header-auth > a' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'icon12buttoncolor2loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون بعد از نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
            'showiconafterloginandsignupkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eight .top-header-auth > a i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolor21loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ اول پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolor22loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ دوم پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradius2loginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده  ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eight .top-header-auth > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border2loginandsignupkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'selector' => '{{WRAPPER}} .top-header-eight .top-header-auth > a',
        ]
      );
      $this->add_control(
        'buttonborders2loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border2loginandsignupkaveh!' => '',
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eight .top-header-auth > a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tab2loginandsignupkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
        ]
      );
      $this->add_control(
        'textbuttoncolorhover2loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eight .top-header-auth > a:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'icon12buttonhovercolor2loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون بعد از نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
            'showiconafterloginandsignupkaveh' => 'yes',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eight .top-header-auth > a:hover i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhover21loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ اول پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhover22loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ دوم پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushover2loginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده  ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eight .top-header-auth > a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhover2loginandsignupkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'selector' => '{{WRAPPER}} .top-header-eight .top-header-auth > a:hover',
        ]
      );
      $this->add_control(
        'buttonbordershover2loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhover2loginandsignupkaveh!' => '',
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eight .top-header-auth > a:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hrer2loginandsignupkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow12loginandsignupkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'selector' => '{{WRAPPER}} .top-header-eight .top-header-auth > a',
        ]
      );
      $this->add_control(
        'buttonpadding2loginandsignupkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'two',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-eight .top-header-auth > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->start_controls_tabs(
        'style_tabs3loginandsignupkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tab3loginandsignupkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
        ]
      );
      $this->add_control(
        'textbuttoncolor3loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-auth > a' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolor211loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-auth > a' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'icon12buttoncolor3loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-four-btn-search' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      
      $this->add_control(
        'buttoncolor23loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine-auth-search' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolor24loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-auth > a' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradius3loginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-auth > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'buttonradius32loginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine-auth-search' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border3loginandsignupkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selector' => '{{WRAPPER}} .top-header-nine-auth-search',
        ]
      );
      $this->add_control(
        'buttonborders3loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border3loginandsignupkaveh!' => '',
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine-auth-search' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tab3loginandsignupkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
        ]
      );
      $this->add_control(
        'textbuttoncolorhover3loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-auth > a:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'icon12buttonhovercolor3loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-four-btn-search:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhover23loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine-auth-search:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhover211loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ  پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-auth > a:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushover3loginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه نوشته', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine .top-header-auth > a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'buttonradius32hoverloginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine-auth-search:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhover3loginandsignupkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selector' => '{{WRAPPER}} .top-header-nine-auth-search:hover',
        ]
      );
      $this->add_control(
        'buttonbordershover3loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhover3loginandsignupkaveh!' => '',
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-nine-auth-search:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hrer3loginandsignupkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow13loginandsignupkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'three',
          ],
          'selector' => '{{WRAPPER}} .top-header-nine-auth-search',
        ]
      );
      $this->start_controls_tabs(
        'style_tabs4loginandsignupkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tab4loginandsignupkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'four',
          ],
        ]
      );
      $this->add_control(
        'icon12buttoncolor4loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'four',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-twelve .top-header-auth > a i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tab4loginandsignupkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'four',
          ],
        ]
      );
      $this->add_control(
        'icon12buttonhovercolor4loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'four',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-twelve .top-header-auth > a:hover i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hrer4loginandsignupkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'four',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow14loginandsignupkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'four',
          ],
          'selector' => '{{WRAPPER}} .top-header-twelve .top-header-auth > a',
        ]
      );
      $this->start_controls_tabs(
        'style_tabs5loginandsignupkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tab5loginandsignupkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
        ]
      );
      $this->add_control(
        'icon12buttoncolor5loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      
      $this->add_control(
        'buttoncolor25loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradius5loginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border5loginandsignupkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'selector' => '{{WRAPPER}} .top-header-fourteen .top-header-auth > a',
        ]
      );
      $this->add_control(
        'buttonborders5loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'border5loginandsignupkaveh!' => '',
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tab5loginandsignupkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
        ]
      );
      $this->add_control(
        'icon12buttonhovercolor5loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a:hover i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhover25loginandsignupkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushover5loginandsignupkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhover5loginandsignupkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'selector' => '{{WRAPPER}} .top-header-fourteen .top-header-auth > a:hover',
        ]
      );
      $this->add_control(
        'buttonbordershover5loginandsignupkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhover5loginandsignupkaveh!' => '',
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-fourteen .top-header-auth > a:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hrer5loginandsignupkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow15loginandsignupkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'condition' => [
            'styleboxloginandsignupkaveh' =>'five',
          ],
          'selector' => '{{WRAPPER}} .top-header-fourteen .top-header-auth > a',
        ]
      );
      $this->end_controls_section();
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
  
?>
    <?php if('one'===$settings['styleboxloginandsignupkaveh']){ ?>
      <div class="top-header-auth align-self-center">
          <a <?php if( !is_user_logged_in() ): ?> onclick="showPopup()" <?php else: ?> href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>"<?php endif; ?> class="btn p-0">
          <?php if('yes'===$settings['showiconbeforeloginandsignupkaveh']){ ?>
            <i class="<?php echo  esc_attr($settings['iconeleloginandsignupkave']['value']); ?>"></i>
            <?php } ?>
            <span><?php if( !is_user_logged_in() ): echo esc_html($settings['titleloginandsignupkaveh']); else: echo 'حساب کاربری من'; endif; ?></span>
            <?php if('yes'===$settings['showiconafterloginandsignupkaveh']){ ?>
            <i class="<?php echo  esc_attr($settings['iconeleafterloginandsignupkave']['value']); ?>"></i>
            <?php } ?>         
           </a>
          <?php if( is_user_logged_in() ): 
          $current_user = wp_get_current_user();  
          $display_name = $current_user->display_name;
          $orders_url = wc_get_endpoint_url( 'orders', '', wc_get_page_permalink( 'myaccount' ) );
          $profile_url = wc_get_endpoint_url( 'edit-account', '', wc_get_page_permalink( 'myaccount' ) );
          $avatar_url = get_avatar_url( wp_get_current_user()->user_email);
          ?>
          <ul class="top-header-auth-dropdown">
            <li>
            <img class="rounded-circle profimg" src="<?php echo $avatar_url; ?>" alt="">
              <?php echo $display_name; ?>
            </li>
            <li>
              <a href="<?php echo $orders_url; ?>"> سفارش ها </a>
            </li>
            <li>
              <a href="<?php echo $profile_url; ?>"> پروفایل کاربری</a>
            </li>
           
            <li>
              <a href="<?php echo wp_logout_url( home_url() ); ?>"> خروج از حساب کاربری </a>
            </li>
          </ul>
          <?php endif; ?>
      </div>
       
    <?php }elseif('two'===$settings['styleboxloginandsignupkaveh']){ ?>
    <div class="top-header-eight">
      <div class="top-header-auth top-header-three-auth ms-sm-auto">
          <a <?php if( !is_user_logged_in() ): ?> onclick="showPopup()" <?php else: ?> href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>"<?php endif; ?>>
            <span class="d-none d-sm-inline-block"><?php if( !is_user_logged_in() ): echo esc_html($settings['titleloginandsignupkaveh']); else: echo 'حساب کاربری من'; endif; ?></span>
            <?php if('yes'===$settings['showiconafterloginandsignupkaveh']){ ?>
            <i class="<?php echo  esc_attr($settings['iconeleafterloginandsignupkave']['value']); ?> d-none d-sm-inline-block"></i>
            <?php } ?>   
          </a>
          <?php if( is_user_logged_in() ): 
          $current_user = wp_get_current_user();  
          $display_name = $current_user->display_name;
          $orders_url = wc_get_endpoint_url( 'orders', '', wc_get_page_permalink( 'myaccount' ) );
          $profile_url = wc_get_endpoint_url( 'edit-account', '', wc_get_page_permalink( 'myaccount' ) );
          $avatar_url = get_avatar_url( wp_get_current_user()->user_email);
          ?>
          <ul class="top-header-auth-dropdown">
            <li>
            <img class="rounded-circle profimg" src="<?php echo $avatar_url; ?>" alt="">
              <?php echo $display_name; ?>
            </li>
            <li>
              <a href="<?php echo $orders_url; ?>"> سفارش ها </a>
            </li>
            <li>
              <a href="<?php echo $profile_url; ?>"> پروفایل کاربری</a>
            </li>
           
            <li>
              <a href="<?php echo wp_logout_url( home_url() ); ?>"> خروج از حساب کاربری </a>
            </li>
          </ul>
          <?php endif; ?>
        </div>
        </div>
        <style>
          <?php echo '.elementor-element-' . $clsid . ''; ?> .top-header-eight .top-header-auth > a {
          background-image: -webkit-linear-gradient(left, <?php echo  esc_html($settings['buttoncolor21loginandsignupkaveh']); ?>, <?php echo  esc_html($settings['buttoncolor22loginandsignupkaveh']); ?>);
          background-image: -moz-linear-gradient(left, <?php echo  esc_html($settings['buttoncolor21loginandsignupkaveh']); ?>, <?php echo  esc_html($settings['buttoncolor22loginandsignupkaveh']); ?>);
          background-image: -o-linear-gradient(left, <?php echo  esc_html($settings['buttoncolor21loginandsignupkaveh']); ?>, <?php echo  esc_html($settings['buttoncolor22loginandsignupkaveh']); ?>);
          background-image: linear-gradient(to right, <?php echo  esc_html($settings['buttoncolor21loginandsignupkaveh']); ?>, <?php echo  esc_html($settings['buttoncolor22loginandsignupkaveh']); ?>);
          }
          <?php echo '.elementor-element-' . $clsid . ''; ?> .top-header-eight .top-header-auth > a:hover {
          background-image: -webkit-linear-gradient(left, <?php echo  esc_html($settings['buttoncolorhover21loginandsignupkaveh']); ?>, <?php echo  esc_html($settings['buttoncolorhover22loginandsignupkaveh']); ?>);
          background-image: -moz-linear-gradient(left, <?php echo  esc_html($settings['buttoncolorhover21loginandsignupkaveh']); ?>, <?php echo  esc_html($settings['buttoncolorhover22loginandsignupkaveh']); ?>);
          background-image: -o-linear-gradient(left, <?php echo  esc_html($settings['buttoncolorhover21loginandsignupkaveh']); ?>, <?php echo  esc_html($settings['buttoncolorhover22loginandsignupkaveh']); ?>);
          background-image: linear-gradient(to right, <?php echo  esc_html($settings['buttoncolorhover21loginandsignupkaveh']); ?>, <?php echo  esc_html($settings['buttoncolorhover22loginandsignupkaveh']); ?>);
          }
        </style>
    <?php }elseif('three'===$settings['styleboxloginandsignupkaveh']){ ?>
    <div class="top-header-nine">
      <div class="top-header-nine-auth-search d-flex align-items-center ms-auto">
          <div class="top-header-auth ms-sm-auto ms-lg-0">
            <a <?php if( !is_user_logged_in() ): ?> onclick="showPopup()" <?php else: ?> href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>"<?php endif; ?> class="btn p-0">
              <span><?php if( !is_user_logged_in() ): echo esc_html($settings['titleloginandsignupkaveh']); else: echo 'حساب کاربری من'; endif; ?></span>
              <i class="icon-user-circle d-block d-sm-none m-0"></i>
            </a>
            <?php if( is_user_logged_in() ): 
          $current_user = wp_get_current_user();  
          $display_name = $current_user->display_name;
          $orders_url = wc_get_endpoint_url( 'orders', '', wc_get_page_permalink( 'myaccount' ) );
          $profile_url = wc_get_endpoint_url( 'edit-account', '', wc_get_page_permalink( 'myaccount' ) );
          $avatar_url = get_avatar_url( wp_get_current_user()->user_email);
          ?>
          <ul class="top-header-auth-dropdown">
            <li>
            <img class="rounded-circle profimg" src="<?php echo $avatar_url; ?>" alt="">
              <?php echo $display_name; ?>
            </li>
            <li>
              <a href="<?php echo $orders_url; ?>"> سفارش ها </a>
            </li>
            <li>
              <a href="<?php echo $profile_url; ?>"> پروفایل کاربری</a>
            </li>
           
            <li>
              <a href="<?php echo wp_logout_url( home_url() ); ?>"> خروج از حساب کاربری </a>
            </li>
          </ul>
          <?php endif; ?>
          </div>
          <button type="button" class="top-header-four-btn-search bg-transparent p-0 w-auto h-auto">
            <i class="icon-search"></i>
          </button>
          <div class="top-header-four-search">
            <div class="backdrop"></div>
            <form method="get" action="#" class="position-relative">
              <input id="maninpu<?php echo $clsid; ?>" oninput="fetchData()" oninput="fetchData()" type="text" name="search" class="form-control" placeholder="<?php echo  esc_attr($settings['title2loginandsignupkaveh']); ?>">
              <button type="submit">
                <i class="icon-search"></i>
              </button>
            </form>
          </div>
          <script>
      var theForm<?php echo $clsid; ?> = document.getElementById('manod<?php echo $clsid; ?>');
      var theDiv<?php echo $clsid; ?> = document.getElementById('seeebox<?php echo $clsid; ?>');
      var theInput<?php echo $clsid; ?> = document.getElementById('maninpu<?php echo $clsid; ?>');
      var theOutput<?php echo $clsid; ?> = document.getElementById('keyword<?php echo $clsid; ?>');
      theInput<?php echo $clsid; ?>.oninput = function(rmv){
        theDiv<?php echo $clsid; ?>.classList.remove('d-none');
      };
      function hidePopup<?php echo $clsid; ?>() {
        theDiv<?php echo $clsid; ?>.classList.add('d-none');
      }
      theInput<?php echo $clsid; ?>.addEventListener('input', function (evt) {
        theOutput<?php echo $clsid; ?>.value = theInput<?php echo $clsid; ?>.value;
        theOutput<?php echo $clsid; ?>.focus();
       });
       theOutput<?php echo $clsid; ?>.addEventListener('input', function (evtt) {
        theInput<?php echo $clsid; ?>.value = theOutput<?php echo $clsid; ?>.value;
       });
      theForm<?php echo $clsid; ?>.addEventListener('submit', function(event) {
        event.preventDefault();
      });

    </script>
        </div>
    </div>
    <?php }elseif('four'===$settings['styleboxloginandsignupkaveh']){ ?>
    <div class="top-header-twelve">
      <div class="top-header-auth">
          <a <?php if( !is_user_logged_in() ): ?> onclick="showPopup()" <?php else: ?> href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>"<?php endif; ?> class="top-header-auth btn p-0">
            <i class="<?php echo  esc_attr($settings['iconele4loginandsignupkave']['value']); ?>"></i>
          </a>
          <?php if( is_user_logged_in() ): 
          $current_user = wp_get_current_user();  
          $display_name = $current_user->display_name;
          $orders_url = wc_get_endpoint_url( 'orders', '', wc_get_page_permalink( 'myaccount' ) );
          $profile_url = wc_get_endpoint_url( 'edit-account', '', wc_get_page_permalink( 'myaccount' ) );
          $avatar_url = get_avatar_url( wp_get_current_user()->user_email);
          ?>
          <ul class="top-header-auth-dropdown">
            <li>
            <img class="rounded-circle profimg" src="<?php echo $avatar_url; ?>" alt="">
              <?php echo $display_name; ?>
            </li>
            <li>
              <a href="<?php echo $orders_url; ?>"> سفارش ها </a>
            </li>
            <li>
              <a href="<?php echo $profile_url; ?>"> پروفایل کاربری</a>
            </li>
           
            <li>
              <a href="<?php echo wp_logout_url( home_url() ); ?>"> خروج از حساب کاربری </a>
            </li>
          </ul>
          <?php endif; ?>
        </div>
        </div>
    <?php }elseif('five'===$settings['styleboxloginandsignupkaveh']){ ?>
      <div class="top-header-fourteen">
        <div class="top-header-auth">
            <a <?php if( !is_user_logged_in() ): ?> onclick="showPopup()" <?php else: ?> href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>"<?php endif; ?> class="top-header-auth btn p-0">
              <i class="icon-user-fill"></i>
            </a>
            <?php if( is_user_logged_in() ): 
          $current_user = wp_get_current_user();  
          $display_name = $current_user->display_name;
          $orders_url = wc_get_endpoint_url( 'orders', '', wc_get_page_permalink( 'myaccount' ) );
          $profile_url = wc_get_endpoint_url( 'edit-account', '', wc_get_page_permalink( 'myaccount' ) );
          $avatar_url = get_avatar_url( wp_get_current_user()->user_email);
          ?>
          <ul class="top-header-auth-dropdown">
            <li>
              <img class="rounded-circle profimg" src="<?php echo $avatar_url; ?>" alt="">
              <?php echo $display_name; ?>
            </li>
            <li>
              <a href="<?php echo $orders_url; ?>"> سفارش ها </a>
            </li>
            <li>
              <a href="<?php echo $profile_url; ?>"> پروفایل کاربری</a>
            </li>
           
            <li>
              <a href="<?php echo wp_logout_url( home_url() ); ?>"> خروج از حساب کاربری </a>
            </li>
          </ul>
          <?php endif; ?>
          </div>
        </div>
    <?php }elseif('six'===$settings['styleboxloginandsignupkaveh']){ ?>
      <form method="get" action="#"
          class="top-header-eleven-search d-flex align-items-center position-relative ms-lg-auto rounded-pill w-100 order-5 order-lg-3">
          <select name="category" class="form-control rounded-pill bg-white border-none">
            <option value=""> دسته بندی محصول </option>
            <option value="1"> ابزار برقی </option>
            <option value="2"> ابزار شارژی و لیزری </option>
            <option value="3"> ابزار بادی و باغبانی </option>
            <option value="4"> متعلقات ابزار </option>
          </select>
          <input id="maninpu<?php echo $clsid; ?>" oninput="fetchData()" oninput="fetchData()" type="text" name="search" class="form-control rounded-pill bg-white border-none"
          placeholder="<?php echo  esc_attr($settings['titleloginandsignupkaveh']); ?>" />
          <button type="submit" class="position-absolute top-50 translate-middle-y">
            <i class="icon-search"></i>
          </button>
      </form>
      <script>
      var theForm<?php echo $clsid; ?> = document.getElementById('manod<?php echo $clsid; ?>');
      var theDiv<?php echo $clsid; ?> = document.getElementById('seeebox<?php echo $clsid; ?>');
      var theInput<?php echo $clsid; ?> = document.getElementById('maninpu<?php echo $clsid; ?>');
      var theOutput<?php echo $clsid; ?> = document.getElementById('keyword<?php echo $clsid; ?>');
      theInput<?php echo $clsid; ?>.oninput = function(rmv){
        theDiv<?php echo $clsid; ?>.classList.remove('d-none');
      };
      function hidePopup<?php echo $clsid; ?>() {
        theDiv<?php echo $clsid; ?>.classList.add('d-none');
      }
      theInput<?php echo $clsid; ?>.addEventListener('input', function (evt) {
        theOutput<?php echo $clsid; ?>.value = theInput<?php echo $clsid; ?>.value;
        theOutput<?php echo $clsid; ?>.focus();
       });
       theOutput<?php echo $clsid; ?>.addEventListener('input', function (evtt) {
        theInput<?php echo $clsid; ?>.value = theOutput<?php echo $clsid; ?>.value;
       });
      theForm<?php echo $clsid; ?>.addEventListener('submit', function(event) {
        event.preventDefault();
      });

    </script>
    <?php } ?>
    <!--start search popup -->
    <div id="seeebox<?php echo $clsid; ?>" class="seeebox d-none">
          <div onclick="hidePopup<?php echo $clsid; ?>()" class="backdrop"></div>
          <div class="container position-fixed top-50 start-50 translate-middle">
            <svg onclick="hidePopup<?php echo $clsid; ?>()" class="position-absolute top-0 end-0 bg-porp me-3 mt-3" xmlns="http://www.w3.org/2000/svg" width="38"
              height="12" viewBox="0 0 38 12">
              <g id="Group_4143" data-name="Group 4143" transform="translate(-176 -62)">
                <path id="Arrow_-_Left_2" data-name="Arrow - Left 2"
                  d="M7.369,10.869c.057-.058.27-.306.469-.51a21.69,21.69,0,0,1,5.8-4.024A4.616,4.616,0,0,1,14.812,6a1.933,1.933,0,0,1,.9.218,1.874,1.874,0,0,1,.795.9,9.849,9.849,0,0,1,.256,1.064A23.975,23.975,0,0,1,17,11.992a27.728,27.728,0,0,1-.213,3.689,8.5,8.5,0,0,1-.341,1.327A1.785,1.785,0,0,1,14.868,18h-.056a4.879,4.879,0,0,1-1.321-.409,21.691,21.691,0,0,1-5.668-3.966,5.659,5.659,0,0,1-.482-.554A1.783,1.783,0,0,1,7,12.007,1.875,1.875,0,0,1,7.369,10.869Z"
                  transform="translate(169 56)" fill="#919191" />
                <path id="Arrow_-_Left_2-2" data-name="Arrow - Left 2"
                  d="M7.369,10.869c.057-.058.27-.306.469-.51a21.69,21.69,0,0,1,5.8-4.024A4.616,4.616,0,0,1,14.812,6a1.933,1.933,0,0,1,.9.218,1.874,1.874,0,0,1,.795.9,9.849,9.849,0,0,1,.256,1.064A23.975,23.975,0,0,1,17,11.992a27.728,27.728,0,0,1-.213,3.689,8.5,8.5,0,0,1-.341,1.327A1.785,1.785,0,0,1,14.868,18h-.056a4.879,4.879,0,0,1-1.321-.409,21.691,21.691,0,0,1-5.668-3.966,5.659,5.659,0,0,1-.482-.554A1.783,1.783,0,0,1,7,12.007,1.875,1.875,0,0,1,7.369,10.869Z"
                  transform="translate(183 56)" fill="#919191" />
                <path id="Arrow_-_Left_2-3" data-name="Arrow - Left 2"
                  d="M7.369,10.869c.057-.058.27-.306.469-.51a21.69,21.69,0,0,1,5.8-4.024A4.616,4.616,0,0,1,14.812,6a1.933,1.933,0,0,1,.9.218,1.874,1.874,0,0,1,.795.9,9.849,9.849,0,0,1,.256,1.064A23.975,23.975,0,0,1,17,11.992a27.728,27.728,0,0,1-.213,3.689,8.5,8.5,0,0,1-.341,1.327A1.785,1.785,0,0,1,14.868,18h-.056a4.879,4.879,0,0,1-1.321-.409,21.691,21.691,0,0,1-5.668-3.966,5.659,5.659,0,0,1-.482-.554A1.783,1.783,0,0,1,7,12.007,1.875,1.875,0,0,1,7.369,10.869Z"
                  transform="translate(197 56)" fill="#919191" />
              </g>
            </svg>

            <i class="icon-search position-absolute top-0 start-0 bg-purp"></i>
            <form id="manod<?php echo $clsid; ?>" action="/" method="get" autocomplete="off">
            <input id="keyword<?php echo $clsid; ?>" oninput="fetchData()" class="form-control position-absolute fetchinpu" type="text" placeholder="برای یافتن محصول مورد نیاز جستجو کنید"
              aria-label="default input example"></form>
            <div class="row seabox shadow-lg bg-white rounded-4 pt-5">
              <div class="col-lg-7 p-3 position-relative">
                <div class="swiper-sea-next position-absolute top-0 end-0 bg-white rounded">
                  <svg xmlns="http://www.w3.org/2000/svg" width="6.667" height="8" viewBox="0 0 6.667 8">
                    <path id="Arrow_-_Left_2" data-name="Arrow - Left 2" d="M7.246,9.246c.038-.039.18-.2.312-.34a14.46,14.46,0,0,1,3.864-2.683A3.078,3.078,0,0,1,12.208,6a1.289,1.289,0,0,1,.6.145,1.249,1.249,0,0,1,.53.6,6.566,6.566,0,0,1,.171.709,15.983,15.983,0,0,1,.161,2.537,18.486,18.486,0,0,1-.142,2.459,5.669,5.669,0,0,1-.227.885A1.19,1.19,0,0,1,12.246,14h-.038a3.253,3.253,0,0,1-.881-.273,14.46,14.46,0,0,1-3.779-2.644,3.773,3.773,0,0,1-.321-.369A1.189,1.189,0,0,1,7,10,1.25,1.25,0,0,1,7.246,9.246Z" transform="translate(-7 -6)" fill="#200e32"/>
                  </svg>
                </div>
                <div class="swiper-sea-prev position-absolute top-0 start-0 bg-white rounded">
                  <svg xmlns="http://www.w3.org/2000/svg" width="6.667" height="8" viewBox="0 0 6.667 8">
                    <path id="Arrow_-_Left_2" data-name="Arrow - Left 2" d="M7.246,9.246c.038-.039.18-.2.312-.34a14.46,14.46,0,0,1,3.864-2.683A3.078,3.078,0,0,1,12.208,6a1.289,1.289,0,0,1,.6.145,1.249,1.249,0,0,1,.53.6,6.566,6.566,0,0,1,.171.709,15.983,15.983,0,0,1,.161,2.537,18.486,18.486,0,0,1-.142,2.459,5.669,5.669,0,0,1-.227.885A1.19,1.19,0,0,1,12.246,14h-.038a3.253,3.253,0,0,1-.881-.273,14.46,14.46,0,0,1-3.779-2.644,3.773,3.773,0,0,1-.321-.369A1.189,1.189,0,0,1,7,10,1.25,1.25,0,0,1,7.246,9.246Z" transform="translate(-7 -6)" fill="#200e32"/>
                  </svg>
                </div>
                <div class="swiper swiper-seabox  ms-3 mx-4 overflow-hidden pb-5 pt-2">
                  <div class="swiper-wrapper search_result datafetch3" id="datafetch3">
                
                
                  </div>
                </div>

                <div class="row srows">
                  <div class="col-sm-12 col-md-6 col-lg-6 pt-2">
                    <p class="ps-2">
                      <svg class="mx-2" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                        <path id="Filter_2" data-name="Filter 2"
                          d="M4.554,2H23.446A2.592,2.592,0,0,1,26,4.631V6.469a2.668,2.668,0,0,1-.765,1.876l-7.806,7.9a.7.7,0,0,1-.507.213l-6.536-.02a.709.709,0,0,1-.524-.234L2.689,8.309A2.675,2.675,0,0,1,2,6.509V4.632A2.594,2.594,0,0,1,4.554,2Zm6.182,16.589,5.826.018a.67.67,0,0,1,.657.678v3.277a.959.959,0,0,1-.544.869l-5.288,2.483a.907.907,0,0,1-.886-.066.962.962,0,0,1-.426-.8V19.267A.669.669,0,0,1,10.736,18.589Z"
                          transform="translate(-2 -2)" fill="#212341" fill-rule="evenodd" />
                      </svg>
                      کالاها
                      <svg class="mx-2" xmlns="http://www.w3.org/2000/svg" width="20" height="1" viewBox="0 0 20 1">
                        <g id="Rectangle_509" data-name="Rectangle 509" fill="#a9a9a9" stroke="#919191" stroke-width="1">
                          <rect width="20" height="1" stroke="none" />
                          <rect x="0.5" y="0.5" width="19" fill="none" />
                        </g>
                      </svg>
                    </p>
                    
                    <div class="search_result datafetch" id="datafetch">

                    </div>

                
                  </div>
                  <div class="col-sm-12 col-md-6 col-lg-6 pt-2">
                    <p class="ps-2">
                      <svg class="mx-2" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                        <path id="Category"
                          d="M5.048,2H9.1a3.058,3.058,0,0,1,3.048,3.073V9.164A3.05,3.05,0,0,1,9.1,12.236H5.048A3.058,3.058,0,0,1,2,9.164V5.073A3.066,3.066,0,0,1,5.048,2Zm0,13.764H9.1a3.051,3.051,0,0,1,3.048,3.073v4.091A3.058,3.058,0,0,1,9.1,26H5.048A3.065,3.065,0,0,1,2,22.928V18.837A3.059,3.059,0,0,1,5.048,15.764ZM22.952,2H18.9a3.058,3.058,0,0,0-3.048,3.073V9.164A3.05,3.05,0,0,0,18.9,12.236h4.056A3.058,3.058,0,0,0,26,9.164V5.073A3.066,3.066,0,0,0,22.952,2ZM18.9,15.764h4.056A3.059,3.059,0,0,1,26,18.837v4.091A3.065,3.065,0,0,1,22.952,26H18.9a3.058,3.058,0,0,1-3.048-3.072V18.837A3.051,3.051,0,0,1,18.9,15.764Z"
                          transform="translate(-2 -2)" fill="#212341" fill-rule="evenodd" />
                      </svg>
                      دسته بندی ها
                      <svg class="mx-2" xmlns="http://www.w3.org/2000/svg" width="20" height="1" viewBox="0 0 20 1">
                        <g id="Rectangle_509" data-name="Rectangle 509" fill="#a9a9a9" stroke="#919191" stroke-width="1">
                          <rect width="20" height="1" stroke="none" />
                          <rect x="0.5" y="0.5" width="19" fill="none" />
                        </g>
                      </svg>
                    </p>
                    <div class="search_result datafetch2" id="datafetch2">

                    </div>
                  
                  
                    
                  </div>
                </div>
              </div>
              <div class="col-lg-5 p-3 justify-content-between position-relative">
                <div class="swiper swiper-geabox overflow-hidden position-relative">
                  <div class="swiper-wrapper">
                  <?php
                  $options = get_option( 'kaveh_frame' );
                  $mkpicsearchslider = $options['search-pic-repeater'];
                  ?>
                  <?php
                  for ($i = 0; $i < count($mkpicsearchslider); $i++) {
                      ?>
                    
                    <div class="swiper-slide">
                      <img class="d-block rounded-4 m-2 w-75" src="<?php echo $mkpicsearchslider[$i]['searc-pic']; ?>" alt="">
                    </div>
                      <?php
                  }
                  ?>
                  
                   
                  </div>
                  <div class="swiper-pagination"></div>

                </div>
                <img class="d-inline rounded-4 m-2 w-50 nomobile" src="<?php echo $options['aj-search']; ?>" alt="">
                <img class="d-inline rounded-4 m-2 w-50 nomobile" src="<?php echo $options['aj-search2'] ?>" alt="">
              </div>
            </div>
          </div>
        </div>
        
    <style>
      .elementor .seeebox img {
        height: auto;
        max-width: 100%;
      }
    </style>
    <!--end search popup -->
    <?php
  }


}
