<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Categorycarouselsecondstkaveh extends Widget_Base{

  public function get_name(){
    return 'categorycarouselsecondstkaveh';
  }

  public function get_title(){
    return esc_html__( 'کاروسل دسته بندی ها سبک دو', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentcategorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'عنوان المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'styleboxcategorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'طرح بندی المان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'one',
          'options' => [
            'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
            'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
            'three'  => esc_html__( 'طرح بندی سوم', 'kaveh-core' ),
            'four'  => esc_html__( 'طرح بندی چهار', 'kaveh-core' ),
            'five'  => esc_html__( 'طرح بندی پنج', 'kaveh-core' ),
            'six'  => esc_html__( 'طرح بندی شش', 'kaveh-core' ),
    
          ],
        ]
        ); 
        $this->add_control(
          'beforetitlecategorycarouselsecondstkaveh',
          [
            'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'محصولات',
            'condition' => [
              'styleboxcategorycarouselsecondstkaveh' => 'five',
            ],
    
          ]
        );
        $this->add_control(
          'tagheadingbeforecategorycarouselsecondstkaveh',
          [
            'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'H6',
            'condition' => [
              'styleboxcategorycarouselsecondstkaveh' => 'five',
            ],
            'options' => [
              'H1'  => esc_html__( 'H1', 'kaveh-core' ),
              'H2' => esc_html__( 'H2', 'kaveh-core' ),
              'H3' => esc_html__( 'H3', 'kaveh-core' ),
              'H4' => esc_html__( 'H4', 'kaveh-core' ),
              'H5' => esc_html__( 'H5', 'kaveh-core' ),
              'H6' => esc_html__( 'H6', 'kaveh-core' ),
              'p' => esc_html__( 'p', 'kaveh-core' ),
              'div' => esc_html__( 'div', 'kaveh-core' ),
              'span' => esc_html__( 'span', 'kaveh-core' ),
            ],
          ]
        );
        $this->add_control(
          'titlecategorycarouselsecondstkaveh',
          [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'دسته بندی ها',
            'condition' => [
              'styleboxcategorycarouselsecondstkaveh' => [ 'three' , 'five' , 'four' , 'six' ],
        
            ],
     
          ]
        );
        $this->add_control(
          'tagheadingtcategorycarouselsecondstkaveh',
          [
            'label' => esc_html__( 'تگ عنوان اصلی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'H4',
            'condition' => [
              'styleboxcategorycarouselsecondstkaveh' => [ 'three' , 'five' , 'four' , 'six' ],
        
            ],
            'options' => [
              'H1'  => esc_html__( 'H1', 'kaveh-core' ),
              'H2' => esc_html__( 'H2', 'kaveh-core' ),
              'H3' => esc_html__( 'H3', 'kaveh-core' ),
              'H4' => esc_html__( 'H4', 'kaveh-core' ),
              'H5' => esc_html__( 'H5', 'kaveh-core' ),
              'H6' => esc_html__( 'H6', 'kaveh-core' ),
              'p' => esc_html__( 'p', 'kaveh-core' ),
              'div' => esc_html__( 'div', 'kaveh-core' ),
              'span' => esc_html__( 'span', 'kaveh-core' ),
            ],
          ]
        );
       $this->end_controls_section();
        $this->start_controls_section(
          'contentccategorycarouselsecondstkaveh',
          [
            'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
          ]
        );
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
      'title1categorycarouselsecondstkaveh',
      [
        'label' => esc_html__( 'عنوان', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'دسته بندی',

      ]
    ); 
    $repeater->add_control(
      'imgcategorycarouselsecondstkaveh',
      [
        'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $repeater->add_control(
      'linkcategorycarouselsecondstkaveh',
      [
        'label' => esc_html__( 'لینک', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
      ]
    );
    $this->add_control(
      'listcategorycarouselsecondstkaveh',
      [
        'label' => esc_html__( 'دسته بندی ها', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'title1categorycarouselsecondstkaveh' => esc_html__( 'عنوان', 'kaveh-core' ),
            'linkcategorycarouselsecondstkaveh' => esc_html__( '#', 'kaveh-core' ),
          ],
      ]
      ]
    
    ); 
    $this->add_control(
      'tagheadingc1categorycarouselsecondstkaveh',
      [
        'label' => esc_html__( 'تگ عنوان دسته بندی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H3',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );

       $this->end_controls_section();
       $this->start_controls_section(
        'content2categorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'تنظیمات کاروسل', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'productcolumncategorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در دسکتاپ', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 9,
          'step' => 0.5,
          'default' => 7,
      
        ]
      );
      $this->add_control(
        'productcolumn2categorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در تبلت', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 0.5,
          'default' => 3,
      
        ]
      );
      $this->add_control(
        'productcolumn3categorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'تعداد ستون محصولات در موبایل', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::NUMBER,
          'min' => 0,
          'max' => 5,
          'step' => 0.5,
          'default' => 1,
      
        ]
      );
       $this->end_controls_section();
       $this->start_controls_section(
        'style_tcategorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'استایل عناوین', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
            'styleboxcategorycarouselsecondstkaveh' => ['three','four','five','six'],
          ],
        ]
      ); 
      $this->add_control(
        'textcolortcategorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcategorycarouselsecondstkaveh' => ['three','four','five','six'],
          ],
          'selectors' => [
            '{{WRAPPER}} .category-product-t' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlet_categorycarouselsecondstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'condition' => [
            'styleboxcategorycarouselsecondstkaveh' => ['three','four','five','six'],
          ],
          'selector' => '{{WRAPPER}} .category-product-t',
        ]
      );
      $this->add_control(
        'buttonpaddingtcategorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxcategorycarouselsecondstkaveh' => ['three','four','six'],
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .category-product-t' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'buttonradiustcategorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxcategorycarouselsecondstkaveh' => ['three','four','six'],
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .category-product-t' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'bgcolortcategorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcategorycarouselsecondstkaveh' => ['three','four','six'],
          ],
          'selectors' => [
            '{{WRAPPER}} .category-product-t' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'textcolor3categorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ زیر عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcategorycarouselsecondstkaveh' => 'five',
          ],
          'selectors' => [
            '{{WRAPPER}} .section-heading-sub-title' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title21_categorycarouselsecondstkaveh',
          'label' => esc_html__( 'تایپوگرافی زیر عنوان', 'kaveh-core' ),
          'condition' => [
            'styleboxcategorycarouselsecondstkaveh' => 'five',
          ],
          'selector' => '{{WRAPPER}} .section-heading-sub-title',
        ]
      );
      $this->add_control(
        'shapestcategorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ اول پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcategorycarouselsecondstkaveh' => 'five',
          ],
        ]
      ); 
      
      $this->add_control(
        'bradiustcategorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxcategorycarouselsecondstkaveh' => 'five',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .best-seller-products .section-heading .detail::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} .category-products-four .section-heading .detail::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

          ],
        ]
      );
      $this->end_controls_section();
       $this->start_controls_section(
        'style_c1categorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'استایل باکس دسته بندی ها', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'textcolorc1categorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .title-category' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'bgcolor2categorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcategorycarouselsecondstkaveh' => 'three',
          ],
          'selectors' => [
            '{{WRAPPER}} .category-products-two-item .ct2t ' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonpadding2categorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxcategorycarouselsecondstkaveh' => 'three',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .category-products-two-item .ct2t ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'buttonradius2categorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxcategorycarouselsecondstkaveh' => 'three',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .category-products-two-item .ct2t' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'bgcolorcategorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'styleboxcategorycarouselsecondstkaveh' => 'six',
          ],
          'selectors' => [
            '{{WRAPPER}} .category-products-fiveteen-item .cat2st6' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonpaddingcategorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxcategorycarouselsecondstkaveh' => 'six',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .category-products-fiveteen-item .cat2st6' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'buttonradiushovercategorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'condition' => [
            'styleboxcategorycarouselsecondstkaveh' => 'six',
          ],
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .category-products-fiveteen-item .cat2st6' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'titlec1_categorycarouselsecondstkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .title-category',
        ]
      );
      $this->add_control(
        'paddingtopcategorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'فاصله عنوان از بالا', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => -200,
              'max' => 200,
              'step' => 5,
            ],
            '%' => [
              'min' => -100,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .title-category' => 'margin-top: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'hr1tcategorycarouselsecondstkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      ); 
      $this->add_control(
        'imagewidthc1categorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'عرض تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 480,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .category-image-item img' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'imageheightc1categorycarouselsecondstkaveh',
        [
          'label' => esc_html__( 'ارتفاع تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 480,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-category-two-item img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->end_controls_section();
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <?php if('one'===$settings['styleboxcategorycarouselsecondstkaveh']){ ?>
    <div class="top-category-two">
      <div class="container">
        <div class="top-category-two-wrapper">
          <div class="swiper swiper-top-category-two overflow-hidden">
            <div class="swiper-wrapper">
            <?php
              if ( $settings['listcategorycarouselsecondstkaveh'] ) {
              foreach (  $settings['listcategorycarouselsecondstkaveh'] as $item ) {
              ?>
              <div class="swiper-slide">
                <a href="<?php echo  esc_url($item['linkcategorycarouselsecondstkaveh']); ?>" class="category-image-item top-category-two-item d-flex align-items-center">
                  <img src="<?php echo esc_url($item['imgcategorycarouselsecondstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['imgcategorycarouselsecondstkaveh'] )); ?>" />
                  <<?php echo  esc_attr($settings['tagheadingc1categorycarouselsecondstkaveh']); ?> class="title-category"> <?php echo  esc_html($item['title1categorycarouselsecondstkaveh']); ?> </<?php echo  esc_attr($settings['tagheadingc1categorycarouselsecondstkaveh']); ?>>
                </a>
              </div>
              <?php 
            }
              }
            ?>
            </div>
          </div>
        </div>
      </div>
    </div>
    <?php }elseif('two'===$settings['styleboxcategorycarouselsecondstkaveh']){ ?>
     <section class="top-category-three">
      <div class="container">
        <div class="swiper swiper-top-category-three overflow-hidden">
          <div class="swiper-wrapper">
          <?php
              if ( $settings['listcategorycarouselsecondstkaveh'] ) {
              foreach (  $settings['listcategorycarouselsecondstkaveh'] as $item ) {
              ?>
            <div class="swiper-slide">
              <div class="category-image-item top-category-three-item position-relative d-flex align-items-center">
                <a href="<?php echo  esc_url($item['linkcategorycarouselsecondstkaveh']); ?>" class="stretched-link"></a>
                <img src="<?php echo esc_url($item['imgcategorycarouselsecondstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['imgcategorycarouselsecondstkaveh'] )); ?>" class="position-absolute" />
                <div class="detail">
                  <<?php echo  esc_attr($settings['tagheadingc1categorycarouselsecondstkaveh']); ?> class="title-category"><?php echo  esc_html($item['title1categorycarouselsecondstkaveh']); ?></<?php echo  esc_attr($settings['tagheadingc1categorycarouselsecondstkaveh']); ?>>
                </div>
              </div>
            </div>
            <?php 
            }
              }
            ?>
          </div>
          <div class="swiper-button-next d-none"></div>
          <div class="swiper-button-prev d-none"></div>
        </div>
      </div>
    </section>
    <?php }elseif('three'===$settings['styleboxcategorycarouselsecondstkaveh']){ ?>
    <section class="category-products-two">
      <div class="container position-relative">
        <<?php echo  esc_attr($settings['tagheadingtcategorycarouselsecondstkaveh']); ?> class="category-product-t category-products-two-title fw-normal position-relative"><?php echo  esc_html($settings['titlecategorycarouselsecondstkaveh']); ?></<?php echo  esc_attr($settings['tagheadingtcategorycarouselsecondstkaveh']); ?>>
        <div class="swiper swiper-category-products-two overflow-hidden">
          <div class="swiper-wrapper">
          <?php
              if ( $settings['listcategorycarouselsecondstkaveh'] ) {
              foreach (  $settings['listcategorycarouselsecondstkaveh'] as $item ) {
              ?>
            <div class="swiper-slide">
              <div class="category-image-item category-products-two-item position-relative">
                <a href="<?php echo  esc_url($item['linkcategorycarouselsecondstkaveh']); ?>" class="stretched-link"></a>
                <img src="<?php echo esc_url($item['imgcategorycarouselsecondstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['imgcategorycarouselsecondstkaveh'] )); ?>" />
                <<?php echo  esc_attr($settings['tagheadingc1categorycarouselsecondstkaveh']); ?> class="title-category text-center ct2t"><?php echo  esc_html($item['title1categorycarouselsecondstkaveh']); ?></<?php echo  esc_attr($settings['tagheadingc1categorycarouselsecondstkaveh']); ?>>
              </div>
            </div>
            <?php 
            }
              }
            ?>
          </div>
        </div>
      </div>
    </section>
    <?php }elseif('four'===$settings['styleboxcategorycarouselsecondstkaveh']){ ?>
    <section class="category-products-three">
      <div class="container">
        <<?php echo  esc_attr($settings['tagheadingtcategorycarouselsecondstkaveh']); ?> class="category-product-t category-products-three-title mx-auto  "><?php echo  esc_html($settings['titlecategorycarouselsecondstkaveh']); ?></<?php echo  esc_attr($settings['tagheadingtcategorycarouselsecondstkaveh']); ?>>
        <div class="category-products-three-wrapper position-relative">
          <div class="swiper swiper-category-products-three overflow-hidden">
            <div class="swiper-wrapper">
            <?php
              if ( $settings['listcategorycarouselsecondstkaveh'] ) {
              foreach (  $settings['listcategorycarouselsecondstkaveh'] as $item ) {
              ?>
              <!-- Start Item -->
              <div class="swiper-slide">
                <div class="category-image-item category-products-three-item position-relative">
                  <a href="<?php echo  esc_url($item['linkcategorycarouselsecondstkaveh']); ?>" class="stretched-link"></a>
                  <img src="<?php echo esc_url($item['imgcategorycarouselsecondstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['imgcategorycarouselsecondstkaveh'] )); ?>" class="mx-auto d-block" />
                  <<?php echo  esc_attr($settings['tagheadingc1categorycarouselsecondstkaveh']); ?> class="title-category text-center text-truncate seccat4t"><?php echo  esc_html($item['title1categorycarouselsecondstkaveh']); ?></<?php echo  esc_attr($settings['tagheadingc1categorycarouselsecondstkaveh']); ?>>
                </div>
              </div>
              <!-- End Item -->
              <?php 
            }
              }
            ?>
            </div>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
          </div>
        </div>
      </div>
    </section>
    <?php }elseif('five'===$settings['styleboxcategorycarouselsecondstkaveh']){ ?>
    <section class="category-products-four">
      <div class="container position-relative">
        <!-- Start Heading -->
        <div class="section-heading d-flex justify-content-between">
          <div class="detail position-relative">
            <<?php echo  esc_attr($settings['tagheadingbeforecategorycarouselsecondstkaveh']); ?> class="category-product-t section-heading-title"><?php echo  esc_html($settings['beforetitlecategorycarouselsecondstkaveh']); ?></<?php echo  esc_attr($settings['tagheadingbeforecategorycarouselsecondstkaveh']); ?>>
            <<?php echo  esc_attr($settings['tagheadingtcategorycarouselsecondstkaveh']); ?> class="section-heading-sub-title"><?php echo  esc_html($settings['titlecategorycarouselsecondstkaveh']); ?></<?php echo  esc_attr($settings['tagheadingtcategorycarouselsecondstkaveh']); ?>>
          </div>
        </div>
        <!-- End Heading -->
        <!-- Start Carousel -->
        <div class="swiper swiper-category-products-four overflow-hidden">
          <div class="swiper-wrapper">
          <?php
              if ( $settings['listcategorycarouselsecondstkaveh'] ) {
              foreach (  $settings['listcategorycarouselsecondstkaveh'] as $item ) {
              ?>
            <!-- Start Item -->
            <div class="swiper-slide">
              <div class="category-image-item category-products-four-item position-relative">
                <a href="<?php echo  esc_url($item['linkcategorycarouselsecondstkaveh']); ?>" class="stretched-link"></a>
                <img src="<?php echo esc_url($item['imgcategorycarouselsecondstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['imgcategorycarouselsecondstkaveh'] )); ?>" />
                <<?php echo  esc_attr($settings['tagheadingc1categorycarouselsecondstkaveh']); ?> class="title-category text-center mb-0 text-truncate teab2st5"><?php echo  esc_html($item['title1categorycarouselsecondstkaveh']); ?></<?php echo  esc_attr($settings['tagheadingc1categorycarouselsecondstkaveh']); ?>>
              </div>
            </div>
            <!-- End Item -->
            <?php 
            }
              }
            ?>
          </div>
          <div class="swiper-button-next"></div>
          <div class="swiper-button-prev"></div>
        </div>
        <!-- End Carousel -->
      </div>
    </section>
    <style>
      <?php echo '.elementor-element-' . $clsid . ''; ?> .best-seller-products .section-heading .detail::before, .category-products-four .section-heading .detail::before {
    background-image: -webkit-linear-gradient(225deg, <?php echo  esc_html($settings['shapestcategorycarouselsecondstkaveh']); ?> -20%, rgba(0, 255, 147, 0) 64%);
    background-image: -moz-linear-gradient(225deg, <?php echo  esc_html($settings['shapestcategorycarouselsecondstkaveh']); ?> -20%, rgba(0, 255, 147, 0) 64%);
    background-image: -o-linear-gradient(225deg, <?php echo  esc_html($settings['shapestcategorycarouselsecondstkaveh']); ?> -20%, rgba(0, 255, 147, 0) 64%);
    background-image: linear-gradient(-135deg, <?php echo  esc_html($settings['shapestcategorycarouselsecondstkaveh']); ?> -20%, rgba(0, 255, 147, 0) 64%);
}
    </style>
    <?php }elseif('six'===$settings['styleboxcategorycarouselsecondstkaveh']){ ?>
      <section class="category-products-fiveteen">
      <div class="container position-relative">
        <<?php echo  esc_attr($settings['tagheadingtcategorycarouselsecondstkaveh']); ?> class="category-product-t title mx-auto text-center"><?php echo  esc_html($settings['titlecategorycarouselsecondstkaveh']); ?></<?php echo  esc_attr($settings['tagheadingtcategorycarouselsecondstkaveh']); ?>>
        <!-- Start Carousel -->
        <div class="swiper swiper-category-products-fiveteen overflow-hidden w-100 mx-auto">
          <div class="swiper-wrapper">
          <?php
              if ( $settings['listcategorycarouselsecondstkaveh'] ) {
              foreach (  $settings['listcategorycarouselsecondstkaveh'] as $item ) {
              ?>
            <!-- Start Category -->
            <div class="swiper-slide">
              <div class="category-image-item category-products-fiveteen-item">
                <a href="<?php echo  esc_url($item['linkcategorycarouselsecondstkaveh']); ?>" class="stretched-link"></a>
                <img src="<?php echo esc_url($item['imgcategorycarouselsecondstkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['imgcategorycarouselsecondstkaveh'] )); ?>" class="d-block mx-auto" />
                <<?php echo  esc_attr($settings['tagheadingc1categorycarouselsecondstkaveh']); ?> class="title-category mb-3 text-center mx-auto cat2st6"><?php echo  esc_html($item['title1categorycarouselsecondstkaveh']); ?></<?php echo  esc_attr($settings['tagheadingc1categorycarouselsecondstkaveh']); ?>>
              </div>
            </div>
            <!-- End Category -->
            <?php 
            }
              }
            ?>
          </div>
          <div class="swiper-button-next"></div>
          <div class="swiper-button-prev"></div>
        </div>
        <!-- End Carousel -->
      </div>
    </section>

    <?php } ?>
    <script>
      function init<?php echo $clsid; ?>() {
  // Swiper Top Category Two
  new Swiper(".swiper-top-category-two", {
    loop: true,
    breakpoints: {
      320: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 4,
      },
      390: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 8,
      },
      576: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn2categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 12,
      },
      768: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn2categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 15,
      },
      992: {
        slidesPerView: <?php echo  esc_html($settings['productcolumncategorycarouselsecondstkaveh']); ?>,
        spaceBetween: 20,
      },
      1200: {
        slidesPerView: <?php echo  esc_html($settings['productcolumncategorycarouselsecondstkaveh']); ?>,
        spaceBetween: 27,
      },
    },
  });
  // Swiper Top Category
  new Swiper(".swiper-top-category-three", {
    loop: true,
    breakpoints: {
      320: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 4,
      },
      400: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 8,
      },
      500: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 12,
      },
      768: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn2categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 12,
      },
      992: {
        slidesPerView: <?php echo  esc_html($settings['productcolumncategorycarouselsecondstkaveh']); ?>,
        spaceBetween: 15,
      },
      1200: {
        slidesPerView: <?php echo  esc_html($settings['productcolumncategorycarouselsecondstkaveh']); ?>,
        spaceBetween: 20,
      },
      1400: {
        slidesPerView: <?php echo  esc_html($settings['productcolumncategorycarouselsecondstkaveh']); ?>,
        spaceBetween: 30,
      },
    },
  });
  // Swiper Top Category
  new Swiper(".swiper-category-products-two", {
    loop: true,
    breakpoints: {
      320: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 5,
      },
      576: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 12,
      },
      768: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn2categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 12,
      },
      992: {
        slidesPerView: <?php echo  esc_html($settings['productcolumncategorycarouselsecondstkaveh']); ?>,
        spaceBetween: 15,
      },
      1200: {
        slidesPerView: <?php echo  esc_html($settings['productcolumncategorycarouselsecondstkaveh']); ?>,
        spaceBetween: 31,
      },
    },
  });
    // Swiper Top Category
    new Swiper(".swiper-category-products-three", {
    loop: true,
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    breakpoints: {
      320: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 5,
      },
      500: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 8,
      },
      768: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn2categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 12,
      },
      992: {
        slidesPerView: <?php echo  esc_html($settings['productcolumncategorycarouselsecondstkaveh']); ?>,
        spaceBetween: 12,
      },
      1200: {
        slidesPerView: <?php echo  esc_html($settings['productcolumncategorycarouselsecondstkaveh']); ?>,
        spaceBetween: 23,
      },
    },
  });
    // Swiper Product-category Four
    new Swiper(".swiper-category-products-four", {
    loop: true,
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    breakpoints: {
      320: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 12,
      },
      370: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 8,
      },
      500: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn2categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 8,
      },
      768: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn2categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 12,
      },
      992: {
        slidesPerView: <?php echo  esc_html($settings['productcolumncategorycarouselsecondstkaveh']); ?>,
        spaceBetween: 20,
      },
      1200: {
        slidesPerView: <?php echo  esc_html($settings['productcolumncategorycarouselsecondstkaveh']); ?>,
        spaceBetween: 35,
      },
    },
  });
  // Swiper Product Category Fiveteen
  new Swiper(".swiper-category-products-fiveteen", {
    loop: true,
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    breakpoints: {
      320: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 8,
      },
      370: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn3categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 8,
      },
      500: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn2categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 8,
      },
      768: {
        slidesPerView: <?php echo  esc_html($settings['productcolumn2categorycarouselsecondstkaveh']); ?>,
        spaceBetween: 12,
      },
      992: {
        slidesPerView: <?php echo  esc_html($settings['productcolumncategorycarouselsecondstkaveh']); ?>,
        spaceBetween: 20,
      },
      1200: {
        slidesPerView: <?php echo  esc_html($settings['productcolumncategorycarouselsecondstkaveh']); ?>,
        spaceBetween: 35,
      },
    },
  });
}
      if (window.Swiper) {
    // Swiper library already loaded, initialize Swiper instance
    init<?php echo $clsid; ?>();
  } else {
    // Swiper library not yet loaded, wait for it to load
    window.addEventListener("load", function() {
      init<?php echo $clsid; ?>();
    });
  }
    </script>
    <?php
  }


}
